/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.java.api.common.queries;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.File;
import java.io.IOException;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.atomic.AtomicReference;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.netbeans.api.annotations.common.CheckForNull;
import org.netbeans.api.annotations.common.NonNull;
import org.netbeans.api.annotations.common.NullAllowed;
import org.netbeans.api.java.queries.SourceLevelQuery;
import org.netbeans.api.java.source.JavaSource;
import org.netbeans.modules.java.api.common.SourceRoots;
import org.netbeans.modules.java.api.common.util.CommonModuleUtils;
import org.netbeans.modules.java.preprocessorbridge.api.ModuleUtilities;
import org.netbeans.spi.java.queries.CompilerOptionsQueryImplementation;
import org.netbeans.spi.project.support.ant.PropertyEvaluator;
import org.openide.filesystems.FileAttributeEvent;
import org.openide.filesystems.FileChangeListener;
import org.openide.filesystems.FileEvent;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileRenameEvent;
import org.openide.filesystems.FileUtil;
import org.openide.modules.SpecificationVersion;
import org.openide.util.ChangeSupport;
import org.openide.util.Parameters;
import org.openide.util.WeakListeners;

final class UnitTestsCompilerOptionsQueryImpl
implements CompilerOptionsQueryImplementation {
    private static final Logger LOG = Logger.getLogger(UnitTestsCompilerOptionsQueryImpl.class.getName());
    private static final String MODULE_INFO_JAVA = "module-info.java";
    private final PropertyEvaluator eval;
    private final SourceRoots srcRoots;
    private final SourceRoots testRoots;
    private final AtomicReference<ResultImpl> result;

    UnitTestsCompilerOptionsQueryImpl(@NonNull PropertyEvaluator eval, @NonNull SourceRoots srcRoots, @NonNull SourceRoots testRoots) {
        Parameters.notNull("eval", eval);
        Parameters.notNull("srcRoots", srcRoots);
        Parameters.notNull("testRoots", testRoots);
        this.eval = eval;
        this.srcRoots = srcRoots;
        this.testRoots = testRoots;
        this.result = new AtomicReference();
    }

    @Override
    @CheckForNull
    public CompilerOptionsQueryImplementation.Result getOptions(@NonNull FileObject file) {
        for (FileObject root : this.testRoots.getRoots()) {
            if (!UnitTestsCompilerOptionsQueryImpl.isArtifact(root, file)) continue;
            ResultImpl res = this.result.get();
            if (res == null) {
                res = new ResultImpl(this.eval, this.srcRoots, this.testRoots);
                if (!this.result.compareAndSet(null, res)) {
                    res = this.result.get();
                }
                assert (res != null);
            }
            return res;
        }
        return null;
    }

    private static boolean isArtifact(@NonNull FileObject root, @NonNull FileObject file) {
        return root.equals(file) || FileUtil.isParentOf(root, file);
    }

    private static final class ResultImpl
    extends CompilerOptionsQueryImplementation.Result
    implements ChangeListener,
    PropertyChangeListener,
    FileChangeListener {
        private final PropertyEvaluator eval;
        private final SourceRoots srcRoots;
        private final SourceRoots testRoots;
        private final ChangeSupport cs;
        private final ThreadLocal<boolean[]> reenter;
        private final Collection<File> moduleInfoListeners;
        private List<String> cache;
        private SourceLevelQuery.Result sourceLevel;
        private boolean listensOnRoots;

        ResultImpl(@NonNull PropertyEvaluator eval, @NonNull SourceRoots srcRoots, @NonNull SourceRoots testRoots) {
            this.eval = eval;
            this.srcRoots = srcRoots;
            this.testRoots = testRoots;
            this.cs = new ChangeSupport(this);
            this.reenter = new ThreadLocal();
            this.moduleInfoListeners = new HashSet<File>();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public List<? extends String> getArguments() {
            List<String> args;
            SourceLevelQuery.Result[] slq = new SourceLevelQuery.Result[1];
            ResultImpl resultImpl = this;
            synchronized (resultImpl) {
                args = this.cache;
                slq[0] = this.sourceLevel;
            }
            if (args == null) {
                boolean[] state = this.reenter.get();
                if (state != null) {
                    args = Collections.emptyList();
                    state[0] = true;
                } else {
                    this.reenter.set(new boolean[1]);
                    try {
                        HashSet allRoots = new HashSet();
                        FileObject srcModuleInfo = ResultImpl.findModuleInfo(this.srcRoots, allRoots, null);
                        FileObject testModuleInfo = ResultImpl.findModuleInfo(this.testRoots, allRoots, slq);
                        boolean isLegacy = Optional.ofNullable(slq[0]).map(r -> r.getSourceLevel()).map(sl -> CommonModuleUtils.JDK9.compareTo(new SpecificationVersion((String)sl)) > 0).orElse(Boolean.TRUE);
                        TestMode mode = isLegacy ? TestMode.LEGACY : (srcModuleInfo == null ? TestMode.UNNAMED : (testModuleInfo == null ? TestMode.INLINED : TestMode.MODULE));
                        String propVal = this.eval.getProperty("javac.test.compilerargs");
                        args = propVal != null && !propVal.isEmpty() ? this.parseLine(propVal) : mode.createArguments(srcModuleInfo, testModuleInfo);
                        ResultImpl resultImpl2 = this;
                        synchronized (resultImpl2) {
                            if (this.cache == null) {
                                this.cache = args;
                            } else {
                                args = this.cache;
                            }
                            if (this.sourceLevel == null && slq[0] != null) {
                                this.sourceLevel = slq[0];
                                if (this.sourceLevel.supportsChanges()) {
                                    this.sourceLevel.addChangeListener(WeakListeners.change(this, this.sourceLevel));
                                }
                            }
                            if (!this.listensOnRoots) {
                                this.listensOnRoots = true;
                                this.srcRoots.addPropertyChangeListener(WeakListeners.propertyChange(this, this.srcRoots));
                                this.testRoots.addPropertyChangeListener(WeakListeners.propertyChange(this, this.testRoots));
                                this.eval.addPropertyChangeListener(WeakListeners.propertyChange(this, this.eval));
                            }
                            HashSet<File> toRemove = new HashSet<File>(this.moduleInfoListeners);
                            toRemove.removeAll(allRoots);
                            allRoots.removeAll(this.moduleInfoListeners);
                            for (File f : toRemove) {
                                FileUtil.removeFileChangeListener(this, new File(f, UnitTestsCompilerOptionsQueryImpl.MODULE_INFO_JAVA));
                                this.moduleInfoListeners.remove(f);
                            }
                            for (File f : allRoots) {
                                FileUtil.addFileChangeListener(this, new File(f, UnitTestsCompilerOptionsQueryImpl.MODULE_INFO_JAVA));
                                this.moduleInfoListeners.add(f);
                            }
                        }
                    }
                    finally {
                        boolean fire = Optional.ofNullable(this.reenter.get()).map(ba -> ba[0]).orElse(Boolean.FALSE);
                        this.reenter.remove();
                        if (fire) {
                            this.cs.fireChange();
                        }
                    }
                }
            }
            return args;
        }

        @Override
        public void addChangeListener(@NonNull ChangeListener listener) {
            this.cs.addChangeListener(listener);
        }

        @Override
        public void removeChangeListener(@NonNull ChangeListener listener) {
            this.cs.removeChangeListener(listener);
        }

        @Override
        public void stateChanged(@NonNull ChangeEvent e) {
            this.reset();
        }

        @Override
        public void propertyChange(@NonNull PropertyChangeEvent evt) {
            String evtName = evt.getPropertyName();
            if (SourceRoots.PROP_ROOTS.equals(evtName) || "javac.test.compilerargs".equals(evtName) || evt == null) {
                this.reset();
            }
        }

        @Override
        public void fileDataCreated(FileEvent fe) {
            this.reset();
        }

        @Override
        public void fileChanged(FileEvent fe) {
            this.reset();
        }

        @Override
        public void fileDeleted(FileEvent fe) {
            this.reset();
        }

        @Override
        public void fileRenamed(FileRenameEvent fe) {
            this.reset();
        }

        @Override
        public void fileFolderCreated(FileEvent fe) {
        }

        @Override
        public void fileAttributeChanged(FileAttributeEvent fe) {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void reset() {
            ResultImpl resultImpl = this;
            synchronized (resultImpl) {
                this.cache = null;
            }
            this.cs.fireChange();
        }

        private static FileObject findModuleInfo(@NonNull SourceRoots roots, @NonNull Collection<? super File> rootCollector, @NullAllowed SourceLevelQuery.Result[] holder) {
            FileObject result = null;
            for (FileObject root : roots.getRoots()) {
                FileObject moduleInfo;
                if (holder != null && holder[0] == null) {
                    holder[0] = SourceLevelQuery.getSourceLevel2(root);
                }
                Optional.ofNullable(FileUtil.toFile(root)).ifPresent(rootCollector::add);
                if (result != null || (moduleInfo = root.getFileObject(UnitTestsCompilerOptionsQueryImpl.MODULE_INFO_JAVA)) == null) continue;
                result = moduleInfo;
            }
            return result;
        }

        @CheckForNull
        private static String getModuleName(@NonNull FileObject moduleInfo) {
            try {
                JavaSource src = JavaSource.forFileObject(moduleInfo);
                if (src != null) {
                    return ModuleUtilities.get(src).parseModuleName();
                }
            }
            catch (IOException ioe) {
                LOG.log(Level.WARNING, "Cannot read module declaration in: {0} due to: {1}", new Object[]{FileUtil.getFileDisplayName(moduleInfo), ioe.getMessage()});
            }
            return null;
        }

        /*
         * Uses 'sealed' constructs - enablewith --sealed true
         */
        private static enum TestMode {
            LEGACY{

                @Override
                List<String> createArguments(@NullAllowed FileObject srcModuleInfo, @NullAllowed FileObject testModuleInfo) {
                    return Collections.emptyList();
                }
            }
            ,
            UNNAMED{

                @Override
                List<String> createArguments(@NullAllowed FileObject srcModuleInfo, @NullAllowed FileObject testModuleInfo) {
                    return Collections.emptyList();
                }
            }
            ,
            INLINED{

                @Override
                List<String> createArguments(@NullAllowed FileObject srcModuleInfo, @NullAllowed FileObject testModuleInfo) {
                    String moduleName = ResultImpl.getModuleName(srcModuleInfo);
                    if (moduleName == null) {
                        return Collections.emptyList();
                    }
                    List<String> result = Arrays.asList(String.format("-XD-Xmodule:%s", moduleName), "--add-reads", String.format("%s=ALL-UNNAMED", moduleName));
                    return Collections.unmodifiableList(result);
                }
            }
            ,
            MODULE{

                @Override
                List<String> createArguments(@NullAllowed FileObject srcModuleInfo, @NullAllowed FileObject testModuleInfo) {
                    String moduleName = ResultImpl.getModuleName(testModuleInfo);
                    if (moduleName == null) {
                        return Collections.emptyList();
                    }
                    List<String> result = Arrays.asList("--add-reads", String.format("%s=ALL-UNNAMED", moduleName));
                    return Collections.unmodifiableList(result);
                }
            };


            @NonNull
            abstract List<String> createArguments(@NullAllowed FileObject var1, @NullAllowed FileObject var2);
        }
    }
}

