/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.api.plugin.descriptor.lifecycle;

import java.io.Serializable;
import java.util.Collection;
import java.util.List;
import org.apache.maven.api.annotations.Experimental;
import org.apache.maven.api.annotations.Generated;
import org.apache.maven.api.annotations.Immutable;
import org.apache.maven.api.annotations.Nonnull;
import org.apache.maven.api.annotations.NotThreadSafe;
import org.apache.maven.api.annotations.ThreadSafe;
import org.apache.maven.api.plugin.descriptor.lifecycle.ImmutableCollections;
import org.apache.maven.api.plugin.descriptor.lifecycle.Lifecycle;

@Experimental
@Generated
@ThreadSafe
@Immutable
public class LifecycleConfiguration
implements Serializable {
    final String namespaceUri;
    final String modelEncoding;
    final List<Lifecycle> lifecycles;

    protected LifecycleConfiguration(Builder builder) {
        String string = builder.namespaceUri != null ? builder.namespaceUri : (this.namespaceUri = builder.base != null ? builder.base.namespaceUri : null);
        String string2 = builder.modelEncoding != null ? builder.modelEncoding : (this.modelEncoding = builder.base != null ? builder.base.modelEncoding : "UTF-8");
        this.lifecycles = ImmutableCollections.copy(builder.lifecycles != null ? builder.lifecycles : (builder.base != null ? builder.base.lifecycles : null));
    }

    public String getNamespaceUri() {
        return this.namespaceUri;
    }

    public String getModelEncoding() {
        return this.modelEncoding;
    }

    @Nonnull
    public List<Lifecycle> getLifecycles() {
        return this.lifecycles;
    }

    @Nonnull
    public Builder with() {
        return LifecycleConfiguration.newBuilder(this);
    }

    @Nonnull
    public LifecycleConfiguration withLifecycles(Collection<Lifecycle> lifecycles) {
        return LifecycleConfiguration.newBuilder(this, true).lifecycles(lifecycles).build();
    }

    @Nonnull
    public static LifecycleConfiguration newInstance() {
        return LifecycleConfiguration.newInstance(true);
    }

    @Nonnull
    public static LifecycleConfiguration newInstance(boolean withDefaults) {
        return LifecycleConfiguration.newBuilder(withDefaults).build();
    }

    @Nonnull
    public static Builder newBuilder() {
        return LifecycleConfiguration.newBuilder(true);
    }

    @Nonnull
    public static Builder newBuilder(boolean withDefaults) {
        return new Builder(withDefaults);
    }

    @Nonnull
    public static Builder newBuilder(LifecycleConfiguration from) {
        return LifecycleConfiguration.newBuilder(from, false);
    }

    @Nonnull
    public static Builder newBuilder(LifecycleConfiguration from, boolean forceCopy) {
        return new Builder(from, forceCopy);
    }

    @NotThreadSafe
    public static class Builder {
        LifecycleConfiguration base;
        String namespaceUri;
        String modelEncoding;
        Collection<Lifecycle> lifecycles;

        protected Builder(boolean withDefaults) {
            if (withDefaults) {
                // empty if block
            }
        }

        protected Builder(LifecycleConfiguration base, boolean forceCopy) {
            this.namespaceUri = base.namespaceUri;
            this.modelEncoding = base.modelEncoding;
            if (forceCopy) {
                this.lifecycles = base.lifecycles;
            } else {
                this.base = base;
            }
        }

        @Nonnull
        public Builder namespaceUri(String namespaceUri) {
            this.namespaceUri = namespaceUri;
            return this;
        }

        @Nonnull
        public Builder modelEncoding(String modelEncoding) {
            this.modelEncoding = modelEncoding;
            return this;
        }

        @Nonnull
        public Builder lifecycles(Collection<Lifecycle> lifecycles) {
            this.lifecycles = lifecycles;
            return this;
        }

        @Nonnull
        public LifecycleConfiguration build() {
            if (this.base != null && (this.lifecycles == null || this.lifecycles == this.base.lifecycles)) {
                return this.base;
            }
            return new LifecycleConfiguration(this);
        }
    }
}

