/*
 * Decompiled with CFR 0.152.
 */
package org.ops4j.pax.jms.config.impl;

import java.util.Arrays;
import java.util.Dictionary;
import java.util.Hashtable;
import java.util.Map;
import javax.jms.ConnectionFactory;
import javax.jms.JMSRuntimeException;
import javax.jms.XAConnectionFactory;
import org.jasypt.encryption.StringEncryptor;
import org.ops4j.pax.jms.config.impl.ConnectionFactoryConfigManager;
import org.ops4j.pax.jms.config.impl.ConnectionFactoryRegistration;
import org.ops4j.pax.jms.config.impl.Decryptor;
import org.ops4j.pax.jms.config.impl.ExternalConfigLoader;
import org.ops4j.pax.jms.config.impl.PoolingWrapper;
import org.ops4j.pax.jms.config.impl.ServiceTrackerHelper;
import org.ops4j.pax.jms.service.ConnectionFactoryFactory;
import org.ops4j.pax.jms.service.PooledConnectionFactoryFactory;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceReference;
import org.osgi.service.cm.ConfigurationException;
import org.osgi.util.tracker.ServiceTracker;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ConnectionFactoryWrapper {
    public static final Logger LOG = LoggerFactory.getLogger(ConnectionFactoryWrapper.class);
    private ServiceTracker<?, ?> tracker;
    private Object cf;

    public ConnectionFactoryWrapper(BundleContext context, ExternalConfigLoader externalConfigLoader, Object connectionFactory, ServiceReference<Object> reference) {
        LOG.info("Got service reference {}", connectionFactory);
        this.cf = connectionFactory;
        boolean xa = false;
        Object objectClass = reference.getProperty("objectClass");
        if (objectClass instanceof String) {
            xa = XAConnectionFactory.class.getName().equals(objectClass);
        } else if (objectClass instanceof String[]) {
            xa = Arrays.stream((String[])objectClass).anyMatch(c -> XAConnectionFactory.class.getName().equals(c));
        }
        ProvidedConnectionFactoryFactory providedCFFactory = xa ? new ProvidedConnectionFactoryFactory((XAConnectionFactory)connectionFactory) : new ProvidedConnectionFactoryFactory((ConnectionFactory)connectionFactory);
        Dictionary<String, Object> config = this.serviceReferenceProperties(reference);
        Dictionary<String, Object> loadedConfig = externalConfigLoader.resolve(config);
        loadedConfig.put("xa", Boolean.toString(xa));
        loadedConfig.put("service.ranking", this.getInt(config, "service.ranking", 0) + 1000);
        loadedConfig.put("pax.jms.service.id.ref", config.get("service.id"));
        String seFilter = ConnectionFactoryConfigManager.getStringEncryptorFilter(loadedConfig);
        String pcffFilter = null;
        try {
            pcffFilter = ConnectionFactoryConfigManager.getPooledCFFFilter(loadedConfig);
        }
        catch (ConfigurationException e) {
            throw new IllegalArgumentException(e.getMessage(), e);
        }
        ServiceTrackerHelper helper = ServiceTrackerHelper.helper(context);
        if (pcffFilter == null) {
            throw new IllegalArgumentException("No pooling configuration available for service " + connectionFactory.toString() + ": " + loadedConfig);
        }
        String finalPcffFilter = pcffFilter;
        this.tracker = helper.track(StringEncryptor.class, seFilter, se -> helper.track(PooledConnectionFactoryFactory.class, finalPcffFilter, pcff -> new ConnectionFactoryRegistration(context, new PoolingWrapper((PooledConnectionFactoryFactory)pcff, providedCFFactory), loadedConfig, new Decryptor((StringEncryptor)se).decrypt(loadedConfig)), ConnectionFactoryRegistration::close));
    }

    private Dictionary<String, Object> serviceReferenceProperties(ServiceReference<Object> reference) {
        Hashtable<String, Object> result = new Hashtable<String, Object>();
        if (reference != null) {
            for (String key : reference.getPropertyKeys()) {
                result.put(key, reference.getProperty(key));
            }
        }
        return result;
    }

    public void close() {
        if (this.tracker != null) {
            if (this.cf != null) {
                LOG.info("Closed service reference: {}", this.cf);
            }
            this.tracker.close();
        }
    }

    private int getInt(Dictionary<String, Object> properties, String name, int defaultValue) {
        Object v = properties.get(name);
        if (v instanceof Integer) {
            return (Integer)v;
        }
        if (v instanceof String) {
            return Integer.parseInt((String)v);
        }
        return defaultValue;
    }

    private static final class ProvidedConnectionFactoryFactory
    implements ConnectionFactoryFactory {
        private ConnectionFactory providedCF;
        private XAConnectionFactory providedXACF;

        ProvidedConnectionFactoryFactory(ConnectionFactory providedConnectionFactory) {
            this.providedCF = providedConnectionFactory;
        }

        ProvidedConnectionFactoryFactory(XAConnectionFactory providedXAConnectionFactory) {
            this.providedXACF = providedXAConnectionFactory;
        }

        public ConnectionFactory createConnectionFactory(Map<String, Object> props) throws JMSRuntimeException {
            return this.providedCF;
        }

        public XAConnectionFactory createXAConnectionFactory(Map<String, Object> props) throws JMSRuntimeException {
            return this.providedXACF;
        }
    }
}

