/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wiki.ui.admin;

import javax.management.MBeanAttributeInfo;
import javax.management.MBeanInfo;
import javax.management.NotCompliantMBeanException;
import org.apache.commons.lang3.StringUtils;
import org.apache.wiki.api.core.Context;
import org.apache.wiki.api.core.Engine;
import org.apache.wiki.management.SimpleMBean;
import org.apache.wiki.ui.admin.AdminBean;

public abstract class SimpleAdminBean
extends SimpleMBean
implements AdminBean {
    protected Engine m_engine;

    protected SimpleAdminBean() throws NotCompliantMBeanException {
    }

    @Override
    public void initialize(Engine engine) {
        this.m_engine = engine;
    }

    @Override
    public String doGet(Context context) {
        MBeanInfo info = this.getMBeanInfo();
        MBeanAttributeInfo[] attributes = info.getAttributes();
        StringBuilder sb = new StringBuilder();
        for (MBeanAttributeInfo attribute : attributes) {
            sb.append("<div class='block'>\n");
            sb.append("<label>").append(StringUtils.capitalize((String)attribute.getName())).append("</label>\n");
            try {
                Object value = this.getAttribute(attribute.getName());
                if (attribute.isWritable()) {
                    sb.append("<input type='text' name='question' size='30' value='").append(value).append("' />\n");
                } else {
                    sb.append("<input type='text' class='readonly' readonly='true' size='30' value='").append(value).append("' />\n");
                }
            }
            catch (Exception e) {
                sb.append("Exception: ").append(e.getMessage());
            }
            sb.append("<div class='description'>").append(attribute.getDescription()).append("</div>\n");
            sb.append("</div>\n");
        }
        return sb.toString();
    }

    @Override
    public String doPost(Context context) {
        return null;
    }

    @Override
    public String getId() {
        return this.getClass().getName();
    }
}

