/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.facet.taxonomy;

import java.io.IOException;
import org.apache.lucene.facet.taxonomy.FacetLabel;
import org.apache.lucene.facet.taxonomy.ParallelTaxonomyArrays;
import org.apache.lucene.facet.taxonomy.TaxonomyReader;
import org.apache.lucene.index.DocValues;
import org.apache.lucene.index.LeafReaderContext;
import org.apache.lucene.index.SortedNumericDocValues;

public class TaxonomyFacetLabels {
    private final TaxonomyReader taxoReader;
    private final String indexFieldName;

    public TaxonomyFacetLabels(TaxonomyReader taxoReader, String indexFieldName) {
        this.taxoReader = taxoReader;
        this.indexFieldName = indexFieldName;
    }

    public FacetLabelReader getFacetLabelReader(LeafReaderContext readerContext) throws IOException {
        SortedNumericDocValues ordinalValues = DocValues.getSortedNumeric(readerContext.reader(), this.indexFieldName);
        if (ordinalValues == null) {
            ordinalValues = DocValues.emptySortedNumeric();
        }
        return new FacetLabelReader(ordinalValues);
    }

    public class FacetLabelReader {
        private final SortedNumericDocValues ordinalValues;
        private int currentDocId = -1;
        private boolean currentDocHasValues;
        private int currentPos;
        private int currentDocOrdinalCount;
        private ParallelTaxonomyArrays.IntArray parents;

        public FacetLabelReader(SortedNumericDocValues ordinalValues) {
            this.ordinalValues = ordinalValues;
        }

        public FacetLabel nextFacetLabel(int docId) throws IOException {
            if (this.currentDocId != docId) {
                if (docId < this.currentDocId) {
                    throw new IllegalArgumentException("docs out of order: previous docId=" + this.currentDocId + " current docId=" + docId);
                }
                this.currentDocId = docId;
                this.currentDocHasValues = this.ordinalValues.advanceExact(docId);
                if (this.currentDocHasValues) {
                    this.currentDocOrdinalCount = this.ordinalValues.docValueCount();
                    this.currentPos = 0;
                }
            }
            if (!this.currentDocHasValues) {
                return null;
            }
            assert (this.currentPos <= this.currentDocOrdinalCount);
            if (this.currentPos == this.currentDocOrdinalCount) {
                return null;
            }
            int ord = (int)this.ordinalValues.nextValue();
            ++this.currentPos;
            return TaxonomyFacetLabels.this.taxoReader.getPath(ord);
        }

        private boolean isDescendant(int ord, int ancestorOrd) {
            while (ord != -1 && ord != 0) {
                if (this.parents.get(ord) == ancestorOrd) {
                    return true;
                }
                ord = this.parents.get(ord);
            }
            return false;
        }

        public FacetLabel nextFacetLabel(int docId, String facetDimension) throws IOException {
            if (facetDimension == null) {
                throw new IllegalArgumentException("Input facet dimension cannot be null");
            }
            int parentOrd = TaxonomyFacetLabels.this.taxoReader.getOrdinal(new FacetLabel(facetDimension));
            if (parentOrd == -1) {
                throw new IllegalArgumentException("Category ordinal not found for facet dimension: " + facetDimension);
            }
            if (this.currentDocId != docId) {
                if (docId < this.currentDocId) {
                    throw new IllegalArgumentException("docs out of order: previous docId=" + this.currentDocId + " current docId=" + docId);
                }
                this.currentDocId = docId;
                this.currentDocHasValues = this.ordinalValues.advanceExact(docId);
                if (this.currentDocHasValues) {
                    this.currentDocOrdinalCount = this.ordinalValues.docValueCount();
                    this.currentPos = 0;
                }
            }
            if (!this.currentDocHasValues) {
                return null;
            }
            assert (this.currentPos <= this.currentDocOrdinalCount);
            if (this.currentPos == this.currentDocOrdinalCount) {
                return null;
            }
            if (this.parents == null) {
                this.parents = TaxonomyFacetLabels.this.taxoReader.getParallelTaxonomyArrays().parents();
            }
            do {
                int ord = (int)this.ordinalValues.nextValue();
                ++this.currentPos;
                if (!this.isDescendant(ord, parentOrd)) continue;
                return TaxonomyFacetLabels.this.taxoReader.getPath(ord);
            } while (this.currentPos < this.currentDocOrdinalCount);
            return null;
        }
    }
}

