/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.fuseki.mod.shiro;

import jakarta.servlet.ServletContext;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.List;
import org.apache.jena.atlas.logging.LogCtl;
import org.apache.jena.fuseki.main.FusekiAbortException;
import org.apache.jena.fuseki.mod.shiro.ShiroEnvironmentLoaderListener;
import org.apache.shiro.config.ConfigurationException;
import org.apache.shiro.lang.io.ResourceUtils;
import org.apache.shiro.web.env.EnvironmentLoader;
import org.apache.shiro.web.env.IniWebEnvironment;
import org.apache.shiro.web.servlet.AbstractFilter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class FusekiShiro {
    public static final Logger shiroLog = LoggerFactory.getLogger("org.apache.jena.fuseki.Shiro");
    private static final String fileShiroPrefix = "file:";
    private static final int fileShiroPrefixLength = "file:".length();

    FusekiShiro() {
    }

    static void shiroEnvironment(ServletContext servletContext, List<String> possibleShiroIniFiles) {
        ShiroEnvironmentLoaderListener shiroListener = new ShiroEnvironmentLoaderListener(possibleShiroIniFiles);
        LogCtl.disable(IniWebEnvironment.class);
        LogCtl.disable(EnvironmentLoader.class);
        LogCtl.disable(AbstractFilter.class);
        try {
            shiroListener.initEnvironment(servletContext);
        }
        catch (ConfigurationException ex) {
            shiroLog.error(ex.getMessage());
            throw new FusekiAbortException(9);
        }
    }

    static String huntForShiroIni(List<String> locations) {
        for (String loc : locations) {
            String fn;
            Path p;
            if (!(loc.startsWith(fileShiroPrefix) ? Files.exists(p = Path.of(fn = loc.substring(fileShiroPrefixLength), new String[0]), new LinkOption[0]) : ResourceUtils.resourceExists(loc))) continue;
            return loc;
        }
        return null;
    }

    public static String withResourcePrefix(String shiroFileName) {
        if (shiroFileName.startsWith(fileShiroPrefix)) {
            return shiroFileName;
        }
        return fileShiroPrefix + shiroFileName;
    }

    public static String removeResourcePrefix(String shiroFileResource) {
        if (shiroFileResource.startsWith(fileShiroPrefix)) {
            String fn = shiroFileResource.substring(fileShiroPrefixLength);
            return fn;
        }
        return shiroFileResource;
    }
}

