/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.mem.store.roaring;

import java.util.ConcurrentModificationException;
import java.util.NoSuchElementException;
import java.util.function.Consumer;
import org.apache.jena.graph.Triple;
import org.apache.jena.mem.collection.FastHashSet;
import org.apache.jena.util.iterator.NiceIterator;
import org.roaringbitmap.BatchIterator;
import org.roaringbitmap.ImmutableBitmapDataProvider;

public class RoaringBitmapTripleIterator
extends NiceIterator<Triple> {
    protected static final int BUFFER_SIZE = 64;
    private final ImmutableBitmapDataProvider bitmap;
    private final FastHashSet<Triple> triples;
    private final int initialSize;
    private final BatchIterator batchIterator;
    private final int[] buffer = new int[64];
    private int bufferIndex = -1;
    private boolean batchIteratorHasBeenUsed = false;

    public RoaringBitmapTripleIterator(ImmutableBitmapDataProvider bitmap, FastHashSet<Triple> triples) {
        this.bitmap = bitmap;
        this.batchIterator = bitmap.getBatchIterator();
        this.triples = triples;
        this.initialSize = triples.size();
    }

    @Override
    public boolean hasNext() {
        if (this.bufferIndex > 0) {
            return true;
        }
        if (this.batchIterator.hasNext()) {
            if (!this.batchIteratorHasBeenUsed) {
                this.batchIteratorHasBeenUsed = true;
            }
            this.bufferIndex = this.batchIterator.nextBatch(this.buffer);
        }
        return this.bufferIndex > 0;
    }

    @Override
    public Triple next() {
        if (this.triples.size() != this.initialSize) {
            throw new ConcurrentModificationException();
        }
        if (this.hasNext()) {
            return this.triples.getKeyAt(this.buffer[--this.bufferIndex]);
        }
        throw new NoSuchElementException();
    }

    public void forEachRemaining(Consumer<? super Triple> action) {
        if (this.batchIteratorHasBeenUsed) {
            while (-1 < --this.bufferIndex) {
                action.accept(this.triples.getKeyAt(this.buffer[this.bufferIndex]));
            }
            while (this.batchIterator.hasNext()) {
                this.bufferIndex = this.batchIterator.nextBatch(this.buffer);
                while (-1 < --this.bufferIndex) {
                    action.accept(this.triples.getKeyAt(this.buffer[this.bufferIndex]));
                }
            }
        } else {
            this.bitmap.forEach(index -> action.accept(this.triples.getKeyAt(index)));
        }
        if (this.triples.size() != this.initialSize) {
            throw new ConcurrentModificationException();
        }
    }
}

