/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.sparql.sse.builders;

import java.util.List;
import org.apache.jena.sparql.algebra.Table;
import org.apache.jena.sparql.algebra.TableFactory;
import org.apache.jena.sparql.core.Var;
import org.apache.jena.sparql.engine.binding.Binding;
import org.apache.jena.sparql.sse.Item;
import org.apache.jena.sparql.sse.ItemList;
import org.apache.jena.sparql.sse.builders.BuilderBinding;
import org.apache.jena.sparql.sse.builders.BuilderLib;
import org.apache.jena.sparql.sse.builders.BuilderNode;

public class BuilderTable {
    public static Table build(Item item) {
        Item item0;
        BuilderLib.checkTagged(item, "table", "Not a (table ...)");
        ItemList list = item.getList();
        int start = 1;
        if (list.size() == 1) {
            return TableFactory.createEmpty();
        }
        List<Var> vars = null;
        if (list.size() > 1 && (item0 = list.get(1)).isTagged("vars")) {
            vars = BuilderNode.buildVarList(item0);
            list = list.cdr();
        }
        if (list.size() == 2 && list.get(1).isSymbol()) {
            String symbol = list.get(1).getSymbol();
            if (symbol.equals("unit")) {
                return TableFactory.createUnit();
            }
            if (symbol.equals("empty")) {
                return TableFactory.createEmpty();
            }
            BuilderLib.broken(list, "Don't recognized table symbol");
        }
        Table table = TableFactory.create(vars);
        int count = 0;
        Binding lastBinding = null;
        for (int i = start; i < list.size(); ++i) {
            Item itemRow = list.get(i);
            Binding b = BuilderBinding.build(itemRow);
            table.addBinding(b);
            lastBinding = b;
            ++count;
        }
        if (table.size() == 1 && lastBinding.isEmpty()) {
            return TableFactory.createUnit();
        }
        return table;
    }
}

