/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.jndi;

import java.io.IOException;
import java.util.Collections;
import java.util.Hashtable;
import java.util.Map;
import java.util.WeakHashMap;
import javax.naming.Context;
import javax.naming.Name;
import javax.naming.NameParser;
import javax.naming.Reference;
import javax.naming.StringRefAddr;
import javax.naming.spi.ObjectFactory;
import org.eclipse.jetty.jndi.NamingContext;
import org.eclipse.jetty.server.handler.ContextHandler;
import org.eclipse.jetty.util.component.Dumpable;
import org.eclipse.jetty.util.log.Log;
import org.eclipse.jetty.util.log.Logger;

public class ContextFactory
implements ObjectFactory {
    private static final Logger LOG = Log.getLogger(ContextFactory.class);
    private static final Map<ClassLoader, Context> __contextMap = Collections.synchronizedMap(new WeakHashMap());
    private static final ThreadLocal<Context> __threadContext = new ThreadLocal();
    private static final ThreadLocal<ClassLoader> __threadClassLoader = new ThreadLocal();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object getObjectInstance(Object obj, Name name, Context nameCtx, Hashtable env) throws Exception {
        Context ctx = __threadContext.get();
        if (ctx != null) {
            if (LOG.isDebugEnabled()) {
                LOG.debug("Using the Context that is bound on the thread", new Object[0]);
            }
            return ctx;
        }
        ClassLoader loader = __threadClassLoader.get();
        if (loader != null) {
            if (LOG.isDebugEnabled()) {
                LOG.debug("Using threadlocal classloader", new Object[0]);
            }
            Map<ClassLoader, Context> map = __contextMap;
            synchronized (map) {
                ctx = this.getContextForClassLoader(loader);
                if (ctx == null) {
                    ctx = this.newNamingContext(obj, loader, env, name, nameCtx);
                    __contextMap.put(loader, ctx);
                    if (LOG.isDebugEnabled()) {
                        LOG.debug("Made context {} for classloader {}", name.get(0), loader);
                    }
                }
                return ctx;
            }
        }
        ClassLoader tccl = Thread.currentThread().getContextClassLoader();
        loader = tccl;
        if (loader != null) {
            if (LOG.isDebugEnabled()) {
                LOG.debug("Trying thread context classloader", new Object[0]);
            }
            Map<ClassLoader, Context> map = __contextMap;
            synchronized (map) {
                while (ctx == null && loader != null) {
                    ctx = this.getContextForClassLoader(loader);
                    if (ctx != null || loader == null) continue;
                    loader = loader.getParent();
                }
                if (ctx == null) {
                    ctx = this.newNamingContext(obj, tccl, env, name, nameCtx);
                    __contextMap.put(tccl, ctx);
                    if (LOG.isDebugEnabled()) {
                        LOG.debug("Made context {} for classloader {}", name.get(0), tccl);
                    }
                }
                return ctx;
            }
        }
        if (ContextHandler.getCurrentContext() != null) {
            if (LOG.isDebugEnabled() && loader != null) {
                LOG.debug("Trying classloader of current org.eclipse.jetty.server.handler.ContextHandler", new Object[0]);
            }
            Map<ClassLoader, Context> map = __contextMap;
            synchronized (map) {
                loader = ContextHandler.getCurrentContext().getContextHandler().getClassLoader();
                ctx = __contextMap.get(loader);
                if (ctx == null && loader != null) {
                    ctx = this.newNamingContext(obj, loader, env, name, nameCtx);
                    __contextMap.put(loader, ctx);
                    if (LOG.isDebugEnabled()) {
                        LOG.debug("Made context {} for classloader {} ", name.get(0), loader);
                    }
                }
                return ctx;
            }
        }
        return null;
    }

    public NamingContext newNamingContext(Object obj, ClassLoader loader, Hashtable env, Name name, Context parentCtx) throws Exception {
        Reference ref = (Reference)obj;
        StringRefAddr parserAddr = (StringRefAddr)ref.get("parser");
        String parserClassName = parserAddr == null ? null : (String)parserAddr.getContent();
        NameParser parser = parserClassName == null ? null : loader.loadClass(parserClassName).getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
        return new NamingContext(env, name.get(0), (NamingContext)parentCtx, parser);
    }

    public Context getContextForClassLoader(ClassLoader loader) {
        if (loader == null) {
            return null;
        }
        return __contextMap.get(loader);
    }

    public static Context associateContext(Context ctx) {
        Context previous = __threadContext.get();
        __threadContext.set(ctx);
        return previous;
    }

    public static void disassociateContext(Context ctx) {
        __threadContext.set(null);
    }

    public static ClassLoader associateClassLoader(ClassLoader loader) {
        ClassLoader prev = __threadClassLoader.get();
        __threadClassLoader.set(loader);
        return prev;
    }

    public static void disassociateClassLoader() {
        __threadClassLoader.set(null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void dump(Appendable out, String indent) throws IOException {
        Map<ClassLoader, Context> map = __contextMap;
        synchronized (map) {
            Dumpable.dumpObjects(out, indent, String.format("o.e.j.jndi.ContextFactory@%x", __contextMap.hashCode()), __contextMap);
        }
    }
}

