/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.standalone.cli.core;

import java.util.ResourceBundle;
import javax.jcr.Item;
import javax.jcr.Session;
import org.apache.commons.chain.Command;
import org.apache.commons.chain.Context;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.jackrabbit.standalone.cli.CommandHelper;

public class Move
implements Command {
    private static ResourceBundle bundle = CommandHelper.getBundle();
    private static Log log = LogFactory.getLog(Move.class);
    private String srcAbsPathKey = "srcAbsPath";
    private String destAbsPathKey = "destAbsPath";
    private String persistentKey = "persistent";

    @Override
    public boolean execute(Context ctx) throws Exception {
        String srcAbsPath = (String)ctx.get(this.srcAbsPathKey);
        Object destAbsPath = (String)ctx.get(this.destAbsPathKey);
        boolean persistent = Boolean.valueOf((String)ctx.get(this.persistentKey));
        if (!srcAbsPath.startsWith("/") || !((String)destAbsPath).startsWith("/")) {
            throw new IllegalArgumentException(bundle.getString("exception.illegalargument") + ". " + bundle.getString("exception.only.absolute.path") + ".");
        }
        Session s = CommandHelper.getSession(ctx);
        if (log.isDebugEnabled()) {
            log.debug("moving node from " + srcAbsPath + " to " + (String)destAbsPath);
        }
        if (((String)destAbsPath).endsWith("/")) {
            Item source = s.getItem(srcAbsPath);
            destAbsPath = (String)destAbsPath + source.getName();
        }
        if (persistent) {
            s.getWorkspace().move(srcAbsPath, (String)destAbsPath);
        } else {
            s.move(srcAbsPath, (String)destAbsPath);
        }
        return false;
    }

    public String getDestAbsPathKey() {
        return this.destAbsPathKey;
    }

    public void setDestAbsPathKey(String destAbsPathKey) {
        this.destAbsPathKey = destAbsPathKey;
    }

    public String getSrcAbsPathKey() {
        return this.srcAbsPathKey;
    }

    public void setSrcAbsPathKey(String srcAbsPathKey) {
        this.srcAbsPathKey = srcAbsPathKey;
    }

    public String getPersistentKey() {
        return this.persistentKey;
    }

    public void setPersistentKey(String persistentKey) {
        this.persistentKey = persistentKey;
    }
}

