/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.storageengine.rescon.disk.strategy;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.iotdb.commons.cluster.NodeStatus;
import org.apache.iotdb.commons.conf.CommonDescriptor;
import org.apache.iotdb.commons.utils.JVMCommonUtils;
import org.apache.iotdb.db.exception.DiskSpaceInsufficientException;
import org.apache.iotdb.db.storageengine.rescon.disk.FolderManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class DirectoryStrategy {
    protected static final Logger LOGGER = LoggerFactory.getLogger(DirectoryStrategy.class);
    List<String> folders = new ArrayList<String>();
    Map<String, FolderManager.FolderState> foldersStates = new HashMap<String, FolderManager.FolderState>();

    public void setFolders(List<String> folders) throws DiskSpaceInsufficientException {
        boolean hasSpace = false;
        for (String folder : folders) {
            if (!JVMCommonUtils.hasSpace((String)folder)) continue;
            hasSpace = true;
            break;
        }
        if (!hasSpace) {
            LOGGER.error("Disk space is insufficient, change system mode to read-only");
            CommonDescriptor.getInstance().getConfig().setNodeStatus(NodeStatus.ReadOnly);
            throw new DiskSpaceInsufficientException(folders);
        }
        this.folders = folders;
    }

    public void setFoldersStates(Map<String, FolderManager.FolderState> foldersStates) {
        this.foldersStates = foldersStates;
    }

    public void updateFolderState(String folder, FolderManager.FolderState state) {
        this.foldersStates.replace(folder, state);
    }

    public boolean isUnavailableFolder(String dir) {
        return this.foldersStates.getOrDefault(dir, FolderManager.FolderState.HEALTHY) != FolderManager.FolderState.HEALTHY;
    }

    public abstract int nextFolderIndex() throws DiskSpaceInsufficientException;
}

