/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ratis.server.impl;

import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicReference;
import org.apache.ratis.proto.RaftProtos;
import org.apache.ratis.protocol.RaftPeer;
import org.apache.ratis.protocol.RaftPeerId;
import org.apache.ratis.server.impl.FollowerState;
import org.apache.ratis.server.impl.LeaderElection;
import org.apache.ratis.server.impl.LeaderStateImpl;
import org.apache.ratis.server.impl.RaftServerImpl;
import org.apache.ratis.server.impl.ServerProtoUtils;
import org.apache.ratis.server.leader.LogAppender;
import org.apache.ratis.util.JavaUtils;
import org.apache.ratis.util.Preconditions;
import org.apache.ratis.util.Timestamp;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class RoleInfo {
    public static final Logger LOG = LoggerFactory.getLogger(RoleInfo.class);
    private final RaftPeerId id;
    private final AtomicReference<RaftProtos.RaftPeerRole> role = new AtomicReference();
    private final AtomicReference<LeaderStateImpl> leaderState = new AtomicReference();
    private final AtomicReference<FollowerState> followerState = new AtomicReference();
    private final AtomicReference<LeaderElection> leaderElection = new AtomicReference();
    private final AtomicBoolean pauseLeaderElection = new AtomicBoolean(false);
    private final AtomicReference<Timestamp> transitionTime;

    RoleInfo(RaftPeerId id) {
        this.id = id;
        this.transitionTime = new AtomicReference<Timestamp>(Timestamp.currentTime());
    }

    void transitionRole(RaftProtos.RaftPeerRole newRole) {
        this.role.set(newRole);
        this.transitionTime.set(Timestamp.currentTime());
    }

    long getRoleElapsedTimeMs() {
        return this.transitionTime.get().elapsedTimeMs();
    }

    RaftProtos.RaftPeerRole getCurrentRole() {
        return this.role.get();
    }

    boolean isLeaderReady() {
        return this.getLeaderState().map(LeaderStateImpl::isReady).orElse(false);
    }

    Optional<LeaderStateImpl> getLeaderState() {
        return Optional.ofNullable(this.leaderState.get());
    }

    LeaderStateImpl getLeaderStateNonNull() {
        return Objects.requireNonNull(this.leaderState.get(), "leaderState is null");
    }

    LeaderStateImpl updateLeaderState(RaftServerImpl server) {
        return this.updateAndGet(this.leaderState, new LeaderStateImpl(server));
    }

    CompletableFuture<Void> shutdownLeaderState(boolean allowNull) {
        LeaderStateImpl leader = this.leaderState.getAndSet(null);
        if (leader == null) {
            if (!allowNull) {
                return JavaUtils.completeExceptionally((Throwable)new NullPointerException("leaderState == null"));
            }
            return CompletableFuture.completedFuture(null);
        }
        LOG.info("{}: shutdown {}", (Object)this.id, (Object)leader);
        return leader.stop();
    }

    Optional<FollowerState> getFollowerState() {
        return Optional.ofNullable(this.followerState.get());
    }

    void startFollowerState(RaftServerImpl server, Object reason) {
        this.updateAndGet(this.followerState, new FollowerState(server, reason)).start();
    }

    CompletableFuture<Void> shutdownFollowerState() {
        FollowerState follower = this.followerState.getAndSet(null);
        if (follower == null) {
            return CompletableFuture.completedFuture(null);
        }
        LOG.info("{}: shutdown {}", (Object)this.id, (Object)follower);
        return follower.stopRunning();
    }

    void startLeaderElection(RaftServerImpl server, boolean force) {
        if (this.pauseLeaderElection.get()) {
            return;
        }
        this.updateAndGet(this.leaderElection, new LeaderElection(server, force)).start();
    }

    void setLeaderElectionPause(boolean pause) {
        this.pauseLeaderElection.set(pause);
    }

    CompletableFuture<Void> shutdownLeaderElection() {
        LeaderElection election = this.leaderElection.getAndSet(null);
        if (election == null) {
            return CompletableFuture.completedFuture(null);
        }
        LOG.info("{}: shutdown {}", (Object)this.id, (Object)election);
        return election.shutdown();
    }

    private <T> T updateAndGet(AtomicReference<T> ref, T current) {
        T updated = ref.updateAndGet(previous -> previous != null ? previous : current);
        Preconditions.assertTrue((updated == current ? 1 : 0) != 0, (Object)"previous != null");
        LOG.info("{}: start {}", (Object)this.id, current);
        return updated;
    }

    RaftProtos.RoleInfoProto buildRoleInfoProto(RaftServerImpl server) {
        RaftProtos.RaftPeerRole currentRole = this.getCurrentRole();
        RaftProtos.RoleInfoProto.Builder proto = RaftProtos.RoleInfoProto.newBuilder().setSelf(server.getPeer().getRaftPeerProto()).setRole(currentRole).setRoleElapsedTimeMs(this.getRoleElapsedTimeMs());
        switch (currentRole) {
            case LEADER: {
                this.getLeaderState().ifPresent(leader -> {
                    RaftProtos.LeaderInfoProto.Builder b = RaftProtos.LeaderInfoProto.newBuilder().setTerm(leader.getCurrentTerm());
                    leader.getLogAppenders().map(LogAppender::getFollower).map(f -> ServerProtoUtils.toServerRpcProto(f.getPeer(), f.getLastRpcResponseTime().elapsedTimeMs())).forEach(arg_0 -> ((RaftProtos.LeaderInfoProto.Builder)b).addFollowerInfo(arg_0));
                    proto.setLeaderInfo(b);
                });
                return proto.build();
            }
            case CANDIDATE: {
                return proto.setCandidateInfo(RaftProtos.CandidateInfoProto.newBuilder().setLastLeaderElapsedTimeMs(server.getState().getLastLeaderElapsedTimeMs())).build();
            }
            case LISTENER: 
            case FOLLOWER: {
                int outstandingOp;
                long rpcElapsed;
                FollowerState follower = this.getFollowerState().orElse(null);
                if (follower != null) {
                    rpcElapsed = follower.getLastRpcTime().elapsedTimeMs();
                    outstandingOp = follower.getOutstandingOp();
                } else {
                    rpcElapsed = 0L;
                    outstandingOp = 0;
                }
                RaftPeer leader2 = server.getRaftConf().getPeer(server.getState().getLeaderId(), new RaftProtos.RaftPeerRole[0]);
                return proto.setFollowerInfo(RaftProtos.FollowerInfoProto.newBuilder().setLeaderInfo(ServerProtoUtils.toServerRpcProto(leader2, rpcElapsed)).setOutstandingOp(outstandingOp)).build();
            }
        }
        throw new IllegalStateException("Unexpected role " + currentRole);
    }

    public String toString() {
        return String.format("%9s", this.role);
    }
}

