/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tsfile.enums;

import java.io.DataOutputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.ByteBuffer;
import org.apache.tsfile.write.UnSupportedDataTypeException;

public enum TSDataType {
    BOOLEAN(0),
    INT32(1),
    INT64(2),
    FLOAT(3),
    DOUBLE(4),
    TEXT(5),
    VECTOR(6),
    UNKNOWN(7),
    TIMESTAMP(8),
    DATE(9),
    BLOB(10),
    STRING(11);

    private final byte type;

    private TSDataType(byte type) {
        this.type = type;
    }

    public static TSDataType deserialize(byte type) {
        return TSDataType.getTsDataType(type);
    }

    public byte getType() {
        return this.type;
    }

    public static TSDataType getTsDataType(byte type) {
        switch (type) {
            case 0: {
                return BOOLEAN;
            }
            case 1: {
                return INT32;
            }
            case 2: {
                return INT64;
            }
            case 3: {
                return FLOAT;
            }
            case 4: {
                return DOUBLE;
            }
            case 5: {
                return TEXT;
            }
            case 6: {
                return VECTOR;
            }
            case 7: {
                return UNKNOWN;
            }
            case 8: {
                return TIMESTAMP;
            }
            case 9: {
                return DATE;
            }
            case 10: {
                return BLOB;
            }
            case 11: {
                return STRING;
            }
        }
        throw new IllegalArgumentException("Invalid input: " + type);
    }

    public static TSDataType deserializeFrom(ByteBuffer buffer) {
        return TSDataType.deserialize(buffer.get());
    }

    public static TSDataType deserializeFrom(InputStream stream) throws IOException {
        return TSDataType.deserialize((byte)stream.read());
    }

    public static int getSerializedSize() {
        return 1;
    }

    public void serializeTo(ByteBuffer byteBuffer) {
        byteBuffer.put(this.serialize());
    }

    public void serializeTo(DataOutputStream outputStream) throws IOException {
        outputStream.write(this.serialize());
    }

    public void serializeTo(FileOutputStream outputStream) throws IOException {
        outputStream.write(this.serialize());
    }

    public int getDataTypeSize() {
        switch (this) {
            case BOOLEAN: {
                return 1;
            }
            case INT32: 
            case FLOAT: 
            case DATE: {
                return 4;
            }
            case TEXT: 
            case INT64: 
            case DOUBLE: 
            case VECTOR: 
            case BLOB: 
            case STRING: 
            case TIMESTAMP: {
                return 8;
            }
        }
        throw new UnSupportedDataTypeException(this.toString());
    }

    public byte serialize() {
        return this.type;
    }

    public boolean isNumeric() {
        switch (this) {
            case INT32: 
            case FLOAT: 
            case INT64: 
            case DOUBLE: {
                return true;
            }
            case BOOLEAN: 
            case DATE: 
            case TEXT: 
            case VECTOR: 
            case BLOB: 
            case STRING: 
            case TIMESTAMP: {
                return false;
            }
        }
        throw new UnSupportedDataTypeException(this.toString());
    }

    public boolean isComparable() {
        switch (this) {
            case BOOLEAN: 
            case INT32: 
            case FLOAT: 
            case DATE: 
            case TEXT: 
            case INT64: 
            case DOUBLE: 
            case STRING: 
            case TIMESTAMP: {
                return true;
            }
            case VECTOR: 
            case BLOB: {
                return false;
            }
        }
        throw new UnSupportedDataTypeException(this.toString());
    }

    public boolean isBinary() {
        return this == TEXT || this == STRING || this == BLOB;
    }
}

