/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite3.raft.jraft.core;

import com.codahale.metrics.Metric;
import com.lmax.disruptor.EventFactory;
import com.lmax.disruptor.EventHandler;
import com.lmax.disruptor.EventTranslator;
import com.lmax.disruptor.RingBuffer;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.NavigableMap;
import java.util.TreeMap;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import org.apache.ignite3.internal.logger.IgniteLogger;
import org.apache.ignite3.internal.logger.Loggers;
import org.apache.ignite3.internal.util.ArrayUtils;
import org.apache.ignite3.raft.jraft.FSMCaller;
import org.apache.ignite3.raft.jraft.ReadOnlyService;
import org.apache.ignite3.raft.jraft.Status;
import org.apache.ignite3.raft.jraft.closure.ReadIndexClosure;
import org.apache.ignite3.raft.jraft.core.NodeImpl;
import org.apache.ignite3.raft.jraft.core.NodeMetrics;
import org.apache.ignite3.raft.jraft.disruptor.DisruptorEventType;
import org.apache.ignite3.raft.jraft.disruptor.NodeIdAware;
import org.apache.ignite3.raft.jraft.disruptor.StripedDisruptor;
import org.apache.ignite3.raft.jraft.entity.ReadIndexState;
import org.apache.ignite3.raft.jraft.entity.ReadIndexStatus;
import org.apache.ignite3.raft.jraft.error.OverloadException;
import org.apache.ignite3.raft.jraft.error.RaftError;
import org.apache.ignite3.raft.jraft.error.RaftException;
import org.apache.ignite3.raft.jraft.option.RaftOptions;
import org.apache.ignite3.raft.jraft.option.ReadOnlyServiceOptions;
import org.apache.ignite3.raft.jraft.rpc.ReadIndexRequestBuilder;
import org.apache.ignite3.raft.jraft.rpc.RpcRequests;
import org.apache.ignite3.raft.jraft.rpc.RpcResponseClosureAdapter;
import org.apache.ignite3.raft.jraft.util.Bytes;
import org.apache.ignite3.raft.jraft.util.DisruptorMetricSet;
import org.apache.ignite3.raft.jraft.util.OnlyForTest;
import org.apache.ignite3.raft.jraft.util.Utils;

public class ReadOnlyServiceImpl
implements ReadOnlyService,
FSMCaller.LastAppliedLogIndexListener {
    private StripedDisruptor<ReadIndexEvent> readIndexDisruptor;
    private RingBuffer<ReadIndexEvent> readIndexQueue;
    private RaftOptions raftOptions;
    private NodeImpl node;
    private final Lock lock = new ReentrantLock();
    private FSMCaller fsmCaller;
    private volatile CountDownLatch shutdownLatch;
    private NodeMetrics nodeMetrics;
    private volatile RaftException error;
    private final TreeMap<Long, List<ReadIndexStatus>> pendingNotifyStatus = new TreeMap();
    private static final IgniteLogger LOG = Loggers.forClass(ReadOnlyServiceImpl.class);

    private void executeReadIndexEvents(List<ReadIndexEvent> events) {
        if (events.isEmpty()) {
            return;
        }
        ReadIndexRequestBuilder rb = this.raftOptions.getRaftMessagesFactory().readIndexRequest().groupId(this.node.getGroupId()).serverId(this.node.getServerId().toString());
        ArrayList<ReadIndexState> states = new ArrayList<ReadIndexState>(events.size());
        ArrayList<ByteBuffer> entries = new ArrayList<ByteBuffer>(events.size());
        for (ReadIndexEvent event : events) {
            byte[] ctx = event.requestContext.get();
            entries.add(ctx == null ? ArrayUtils.EMPTY_BYTE_BUFFER : ByteBuffer.wrap(ctx));
            states.add(new ReadIndexState(event.requestContext, event.done, event.startTime));
        }
        RpcRequests.ReadIndexRequest request = rb.entriesList(entries).build();
        this.node.handleReadIndexRequest(request, new ReadIndexResponseClosure(states, request));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void resetPendingStatusError(Status st) {
        this.lock.lock();
        try {
            Iterator<List<ReadIndexStatus>> it = this.pendingNotifyStatus.values().iterator();
            while (it.hasNext()) {
                List<ReadIndexStatus> statuses = it.next();
                for (ReadIndexStatus status : statuses) {
                    this.reportError(status, st);
                }
                it.remove();
            }
        }
        finally {
            this.lock.unlock();
        }
    }

    @Override
    public boolean init(ReadOnlyServiceOptions opts) {
        this.node = opts.getNode();
        this.nodeMetrics = this.node.getNodeMetrics();
        this.fsmCaller = opts.getFsmCaller();
        this.raftOptions = opts.getRaftOptions();
        this.readIndexDisruptor = opts.getReadOnlyServiceDisruptor();
        this.readIndexQueue = this.readIndexDisruptor.subscribe(this.node.getNodeId(), new ReadIndexEventHandler());
        if (this.nodeMetrics.getMetricRegistry() != null) {
            this.nodeMetrics.getMetricRegistry().register("jraft-read-only-service-disruptor", (Metric)new DisruptorMetricSet(this.readIndexQueue));
        }
        this.fsmCaller.addLastAppliedLogIndexListener(this);
        this.node.getOptions().getScheduler().scheduleAtFixedRate(() -> this.onApplied(this.fsmCaller.getLastAppliedIndex()), this.raftOptions.getMaxElectionDelayMs(), this.raftOptions.getMaxElectionDelayMs(), TimeUnit.MILLISECONDS);
        return true;
    }

    @Override
    public synchronized void setError(RaftException error) {
        if (this.error == null) {
            this.error = error;
        }
    }

    @Override
    public synchronized void shutdown() {
        if (this.shutdownLatch != null) {
            return;
        }
        this.shutdownLatch = new CountDownLatch(1);
        Utils.runInThread(this.node.getOptions().getCommonExecutor(), () -> this.readIndexQueue.publishEvent((event, sequence) -> {
            event.nodeId = this.node.getNodeId();
            event.handler = null;
            event.evtType = DisruptorEventType.REGULAR;
            event.shutdownLatch = this.shutdownLatch;
        }));
    }

    @Override
    public void join() throws InterruptedException {
        if (this.shutdownLatch != null) {
            this.shutdownLatch.await();
        }
        this.readIndexDisruptor.unsubscribe(this.node.getNodeId());
        this.resetPendingStatusError(new Status(RaftError.ESTOP, "Node is quit.", new Object[0]));
    }

    @Override
    public void addRequest(byte[] reqCtx, ReadIndexClosure closure) {
        if (this.shutdownLatch != null) {
            Utils.runClosureInThread(this.node.getOptions().getCommonExecutor(), closure, new Status(RaftError.EHOSTDOWN, "Was stopped", new Object[0]));
            throw new IllegalStateException("Service already shutdown.");
        }
        try {
            EventTranslator translator = (event, sequence) -> {
                event.nodeId = this.node.getNodeId();
                event.handler = null;
                event.evtType = DisruptorEventType.REGULAR;
                event.done = closure;
                event.requestContext = new Bytes(reqCtx);
                event.startTime = Utils.monotonicMs();
            };
            switch (this.node.getOptions().getApplyTaskMode()) {
                case Blocking: {
                    this.readIndexQueue.publishEvent(translator);
                    break;
                }
                default: {
                    if (!this.readIndexQueue.tryPublishEvent(translator)) {
                        String errorMsg = "Node is busy, has too many read-index requests, queue is full and bufferSize=" + this.readIndexQueue.getBufferSize();
                        Utils.runClosureInThread(this.node.getOptions().getCommonExecutor(), closure, new Status(RaftError.EBUSY, errorMsg, new Object[0]));
                        this.nodeMetrics.recordTimes("read-index-overload-times", 1L);
                        LOG.warn("Node {} ReadOnlyServiceImpl readIndexQueue is overload.", this.node.getNodeId());
                        if (closure == null) {
                            throw new OverloadException(errorMsg);
                        }
                    }
                    break;
                }
            }
        }
        catch (Exception e) {
            Utils.runClosureInThread(this.node.getOptions().getCommonExecutor(), closure, new Status(RaftError.EPERM, "Node is down.", new Object[0]));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void onApplied(long appliedIndex) {
        ArrayList pendingStatuses = null;
        this.lock.lock();
        try {
            if (this.pendingNotifyStatus.isEmpty()) {
                return;
            }
            NavigableMap<Long, List<ReadIndexStatus>> statuses = this.pendingNotifyStatus.headMap(appliedIndex, true);
            if (statuses != null) {
                pendingStatuses = new ArrayList(statuses.size() << 1);
                Iterator it = statuses.entrySet().iterator();
                while (it.hasNext()) {
                    Map.Entry entry = it.next();
                    pendingStatuses.addAll((Collection)entry.getValue());
                    it.remove();
                }
            }
            if (this.error != null) {
                this.resetPendingStatusError(this.error.getStatus());
            }
        }
        finally {
            this.lock.unlock();
            if (pendingStatuses != null && !pendingStatuses.isEmpty()) {
                for (ReadIndexStatus status : pendingStatuses) {
                    this.notifySuccess(status);
                }
            }
        }
    }

    @OnlyForTest
    void flush() throws InterruptedException {
        CountDownLatch latch = new CountDownLatch(1);
        this.readIndexQueue.publishEvent((task, sequence) -> {
            task.nodeId = this.node.getNodeId();
            task.handler = null;
            task.evtType = DisruptorEventType.REGULAR;
            task.shutdownLatch = latch;
        });
        latch.await();
    }

    @OnlyForTest
    TreeMap<Long, List<ReadIndexStatus>> getPendingNotifyStatus() {
        return this.pendingNotifyStatus;
    }

    @OnlyForTest
    RaftOptions getRaftOptions() {
        return this.raftOptions;
    }

    private void reportError(ReadIndexStatus status, Status st) {
        long nowMs = Utils.monotonicMs();
        List<ReadIndexState> states = status.getStates();
        int taskCount = states.size();
        for (int i = 0; i < taskCount; ++i) {
            ReadIndexState task = states.get(i);
            ReadIndexClosure done = task.getDone();
            if (done == null) continue;
            this.nodeMetrics.recordLatency("read-index", nowMs - task.getStartTimeMs());
            done.run(st);
        }
    }

    private void notifySuccess(ReadIndexStatus status) {
        long nowMs = Utils.monotonicMs();
        List<ReadIndexState> states = status.getStates();
        int taskCount = states.size();
        for (int i = 0; i < taskCount; ++i) {
            ReadIndexState task = states.get(i);
            ReadIndexClosure done = task.getDone();
            if (done == null) continue;
            this.nodeMetrics.recordLatency("read-index", nowMs - task.getStartTimeMs());
            done.setResult(task.getIndex(), task.getRequestContext().get());
            done.run(Status.OK());
        }
    }

    public static class ReadIndexEvent
    extends NodeIdAware {
        Bytes requestContext;
        ReadIndexClosure done;
        CountDownLatch shutdownLatch;
        long startTime;

        @Override
        public void reset() {
            super.reset();
            this.requestContext = null;
            this.done = null;
            this.shutdownLatch = null;
            this.startTime = 0L;
        }
    }

    class ReadIndexResponseClosure
    extends RpcResponseClosureAdapter<RpcRequests.ReadIndexResponse> {
        final List<ReadIndexState> states;
        final RpcRequests.ReadIndexRequest request;

        ReadIndexResponseClosure(List<ReadIndexState> states, RpcRequests.ReadIndexRequest request) {
            this.states = states;
            this.request = request;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run(Status status) {
            if (!status.isOk()) {
                this.notifyFail(status);
                return;
            }
            RpcRequests.ReadIndexResponse readIndexResponse = (RpcRequests.ReadIndexResponse)this.getResponse();
            if (!readIndexResponse.success()) {
                this.notifyFail(new Status(-1, "Fail to run ReadIndex task, maybe the leader stepped down."));
                return;
            }
            ReadIndexStatus readIndexStatus = new ReadIndexStatus(this.states, this.request, readIndexResponse.index());
            for (ReadIndexState state : this.states) {
                state.setIndex(readIndexResponse.index());
            }
            boolean doUnlock = true;
            ReadOnlyServiceImpl.this.lock.lock();
            try {
                if (readIndexStatus.isApplied(ReadOnlyServiceImpl.this.fsmCaller.getLastAppliedIndex())) {
                    ReadOnlyServiceImpl.this.lock.unlock();
                    doUnlock = false;
                    ReadOnlyServiceImpl.this.notifySuccess(readIndexStatus);
                } else if (readIndexStatus.isOverMaxReadIndexLag(ReadOnlyServiceImpl.this.fsmCaller.getLastAppliedIndex(), ReadOnlyServiceImpl.this.raftOptions.getMaxReadIndexLag())) {
                    ReadOnlyServiceImpl.this.lock.unlock();
                    doUnlock = false;
                    this.notifyFail(new Status(-1, "Fail to run ReadIndex task, the gap of current node's apply index between leader's commit index over maxReadIndexLag"));
                } else {
                    ReadOnlyServiceImpl.this.pendingNotifyStatus.computeIfAbsent(readIndexStatus.getIndex(), k -> new ArrayList(10)).add(readIndexStatus);
                }
            }
            finally {
                if (doUnlock) {
                    ReadOnlyServiceImpl.this.lock.unlock();
                }
            }
        }

        private void notifyFail(Status status) {
            long nowMs = Utils.monotonicMs();
            for (ReadIndexState state : this.states) {
                ReadOnlyServiceImpl.this.nodeMetrics.recordLatency("read-index", nowMs - state.getStartTimeMs());
                ReadIndexClosure done = state.getDone();
                if (done == null) continue;
                Bytes reqCtx = state.getRequestContext();
                done.run(status, -1L, reqCtx != null ? reqCtx.get() : null);
            }
        }
    }

    private class ReadIndexEventHandler
    implements EventHandler<ReadIndexEvent> {
        private final List<ReadIndexEvent> events;

        private ReadIndexEventHandler() {
            this.events = new ArrayList<ReadIndexEvent>(ReadOnlyServiceImpl.this.raftOptions.getApplyBatch());
        }

        public void onEvent(ReadIndexEvent newEvent, long sequence, boolean endOfBatch) throws Exception {
            if (newEvent.shutdownLatch != null) {
                ReadOnlyServiceImpl.this.executeReadIndexEvents(this.events);
                this.reset();
                newEvent.shutdownLatch.countDown();
                return;
            }
            this.events.add(newEvent);
            if (this.events.size() >= ReadOnlyServiceImpl.this.raftOptions.getApplyBatch() || endOfBatch) {
                ReadOnlyServiceImpl.this.executeReadIndexEvents(this.events);
                this.reset();
            }
        }

        private void reset() {
            for (ReadIndexEvent event : this.events) {
                event.reset();
            }
            this.events.clear();
        }
    }

    private static class ReadIndexEventFactory
    implements EventFactory<ReadIndexEvent> {
        private ReadIndexEventFactory() {
        }

        public ReadIndexEvent newInstance() {
            return new ReadIndexEvent();
        }
    }
}

