/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.util;

import java.util.Arrays;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.Executor;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.Supplier;
import org.apache.ignite.internal.util.CompletableFutures;
import org.apache.ignite.internal.util.VersatileReadWriteLock;

public class StripedVersatileReadWriteLock {
    private static final int DEFAULT_CONCURRENCY = Math.max(1, Runtime.getRuntime().availableProcessors() / 2);
    private final VersatileReadWriteLock[] locks;
    private static final AtomicInteger INDEX_GENERATOR = new AtomicInteger();
    private static final ThreadLocal<Integer> INDEX = ThreadLocal.withInitial(INDEX_GENERATOR::incrementAndGet);

    public StripedVersatileReadWriteLock(Executor asyncContinuationExecutor) {
        this(asyncContinuationExecutor, DEFAULT_CONCURRENCY);
    }

    private StripedVersatileReadWriteLock(Executor asyncContinuationExecutor, int concurrency) {
        assert (concurrency > 0) : "Concurrency must be positive, but was: " + concurrency;
        this.locks = new VersatileReadWriteLock[concurrency];
        for (int i = 0; i < concurrency; ++i) {
            this.locks[i] = new VersatileReadWriteLock(asyncContinuationExecutor);
        }
    }

    private int currentIndex() {
        int index = INDEX.get();
        return index % this.locks.length;
    }

    private VersatileReadWriteLock currentLock() {
        return this.locks[this.currentIndex()];
    }

    public void readLock() {
        this.currentLock().readLock();
    }

    public boolean tryReadLock() {
        return this.currentLock().tryReadLock();
    }

    public void readUnlock() {
        this.currentLock().readUnlock();
    }

    private void readUnlock(int idx) {
        this.locks[idx].readUnlock();
    }

    public void writeLock() {
        for (VersatileReadWriteLock lock : this.locks) {
            lock.writeLock();
        }
    }

    private void writeUnlock0(int fromIndex) {
        for (int i = fromIndex; i >= 0; --i) {
            this.locks[i].writeUnlock();
        }
    }

    public boolean tryWriteLock() {
        int i;
        try {
            for (i = 0; i < this.locks.length; ++i) {
                if (this.locks[i].tryWriteLock()) continue;
                break;
            }
        }
        finally {
            if (0 < i && i < this.locks.length) {
                this.writeUnlock0(i - 1);
            }
        }
        return i == this.locks.length;
    }

    public void writeUnlock() {
        this.writeUnlock0(this.locks.length - 1);
    }

    public <T> CompletableFuture<T> inReadLockAsync(Supplier<? extends CompletableFuture<T>> action) {
        int index = this.currentIndex();
        return ((CompletableFuture)this.locks[index].readLockAsync().thenCompose(unused -> (CompletionStage)action.get())).whenComplete((res, ex) -> this.readUnlock(index));
    }

    public <T> CompletableFuture<T> inWriteLockAsync(Supplier<? extends CompletableFuture<T>> action) {
        return ((CompletableFuture)this.writeLockAsync().thenCompose(unused -> (CompletionStage)action.get())).whenComplete((res, ex) -> this.writeUnlock());
    }

    private CompletableFuture<Void> writeLockAsync() {
        CompletionStage<Void> future = CompletableFutures.nullCompletedFuture();
        for (VersatileReadWriteLock lock : this.locks) {
            future = future.thenCompose(unused -> lock.writeLockAsync());
        }
        return future;
    }

    int readLocksHeld() {
        return Arrays.stream(this.locks).mapToInt(VersatileReadWriteLock::readLocksHeld).sum();
    }

    boolean isWriteLocked() {
        return Arrays.stream(this.locks).anyMatch(VersatileReadWriteLock::isWriteLocked);
    }
}

