/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.core.optim;

import io.micronaut.core.annotation.Internal;
import io.micronaut.core.annotation.NonNull;
import java.util.Map;
import java.util.Optional;
import java.util.ServiceLoader;
import java.util.concurrent.ConcurrentHashMap;

@Internal
public abstract class StaticOptimizations {
    private static final boolean CAPTURE_STACKTRACE_ON_READ = Boolean.getBoolean("micronaut.optimizations.capture.read.trace");
    private static final Map<Class<?>, Object> OPTIMIZATIONS = new ConcurrentHashMap();
    private static final Map<Class<?>, StackTraceElement[]> CHECKED = new ConcurrentHashMap();
    private static boolean cacheEnvironment = false;

    static void reset() {
        OPTIMIZATIONS.clear();
        CHECKED.clear();
        ServiceLoader.load(Loader.class).forEach(loader -> StaticOptimizations.set(loader.load()));
    }

    public static void cacheEnvironment() {
        cacheEnvironment = true;
    }

    @NonNull
    public static <T> Optional<T> get(@NonNull Class<T> optimizationClass) {
        CHECKED.put(optimizationClass, StaticOptimizations.maybeCaptureStackTrace());
        Object value = OPTIMIZATIONS.get(optimizationClass);
        return Optional.ofNullable(value);
    }

    private static StackTraceElement[] maybeCaptureStackTrace() {
        if (CAPTURE_STACKTRACE_ON_READ) {
            return new Exception().getStackTrace();
        }
        return new StackTraceElement[0];
    }

    public static <T> void set(@NonNull T value) {
        Class<?> optimizationClass = value.getClass();
        if (CHECKED.containsKey(optimizationClass)) {
            StackTraceElement[] stackTrace;
            if (!CAPTURE_STACKTRACE_ON_READ) {
                throw new IllegalStateException("Optimization state for " + optimizationClass + " was read before it was set. Run with -Dmicronaut.optimizations.capture.read.trace=true to enable stack trace capture.");
            }
            StringBuilder sb = new StringBuilder("Optimization state for " + optimizationClass + " was read before it was set. Stack trace:\n");
            for (StackTraceElement element : stackTrace = CHECKED.get(optimizationClass)) {
                sb.append("\t").append(element.toString()).append("\n");
            }
            throw new IllegalStateException(sb.toString());
        }
        OPTIMIZATIONS.put(optimizationClass, value);
    }

    public static boolean isEnvironmentCached() {
        return cacheEnvironment;
    }

    static {
        StaticOptimizations.reset();
    }

    @FunctionalInterface
    public static interface Loader<T> {
        public T load();
    }
}

