/*
 *  Licensed to the Apache Software Foundation (ASF) under one
 *  or more contributor license agreements.  See the NOTICE file
 *  distributed with this work for additional information
 *  regarding copyright ownership.  The ASF licenses this file
 *  to you under the Apache License, Version 2.0 (the
 *  "License"); you may not use this file except in compliance
 *  with the License.  You may obtain a copy of the License at
 *
 *    https://www.apache.org/licenses/LICENSE-2.0
 *
 *  Unless required by applicable law or agreed to in writing,
 *  software distributed under the License is distributed on an
 *  "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 *  KIND, either express or implied.  See the License for the
 *  specific language governing permissions and limitations
 *  under the License.
 */
package org.grails.datastore.gorm

import grails.persistence.Entity
import org.apache.grails.data.simple.core.GrailsDataCoreTckManager
import org.apache.grails.data.testing.tck.base.GrailsDataTckSpec
import spock.lang.Issue

/**
 * @author graemerocher
 */
class InOperatorWithAssociationsSpec extends GrailsDataTckSpec<GrailsDataCoreTckManager> {
    void setupSpec() {
        manager.domainClasses.addAll([InAuthor, InBook])
    }

    @Issue('https://github.com/apache/grails-core/issues/9279')
    void "Test query association using in operator in where query"() {
        setup: "Creating authors and books."
        InAuthor adams = new InAuthor(name: "Douglas Adams").save(failOnError: 'true')
        InAuthor meyerhoff = new InAuthor(name: "Joachim Meyerhoff").save(failOnError: 'true')
        new InBook(name: 'Per Anhalter durch die Galaxis', author: adams).save(failOnError: 'true')
        new InBook(name: 'Wann wird es endlich wieder so, wie es nie war', author: meyerhoff).save(failOnError: 'true', flush: true)
        def authors = [adams, meyerhoff]
        manager.session.clear()

        when: "Getting books by list of authors."
        List<InBook> books = InBook.where { author in authors }.list()

        then: "The service will find them"
        books.size() == 2
    }
}

@Entity
class InAuthor {
    Long id
    String name
}

@Entity
class InBook {
    Long id
    String name
    InAuthor author
}
