/*
 * Decompiled with CFR 0.152.
 */
package org.apache.datasketches.filters.bloomfilter;

import java.lang.foreign.MemorySegment;
import java.util.Arrays;
import org.apache.datasketches.common.SketchesArgumentException;
import org.apache.datasketches.common.Util;
import org.apache.datasketches.common.positional.PositionalSegment;
import org.apache.datasketches.filters.bloomfilter.BitArray;

final class HeapBitArray
extends BitArray {
    private long numBitsSet_;
    private boolean isDirty_;
    private final long[] data_;

    HeapBitArray(long numBits) {
        if (numBits <= 0L) {
            throw new SketchesArgumentException("Number of bits must be strictly positive. Found: " + numBits);
        }
        if (numBits > 137438953408L) {
            throw new SketchesArgumentException("Number of bits may not exceed 137438953408. Found: " + numBits);
        }
        int numLongs = (int)Util.ceilingMultiple2expK(numBits, 6);
        this.numBitsSet_ = 0L;
        this.isDirty_ = false;
        this.data_ = new long[numLongs];
    }

    HeapBitArray(long numBitsSet, long[] data) {
        this.data_ = data;
        this.isDirty_ = numBitsSet < 0L;
        this.numBitsSet_ = numBitsSet;
    }

    static HeapBitArray heapify(PositionalSegment posSeg, boolean isEmpty) {
        int numLongs = posSeg.getInt();
        if (numLongs < 0) {
            throw new SketchesArgumentException("Possible corruption: Must have non-negative array size. Found: " + numLongs);
        }
        if (isEmpty) {
            return new HeapBitArray((long)numLongs * 64L);
        }
        posSeg.getInt();
        long numBitsSet = posSeg.getLong();
        long[] data = new long[numLongs];
        posSeg.getLongArray(data, 0, numLongs);
        return new HeapBitArray(numBitsSet, data);
    }

    @Override
    protected boolean isDirty() {
        return this.isDirty_;
    }

    @Override
    public boolean hasMemorySegment() {
        return false;
    }

    @Override
    public boolean isOffHeap() {
        return false;
    }

    @Override
    boolean isReadOnly() {
        return false;
    }

    @Override
    public boolean isSameResource(MemorySegment that) {
        return false;
    }

    @Override
    boolean getBit(long index) {
        return (this.data_[(int)index >>> 6] & 1L << (int)index) != 0L;
    }

    @Override
    void setBit(long index) {
        int n = (int)index >>> 6;
        this.data_[n] = this.data_[n] | 1L << (int)index;
        this.isDirty_ = true;
    }

    @Override
    boolean getAndSetBit(long index) {
        int offset = (int)index >>> 6;
        long mask = 1L << (int)index;
        if ((this.data_[offset] & mask) != 0L) {
            return true;
        }
        int n = offset;
        this.data_[n] = this.data_[n] | mask;
        ++this.numBitsSet_;
        return false;
    }

    @Override
    long getNumBitsSet() {
        if (this.isDirty_) {
            this.numBitsSet_ = 0L;
            for (long val : this.data_) {
                this.numBitsSet_ += (long)Long.bitCount(val);
            }
        }
        return this.numBitsSet_;
    }

    @Override
    long getCapacity() {
        return (long)this.data_.length * 64L;
    }

    @Override
    int getArrayLength() {
        return this.data_.length;
    }

    @Override
    void union(BitArray other) {
        if (this.getCapacity() != other.getCapacity()) {
            throw new SketchesArgumentException("Cannot union bit arrays with unequal lengths");
        }
        this.numBitsSet_ = 0L;
        for (int i = 0; i < this.data_.length; ++i) {
            long val = this.data_[i] | other.getLong(i);
            this.numBitsSet_ += (long)Long.bitCount(val);
            this.data_[i] = val;
        }
        this.isDirty_ = false;
    }

    @Override
    void intersect(BitArray other) {
        if (this.getCapacity() != other.getCapacity()) {
            throw new SketchesArgumentException("Cannot intersect bit arrays with unequal lengths");
        }
        this.numBitsSet_ = 0L;
        for (int i = 0; i < this.data_.length; ++i) {
            long val = this.data_[i] & other.getLong(i);
            this.numBitsSet_ += (long)Long.bitCount(val);
            this.data_[i] = val;
        }
        this.isDirty_ = false;
    }

    @Override
    void invert() {
        if (this.isDirty_) {
            this.numBitsSet_ = 0L;
            for (int i = 0; i < this.data_.length; ++i) {
                this.data_[i] = this.data_[i] ^ 0xFFFFFFFFFFFFFFFFL;
                this.numBitsSet_ += (long)Long.bitCount(this.data_[i]);
            }
            this.isDirty_ = false;
        } else {
            for (int i = 0; i < this.data_.length; ++i) {
                this.data_[i] = this.data_[i] ^ 0xFFFFFFFFFFFFFFFFL;
            }
            this.numBitsSet_ = this.getCapacity() - this.numBitsSet_;
        }
    }

    void writeToSegmentAsStream(PositionalSegment posSeg) {
        posSeg.setInt(this.data_.length);
        posSeg.setInt(0);
        if (!this.isEmpty()) {
            posSeg.setLong(this.isDirty_ ? -1L : this.numBitsSet_);
            posSeg.setLongArray(this.data_, 0, this.data_.length);
        }
    }

    @Override
    protected long getLong(int arrayIndex) {
        return this.data_[arrayIndex];
    }

    @Override
    protected void setLong(int arrayIndex, long value) {
        this.data_[arrayIndex] = value;
    }

    @Override
    void reset() {
        Arrays.fill(this.data_, 0L);
        this.numBitsSet_ = 0L;
        this.isDirty_ = false;
    }
}

