/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.javascript;

import java.util.EnumSet;
import org.mozilla.javascript.BaseFunction;
import org.mozilla.javascript.Context;
import org.mozilla.javascript.DecompilerFlag;
import org.mozilla.javascript.EvaluatorException;
import org.mozilla.javascript.NativeCall;
import org.mozilla.javascript.ScriptRuntime;
import org.mozilla.javascript.Scriptable;
import org.mozilla.javascript.debug.DebuggableScript;

public abstract class NativeFunction
extends BaseFunction {
    private static final long serialVersionUID = 8713897114082216401L;
    private boolean isShorthand;

    public final void initScriptFunction(Context cx, Scriptable scope, boolean es6GeneratorFunction, boolean isShorthand) {
        ScriptRuntime.setFunctionProtoAndParent(this, cx, scope, es6GeneratorFunction);
        if (!isShorthand) {
            this.setupDefaultPrototype(scope);
        }
        this.isShorthand = isShorthand;
    }

    @Override
    String decompile(int indent, EnumSet<DecompilerFlag> flags) {
        String rawSource = this.getRawSource();
        if (rawSource != null) {
            return rawSource;
        }
        return super.decompile(indent, flags);
    }

    @Override
    public int getLength() {
        int paramCount = this.getParamCount();
        if (this.getLanguageVersion() != 120) {
            return paramCount;
        }
        Context cx = Context.getContext();
        NativeCall activation = ScriptRuntime.findFunctionActivation(cx, this);
        if (activation == null) {
            return paramCount;
        }
        return activation.originalArgs.length;
    }

    @Override
    public int getArity() {
        return this.getParamCount();
    }

    @Deprecated
    public String jsGet_name() {
        return this.getFunctionName();
    }

    public String getRawSource() {
        return null;
    }

    public DebuggableScript getDebuggableView() {
        return null;
    }

    public Object resumeGenerator(Context cx, Scriptable scope, int operation, Object state, Object value) {
        throw new EvaluatorException("resumeGenerator() not implemented");
    }

    protected abstract int getLanguageVersion();

    protected abstract int getParamCount();

    protected abstract int getParamAndVarCount();

    protected abstract String getParamOrVarName(int var1);

    protected boolean getParamOrVarConst(int index) {
        return false;
    }

    public abstract boolean isStrict();

    public boolean isShorthand() {
        return this.isShorthand;
    }
}

