/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.core.remoting.impl.ssl;

import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import javax.net.ssl.SSLContext;
import org.apache.activemq.artemis.core.remoting.impl.ssl.DefaultSSLContextFactory;
import org.apache.activemq.artemis.spi.core.remoting.ssl.SSLContextConfig;
import org.apache.activemq.artemis.utils.ConfigurationHelper;

public class CachingSSLContextFactory
extends DefaultSSLContextFactory {
    private static final ConcurrentMap<Object, SSLContext> sslContextCache = new ConcurrentHashMap<Object, SSLContext>(2);

    @Override
    public void clearSSLContexts() {
        sslContextCache.clear();
    }

    @Override
    public SSLContext getSSLContext(SSLContextConfig config, Map<String, Object> additionalOpts) throws Exception {
        Object cacheKey = this.getCacheKey(config, additionalOpts);
        return sslContextCache.computeIfAbsent(cacheKey, key -> {
            try {
                return CachingSSLContextFactory.super.getSSLContext(config, additionalOpts);
            }
            catch (Exception ex) {
                throw new RuntimeException("An unexpected exception occured while creating JDK SSLContext with " + String.valueOf(config), ex);
            }
        });
    }

    protected Object getCacheKey(SSLContextConfig config, Map<String, Object> additionalOpts) {
        String cacheKey = ConfigurationHelper.getStringProperty("sslContext", null, additionalOpts);
        if (cacheKey != null) {
            return cacheKey;
        }
        return config;
    }

    @Override
    public int getPriority() {
        return 10;
    }
}

