/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.tools.validator.internal;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.wsdl.Binding;
import javax.wsdl.BindingOperation;
import javax.wsdl.Definition;
import javax.wsdl.extensions.ExtensibilityElement;
import javax.wsdl.extensions.mime.MIMEContent;
import javax.wsdl.extensions.mime.MIMEMultipartRelated;
import javax.wsdl.extensions.mime.MIMEPart;
import org.apache.cxf.binding.soap.SOAPBindingUtil;
import org.apache.cxf.helpers.CastUtils;
import org.apache.cxf.tools.validator.internal.AbstractDefinitionValidator;

public class MIMEBindingValidator
extends AbstractDefinitionValidator {
    public MIMEBindingValidator(Definition def) {
        super(def);
    }

    @Override
    public boolean isValid() {
        Collection bindings = CastUtils.cast(this.def.getBindings().values());
        for (Binding binding : bindings) {
            List bindingOps = CastUtils.cast((List)binding.getBindingOperations());
            for (BindingOperation bindingOperation : bindingOps) {
                if (bindingOperation.getBindingInput() == null) continue;
                List exts = CastUtils.cast((List)bindingOperation.getBindingInput().getExtensibilityElements());
                for (ExtensibilityElement extElement : exts) {
                    if (!(extElement instanceof MIMEMultipartRelated) || this.doValidate((MIMEMultipartRelated)extElement, bindingOperation.getName())) continue;
                    return false;
                }
            }
        }
        return true;
    }

    private boolean doValidate(MIMEMultipartRelated mimeExt, String operationName) {
        boolean gotRootPart = false;
        List parts = CastUtils.cast((List)mimeExt.getMIMEParts());
        for (MIMEPart mPart : parts) {
            ArrayList<MIMEContent> mimeContents = new ArrayList<MIMEContent>();
            List extns = CastUtils.cast((List)mPart.getExtensibilityElements());
            for (ExtensibilityElement extElement : extns) {
                if (SOAPBindingUtil.isSOAPBody((Object)extElement)) {
                    if (gotRootPart) {
                        this.addErrorMessage("Operation(" + operationName + "): There's more than one soap body mime part in its binding input");
                        return false;
                    }
                    gotRootPart = true;
                    continue;
                }
                if (!(extElement instanceof MIMEContent)) continue;
                mimeContents.add((MIMEContent)extElement);
            }
            if (this.doValidateMimeContentPartNames(mimeContents, operationName)) continue;
            return false;
        }
        if (!gotRootPart) {
            this.addErrorMessage("Operation(" + operationName + "): There's no soap body in mime part in its binding input");
            return false;
        }
        return true;
    }

    private boolean doValidateMimeContentPartNames(List<MIMEContent> mimeContents, String operationName) {
        String partName = null;
        for (MIMEContent mimeContent : mimeContents) {
            String mimeContnetPart = mimeContent.getPart();
            if (mimeContnetPart == null) {
                this.addErrorMessage("Operation(" + operationName + "): Must provide part attribute value for meme:content elements");
                return false;
            }
            if (partName == null) {
                partName = mimeContnetPart;
                continue;
            }
            if (partName.equals(mimeContnetPart)) continue;
            this.addErrorMessage("Operation(" + operationName + "): Part attribute value for meme:content elements are different");
            return false;
        }
        return true;
    }
}

