/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.clustering;

import java.util.List;
import java.util.logging.Logger;
import org.apache.cxf.clustering.FailoverTargetSelector;
import org.apache.cxf.common.logging.LogUtils;
import org.apache.cxf.endpoint.Endpoint;
import org.apache.cxf.message.Exchange;
import org.apache.cxf.message.Message;
import org.apache.cxf.transport.Conduit;

public class LoadDistributorTargetSelector
extends FailoverTargetSelector {
    private static final Logger LOG = LogUtils.getL7dLogger(LoadDistributorTargetSelector.class);
    private static final String IS_DISTRIBUTED = "org.apache.cxf.clustering.LoadDistributorTargetSelector.IS_DISTRIBUTED";
    private List<String> addressList;
    private boolean failover = true;

    public LoadDistributorTargetSelector() {
    }

    public LoadDistributorTargetSelector(String clientBootstrapAddress) {
        super(clientBootstrapAddress);
    }

    public LoadDistributorTargetSelector(Conduit c) {
        super(c);
    }

    public boolean isFailover() {
        return this.failover;
    }

    public void setFailover(boolean failover) {
        this.failover = failover;
    }

    @Override
    protected Logger getLogger() {
        return LOG;
    }

    @Override
    public synchronized Conduit selectConduit(Message message) {
        Endpoint target;
        Conduit c = (Conduit)message.get(Conduit.class);
        if (c != null) {
            return c;
        }
        Exchange exchange = message.getExchange();
        String key = String.valueOf(System.identityHashCode(exchange));
        FailoverTargetSelector.InvocationContext invocation = this.getInvocationContext(key);
        if (invocation != null && !invocation.getContext().containsKey(IS_DISTRIBUTED) && (target = this.getDistributionTarget(exchange, invocation)) != null) {
            this.setEndpoint(target);
            message.put((Object)Message.ENDPOINT_ADDRESS, (Object)target.getEndpointInfo().getAddress());
            message.put((Object)"org.apache.cxf.ConduitSelector.compareFullUrl", (Object)Boolean.TRUE);
            this.overrideAddressProperty(invocation.getContext());
            invocation.getContext().put(IS_DISTRIBUTED, null);
        }
        return this.getSelectedConduit(message);
    }

    @Override
    protected Endpoint getFailoverTarget(Exchange exchange, FailoverTargetSelector.InvocationContext invocation) {
        List<String> alternateAddresses;
        if (!invocation.hasAlternates()) {
            alternateAddresses = this.getStrategy().getAlternateAddresses(exchange);
            if (alternateAddresses != null) {
                alternateAddresses.remove(exchange.getEndpoint().getEndpointInfo().getAddress());
                invocation.setAlternateAddresses(alternateAddresses);
            } else {
                invocation.setAlternateEndpoints(this.getStrategy().getAlternateEndpoints(exchange));
            }
        } else {
            alternateAddresses = invocation.getAlternateAddresses();
        }
        Endpoint failoverTarget = null;
        if (alternateAddresses != null) {
            String alternateAddress = this.getStrategy().selectAlternateAddress(alternateAddresses);
            if (alternateAddress != null) {
                failoverTarget = this.getEndpoint();
                failoverTarget.getEndpointInfo().setAddress(alternateAddress);
            }
        } else {
            failoverTarget = this.getStrategy().selectAlternateEndpoint(invocation.getAlternateEndpoints());
        }
        return failoverTarget;
    }

    @Override
    protected boolean replaceEndpointAddressPropertyIfNeeded(Message message, String endpointAddress, Conduit cond) {
        String requestURI = (String)message.get((Object)"org.apache.cxf.request.uri");
        if (requestURI != null && endpointAddress != null && !requestURI.equals(endpointAddress)) {
            String basePath = (String)message.get((Object)Message.BASE_PATH);
            if (basePath.startsWith((String)endpointAddress)) {
                endpointAddress = basePath;
            }
            if (basePath != null && requestURI.startsWith(basePath)) {
                String pathInfo = requestURI.substring(basePath.length());
                message.put((Object)Message.BASE_PATH, endpointAddress);
                String slash = "/";
                boolean startsWithSlash = pathInfo.startsWith("/");
                endpointAddress = ((String)endpointAddress).endsWith("/") ? (String)endpointAddress + (startsWithSlash ? pathInfo.substring(1) : pathInfo) : (String)endpointAddress + (String)(startsWithSlash ? pathInfo : "/" + pathInfo);
                message.put((Object)Message.ENDPOINT_ADDRESS, endpointAddress);
                message.put((Object)"org.apache.cxf.request.uri", endpointAddress);
                Exchange exchange = message.getExchange();
                String key = String.valueOf(System.identityHashCode(exchange));
                FailoverTargetSelector.InvocationContext invocation = this.getInvocationContext(key);
                if (invocation != null) {
                    this.overrideAddressProperty(invocation.getContext(), cond.getTarget().getAddress().getValue());
                }
                return true;
            }
        }
        return false;
    }

    private Endpoint getDistributionTarget(Exchange exchange, FailoverTargetSelector.InvocationContext invocation) {
        List<String> alternateAddresses;
        if (this.addressList == null || this.addressList.isEmpty()) {
            try {
                this.addressList = this.getStrategy().getAlternateAddresses(null);
            }
            catch (NullPointerException ex) {
                this.getLogger().fine("Strategy " + this.getStrategy().getClass() + " cannot handle a null argument to getAlternateAddresses: " + ex.toString());
            }
        }
        if ((alternateAddresses = this.addressList) == null || alternateAddresses.isEmpty()) {
            alternateAddresses = this.getStrategy().getAlternateAddresses(exchange);
            if (alternateAddresses != null) {
                invocation.setAlternateAddresses(alternateAddresses);
            } else {
                invocation.setAlternateEndpoints(this.getStrategy().getAlternateEndpoints(exchange));
            }
        }
        Endpoint distributionTarget = null;
        if (alternateAddresses != null && !alternateAddresses.isEmpty()) {
            String alternateAddress = this.getStrategy().selectAlternateAddress(alternateAddresses);
            if (alternateAddress != null) {
                distributionTarget = this.getEndpoint();
                distributionTarget.getEndpointInfo().setAddress(alternateAddress);
            }
        } else {
            distributionTarget = this.getStrategy().selectAlternateEndpoint(invocation.getAlternateEndpoints());
        }
        return distributionTarget;
    }

    @Override
    protected boolean requiresFailover(Exchange exchange, Exception ex) {
        return this.failover && super.requiresFailover(exchange, ex);
    }
}

