/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ext.exasol.model.cache;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import java.util.stream.Collectors;
import org.jkiss.code.NotNull;
import org.jkiss.dbeaver.DBException;
import org.jkiss.dbeaver.ext.exasol.model.ExasolTable;
import org.jkiss.dbeaver.ext.exasol.model.ExasolTableColumn;
import org.jkiss.dbeaver.ext.exasol.model.ExasolTablePartitionColumn;
import org.jkiss.dbeaver.model.DBPDataKind;
import org.jkiss.dbeaver.model.runtime.DBRProgressMonitor;
import org.jkiss.dbeaver.model.struct.cache.AbstractObjectCache;

public class ExasolTablePartitionColumnCache
extends AbstractObjectCache<ExasolTable, ExasolTablePartitionColumn> {
    private List<ExasolTablePartitionColumn> tablePartitionColumns = new ArrayList<ExasolTablePartitionColumn>();

    @NotNull
    public Collection<ExasolTablePartitionColumn> getAllObjects(@NotNull DBRProgressMonitor monitor, ExasolTable owner) throws DBException {
        if (this.tablePartitionColumns.isEmpty() && !this.fullCache) {
            for (ExasolTableColumn col : owner.getAttributes(monitor)) {
                if (col.getPartitionKeyOrdinalPosition() == null) continue;
                this.tablePartitionColumns.add(new ExasolTablePartitionColumn(owner, col, col.getPartitionKeyOrdinalPosition()));
            }
            this.sortPartitionColumns();
            super.setCache(this.tablePartitionColumns);
        }
        return this.tablePartitionColumns;
    }

    public void clearCache() {
        super.clearCache();
        this.tablePartitionColumns.clear();
    }

    public ExasolTablePartitionColumn getObject(@NotNull DBRProgressMonitor monitor, @NotNull ExasolTable owner, @NotNull String name) throws DBException {
        if (!super.isFullyCached()) {
            this.getAllObjects(monitor, owner);
        }
        if (this.tablePartitionColumns.stream().filter(o -> o.getTableColumn().getName().equals(name)).findFirst().isPresent()) {
            return this.tablePartitionColumns.stream().filter(o -> o.getName().equals(name)).findFirst().get();
        }
        return null;
    }

    private void sortPartitionColumns() {
        this.tablePartitionColumns = this.tablePartitionColumns.stream().sorted(Comparator.comparing(ExasolTablePartitionColumn::getOrdinalPosition)).collect(Collectors.toCollection(ArrayList::new));
    }

    public Collection<ExasolTableColumn> getAvailableTableColumns(ExasolTable owner, DBRProgressMonitor monitor) throws DBException {
        return owner.getAttributes(monitor).stream().filter(c -> this.tablePartitionColumns.stream().noneMatch(pc -> pc.getTableColumn() != null && pc.getName().equals(c.getName()))).filter(c -> c.getDataKind() == DBPDataKind.DATETIME || c.getDataKind() == DBPDataKind.NUMERIC).collect(Collectors.toList());
    }
}

