/*
 * Decompiled with CFR 0.152.
 */
package java.lang.invoke;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.lang.invoke.LambdaForm;
import java.lang.invoke.MemberName;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.MethodHandleImpl;
import java.lang.invoke.MethodHandleStatics;
import java.lang.invoke.MethodType;
import java.lang.invoke.MethodTypeForm;
import java.lang.reflect.Array;
import java.lang.reflect.Modifier;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import jdk.internal.org.objectweb.asm.ClassWriter;
import jdk.internal.org.objectweb.asm.Label;
import jdk.internal.org.objectweb.asm.MethodVisitor;
import sun.invoke.util.VerifyAccess;
import sun.invoke.util.VerifyType;
import sun.invoke.util.Wrapper;
import sun.misc.Unsafe;
import sun.reflect.misc.ReflectUtil;

class InvokerBytecodeGenerator {
    private static final String MH = "java/lang/invoke/MethodHandle";
    private static final String MHI = "java/lang/invoke/MethodHandleImpl";
    private static final String LF = "java/lang/invoke/LambdaForm";
    private static final String LFN = "java/lang/invoke/LambdaForm$Name";
    private static final String CLS = "java/lang/Class";
    private static final String OBJ = "java/lang/Object";
    private static final String OBJARY = "[Ljava/lang/Object;";
    private static final String MH_SIG = "Ljava/lang/invoke/MethodHandle;";
    private static final String LF_SIG = "Ljava/lang/invoke/LambdaForm;";
    private static final String LFN_SIG = "Ljava/lang/invoke/LambdaForm$Name;";
    private static final String LL_SIG = "(Ljava/lang/Object;)Ljava/lang/Object;";
    private static final String LLV_SIG = "(Ljava/lang/Object;Ljava/lang/Object;)V";
    private static final String CLL_SIG = "(Ljava/lang/Class;Ljava/lang/Object;)Ljava/lang/Object;";
    private static final String superName = "java/lang/Object";
    private final String className;
    private final String sourceFile;
    private final LambdaForm lambdaForm;
    private final String invokerName;
    private final MethodType invokerType;
    private final int[] localsMap;
    private final LambdaForm.BasicType[] localTypes;
    private final Class<?>[] localClasses;
    private ClassWriter cw;
    private MethodVisitor mv;
    private static final MemberName.Factory MEMBERNAME_FACTORY = MemberName.getFactory();
    private static final Class<?> HOST_CLASS = LambdaForm.class;
    private static final HashMap<String, Integer> DUMP_CLASS_FILES_COUNTERS;
    private static final File DUMP_CLASS_FILES_DIR;
    Map<Object, CpPatch> cpPatches = new HashMap<Object, CpPatch>();
    int cph = 0;
    private static Class<?>[] STATICALLY_INVOCABLE_PACKAGES;

    private InvokerBytecodeGenerator(LambdaForm lambdaForm, int n, String string, String string2, MethodType methodType) {
        if (string2.contains(".")) {
            int n2 = string2.indexOf(".");
            string = string2.substring(0, n2);
            string2 = string2.substring(n2 + 1);
        }
        if (MethodHandleStatics.DUMP_CLASS_FILES) {
            string = InvokerBytecodeGenerator.makeDumpableClassName(string);
        }
        this.className = "java/lang/invoke/LambdaForm$" + string;
        this.sourceFile = "LambdaForm$" + string;
        this.lambdaForm = lambdaForm;
        this.invokerName = string2;
        this.invokerType = methodType;
        this.localsMap = new int[n + 1];
        this.localTypes = new LambdaForm.BasicType[n + 1];
        this.localClasses = new Class[n + 1];
    }

    private InvokerBytecodeGenerator(String string, String string2, MethodType methodType) {
        this(null, methodType.parameterCount(), string, string2, methodType);
        this.localTypes[this.localTypes.length - 1] = LambdaForm.BasicType.V_TYPE;
        for (int i = 0; i < this.localsMap.length; ++i) {
            this.localsMap[i] = methodType.parameterSlotCount() - methodType.parameterSlotDepth(i);
            if (i >= methodType.parameterCount()) continue;
            this.localTypes[i] = LambdaForm.BasicType.basicType(methodType.parameterType(i));
        }
    }

    private InvokerBytecodeGenerator(String string, LambdaForm lambdaForm, MethodType methodType) {
        this(lambdaForm, lambdaForm.names.length, string, lambdaForm.debugName, methodType);
        LambdaForm.Name[] nameArray = lambdaForm.names;
        int n = 0;
        for (int i = 0; i < this.localsMap.length; ++i) {
            this.localsMap[i] = n;
            if (i >= nameArray.length) continue;
            LambdaForm.BasicType basicType = nameArray[i].type();
            n += basicType.basicTypeSlots();
            this.localTypes[i] = basicType;
        }
    }

    static void maybeDump(final String string, final byte[] byArray) {
        if (MethodHandleStatics.DUMP_CLASS_FILES) {
            AccessController.doPrivileged(new PrivilegedAction<Void>(){

                @Override
                public Void run() {
                    try {
                        String string2 = string;
                        File file = new File(DUMP_CLASS_FILES_DIR, string2 + ".class");
                        System.out.println("dump: " + file);
                        file.getParentFile().mkdirs();
                        FileOutputStream fileOutputStream = new FileOutputStream(file);
                        fileOutputStream.write(byArray);
                        fileOutputStream.close();
                        return null;
                    }
                    catch (IOException iOException) {
                        throw MethodHandleStatics.newInternalError(iOException);
                    }
                }
            });
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static String makeDumpableClassName(String string) {
        Integer n;
        Object object = DUMP_CLASS_FILES_COUNTERS;
        synchronized (object) {
            n = DUMP_CLASS_FILES_COUNTERS.get(string);
            if (n == null) {
                n = 0;
            }
            DUMP_CLASS_FILES_COUNTERS.put(string, n + 1);
        }
        object = n.toString();
        while (((String)object).length() < 3) {
            object = "0" + (String)object;
        }
        string = string + (String)object;
        return string;
    }

    String constantPlaceholder(Object object) {
        String string = "CONSTANT_PLACEHOLDER_" + this.cph++;
        if (MethodHandleStatics.DUMP_CLASS_FILES) {
            string = string + " <<" + InvokerBytecodeGenerator.debugString(object) + ">>";
        }
        if (this.cpPatches.containsKey(string)) {
            throw new InternalError("observed CP placeholder twice: " + string);
        }
        int n = this.cw.newConst(string);
        this.cpPatches.put(string, new CpPatch(n, string, object));
        return string;
    }

    Object[] cpPatches(byte[] byArray) {
        int n = InvokerBytecodeGenerator.getConstantPoolSize(byArray);
        Object[] objectArray = new Object[n];
        for (CpPatch cpPatch : this.cpPatches.values()) {
            if (cpPatch.index >= n) {
                throw new InternalError("in cpool[" + n + "]: " + cpPatch + "\n" + Arrays.toString(Arrays.copyOf(byArray, 20)));
            }
            objectArray[cpPatch.index] = cpPatch.value;
        }
        return objectArray;
    }

    private static String debugString(Object object) {
        if (object instanceof MethodHandle) {
            MethodHandle methodHandle = (MethodHandle)object;
            MemberName memberName = methodHandle.internalMemberName();
            if (memberName != null) {
                return memberName.toString();
            }
            return methodHandle.debugString();
        }
        return object.toString();
    }

    private static int getConstantPoolSize(byte[] byArray) {
        return (byArray[8] & 0xFF) << 8 | byArray[9] & 0xFF;
    }

    private MemberName loadMethod(byte[] byArray) {
        Class<?> clazz = InvokerBytecodeGenerator.loadAndInitializeInvokerClass(byArray, this.cpPatches(byArray));
        return InvokerBytecodeGenerator.resolveInvokerMember(clazz, this.invokerName, this.invokerType);
    }

    private static Class<?> loadAndInitializeInvokerClass(byte[] byArray, Object[] objectArray) {
        Class<?> clazz = MethodHandleStatics.UNSAFE.defineAnonymousClass(HOST_CLASS, byArray, objectArray);
        MethodHandleStatics.UNSAFE.ensureClassInitialized(clazz);
        return clazz;
    }

    private static MemberName resolveInvokerMember(Class<?> clazz, String string, MethodType methodType) {
        MemberName memberName = new MemberName(clazz, string, methodType, 6);
        try {
            memberName = MEMBERNAME_FACTORY.resolveOrFail((byte)6, memberName, HOST_CLASS, ReflectiveOperationException.class);
        }
        catch (ReflectiveOperationException reflectiveOperationException) {
            throw MethodHandleStatics.newInternalError(reflectiveOperationException);
        }
        return memberName;
    }

    private void classFilePrologue() {
        this.cw = new ClassWriter(3);
        this.cw.visit(52, 48, this.className, null, "java/lang/Object", null);
        this.cw.visitSource(this.sourceFile, null);
        String string = this.invokerType.toMethodDescriptorString();
        this.mv = this.cw.visitMethod(8, this.invokerName, string, null, null);
    }

    private void classFileEpilogue() {
        this.mv.visitMaxs(0, 0);
        this.mv.visitEnd();
    }

    private void emitConst(Object object) {
        double d;
        float f;
        long l;
        if (object == null) {
            this.mv.visitInsn(1);
            return;
        }
        if (object instanceof Integer) {
            this.emitIconstInsn((Integer)object);
            return;
        }
        if (object instanceof Long && (l = ((Long)object).longValue()) == (long)((short)l)) {
            this.emitIconstInsn((int)l);
            this.mv.visitInsn(133);
            return;
        }
        if (object instanceof Float && (f = ((Float)object).floatValue()) == (float)((short)f)) {
            this.emitIconstInsn((int)f);
            this.mv.visitInsn(134);
            return;
        }
        if (object instanceof Double && (d = ((Double)object).doubleValue()) == (double)((short)d)) {
            this.emitIconstInsn((int)d);
            this.mv.visitInsn(135);
            return;
        }
        if (object instanceof Boolean) {
            this.emitIconstInsn((Boolean)object != false ? 1 : 0);
            return;
        }
        this.mv.visitLdcInsn(object);
    }

    private void emitIconstInsn(int n) {
        int n2;
        switch (n) {
            case 0: {
                n2 = 3;
                break;
            }
            case 1: {
                n2 = 4;
                break;
            }
            case 2: {
                n2 = 5;
                break;
            }
            case 3: {
                n2 = 6;
                break;
            }
            case 4: {
                n2 = 7;
                break;
            }
            case 5: {
                n2 = 8;
                break;
            }
            default: {
                if (n == (byte)n) {
                    this.mv.visitIntInsn(16, n & 0xFF);
                } else if (n == (short)n) {
                    this.mv.visitIntInsn(17, (char)n);
                } else {
                    this.mv.visitLdcInsn(n);
                }
                return;
            }
        }
        this.mv.visitInsn(n2);
    }

    private void emitLoadInsn(LambdaForm.BasicType basicType, int n) {
        int n2 = this.loadInsnOpcode(basicType);
        this.mv.visitVarInsn(n2, this.localsMap[n]);
    }

    private int loadInsnOpcode(LambdaForm.BasicType basicType) throws InternalError {
        switch (basicType) {
            case I_TYPE: {
                return 21;
            }
            case J_TYPE: {
                return 22;
            }
            case F_TYPE: {
                return 23;
            }
            case D_TYPE: {
                return 24;
            }
            case L_TYPE: {
                return 25;
            }
        }
        throw new InternalError("unknown type: " + (Object)((Object)basicType));
    }

    private void emitAloadInsn(int n) {
        this.emitLoadInsn(LambdaForm.BasicType.L_TYPE, n);
    }

    private void emitStoreInsn(LambdaForm.BasicType basicType, int n) {
        int n2 = this.storeInsnOpcode(basicType);
        this.mv.visitVarInsn(n2, this.localsMap[n]);
    }

    private int storeInsnOpcode(LambdaForm.BasicType basicType) throws InternalError {
        switch (basicType) {
            case I_TYPE: {
                return 54;
            }
            case J_TYPE: {
                return 55;
            }
            case F_TYPE: {
                return 56;
            }
            case D_TYPE: {
                return 57;
            }
            case L_TYPE: {
                return 58;
            }
        }
        throw new InternalError("unknown type: " + (Object)((Object)basicType));
    }

    private void emitAstoreInsn(int n) {
        this.emitStoreInsn(LambdaForm.BasicType.L_TYPE, n);
    }

    private byte arrayTypeCode(Wrapper wrapper) {
        switch (wrapper) {
            case BOOLEAN: {
                return 4;
            }
            case BYTE: {
                return 8;
            }
            case CHAR: {
                return 5;
            }
            case SHORT: {
                return 9;
            }
            case INT: {
                return 10;
            }
            case LONG: {
                return 11;
            }
            case FLOAT: {
                return 6;
            }
            case DOUBLE: {
                return 7;
            }
            case OBJECT: {
                return 0;
            }
        }
        throw new InternalError();
    }

    private int arrayInsnOpcode(byte by, int n) throws InternalError {
        int n2;
        assert (n == 83 || n == 50);
        switch (by) {
            case 4: {
                n2 = 84;
                break;
            }
            case 8: {
                n2 = 84;
                break;
            }
            case 5: {
                n2 = 85;
                break;
            }
            case 9: {
                n2 = 86;
                break;
            }
            case 10: {
                n2 = 79;
                break;
            }
            case 11: {
                n2 = 80;
                break;
            }
            case 6: {
                n2 = 81;
                break;
            }
            case 7: {
                n2 = 82;
                break;
            }
            case 0: {
                n2 = 83;
                break;
            }
            default: {
                throw new InternalError();
            }
        }
        return n2 - 83 + n;
    }

    private void freeFrameLocal(int n) {
        int n2 = this.indexForFrameLocal(n);
        if (n2 < 0) {
            return;
        }
        LambdaForm.BasicType basicType = this.localTypes[n2];
        int n3 = this.makeLocalTemp(basicType);
        this.mv.visitVarInsn(this.loadInsnOpcode(basicType), n);
        this.mv.visitVarInsn(this.storeInsnOpcode(basicType), n3);
        assert (this.localsMap[n2] == n);
        this.localsMap[n2] = n3;
        assert (this.indexForFrameLocal(n) < 0);
    }

    private int indexForFrameLocal(int n) {
        for (int i = 0; i < this.localsMap.length; ++i) {
            if (this.localsMap[i] != n || this.localTypes[i] == LambdaForm.BasicType.V_TYPE) continue;
            return i;
        }
        return -1;
    }

    private int makeLocalTemp(LambdaForm.BasicType basicType) {
        int n = this.localsMap[this.localsMap.length - 1];
        this.localsMap[this.localsMap.length - 1] = n + basicType.basicTypeSlots();
        return n;
    }

    private void emitBoxing(Wrapper wrapper) {
        String string = "java/lang/" + wrapper.wrapperType().getSimpleName();
        String string2 = "valueOf";
        String string3 = "(" + wrapper.basicTypeChar() + ")L" + string + ";";
        this.mv.visitMethodInsn(184, string, string2, string3, false);
    }

    private void emitUnboxing(Wrapper wrapper) {
        String string = "java/lang/" + wrapper.wrapperType().getSimpleName();
        String string2 = wrapper.primitiveSimpleName() + "Value";
        String string3 = "()" + wrapper.basicTypeChar();
        this.emitReferenceCast(wrapper.wrapperType(), null);
        this.mv.visitMethodInsn(182, string, string2, string3, false);
    }

    private void emitImplicitConversion(LambdaForm.BasicType basicType, Class<?> clazz, Object object) {
        assert (LambdaForm.BasicType.basicType(clazz) == basicType);
        if (clazz == basicType.basicTypeClass() && basicType != LambdaForm.BasicType.L_TYPE) {
            return;
        }
        switch (basicType) {
            case L_TYPE: {
                if (VerifyType.isNullConversion(Object.class, clazz, false)) {
                    if (MethodHandleStatics.PROFILE_LEVEL > 0) {
                        this.emitReferenceCast(Object.class, object);
                    }
                    return;
                }
                this.emitReferenceCast(clazz, object);
                return;
            }
            case I_TYPE: {
                if (!VerifyType.isNullConversion(Integer.TYPE, clazz, false)) {
                    this.emitPrimCast(basicType.basicTypeWrapper(), Wrapper.forPrimitiveType(clazz));
                }
                return;
            }
        }
        throw MethodHandleStatics.newInternalError("bad implicit conversion: tc=" + (Object)((Object)basicType) + ": " + clazz);
    }

    private boolean assertStaticType(Class<?> clazz, LambdaForm.Name name) {
        int n = name.index();
        Class<?> clazz2 = this.localClasses[n];
        if (clazz2 != null && (clazz2 == clazz || clazz.isAssignableFrom(clazz2))) {
            return true;
        }
        if (clazz2 == null || clazz2.isAssignableFrom(clazz)) {
            this.localClasses[n] = clazz;
        }
        return false;
    }

    private void emitReferenceCast(Class<?> clazz, Object object) {
        Object object2;
        Object object3 = null;
        if (object instanceof LambdaForm.Name) {
            object2 = (LambdaForm.Name)object;
            if (this.assertStaticType(clazz, (LambdaForm.Name)object2)) {
                return;
            }
            if (this.lambdaForm.useCount((LambdaForm.Name)object2) > 1) {
                object3 = object2;
            }
        }
        if (InvokerBytecodeGenerator.isStaticallyNameable(clazz)) {
            object2 = InvokerBytecodeGenerator.getInternalName(clazz);
            this.mv.visitTypeInsn(192, (String)object2);
        } else {
            this.mv.visitLdcInsn(this.constantPlaceholder(clazz));
            this.mv.visitTypeInsn(192, CLS);
            this.mv.visitInsn(95);
            this.mv.visitMethodInsn(184, MHI, "castReference", CLL_SIG, false);
            if (Object[].class.isAssignableFrom(clazz)) {
                this.mv.visitTypeInsn(192, OBJARY);
            } else if (MethodHandleStatics.PROFILE_LEVEL > 0) {
                this.mv.visitTypeInsn(192, "java/lang/Object");
            }
        }
        if (object3 != null) {
            this.mv.visitInsn(89);
            this.emitAstoreInsn(((LambdaForm.Name)object3).index());
        }
    }

    private void emitReturnInsn(LambdaForm.BasicType basicType) {
        int n;
        switch (basicType) {
            case I_TYPE: {
                n = 172;
                break;
            }
            case J_TYPE: {
                n = 173;
                break;
            }
            case F_TYPE: {
                n = 174;
                break;
            }
            case D_TYPE: {
                n = 175;
                break;
            }
            case L_TYPE: {
                n = 176;
                break;
            }
            case V_TYPE: {
                n = 177;
                break;
            }
            default: {
                throw new InternalError("unknown return type: " + (Object)((Object)basicType));
            }
        }
        this.mv.visitInsn(n);
    }

    private static String getInternalName(Class<?> clazz) {
        if (clazz == Object.class) {
            return "java/lang/Object";
        }
        if (clazz == Object[].class) {
            return OBJARY;
        }
        if (clazz == Class.class) {
            return CLS;
        }
        if (clazz == MethodHandle.class) {
            return MH;
        }
        assert (VerifyAccess.isTypeVisible(clazz, Object.class)) : clazz.getName();
        return clazz.getName().replace('.', '/');
    }

    static MemberName generateCustomizedCode(LambdaForm lambdaForm, MethodType methodType) {
        InvokerBytecodeGenerator invokerBytecodeGenerator = new InvokerBytecodeGenerator("MH", lambdaForm, methodType);
        return invokerBytecodeGenerator.loadMethod(invokerBytecodeGenerator.generateCustomizedCodeBytes());
    }

    private boolean checkActualReceiver() {
        this.mv.visitInsn(89);
        this.mv.visitVarInsn(25, this.localsMap[0]);
        this.mv.visitMethodInsn(184, MHI, "assertSame", LLV_SIG, false);
        return true;
    }

    private byte[] generateCustomizedCodeBytes() {
        this.classFilePrologue();
        this.mv.visitAnnotation("Ljava/lang/invoke/LambdaForm$Hidden;", true);
        this.mv.visitAnnotation("Ljava/lang/invoke/LambdaForm$Compiled;", true);
        if (this.lambdaForm.forceInline) {
            this.mv.visitAnnotation("Ljava/lang/invoke/ForceInline;", true);
        } else {
            this.mv.visitAnnotation("Ljava/lang/invoke/DontInline;", true);
        }
        if (this.lambdaForm.customized != null) {
            this.mv.visitLdcInsn(this.constantPlaceholder(this.lambdaForm.customized));
            this.mv.visitTypeInsn(192, MH);
            assert (this.checkActualReceiver());
            this.mv.visitVarInsn(58, this.localsMap[0]);
        }
        LambdaForm.Name name = null;
        block10: for (int i = this.lambdaForm.arity; i < this.lambdaForm.names.length; ++i) {
            Object object;
            LambdaForm.Name name2 = this.lambdaForm.names[i];
            this.emitStoreResult(name);
            name = name2;
            MethodHandleImpl.Intrinsic intrinsic = name2.function.intrinsicName();
            switch (intrinsic) {
                case SELECT_ALTERNATIVE: {
                    assert (this.isSelectAlternative(i));
                    if (MethodHandleStatics.PROFILE_GWT) {
                        assert (name2.arguments[0] instanceof LambdaForm.Name && this.nameRefersTo((LambdaForm.Name)name2.arguments[0], MethodHandleImpl.class, "profileBoolean"));
                        this.mv.visitAnnotation("Ljava/lang/invoke/InjectedProfile;", true);
                    }
                    name = this.emitSelectAlternative(name2, this.lambdaForm.names[i + 1]);
                    ++i;
                    continue block10;
                }
                case GUARD_WITH_CATCH: {
                    assert (this.isGuardWithCatch(i));
                    name = this.emitGuardWithCatch(i);
                    i += 2;
                    continue block10;
                }
                case NEW_ARRAY: {
                    object = name2.function.methodType().returnType();
                    if (!InvokerBytecodeGenerator.isStaticallyNameable(object)) break;
                    this.emitNewArray(name2);
                    continue block10;
                }
                case ARRAY_LOAD: {
                    this.emitArrayLoad(name2);
                    continue block10;
                }
                case ARRAY_STORE: {
                    this.emitArrayStore(name2);
                    continue block10;
                }
                case IDENTITY: {
                    assert (name2.arguments.length == 1);
                    this.emitPushArguments(name2);
                    continue block10;
                }
                case ZERO: {
                    assert (name2.arguments.length == 0);
                    this.emitConst(name2.type.basicTypeWrapper().zero());
                    continue block10;
                }
                case NONE: {
                    break;
                }
                default: {
                    throw MethodHandleStatics.newInternalError("Unknown intrinsic: " + (Object)((Object)intrinsic));
                }
            }
            if (InvokerBytecodeGenerator.isStaticallyInvocable((MemberName)(object = name2.function.member()))) {
                this.emitStaticInvoke((MemberName)object, name2);
                continue;
            }
            this.emitInvoke(name2);
        }
        this.emitReturn(name);
        this.classFileEpilogue();
        this.bogusMethod(this.lambdaForm);
        byte[] byArray = this.cw.toByteArray();
        InvokerBytecodeGenerator.maybeDump(this.className, byArray);
        return byArray;
    }

    void emitArrayLoad(LambdaForm.Name name) {
        this.emitArrayOp(name, 50);
    }

    void emitArrayStore(LambdaForm.Name name) {
        this.emitArrayOp(name, 83);
    }

    void emitArrayOp(LambdaForm.Name name, int n) {
        assert (n == 50 || n == 83);
        Class<?> clazz = name.function.methodType().parameterType(0).getComponentType();
        assert (clazz != null);
        this.emitPushArguments(name);
        if (clazz.isPrimitive()) {
            Wrapper wrapper = Wrapper.forPrimitiveType(clazz);
            n = this.arrayInsnOpcode(this.arrayTypeCode(wrapper), n);
        }
        this.mv.visitInsn(n);
    }

    void emitInvoke(LambdaForm.Name name) {
        assert (!this.isLinkerMethodInvoke(name));
        Object object = name.function.resolvedHandle;
        assert (object != null) : name.exprString();
        this.mv.visitLdcInsn(this.constantPlaceholder(object));
        this.emitReferenceCast(MethodHandle.class, object);
        this.emitPushArguments(name);
        object = name.function.methodType();
        this.mv.visitMethodInsn(182, MH, "invokeBasic", ((MethodType)object).basicType().toMethodDescriptorString(), false);
    }

    static boolean isStaticallyInvocable(LambdaForm.Name name) {
        return InvokerBytecodeGenerator.isStaticallyInvocable(name.function.member());
    }

    static boolean isStaticallyInvocable(MemberName memberName) {
        if (memberName == null) {
            return false;
        }
        if (memberName.isConstructor()) {
            return false;
        }
        Class<?> clazz = memberName.getDeclaringClass();
        if (clazz.isArray() || clazz.isPrimitive()) {
            return false;
        }
        if (clazz.isAnonymousClass() || clazz.isLocalClass()) {
            return false;
        }
        if (clazz.getClassLoader() != MethodHandle.class.getClassLoader()) {
            return false;
        }
        if (ReflectUtil.isVMAnonymousClass(clazz)) {
            return false;
        }
        MethodType methodType = memberName.getMethodOrFieldType();
        if (!InvokerBytecodeGenerator.isStaticallyNameable(methodType.returnType())) {
            return false;
        }
        for (Class<?> clazz2 : methodType.parameterArray()) {
            if (InvokerBytecodeGenerator.isStaticallyNameable(clazz2)) continue;
            return false;
        }
        if (!memberName.isPrivate() && VerifyAccess.isSamePackage(MethodHandle.class, clazz)) {
            return true;
        }
        return memberName.isPublic() && InvokerBytecodeGenerator.isStaticallyNameable(clazz);
    }

    static boolean isStaticallyNameable(Class<?> clazz) {
        if (clazz == Object.class) {
            return true;
        }
        while (clazz.isArray()) {
            clazz = clazz.getComponentType();
        }
        if (clazz.isPrimitive()) {
            return true;
        }
        if (ReflectUtil.isVMAnonymousClass(clazz)) {
            return false;
        }
        if (clazz.getClassLoader() != Object.class.getClassLoader()) {
            return false;
        }
        if (VerifyAccess.isSamePackage(MethodHandle.class, clazz)) {
            return true;
        }
        if (!Modifier.isPublic(clazz.getModifiers())) {
            return false;
        }
        for (Class<?> clazz2 : STATICALLY_INVOCABLE_PACKAGES) {
            if (!VerifyAccess.isSamePackage(clazz2, clazz)) continue;
            return true;
        }
        return false;
    }

    void emitStaticInvoke(LambdaForm.Name name) {
        this.emitStaticInvoke(name.function.member(), name);
    }

    void emitStaticInvoke(MemberName memberName, LambdaForm.Name name) {
        assert (memberName.equals(name.function.member()));
        Class<?> clazz = memberName.getDeclaringClass();
        String string = InvokerBytecodeGenerator.getInternalName(clazz);
        String string2 = memberName.getName();
        byte by = memberName.getReferenceKind();
        if (by == 7) {
            assert (memberName.canBeStaticallyBound()) : memberName;
            by = 5;
        }
        if (memberName.getDeclaringClass().isInterface() && by == 5) {
            by = 9;
        }
        this.emitPushArguments(name);
        if (memberName.isMethod()) {
            String string3 = memberName.getMethodType().toMethodDescriptorString();
            this.mv.visitMethodInsn(this.refKindOpcode(by), string, string2, string3, memberName.getDeclaringClass().isInterface());
        } else {
            String string4 = MethodType.toFieldDescriptorString(memberName.getFieldType());
            this.mv.visitFieldInsn(this.refKindOpcode(by), string, string2, string4);
        }
        if (name.type == LambdaForm.BasicType.L_TYPE) {
            Class<?> clazz2 = memberName.getInvocationType().returnType();
            assert (!clazz2.isPrimitive());
            if (clazz2 != Object.class && !clazz2.isInterface()) {
                this.assertStaticType(clazz2, name);
            }
        }
    }

    void emitNewArray(LambdaForm.Name name) throws InternalError {
        int n;
        Class<?> clazz = name.function.methodType().returnType();
        if (name.arguments.length == 0) {
            Object object;
            try {
                object = name.function.resolvedHandle.invoke();
            }
            catch (Throwable throwable) {
                throw MethodHandleStatics.newInternalError(throwable);
            }
            assert (Array.getLength(object) == 0);
            assert (object.getClass() == clazz);
            this.mv.visitLdcInsn(this.constantPlaceholder(object));
            this.emitReferenceCast(clazz, object);
            return;
        }
        Class<?> clazz2 = clazz.getComponentType();
        assert (clazz2 != null);
        this.emitIconstInsn(name.arguments.length);
        int n2 = 83;
        if (!clazz2.isPrimitive()) {
            this.mv.visitTypeInsn(189, InvokerBytecodeGenerator.getInternalName(clazz2));
        } else {
            n = this.arrayTypeCode(Wrapper.forPrimitiveType(clazz2));
            n2 = this.arrayInsnOpcode((byte)n, n2);
            this.mv.visitIntInsn(188, n);
        }
        for (n = 0; n < name.arguments.length; ++n) {
            this.mv.visitInsn(89);
            this.emitIconstInsn(n);
            this.emitPushArgument(name, n);
            this.mv.visitInsn(n2);
        }
        this.assertStaticType(clazz, name);
    }

    int refKindOpcode(byte by) {
        switch (by) {
            case 5: {
                return 182;
            }
            case 6: {
                return 184;
            }
            case 7: {
                return 183;
            }
            case 9: {
                return 185;
            }
            case 1: {
                return 180;
            }
            case 3: {
                return 181;
            }
            case 2: {
                return 178;
            }
            case 4: {
                return 179;
            }
        }
        throw new InternalError("refKind=" + by);
    }

    private boolean memberRefersTo(MemberName memberName, Class<?> clazz, String string) {
        return memberName != null && memberName.getDeclaringClass() == clazz && memberName.getName().equals(string);
    }

    private boolean nameRefersTo(LambdaForm.Name name, Class<?> clazz, String string) {
        return name.function != null && this.memberRefersTo(name.function.member(), clazz, string);
    }

    private boolean isInvokeBasic(LambdaForm.Name name) {
        if (name.function == null) {
            return false;
        }
        if (name.arguments.length < 1) {
            return false;
        }
        MemberName memberName = name.function.member();
        return this.memberRefersTo(memberName, MethodHandle.class, "invokeBasic") && !memberName.isPublic() && !memberName.isStatic();
    }

    private boolean isLinkerMethodInvoke(LambdaForm.Name name) {
        if (name.function == null) {
            return false;
        }
        if (name.arguments.length < 1) {
            return false;
        }
        MemberName memberName = name.function.member();
        return memberName != null && memberName.getDeclaringClass() == MethodHandle.class && !memberName.isPublic() && memberName.isStatic() && memberName.getName().startsWith("linkTo");
    }

    private boolean isSelectAlternative(int n) {
        if (n + 1 >= this.lambdaForm.names.length) {
            return false;
        }
        LambdaForm.Name name = this.lambdaForm.names[n];
        LambdaForm.Name name2 = this.lambdaForm.names[n + 1];
        return this.nameRefersTo(name, MethodHandleImpl.class, "selectAlternative") && this.isInvokeBasic(name2) && name2.lastUseIndex(name) == 0 && this.lambdaForm.lastUseIndex(name) == n + 1;
    }

    private boolean isGuardWithCatch(int n) {
        if (n + 2 >= this.lambdaForm.names.length) {
            return false;
        }
        LambdaForm.Name name = this.lambdaForm.names[n];
        LambdaForm.Name name2 = this.lambdaForm.names[n + 1];
        LambdaForm.Name name3 = this.lambdaForm.names[n + 2];
        return this.nameRefersTo(name2, MethodHandleImpl.class, "guardWithCatch") && this.isInvokeBasic(name) && this.isInvokeBasic(name3) && name2.lastUseIndex(name) == 3 && this.lambdaForm.lastUseIndex(name) == n + 1 && name3.lastUseIndex(name2) == 1 && this.lambdaForm.lastUseIndex(name2) == n + 2;
    }

    private LambdaForm.Name emitSelectAlternative(LambdaForm.Name name, LambdaForm.Name name2) {
        assert (InvokerBytecodeGenerator.isStaticallyInvocable(name2));
        LambdaForm.Name name3 = (LambdaForm.Name)name2.arguments[0];
        Label label = new Label();
        Label label2 = new Label();
        this.emitPushArgument(name, 0);
        this.mv.visitJumpInsn(153, label);
        Class[] classArray = (Class[])this.localClasses.clone();
        this.emitPushArgument(name, 1);
        this.emitAstoreInsn(name3.index());
        this.emitStaticInvoke(name2);
        this.mv.visitJumpInsn(167, label2);
        this.mv.visitLabel(label);
        System.arraycopy(classArray, 0, this.localClasses, 0, classArray.length);
        this.emitPushArgument(name, 2);
        this.emitAstoreInsn(name3.index());
        this.emitStaticInvoke(name2);
        this.mv.visitLabel(label2);
        System.arraycopy(classArray, 0, this.localClasses, 0, classArray.length);
        return name2;
    }

    private LambdaForm.Name emitGuardWithCatch(int n) {
        LambdaForm.Name name = this.lambdaForm.names[n];
        LambdaForm.Name name2 = this.lambdaForm.names[n + 1];
        LambdaForm.Name name3 = this.lambdaForm.names[n + 2];
        Label label = new Label();
        Label label2 = new Label();
        Label label3 = new Label();
        Label label4 = new Label();
        Class<?> clazz = name3.function.resolvedHandle.type().returnType();
        MethodType methodType = name.function.resolvedHandle.type().dropParameterTypes(0, 1).changeReturnType(clazz);
        this.mv.visitTryCatchBlock(label, label2, label3, "java/lang/Throwable");
        this.mv.visitLabel(label);
        this.emitPushArgument(name2, 0);
        this.emitPushArguments(name, 1);
        this.mv.visitMethodInsn(182, MH, "invokeBasic", methodType.basicType().toMethodDescriptorString(), false);
        this.mv.visitLabel(label2);
        this.mv.visitJumpInsn(167, label4);
        this.mv.visitLabel(label3);
        this.mv.visitInsn(89);
        this.emitPushArgument(name2, 1);
        this.mv.visitInsn(95);
        this.mv.visitMethodInsn(182, CLS, "isInstance", "(Ljava/lang/Object;)Z", false);
        Label label5 = new Label();
        this.mv.visitJumpInsn(153, label5);
        this.emitPushArgument(name2, 2);
        this.mv.visitInsn(95);
        this.emitPushArguments(name, 1);
        MethodType methodType2 = methodType.insertParameterTypes(0, Throwable.class);
        this.mv.visitMethodInsn(182, MH, "invokeBasic", methodType2.basicType().toMethodDescriptorString(), false);
        this.mv.visitJumpInsn(167, label4);
        this.mv.visitLabel(label5);
        this.mv.visitInsn(191);
        this.mv.visitLabel(label4);
        return name3;
    }

    private void emitPushArguments(LambdaForm.Name name) {
        this.emitPushArguments(name, 0);
    }

    private void emitPushArguments(LambdaForm.Name name, int n) {
        for (int i = n; i < name.arguments.length; ++i) {
            this.emitPushArgument(name, i);
        }
    }

    private void emitPushArgument(LambdaForm.Name name, int n) {
        Object object = name.arguments[n];
        Class<?> clazz = name.function.methodType().parameterType(n);
        this.emitPushArgument(clazz, object);
    }

    private void emitPushArgument(Class<?> clazz, Object object) {
        LambdaForm.BasicType basicType = LambdaForm.BasicType.basicType(clazz);
        if (object instanceof LambdaForm.Name) {
            LambdaForm.Name name = (LambdaForm.Name)object;
            this.emitLoadInsn(name.type, name.index());
            this.emitImplicitConversion(name.type, clazz, name);
        } else if ((object == null || object instanceof String) && basicType == LambdaForm.BasicType.L_TYPE) {
            this.emitConst(object);
        } else if (Wrapper.isWrapperType(object.getClass()) && basicType != LambdaForm.BasicType.L_TYPE) {
            this.emitConst(object);
        } else {
            this.mv.visitLdcInsn(this.constantPlaceholder(object));
            this.emitImplicitConversion(LambdaForm.BasicType.L_TYPE, clazz, object);
        }
    }

    private void emitStoreResult(LambdaForm.Name name) {
        if (name != null && name.type != LambdaForm.BasicType.V_TYPE) {
            this.emitStoreInsn(name.type, name.index());
        }
    }

    private void emitReturn(LambdaForm.Name name) {
        Class<?> clazz = this.invokerType.returnType();
        LambdaForm.BasicType basicType = this.lambdaForm.returnType();
        assert (basicType == LambdaForm.BasicType.basicType(clazz));
        if (basicType == LambdaForm.BasicType.V_TYPE) {
            this.mv.visitInsn(177);
        } else {
            LambdaForm.Name name2 = this.lambdaForm.names[this.lambdaForm.result];
            if (name2 != name) {
                this.emitLoadInsn(basicType, this.lambdaForm.result);
            }
            this.emitImplicitConversion(basicType, clazz, name2);
            this.emitReturnInsn(basicType);
        }
    }

    private void emitPrimCast(Wrapper wrapper, Wrapper wrapper2) {
        if (wrapper == wrapper2) {
            return;
        }
        if (wrapper.isSubwordOrInt()) {
            this.emitI2X(wrapper2);
        } else if (wrapper2.isSubwordOrInt()) {
            this.emitX2I(wrapper);
            if (wrapper2.bitWidth() < 32) {
                this.emitI2X(wrapper2);
            }
        } else {
            boolean bl = false;
            block0 : switch (wrapper) {
                case LONG: {
                    switch (wrapper2) {
                        case FLOAT: {
                            this.mv.visitInsn(137);
                            break block0;
                        }
                        case DOUBLE: {
                            this.mv.visitInsn(138);
                            break block0;
                        }
                    }
                    bl = true;
                    break;
                }
                case FLOAT: {
                    switch (wrapper2) {
                        case LONG: {
                            this.mv.visitInsn(140);
                            break block0;
                        }
                        case DOUBLE: {
                            this.mv.visitInsn(141);
                            break block0;
                        }
                    }
                    bl = true;
                    break;
                }
                case DOUBLE: {
                    switch (wrapper2) {
                        case LONG: {
                            this.mv.visitInsn(143);
                            break block0;
                        }
                        case FLOAT: {
                            this.mv.visitInsn(144);
                            break block0;
                        }
                    }
                    bl = true;
                    break;
                }
                default: {
                    bl = true;
                }
            }
            if (bl) {
                throw new IllegalStateException("unhandled prim cast: " + (Object)((Object)wrapper) + "2" + (Object)((Object)wrapper2));
            }
        }
    }

    private void emitI2X(Wrapper wrapper) {
        switch (wrapper) {
            case BYTE: {
                this.mv.visitInsn(145);
                break;
            }
            case SHORT: {
                this.mv.visitInsn(147);
                break;
            }
            case CHAR: {
                this.mv.visitInsn(146);
                break;
            }
            case INT: {
                break;
            }
            case LONG: {
                this.mv.visitInsn(133);
                break;
            }
            case FLOAT: {
                this.mv.visitInsn(134);
                break;
            }
            case DOUBLE: {
                this.mv.visitInsn(135);
                break;
            }
            case BOOLEAN: {
                this.mv.visitInsn(4);
                this.mv.visitInsn(126);
                break;
            }
            default: {
                throw new InternalError("unknown type: " + (Object)((Object)wrapper));
            }
        }
    }

    private void emitX2I(Wrapper wrapper) {
        switch (wrapper) {
            case LONG: {
                this.mv.visitInsn(136);
                break;
            }
            case FLOAT: {
                this.mv.visitInsn(139);
                break;
            }
            case DOUBLE: {
                this.mv.visitInsn(142);
                break;
            }
            default: {
                throw new InternalError("unknown type: " + (Object)((Object)wrapper));
            }
        }
    }

    static MemberName generateLambdaFormInterpreterEntryPoint(String string) {
        assert (LambdaForm.isValidSignature(string));
        String string2 = "interpret_" + LambdaForm.signatureReturn(string).basicTypeChar();
        MethodType methodType = LambdaForm.signatureType(string);
        methodType = methodType.changeParameterType(0, MethodHandle.class);
        InvokerBytecodeGenerator invokerBytecodeGenerator = new InvokerBytecodeGenerator("LFI", string2, methodType);
        return invokerBytecodeGenerator.loadMethod(invokerBytecodeGenerator.generateLambdaFormInterpreterEntryPointBytes());
    }

    private byte[] generateLambdaFormInterpreterEntryPointBytes() {
        Object object;
        this.classFilePrologue();
        this.mv.visitAnnotation("Ljava/lang/invoke/LambdaForm$Hidden;", true);
        this.mv.visitAnnotation("Ljava/lang/invoke/DontInline;", true);
        this.emitIconstInsn(this.invokerType.parameterCount());
        this.mv.visitTypeInsn(189, "java/lang/Object");
        for (int i = 0; i < this.invokerType.parameterCount(); ++i) {
            object = this.invokerType.parameterType(i);
            this.mv.visitInsn(89);
            this.emitIconstInsn(i);
            this.emitLoadInsn(LambdaForm.BasicType.basicType(object), i);
            if (((Class)object).isPrimitive()) {
                this.emitBoxing(Wrapper.forPrimitiveType(object));
            }
            this.mv.visitInsn(83);
        }
        this.emitAloadInsn(0);
        this.mv.visitFieldInsn(180, MH, "form", LF_SIG);
        this.mv.visitInsn(95);
        this.mv.visitMethodInsn(182, LF, "interpretWithArguments", "([Ljava/lang/Object;)Ljava/lang/Object;", false);
        Class<?> clazz = this.invokerType.returnType();
        if (clazz.isPrimitive() && clazz != Void.TYPE) {
            this.emitUnboxing(Wrapper.forPrimitiveType(clazz));
        }
        this.emitReturnInsn(LambdaForm.BasicType.basicType(clazz));
        this.classFileEpilogue();
        this.bogusMethod(this.invokerType);
        object = this.cw.toByteArray();
        InvokerBytecodeGenerator.maybeDump(this.className, (byte[])object);
        return object;
    }

    static MemberName generateNamedFunctionInvoker(MethodTypeForm methodTypeForm) {
        MethodType methodType = LambdaForm.NamedFunction.INVOKER_METHOD_TYPE;
        String string = "invoke_" + LambdaForm.shortenSignature(LambdaForm.basicTypeSignature(methodTypeForm.erasedType()));
        InvokerBytecodeGenerator invokerBytecodeGenerator = new InvokerBytecodeGenerator("NFI", string, methodType);
        return invokerBytecodeGenerator.loadMethod(invokerBytecodeGenerator.generateNamedFunctionInvokerImpl(methodTypeForm));
    }

    private byte[] generateNamedFunctionInvokerImpl(MethodTypeForm methodTypeForm) {
        Wrapper wrapper;
        Object object;
        Class<?> clazz;
        MethodType methodType = methodTypeForm.erasedType();
        this.classFilePrologue();
        this.mv.visitAnnotation("Ljava/lang/invoke/LambdaForm$Hidden;", true);
        this.mv.visitAnnotation("Ljava/lang/invoke/ForceInline;", true);
        this.emitAloadInsn(0);
        for (int i = 0; i < methodType.parameterCount(); ++i) {
            this.emitAloadInsn(1);
            this.emitIconstInsn(i);
            this.mv.visitInsn(50);
            clazz = methodType.parameterType(i);
            if (!clazz.isPrimitive()) continue;
            object = methodType.basicType().wrap().parameterType(i);
            wrapper = Wrapper.forBasicType(clazz);
            Wrapper wrapper2 = wrapper.isSubwordOrInt() ? Wrapper.INT : wrapper;
            this.emitUnboxing(wrapper2);
            this.emitPrimCast(wrapper2, wrapper);
        }
        String string = methodType.basicType().toMethodDescriptorString();
        this.mv.visitMethodInsn(182, MH, "invokeBasic", string, false);
        clazz = methodType.returnType();
        if (clazz != Void.TYPE && clazz.isPrimitive()) {
            object = Wrapper.forBasicType(clazz);
            wrapper = ((Wrapper)((Object)object)).isSubwordOrInt() ? Wrapper.INT : object;
            this.emitPrimCast((Wrapper)((Object)object), wrapper);
            this.emitBoxing(wrapper);
        }
        if (clazz == Void.TYPE) {
            this.mv.visitInsn(1);
        }
        this.emitReturnInsn(LambdaForm.BasicType.L_TYPE);
        this.classFileEpilogue();
        this.bogusMethod(methodType);
        object = this.cw.toByteArray();
        InvokerBytecodeGenerator.maybeDump(this.className, object);
        return object;
    }

    private void bogusMethod(Object ... objectArray) {
        if (MethodHandleStatics.DUMP_CLASS_FILES) {
            this.mv = this.cw.visitMethod(8, "dummy", "()V", null, null);
            for (Object object : objectArray) {
                this.mv.visitLdcInsn(object.toString());
                this.mv.visitInsn(87);
            }
            this.mv.visitInsn(177);
            this.mv.visitMaxs(0, 0);
            this.mv.visitEnd();
        }
    }

    static {
        if (MethodHandleStatics.DUMP_CLASS_FILES) {
            DUMP_CLASS_FILES_COUNTERS = new HashMap();
            try {
                File file = new File("DUMP_CLASS_FILES");
                if (!file.exists()) {
                    file.mkdirs();
                }
                DUMP_CLASS_FILES_DIR = file;
                System.out.println("Dumping class files to " + DUMP_CLASS_FILES_DIR + "/...");
            }
            catch (Exception exception) {
                throw MethodHandleStatics.newInternalError(exception);
            }
        } else {
            DUMP_CLASS_FILES_COUNTERS = null;
            DUMP_CLASS_FILES_DIR = null;
        }
        STATICALLY_INVOCABLE_PACKAGES = new Class[]{Object.class, Arrays.class, Unsafe.class};
    }

    class CpPatch {
        final int index;
        final String placeholder;
        final Object value;

        CpPatch(int n, String string, Object object) {
            this.index = n;
            this.placeholder = string;
            this.value = object;
        }

        public String toString() {
            return "CpPatch/index=" + this.index + ",placeholder=" + this.placeholder + ",value=" + this.value;
        }
    }
}

