/*
    This file is part of the WebKit open source project.
    This file has been generated by generate-bindings.pl. DO NOT MODIFY!

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public License
    along with this library; see the file COPYING.LIB.  If not, write to
    the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
    Boston, MA 02110-1301, USA.
*/

#include "config.h"
#include "JSWebTransportSendStream.h"

#include "ActiveDOMObject.h"
#include "DOMPromiseProxy.h"
#include "ExtendedDOMClientIsoSubspaces.h"
#include "ExtendedDOMIsoSubspaces.h"
#include "JSDOMAttribute.h"
#include "JSDOMBinding.h"
#include "JSDOMConstructorNotConstructable.h"
#include "JSDOMConvertDictionary.h"
#include "JSDOMConvertNullable.h"
#include "JSDOMConvertNumbers.h"
#include "JSDOMConvertPromise.h"
#include "JSDOMExceptionHandling.h"
#include "JSDOMGlobalObject.h"
#include "JSDOMGlobalObjectInlines.h"
#include "JSDOMOperation.h"
#include "JSDOMOperationReturningPromise.h"
#include "JSDOMWrapperCache.h"
#include "JSWebTransportSendStreamStats.h"
#include "ScriptExecutionContext.h"
#include "WebCoreJSClientData.h"
#include <JavaScriptCore/HeapAnalyzer.h>
#include <JavaScriptCore/JSCInlines.h>
#include <JavaScriptCore/JSDestructibleObjectHeapCellType.h>
#include <JavaScriptCore/SlotVisitorMacros.h>
#include <JavaScriptCore/SubspaceInlines.h>
#include <wtf/GetPtr.h>
#include <wtf/PointerPreparations.h>
#include <wtf/URL.h>
#include <wtf/text/MakeString.h>


namespace WebCore {
using namespace JSC;

// Functions

static JSC_DECLARE_HOST_FUNCTION(jsWebTransportSendStreamPrototypeFunction_getStats);

// Attributes

static JSC_DECLARE_CUSTOM_GETTER(jsWebTransportSendStreamConstructor);
static JSC_DECLARE_CUSTOM_GETTER(jsWebTransportSendStream_sendOrder);
static JSC_DECLARE_CUSTOM_SETTER(setJSWebTransportSendStream_sendOrder);

class JSWebTransportSendStreamPrototype final : public JSC::JSNonFinalObject {
public:
    using Base = JSC::JSNonFinalObject;
    static JSWebTransportSendStreamPrototype* create(JSC::VM& vm, JSDOMGlobalObject* globalObject, JSC::Structure* structure)
    {
        JSWebTransportSendStreamPrototype* ptr = new (NotNull, JSC::allocateCell<JSWebTransportSendStreamPrototype>(vm)) JSWebTransportSendStreamPrototype(vm, globalObject, structure);
        ptr->finishCreation(vm);
        return ptr;
    }

    DECLARE_INFO;
    template<typename CellType, JSC::SubspaceAccess>
    static JSC::GCClient::IsoSubspace* subspaceFor(JSC::VM& vm)
    {
        STATIC_ASSERT_ISO_SUBSPACE_SHARABLE(JSWebTransportSendStreamPrototype, Base);
        return &vm.plainObjectSpace();
    }
    static JSC::Structure* createStructure(JSC::VM& vm, JSC::JSGlobalObject* globalObject, JSC::JSValue prototype)
    {
        return JSC::Structure::create(vm, globalObject, prototype, JSC::TypeInfo(JSC::ObjectType, StructureFlags), info());
    }

private:
    JSWebTransportSendStreamPrototype(JSC::VM& vm, JSC::JSGlobalObject*, JSC::Structure* structure)
        : JSC::JSNonFinalObject(vm, structure)
    {
    }

    void finishCreation(JSC::VM&);
};
STATIC_ASSERT_ISO_SUBSPACE_SHARABLE(JSWebTransportSendStreamPrototype, JSWebTransportSendStreamPrototype::Base);

using JSWebTransportSendStreamDOMConstructor = JSDOMConstructorNotConstructable<JSWebTransportSendStream>;

template<> const ClassInfo JSWebTransportSendStreamDOMConstructor::s_info = { "WebTransportSendStream"_s, &Base::s_info, nullptr, nullptr, CREATE_METHOD_TABLE(JSWebTransportSendStreamDOMConstructor) };

template<> JSValue JSWebTransportSendStreamDOMConstructor::prototypeForStructure(JSC::VM& vm, const JSDOMGlobalObject& globalObject)
{
    return JSWritableStream::getConstructor(vm, &globalObject);
}

template<> void JSWebTransportSendStreamDOMConstructor::initializeProperties(VM& vm, JSDOMGlobalObject& globalObject)
{
    putDirect(vm, vm.propertyNames->length, jsNumber(0), JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::DontEnum);
    JSString* nameString = jsNontrivialString(vm, "WebTransportSendStream"_s);
    m_originalName.set(vm, this, nameString);
    putDirect(vm, vm.propertyNames->name, nameString, JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::DontEnum);
    putDirect(vm, vm.propertyNames->prototype, JSWebTransportSendStream::prototype(vm, globalObject), JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::DontEnum | JSC::PropertyAttribute::DontDelete);
}

/* Hash table for prototype */

static const HashTableValue JSWebTransportSendStreamPrototypeTableValues[] =
{
    { "constructor"_s, static_cast<unsigned>(PropertyAttribute::DontEnum), NoIntrinsic, { HashTableValue::GetterSetterType, jsWebTransportSendStreamConstructor, 0 } },
    { "sendOrder"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsWebTransportSendStream_sendOrder, setJSWebTransportSendStream_sendOrder } },
    { "getStats"_s, static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { HashTableValue::NativeFunctionType, jsWebTransportSendStreamPrototypeFunction_getStats, 0 } },
};

const ClassInfo JSWebTransportSendStreamPrototype::s_info = { "WebTransportSendStream"_s, &Base::s_info, nullptr, nullptr, CREATE_METHOD_TABLE(JSWebTransportSendStreamPrototype) };

void JSWebTransportSendStreamPrototype::finishCreation(VM& vm)
{
    Base::finishCreation(vm);
    reifyStaticProperties(vm, JSWebTransportSendStream::info(), JSWebTransportSendStreamPrototypeTableValues, *this);
    JSC_TO_STRING_TAG_WITHOUT_TRANSITION();
}

const ClassInfo JSWebTransportSendStream::s_info = { "WebTransportSendStream"_s, &Base::s_info, nullptr, nullptr, CREATE_METHOD_TABLE(JSWebTransportSendStream) };

JSWebTransportSendStream::JSWebTransportSendStream(Structure* structure, JSDOMGlobalObject& globalObject, Ref<WebTransportSendStream>&& impl)
    : JSWritableStream(structure, globalObject, WTFMove(impl))
{
}

Ref<WebTransportSendStream> JSWebTransportSendStream::protectedWrapped() const
{
    return wrapped();
}

static_assert(!std::is_base_of<ActiveDOMObject, WebTransportSendStream>::value, "Interface is not marked as [ActiveDOMObject] even though implementation class subclasses ActiveDOMObject.");

JSObject* JSWebTransportSendStream::createPrototype(VM& vm, JSDOMGlobalObject& globalObject)
{
    auto* structure = JSWebTransportSendStreamPrototype::createStructure(vm, &globalObject, JSWritableStream::prototype(vm, globalObject));
    structure->setMayBePrototype(true);
    return JSWebTransportSendStreamPrototype::create(vm, &globalObject, structure);
}

JSObject* JSWebTransportSendStream::prototype(VM& vm, JSDOMGlobalObject& globalObject)
{
    return getDOMPrototype<JSWebTransportSendStream>(vm, globalObject);
}

JSValue JSWebTransportSendStream::getConstructor(VM& vm, const JSGlobalObject* globalObject)
{
    return getDOMConstructor<JSWebTransportSendStreamDOMConstructor, DOMConstructorID::WebTransportSendStream>(vm, *jsCast<const JSDOMGlobalObject*>(globalObject));
}

JSC_DEFINE_CUSTOM_GETTER(jsWebTransportSendStreamConstructor, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName))
{
    auto& vm = JSC::getVM(lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    auto* prototype = jsDynamicCast<JSWebTransportSendStreamPrototype*>(JSValue::decode(thisValue));
    if (UNLIKELY(!prototype))
        return throwVMTypeError(lexicalGlobalObject, throwScope);
    return JSValue::encode(JSWebTransportSendStream::getConstructor(vm, prototype->globalObject()));
}

static inline JSValue jsWebTransportSendStream_sendOrderGetter(JSGlobalObject& lexicalGlobalObject, JSWebTransportSendStream& thisObject)
{
    auto& vm = JSC::getVM(&lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    auto& impl = thisObject.wrapped();
    RELEASE_AND_RETURN(throwScope, (toJS<IDLNullable<IDLLongLong>>(lexicalGlobalObject, throwScope, impl.sendOrder())));
}

JSC_DEFINE_CUSTOM_GETTER(jsWebTransportSendStream_sendOrder, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName attributeName))
{
    return IDLAttribute<JSWebTransportSendStream>::get<jsWebTransportSendStream_sendOrderGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, attributeName);
}

static inline bool setJSWebTransportSendStream_sendOrderSetter(JSGlobalObject& lexicalGlobalObject, JSWebTransportSendStream& thisObject, JSValue value)
{
    auto& vm = JSC::getVM(&lexicalGlobalObject);
    UNUSED_PARAM(vm);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    auto& impl = thisObject.wrapped();
    auto nativeValueConversionResult = convert<IDLNullable<IDLLongLong>>(lexicalGlobalObject, value);
    if (UNLIKELY(nativeValueConversionResult.hasException(throwScope)))
        return false;
    invokeFunctorPropagatingExceptionIfNecessary(lexicalGlobalObject, throwScope, [&] {
        return impl.setSendOrder(nativeValueConversionResult.releaseReturnValue());
    });
    return true;
}

JSC_DEFINE_CUSTOM_SETTER(setJSWebTransportSendStream_sendOrder, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, EncodedJSValue encodedValue, PropertyName attributeName))
{
    return IDLAttribute<JSWebTransportSendStream>::set<setJSWebTransportSendStream_sendOrderSetter>(*lexicalGlobalObject, thisValue, encodedValue, attributeName);
}

static inline JSC::EncodedJSValue jsWebTransportSendStreamPrototypeFunction_getStatsBody(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperationReturningPromise<JSWebTransportSendStream>::ClassParameter castedThis, Ref<DeferredPromise>&& promise)
{
    auto& vm = JSC::getVM(lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(callFrame);
    auto& impl = castedThis->wrapped();
    RELEASE_AND_RETURN(throwScope, JSValue::encode(toJS<IDLPromise<IDLDictionary<WebTransportSendStreamStats>>>(*lexicalGlobalObject, *castedThis->globalObject(), throwScope, [&]() -> decltype(auto) { return impl.getStats(WTFMove(promise)); })));
}

JSC_DEFINE_HOST_FUNCTION(jsWebTransportSendStreamPrototypeFunction_getStats, (JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame))
{
    return IDLOperationReturningPromise<JSWebTransportSendStream>::call<jsWebTransportSendStreamPrototypeFunction_getStatsBody>(*lexicalGlobalObject, *callFrame, "getStats");
}

JSC::GCClient::IsoSubspace* JSWebTransportSendStream::subspaceForImpl(JSC::VM& vm)
{
    return WebCore::subspaceForImpl<JSWebTransportSendStream, UseCustomHeapCellType::No>(vm,
        [] (auto& spaces) { return spaces.m_clientSubspaceForWebTransportSendStream.get(); },
        [] (auto& spaces, auto&& space) { spaces.m_clientSubspaceForWebTransportSendStream = std::forward<decltype(space)>(space); },
        [] (auto& spaces) { return spaces.m_subspaceForWebTransportSendStream.get(); },
        [] (auto& spaces, auto&& space) { spaces.m_subspaceForWebTransportSendStream = std::forward<decltype(space)>(space); }
    );
}

void JSWebTransportSendStream::analyzeHeap(JSCell* cell, HeapAnalyzer& analyzer)
{
    auto* thisObject = jsCast<JSWebTransportSendStream*>(cell);
    analyzer.setWrappedObjectForCell(cell, &thisObject->wrapped());
    if (thisObject->scriptExecutionContext())
        analyzer.setLabelForCell(cell, makeString("url "_s, thisObject->scriptExecutionContext()->url().string()));
    Base::analyzeHeap(cell, analyzer);
}


}
