/*
    This file is part of the WebKit open source project.
    This file has been generated by generate-bindings.pl. DO NOT MODIFY!

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public License
    along with this library; see the file COPYING.LIB.  If not, write to
    the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
    Boston, MA 02110-1301, USA.
*/

#include "config.h"
#include "JSUndoItem.h"

#include "ActiveDOMObject.h"
#include "ExtendedDOMClientIsoSubspaces.h"
#include "ExtendedDOMIsoSubspaces.h"
#include "JSDOMAttribute.h"
#include "JSDOMBinding.h"
#include "JSDOMConstructor.h"
#include "JSDOMConvertCallbacks.h"
#include "JSDOMConvertInterface.h"
#include "JSDOMConvertStrings.h"
#include "JSDOMExceptionHandling.h"
#include "JSDOMGlobalObject.h"
#include "JSDOMGlobalObjectInlines.h"
#include "JSDOMWrapperCache.h"
#include "JSVoidCallback.h"
#include "ScriptExecutionContext.h"
#include "WebCoreJSClientData.h"
#include <JavaScriptCore/FunctionPrototype.h>
#include <JavaScriptCore/HeapAnalyzer.h>
#include <JavaScriptCore/JSCInlines.h>
#include <JavaScriptCore/JSDestructibleObjectHeapCellType.h>
#include <JavaScriptCore/SlotVisitorMacros.h>
#include <JavaScriptCore/SubspaceInlines.h>
#include <wtf/GetPtr.h>
#include <wtf/PointerPreparations.h>
#include <wtf/URL.h>
#include <wtf/text/MakeString.h>


namespace WebCore {
using namespace JSC;

template<> ConversionResult<IDLDictionary<UndoItem::Init>> convertDictionary<UndoItem::Init>(JSGlobalObject& lexicalGlobalObject, JSValue value)
{
    auto& vm = JSC::getVM(&lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    bool isNullOrUndefined = value.isUndefinedOrNull();
    auto* object = isNullOrUndefined ? nullptr : value.getObject();
    if (UNLIKELY(!isNullOrUndefined && !object)) {
        throwTypeError(&lexicalGlobalObject, throwScope);
        return ConversionResultException { };
    }
    UndoItem::Init result;
    JSValue labelValue;
    if (isNullOrUndefined)
        labelValue = jsUndefined();
    else {
        labelValue = object->get(&lexicalGlobalObject, Identifier::fromString(vm, "label"_s));
        RETURN_IF_EXCEPTION(throwScope, ConversionResultException { });
    }
    if (labelValue.isUndefined()) {
        throwRequiredMemberTypeError(lexicalGlobalObject, throwScope, "label"_s, "UndoItemInit"_s, "DOMString"_s);
        return ConversionResultException { };
    }
    auto labelConversionResult = convert<IDLDOMString>(lexicalGlobalObject, labelValue);
    if (UNLIKELY(labelConversionResult.hasException(throwScope)))
        return ConversionResultException { };
    result.label = labelConversionResult.releaseReturnValue();
    JSValue redoValue;
    if (isNullOrUndefined)
        redoValue = jsUndefined();
    else {
        redoValue = object->get(&lexicalGlobalObject, Identifier::fromString(vm, "redo"_s));
        RETURN_IF_EXCEPTION(throwScope, ConversionResultException { });
    }
    if (redoValue.isUndefined()) {
        throwRequiredMemberTypeError(lexicalGlobalObject, throwScope, "redo"_s, "UndoItemInit"_s, "VoidCallback"_s);
        return ConversionResultException { };
    }
    auto redoConversionResult = convert<IDLCallbackFunction<JSVoidCallback>>(lexicalGlobalObject, redoValue, *jsCast<JSDOMGlobalObject*>(&lexicalGlobalObject));
    if (UNLIKELY(redoConversionResult.hasException(throwScope)))
        return ConversionResultException { };
    result.redo = redoConversionResult.releaseReturnValue();
    JSValue undoValue;
    if (isNullOrUndefined)
        undoValue = jsUndefined();
    else {
        undoValue = object->get(&lexicalGlobalObject, Identifier::fromString(vm, "undo"_s));
        RETURN_IF_EXCEPTION(throwScope, ConversionResultException { });
    }
    if (undoValue.isUndefined()) {
        throwRequiredMemberTypeError(lexicalGlobalObject, throwScope, "undo"_s, "UndoItemInit"_s, "VoidCallback"_s);
        return ConversionResultException { };
    }
    auto undoConversionResult = convert<IDLCallbackFunction<JSVoidCallback>>(lexicalGlobalObject, undoValue, *jsCast<JSDOMGlobalObject*>(&lexicalGlobalObject));
    if (UNLIKELY(undoConversionResult.hasException(throwScope)))
        return ConversionResultException { };
    result.undo = undoConversionResult.releaseReturnValue();
    return result;
}

// Attributes

static JSC_DECLARE_CUSTOM_GETTER(jsUndoItemConstructor);
static JSC_DECLARE_CUSTOM_GETTER(jsUndoItem_label);

class JSUndoItemPrototype final : public JSC::JSNonFinalObject {
public:
    using Base = JSC::JSNonFinalObject;
    static JSUndoItemPrototype* create(JSC::VM& vm, JSDOMGlobalObject* globalObject, JSC::Structure* structure)
    {
        JSUndoItemPrototype* ptr = new (NotNull, JSC::allocateCell<JSUndoItemPrototype>(vm)) JSUndoItemPrototype(vm, globalObject, structure);
        ptr->finishCreation(vm);
        return ptr;
    }

    DECLARE_INFO;
    template<typename CellType, JSC::SubspaceAccess>
    static JSC::GCClient::IsoSubspace* subspaceFor(JSC::VM& vm)
    {
        STATIC_ASSERT_ISO_SUBSPACE_SHARABLE(JSUndoItemPrototype, Base);
        return &vm.plainObjectSpace();
    }
    static JSC::Structure* createStructure(JSC::VM& vm, JSC::JSGlobalObject* globalObject, JSC::JSValue prototype)
    {
        return JSC::Structure::create(vm, globalObject, prototype, JSC::TypeInfo(JSC::ObjectType, StructureFlags), info());
    }

private:
    JSUndoItemPrototype(JSC::VM& vm, JSC::JSGlobalObject*, JSC::Structure* structure)
        : JSC::JSNonFinalObject(vm, structure)
    {
    }

    void finishCreation(JSC::VM&);
};
STATIC_ASSERT_ISO_SUBSPACE_SHARABLE(JSUndoItemPrototype, JSUndoItemPrototype::Base);

using JSUndoItemDOMConstructor = JSDOMConstructor<JSUndoItem>;

template<> EncodedJSValue JSC_HOST_CALL_ATTRIBUTES JSUndoItemDOMConstructor::construct(JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame)
{
    auto& vm = lexicalGlobalObject->vm();
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    auto* castedThis = jsCast<JSUndoItemDOMConstructor*>(callFrame->jsCallee());
    ASSERT(castedThis);
    if (UNLIKELY(callFrame->argumentCount() < 1))
        return throwVMError(lexicalGlobalObject, throwScope, createNotEnoughArgumentsError(lexicalGlobalObject));
    EnsureStillAliveScope argument0 = callFrame->uncheckedArgument(0);
    auto initDictConversionResult = convert<IDLDictionary<UndoItem::Init>>(*lexicalGlobalObject, argument0.value());
    if (UNLIKELY(initDictConversionResult.hasException(throwScope)))
       return encodedJSValue();
    auto object = UndoItem::create(initDictConversionResult.releaseReturnValue());
    if constexpr (IsExceptionOr<decltype(object)>)
        RETURN_IF_EXCEPTION(throwScope, { });
    static_assert(TypeOrExceptionOrUnderlyingType<decltype(object)>::isRef);
    auto jsValue = toJSNewlyCreated<IDLInterface<UndoItem>>(*lexicalGlobalObject, *castedThis->globalObject(), throwScope, WTFMove(object));
    if constexpr (IsExceptionOr<decltype(object)>)
        RETURN_IF_EXCEPTION(throwScope, { });
    setSubclassStructureIfNeeded<UndoItem>(lexicalGlobalObject, callFrame, asObject(jsValue));
    RETURN_IF_EXCEPTION(throwScope, { });
    return JSValue::encode(jsValue);
}
JSC_ANNOTATE_HOST_FUNCTION(JSUndoItemDOMConstructorConstruct, JSUndoItemDOMConstructor::construct);

template<> const ClassInfo JSUndoItemDOMConstructor::s_info = { "UndoItem"_s, &Base::s_info, nullptr, nullptr, CREATE_METHOD_TABLE(JSUndoItemDOMConstructor) };

template<> JSValue JSUndoItemDOMConstructor::prototypeForStructure(JSC::VM& vm, const JSDOMGlobalObject& globalObject)
{
    UNUSED_PARAM(vm);
    return globalObject.functionPrototype();
}

template<> void JSUndoItemDOMConstructor::initializeProperties(VM& vm, JSDOMGlobalObject& globalObject)
{
    putDirect(vm, vm.propertyNames->length, jsNumber(1), JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::DontEnum);
    JSString* nameString = jsNontrivialString(vm, "UndoItem"_s);
    m_originalName.set(vm, this, nameString);
    putDirect(vm, vm.propertyNames->name, nameString, JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::DontEnum);
    putDirect(vm, vm.propertyNames->prototype, JSUndoItem::prototype(vm, globalObject), JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::DontEnum | JSC::PropertyAttribute::DontDelete);
}

/* Hash table for prototype */

static const HashTableValue JSUndoItemPrototypeTableValues[] =
{
    { "constructor"_s, static_cast<unsigned>(PropertyAttribute::DontEnum), NoIntrinsic, { HashTableValue::GetterSetterType, jsUndoItemConstructor, 0 } },
    { "label"_s, JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsUndoItem_label, 0 } },
};

const ClassInfo JSUndoItemPrototype::s_info = { "UndoItem"_s, &Base::s_info, nullptr, nullptr, CREATE_METHOD_TABLE(JSUndoItemPrototype) };

void JSUndoItemPrototype::finishCreation(VM& vm)
{
    Base::finishCreation(vm);
    reifyStaticProperties(vm, JSUndoItem::info(), JSUndoItemPrototypeTableValues, *this);
    JSC_TO_STRING_TAG_WITHOUT_TRANSITION();
}

const ClassInfo JSUndoItem::s_info = { "UndoItem"_s, &Base::s_info, nullptr, nullptr, CREATE_METHOD_TABLE(JSUndoItem) };

JSUndoItem::JSUndoItem(Structure* structure, JSDOMGlobalObject& globalObject, Ref<UndoItem>&& impl)
    : JSDOMWrapper<UndoItem>(structure, globalObject, WTFMove(impl))
{
}

JSObject* JSUndoItem::createPrototype(VM& vm, JSDOMGlobalObject& globalObject)
{
    auto* structure = JSUndoItemPrototype::createStructure(vm, &globalObject, globalObject.objectPrototype());
    structure->setMayBePrototype(true);
    return JSUndoItemPrototype::create(vm, &globalObject, structure);
}

JSObject* JSUndoItem::prototype(VM& vm, JSDOMGlobalObject& globalObject)
{
    return getDOMPrototype<JSUndoItem>(vm, globalObject);
}

JSValue JSUndoItem::getConstructor(VM& vm, const JSGlobalObject* globalObject)
{
    return getDOMConstructor<JSUndoItemDOMConstructor, DOMConstructorID::UndoItem>(vm, *jsCast<const JSDOMGlobalObject*>(globalObject));
}

void JSUndoItem::destroy(JSC::JSCell* cell)
{
    JSUndoItem* thisObject = static_cast<JSUndoItem*>(cell);
    thisObject->JSUndoItem::~JSUndoItem();
}

JSC_DEFINE_CUSTOM_GETTER(jsUndoItemConstructor, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName))
{
    auto& vm = JSC::getVM(lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    auto* prototype = jsDynamicCast<JSUndoItemPrototype*>(JSValue::decode(thisValue));
    if (UNLIKELY(!prototype))
        return throwVMTypeError(lexicalGlobalObject, throwScope);
    return JSValue::encode(JSUndoItem::getConstructor(vm, prototype->globalObject()));
}

static inline JSValue jsUndoItem_labelGetter(JSGlobalObject& lexicalGlobalObject, JSUndoItem& thisObject)
{
    auto& vm = JSC::getVM(&lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    auto& impl = thisObject.wrapped();
    RELEASE_AND_RETURN(throwScope, (toJS<IDLDOMString>(lexicalGlobalObject, throwScope, impl.label())));
}

JSC_DEFINE_CUSTOM_GETTER(jsUndoItem_label, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName attributeName))
{
    return IDLAttribute<JSUndoItem>::get<jsUndoItem_labelGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, attributeName);
}

JSC::GCClient::IsoSubspace* JSUndoItem::subspaceForImpl(JSC::VM& vm)
{
    return WebCore::subspaceForImpl<JSUndoItem, UseCustomHeapCellType::No>(vm,
        [] (auto& spaces) { return spaces.m_clientSubspaceForUndoItem.get(); },
        [] (auto& spaces, auto&& space) { spaces.m_clientSubspaceForUndoItem = std::forward<decltype(space)>(space); },
        [] (auto& spaces) { return spaces.m_subspaceForUndoItem.get(); },
        [] (auto& spaces, auto&& space) { spaces.m_subspaceForUndoItem = std::forward<decltype(space)>(space); }
    );
}

template<typename Visitor>
void JSUndoItem::visitChildrenImpl(JSCell* cell, Visitor& visitor)
{
    auto* thisObject = jsCast<JSUndoItem*>(cell);
    ASSERT_GC_OBJECT_INHERITS(thisObject, info());
    Base::visitChildren(thisObject, visitor);
    thisObject->visitAdditionalChildren(visitor);
}

DEFINE_VISIT_CHILDREN(JSUndoItem);

template<typename Visitor>
void JSUndoItem::visitOutputConstraints(JSCell* cell, Visitor& visitor)
{
    auto* thisObject = jsCast<JSUndoItem*>(cell);
    ASSERT_GC_OBJECT_INHERITS(thisObject, info());
    Base::visitOutputConstraints(thisObject, visitor);
    thisObject->visitAdditionalChildren(visitor);
}

template void JSUndoItem::visitOutputConstraints(JSCell*, AbstractSlotVisitor&);
template void JSUndoItem::visitOutputConstraints(JSCell*, SlotVisitor&);
void JSUndoItem::analyzeHeap(JSCell* cell, HeapAnalyzer& analyzer)
{
    auto* thisObject = jsCast<JSUndoItem*>(cell);
    analyzer.setWrappedObjectForCell(cell, &thisObject->wrapped());
    if (thisObject->scriptExecutionContext())
        analyzer.setLabelForCell(cell, makeString("url "_s, thisObject->scriptExecutionContext()->url().string()));
    Base::analyzeHeap(cell, analyzer);
}

void JSUndoItemOwner::finalize(JSC::Handle<JSC::Unknown> handle, void* context)
{
    auto* jsUndoItem = static_cast<JSUndoItem*>(handle.slot()->asCell());
    auto& world = *static_cast<DOMWrapperWorld*>(context);
    uncacheWrapper(world, jsUndoItem->protectedWrapped().ptr(), jsUndoItem);
}

#if ENABLE(BINDING_INTEGRITY)
#if PLATFORM(WIN)
#pragma warning(disable: 4483)
extern "C" { extern void (*const __identifier("??_7UndoItem@WebCore@@6B@")[])(); }
#else
extern "C" { extern void* _ZTVN7WebCore8UndoItemE[]; }
#endif
template<typename T, typename = std::enable_if_t<std::is_same_v<T, UndoItem>, void>> static inline void verifyVTable(UndoItem* ptr) {
    if constexpr (std::is_polymorphic_v<T>) {
        const void* actualVTablePointer = getVTablePointer<T>(ptr);
#if PLATFORM(WIN)
        void* expectedVTablePointer = __identifier("??_7UndoItem@WebCore@@6B@");
#else
        void* expectedVTablePointer = &_ZTVN7WebCore8UndoItemE[2];
#endif

        // If you hit this assertion you either have a use after free bug, or
        // UndoItem has subclasses. If UndoItem has subclasses that get passed
        // to toJS() we currently require UndoItem you to opt out of binding hardening
        // by adding the SkipVTableValidation attribute to the interface IDL definition
        RELEASE_ASSERT(actualVTablePointer == expectedVTablePointer);
    }
}
#endif
JSC::JSValue toJSNewlyCreated(JSC::JSGlobalObject*, JSDOMGlobalObject* globalObject, Ref<UndoItem>&& impl)
{
#if ENABLE(BINDING_INTEGRITY)
    verifyVTable<UndoItem>(impl.ptr());
#endif
    return createWrapper<UndoItem>(globalObject, WTFMove(impl));
}

JSC::JSValue toJS(JSC::JSGlobalObject* lexicalGlobalObject, JSDOMGlobalObject* globalObject, UndoItem& impl)
{
    return wrap(lexicalGlobalObject, globalObject, impl);
}

UndoItem* JSUndoItem::toWrapped(JSC::VM&, JSC::JSValue value)
{
    if (auto* wrapper = jsDynamicCast<JSUndoItem*>(value))
        return &wrapper->wrapped();
    return nullptr;
}

}
