/*
    This file is part of the WebKit open source project.
    This file has been generated by generate-bindings.pl. DO NOT MODIFY!

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public License
    along with this library; see the file COPYING.LIB.  If not, write to
    the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
    Boston, MA 02110-1301, USA.
*/

#include "config.h"
#include "JSShadowRootInit.h"

#include "JSDOMConvertBoolean.h"
#include "JSDOMConvertEnumeration.h"
#include "JSDOMConvertOptional.h"
#include "JSShadowRootMode.h"
#include "JSSlotAssignmentMode.h"
#include "ScriptExecutionContext.h"
#include <JavaScriptCore/JSCInlines.h>


namespace WebCore {
using namespace JSC;

template<> ConversionResult<IDLDictionary<ShadowRootInit>> convertDictionary<ShadowRootInit>(JSGlobalObject& lexicalGlobalObject, JSValue value)
{
    auto& vm = JSC::getVM(&lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    bool isNullOrUndefined = value.isUndefinedOrNull();
    auto* object = isNullOrUndefined ? nullptr : value.getObject();
    if (UNLIKELY(!isNullOrUndefined && !object)) {
        throwTypeError(&lexicalGlobalObject, throwScope);
        return ConversionResultException { };
    }
    ShadowRootInit result;
    JSValue clonableValue;
    if (isNullOrUndefined)
        clonableValue = jsUndefined();
    else {
        clonableValue = object->get(&lexicalGlobalObject, Identifier::fromString(vm, "clonable"_s));
        RETURN_IF_EXCEPTION(throwScope, ConversionResultException { });
    }
    auto clonableConversionResult = convertOptionalWithDefault<IDLBoolean>(lexicalGlobalObject, clonableValue, [&]() -> ConversionResult<IDLBoolean> { return Converter<IDLBoolean>::ReturnType { false }; });
    if (UNLIKELY(clonableConversionResult.hasException(throwScope)))
        return ConversionResultException { };
    result.clonable = clonableConversionResult.releaseReturnValue();
    JSValue delegatesFocusValue;
    if (isNullOrUndefined)
        delegatesFocusValue = jsUndefined();
    else {
        delegatesFocusValue = object->get(&lexicalGlobalObject, Identifier::fromString(vm, "delegatesFocus"_s));
        RETURN_IF_EXCEPTION(throwScope, ConversionResultException { });
    }
    auto delegatesFocusConversionResult = convertOptionalWithDefault<IDLBoolean>(lexicalGlobalObject, delegatesFocusValue, [&]() -> ConversionResult<IDLBoolean> { return Converter<IDLBoolean>::ReturnType { false }; });
    if (UNLIKELY(delegatesFocusConversionResult.hasException(throwScope)))
        return ConversionResultException { };
    result.delegatesFocus = delegatesFocusConversionResult.releaseReturnValue();
    JSValue modeValue;
    if (isNullOrUndefined)
        modeValue = jsUndefined();
    else {
        modeValue = object->get(&lexicalGlobalObject, Identifier::fromString(vm, "mode"_s));
        RETURN_IF_EXCEPTION(throwScope, ConversionResultException { });
    }
    if (modeValue.isUndefined()) {
        throwRequiredMemberTypeError(lexicalGlobalObject, throwScope, "mode"_s, "ShadowRootInit"_s, "ShadowRootMode"_s);
        return ConversionResultException { };
    }
    auto modeConversionResult = convert<IDLEnumeration<ShadowRootMode>>(lexicalGlobalObject, modeValue);
    if (UNLIKELY(modeConversionResult.hasException(throwScope)))
        return ConversionResultException { };
    result.mode = modeConversionResult.releaseReturnValue();
    if (jsCast<JSDOMGlobalObject*>(&lexicalGlobalObject)->scriptExecutionContext()->settingsValues().declarativeShadowRootsSerializerAPIsEnabled) {
        JSValue serializableValue;
        if (isNullOrUndefined)
            serializableValue = jsUndefined();
        else {
            serializableValue = object->get(&lexicalGlobalObject, Identifier::fromString(vm, "serializable"_s));
            RETURN_IF_EXCEPTION(throwScope, ConversionResultException { });
        }
        auto serializableConversionResult = convertOptionalWithDefault<IDLBoolean>(lexicalGlobalObject, serializableValue, [&]() -> ConversionResult<IDLBoolean> { return Converter<IDLBoolean>::ReturnType { false }; });
        if (UNLIKELY(serializableConversionResult.hasException(throwScope)))
            return ConversionResultException { };
        result.serializable = serializableConversionResult.releaseReturnValue();
    }
    JSValue slotAssignmentValue;
    if (isNullOrUndefined)
        slotAssignmentValue = jsUndefined();
    else {
        slotAssignmentValue = object->get(&lexicalGlobalObject, Identifier::fromString(vm, "slotAssignment"_s));
        RETURN_IF_EXCEPTION(throwScope, ConversionResultException { });
    }
    auto slotAssignmentConversionResult = convertOptionalWithDefault<IDLEnumeration<SlotAssignmentMode>>(lexicalGlobalObject, slotAssignmentValue, [&]() -> ConversionResult<IDLEnumeration<SlotAssignmentMode>> { return Converter<IDLEnumeration<SlotAssignmentMode>>::ReturnType { SlotAssignmentMode::Named }; });
    if (UNLIKELY(slotAssignmentConversionResult.hasException(throwScope)))
        return ConversionResultException { };
    result.slotAssignment = slotAssignmentConversionResult.releaseReturnValue();
    return result;
}

} // namespace WebCore
