/*
    This file is part of the WebKit open source project.
    This file has been generated by generate-bindings.pl. DO NOT MODIFY!

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public License
    along with this library; see the file COPYING.LIB.  If not, write to
    the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
    Boston, MA 02110-1301, USA.
*/

#include "config.h"

#if ENABLE(WEBGL)

#include "JSOESElementIndexUint.h"

#include "ActiveDOMObject.h"
#include "ExtendedDOMClientIsoSubspaces.h"
#include "ExtendedDOMIsoSubspaces.h"
#include "JSDOMBinding.h"
#include "JSDOMExceptionHandling.h"
#include "JSDOMWrapperCache.h"
#include "ScriptExecutionContext.h"
#include "WebCoreJSClientData.h"
#include "WebCoreOpaqueRootInlines.h"
#include <JavaScriptCore/HeapAnalyzer.h>
#include <JavaScriptCore/JSCInlines.h>
#include <JavaScriptCore/JSDestructibleObjectHeapCellType.h>
#include <JavaScriptCore/SlotVisitorMacros.h>
#include <JavaScriptCore/SubspaceInlines.h>
#include <wtf/GetPtr.h>
#include <wtf/PointerPreparations.h>
#include <wtf/URL.h>
#include <wtf/text/MakeString.h>


namespace WebCore {
using namespace JSC;

class JSOESElementIndexUintPrototype final : public JSC::JSNonFinalObject {
public:
    using Base = JSC::JSNonFinalObject;
    static JSOESElementIndexUintPrototype* create(JSC::VM& vm, JSDOMGlobalObject* globalObject, JSC::Structure* structure)
    {
        JSOESElementIndexUintPrototype* ptr = new (NotNull, JSC::allocateCell<JSOESElementIndexUintPrototype>(vm)) JSOESElementIndexUintPrototype(vm, globalObject, structure);
        ptr->finishCreation(vm);
        return ptr;
    }

    DECLARE_INFO;
    template<typename CellType, JSC::SubspaceAccess>
    static JSC::GCClient::IsoSubspace* subspaceFor(JSC::VM& vm)
    {
        STATIC_ASSERT_ISO_SUBSPACE_SHARABLE(JSOESElementIndexUintPrototype, Base);
        return &vm.plainObjectSpace();
    }
    static JSC::Structure* createStructure(JSC::VM& vm, JSC::JSGlobalObject* globalObject, JSC::JSValue prototype)
    {
        return JSC::Structure::create(vm, globalObject, prototype, JSC::TypeInfo(JSC::ObjectType, StructureFlags), info());
    }

private:
    JSOESElementIndexUintPrototype(JSC::VM& vm, JSC::JSGlobalObject*, JSC::Structure* structure)
        : JSC::JSNonFinalObject(vm, structure)
    {
    }

    void finishCreation(JSC::VM&);
};
STATIC_ASSERT_ISO_SUBSPACE_SHARABLE(JSOESElementIndexUintPrototype, JSOESElementIndexUintPrototype::Base);

/* Hash table for prototype */
const ClassInfo JSOESElementIndexUintPrototype::s_info = { "OESElementIndexUint"_s, &Base::s_info, nullptr, nullptr, CREATE_METHOD_TABLE(JSOESElementIndexUintPrototype) };

void JSOESElementIndexUintPrototype::finishCreation(VM& vm)
{
    Base::finishCreation(vm);
    JSC_TO_STRING_TAG_WITHOUT_TRANSITION();
}

const ClassInfo JSOESElementIndexUint::s_info = { "OESElementIndexUint"_s, &Base::s_info, nullptr, nullptr, CREATE_METHOD_TABLE(JSOESElementIndexUint) };

JSOESElementIndexUint::JSOESElementIndexUint(Structure* structure, JSDOMGlobalObject& globalObject, Ref<OESElementIndexUint>&& impl)
    : JSDOMWrapper<OESElementIndexUint>(structure, globalObject, WTFMove(impl))
{
}

static_assert(!std::is_base_of<ActiveDOMObject, OESElementIndexUint>::value, "Interface is not marked as [ActiveDOMObject] even though implementation class subclasses ActiveDOMObject.");

JSObject* JSOESElementIndexUint::createPrototype(VM& vm, JSDOMGlobalObject& globalObject)
{
    auto* structure = JSOESElementIndexUintPrototype::createStructure(vm, &globalObject, globalObject.objectPrototype());
    structure->setMayBePrototype(true);
    return JSOESElementIndexUintPrototype::create(vm, &globalObject, structure);
}

JSObject* JSOESElementIndexUint::prototype(VM& vm, JSDOMGlobalObject& globalObject)
{
    return getDOMPrototype<JSOESElementIndexUint>(vm, globalObject);
}

void JSOESElementIndexUint::destroy(JSC::JSCell* cell)
{
    JSOESElementIndexUint* thisObject = static_cast<JSOESElementIndexUint*>(cell);
    thisObject->JSOESElementIndexUint::~JSOESElementIndexUint();
}

JSC::GCClient::IsoSubspace* JSOESElementIndexUint::subspaceForImpl(JSC::VM& vm)
{
    return WebCore::subspaceForImpl<JSOESElementIndexUint, UseCustomHeapCellType::No>(vm,
        [] (auto& spaces) { return spaces.m_clientSubspaceForOESElementIndexUint.get(); },
        [] (auto& spaces, auto&& space) { spaces.m_clientSubspaceForOESElementIndexUint = std::forward<decltype(space)>(space); },
        [] (auto& spaces) { return spaces.m_subspaceForOESElementIndexUint.get(); },
        [] (auto& spaces, auto&& space) { spaces.m_subspaceForOESElementIndexUint = std::forward<decltype(space)>(space); }
    );
}

void JSOESElementIndexUint::analyzeHeap(JSCell* cell, HeapAnalyzer& analyzer)
{
    auto* thisObject = jsCast<JSOESElementIndexUint*>(cell);
    analyzer.setWrappedObjectForCell(cell, &thisObject->wrapped());
    if (thisObject->scriptExecutionContext())
        analyzer.setLabelForCell(cell, makeString("url "_s, thisObject->scriptExecutionContext()->url().string()));
    Base::analyzeHeap(cell, analyzer);
}

bool JSOESElementIndexUintOwner::isReachableFromOpaqueRoots(JSC::Handle<JSC::Unknown> handle, void*, AbstractSlotVisitor& visitor, ASCIILiteral* reason)
{
    auto* jsOESElementIndexUint = jsCast<JSOESElementIndexUint*>(handle.slot()->asCell());
    auto& owner = jsOESElementIndexUint->wrapped();
    if (UNLIKELY(reason))
        *reason = "Reachable from jsOESElementIndexUint"_s;
    return containsWebCoreOpaqueRoot(visitor, owner);
}

void JSOESElementIndexUintOwner::finalize(JSC::Handle<JSC::Unknown> handle, void* context)
{
    auto* jsOESElementIndexUint = static_cast<JSOESElementIndexUint*>(handle.slot()->asCell());
    auto& world = *static_cast<DOMWrapperWorld*>(context);
    uncacheWrapper(world, jsOESElementIndexUint->protectedWrapped().ptr(), jsOESElementIndexUint);
}

#if ENABLE(BINDING_INTEGRITY)
#if PLATFORM(WIN)
#pragma warning(disable: 4483)
extern "C" { extern void (*const __identifier("??_7OESElementIndexUint@WebCore@@6B@")[])(); }
#else
extern "C" { extern void* _ZTVN7WebCore19OESElementIndexUintE[]; }
#endif
template<typename T, typename = std::enable_if_t<std::is_same_v<T, OESElementIndexUint>, void>> static inline void verifyVTable(OESElementIndexUint* ptr) {
    if constexpr (std::is_polymorphic_v<T>) {
        const void* actualVTablePointer = getVTablePointer<T>(ptr);
#if PLATFORM(WIN)
        void* expectedVTablePointer = __identifier("??_7OESElementIndexUint@WebCore@@6B@");
#else
        void* expectedVTablePointer = &_ZTVN7WebCore19OESElementIndexUintE[2];
#endif

        // If you hit this assertion you either have a use after free bug, or
        // OESElementIndexUint has subclasses. If OESElementIndexUint has subclasses that get passed
        // to toJS() we currently require OESElementIndexUint you to opt out of binding hardening
        // by adding the SkipVTableValidation attribute to the interface IDL definition
        RELEASE_ASSERT(actualVTablePointer == expectedVTablePointer);
    }
}
#endif
JSC::JSValue toJSNewlyCreated(JSC::JSGlobalObject*, JSDOMGlobalObject* globalObject, Ref<OESElementIndexUint>&& impl)
{
#if ENABLE(BINDING_INTEGRITY)
    verifyVTable<OESElementIndexUint>(impl.ptr());
#endif
    return createWrapper<OESElementIndexUint>(globalObject, WTFMove(impl));
}

JSC::JSValue toJS(JSC::JSGlobalObject* lexicalGlobalObject, JSDOMGlobalObject* globalObject, OESElementIndexUint& impl)
{
    return wrap(lexicalGlobalObject, globalObject, impl);
}

OESElementIndexUint* JSOESElementIndexUint::toWrapped(JSC::VM&, JSC::JSValue value)
{
    if (auto* wrapper = jsDynamicCast<JSOESElementIndexUint*>(value))
        return &wrapper->wrapped();
    return nullptr;
}

}

#endif // ENABLE(WEBGL)
