/*
    This file is part of the WebKit open source project.
    This file has been generated by generate-bindings.pl. DO NOT MODIFY!

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public License
    along with this library; see the file COPYING.LIB.  If not, write to
    the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
    Boston, MA 02110-1301, USA.
*/

#include "config.h"
#include "JSMultiCacheQueryOptions.h"

#include "JSDOMConvertBoolean.h"
#include "JSDOMConvertOptional.h"
#include "JSDOMConvertStrings.h"
#include <JavaScriptCore/JSCInlines.h>


namespace WebCore {
using namespace JSC;

template<> ConversionResult<IDLDictionary<MultiCacheQueryOptions>> convertDictionary<MultiCacheQueryOptions>(JSGlobalObject& lexicalGlobalObject, JSValue value)
{
    auto& vm = JSC::getVM(&lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    bool isNullOrUndefined = value.isUndefinedOrNull();
    auto* object = isNullOrUndefined ? nullptr : value.getObject();
    if (UNLIKELY(!isNullOrUndefined && !object)) {
        throwTypeError(&lexicalGlobalObject, throwScope);
        return ConversionResultException { };
    }
    MultiCacheQueryOptions result;
    JSValue ignoreMethodValue;
    if (isNullOrUndefined)
        ignoreMethodValue = jsUndefined();
    else {
        ignoreMethodValue = object->get(&lexicalGlobalObject, Identifier::fromString(vm, "ignoreMethod"_s));
        RETURN_IF_EXCEPTION(throwScope, ConversionResultException { });
    }
    auto ignoreMethodConversionResult = convertOptionalWithDefault<IDLBoolean>(lexicalGlobalObject, ignoreMethodValue, [&]() -> ConversionResult<IDLBoolean> { return Converter<IDLBoolean>::ReturnType { false }; });
    if (UNLIKELY(ignoreMethodConversionResult.hasException(throwScope)))
        return ConversionResultException { };
    result.ignoreMethod = ignoreMethodConversionResult.releaseReturnValue();
    JSValue ignoreSearchValue;
    if (isNullOrUndefined)
        ignoreSearchValue = jsUndefined();
    else {
        ignoreSearchValue = object->get(&lexicalGlobalObject, Identifier::fromString(vm, "ignoreSearch"_s));
        RETURN_IF_EXCEPTION(throwScope, ConversionResultException { });
    }
    auto ignoreSearchConversionResult = convertOptionalWithDefault<IDLBoolean>(lexicalGlobalObject, ignoreSearchValue, [&]() -> ConversionResult<IDLBoolean> { return Converter<IDLBoolean>::ReturnType { false }; });
    if (UNLIKELY(ignoreSearchConversionResult.hasException(throwScope)))
        return ConversionResultException { };
    result.ignoreSearch = ignoreSearchConversionResult.releaseReturnValue();
    JSValue ignoreVaryValue;
    if (isNullOrUndefined)
        ignoreVaryValue = jsUndefined();
    else {
        ignoreVaryValue = object->get(&lexicalGlobalObject, Identifier::fromString(vm, "ignoreVary"_s));
        RETURN_IF_EXCEPTION(throwScope, ConversionResultException { });
    }
    auto ignoreVaryConversionResult = convertOptionalWithDefault<IDLBoolean>(lexicalGlobalObject, ignoreVaryValue, [&]() -> ConversionResult<IDLBoolean> { return Converter<IDLBoolean>::ReturnType { false }; });
    if (UNLIKELY(ignoreVaryConversionResult.hasException(throwScope)))
        return ConversionResultException { };
    result.ignoreVary = ignoreVaryConversionResult.releaseReturnValue();
    JSValue cacheNameValue;
    if (isNullOrUndefined)
        cacheNameValue = jsUndefined();
    else {
        cacheNameValue = object->get(&lexicalGlobalObject, Identifier::fromString(vm, "cacheName"_s));
        RETURN_IF_EXCEPTION(throwScope, ConversionResultException { });
    }
    if (!cacheNameValue.isUndefined()) {
        auto cacheNameConversionResult = convert<IDLDOMString>(lexicalGlobalObject, cacheNameValue);
        if (UNLIKELY(cacheNameConversionResult.hasException(throwScope)))
            return ConversionResultException { };
        result.cacheName = cacheNameConversionResult.releaseReturnValue();
    }
    return result;
}

} // namespace WebCore
