/*
    This file is part of the WebKit open source project.
    This file has been generated by generate-bindings.pl. DO NOT MODIFY!

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public License
    along with this library; see the file COPYING.LIB.  If not, write to
    the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
    Boston, MA 02110-1301, USA.
*/

#include "config.h"
#include "JSGPUTextureFormat.h"

#include <JavaScriptCore/JSCInlines.h>
#include <JavaScriptCore/JSString.h>
#include <wtf/NeverDestroyed.h>
#include <wtf/SortedArrayMap.h>


namespace WebCore {
using namespace JSC;

String convertEnumerationToString(GPUTextureFormat enumerationValue)
{
    static const NeverDestroyed<String> values[] = {
        MAKE_STATIC_STRING_IMPL("r8unorm"),
        MAKE_STATIC_STRING_IMPL("r8snorm"),
        MAKE_STATIC_STRING_IMPL("r8uint"),
        MAKE_STATIC_STRING_IMPL("r8sint"),
        MAKE_STATIC_STRING_IMPL("r16uint"),
        MAKE_STATIC_STRING_IMPL("r16sint"),
        MAKE_STATIC_STRING_IMPL("r16float"),
        MAKE_STATIC_STRING_IMPL("rg8unorm"),
        MAKE_STATIC_STRING_IMPL("rg8snorm"),
        MAKE_STATIC_STRING_IMPL("rg8uint"),
        MAKE_STATIC_STRING_IMPL("rg8sint"),
        MAKE_STATIC_STRING_IMPL("r32uint"),
        MAKE_STATIC_STRING_IMPL("r32sint"),
        MAKE_STATIC_STRING_IMPL("r32float"),
        MAKE_STATIC_STRING_IMPL("rg16uint"),
        MAKE_STATIC_STRING_IMPL("rg16sint"),
        MAKE_STATIC_STRING_IMPL("rg16float"),
        MAKE_STATIC_STRING_IMPL("rgba8unorm"),
        MAKE_STATIC_STRING_IMPL("rgba8unorm-srgb"),
        MAKE_STATIC_STRING_IMPL("rgba8snorm"),
        MAKE_STATIC_STRING_IMPL("rgba8uint"),
        MAKE_STATIC_STRING_IMPL("rgba8sint"),
        MAKE_STATIC_STRING_IMPL("bgra8unorm"),
        MAKE_STATIC_STRING_IMPL("bgra8unorm-srgb"),
        MAKE_STATIC_STRING_IMPL("rgb9e5ufloat"),
        MAKE_STATIC_STRING_IMPL("rgb10a2uint"),
        MAKE_STATIC_STRING_IMPL("rgb10a2unorm"),
        MAKE_STATIC_STRING_IMPL("rg11b10ufloat"),
        MAKE_STATIC_STRING_IMPL("rg32uint"),
        MAKE_STATIC_STRING_IMPL("rg32sint"),
        MAKE_STATIC_STRING_IMPL("rg32float"),
        MAKE_STATIC_STRING_IMPL("rgba16uint"),
        MAKE_STATIC_STRING_IMPL("rgba16sint"),
        MAKE_STATIC_STRING_IMPL("rgba16float"),
        MAKE_STATIC_STRING_IMPL("rgba32uint"),
        MAKE_STATIC_STRING_IMPL("rgba32sint"),
        MAKE_STATIC_STRING_IMPL("rgba32float"),
        MAKE_STATIC_STRING_IMPL("stencil8"),
        MAKE_STATIC_STRING_IMPL("depth16unorm"),
        MAKE_STATIC_STRING_IMPL("depth24plus"),
        MAKE_STATIC_STRING_IMPL("depth24plus-stencil8"),
        MAKE_STATIC_STRING_IMPL("depth32float"),
        MAKE_STATIC_STRING_IMPL("depth32float-stencil8"),
        MAKE_STATIC_STRING_IMPL("bc1-rgba-unorm"),
        MAKE_STATIC_STRING_IMPL("bc1-rgba-unorm-srgb"),
        MAKE_STATIC_STRING_IMPL("bc2-rgba-unorm"),
        MAKE_STATIC_STRING_IMPL("bc2-rgba-unorm-srgb"),
        MAKE_STATIC_STRING_IMPL("bc3-rgba-unorm"),
        MAKE_STATIC_STRING_IMPL("bc3-rgba-unorm-srgb"),
        MAKE_STATIC_STRING_IMPL("bc4-r-unorm"),
        MAKE_STATIC_STRING_IMPL("bc4-r-snorm"),
        MAKE_STATIC_STRING_IMPL("bc5-rg-unorm"),
        MAKE_STATIC_STRING_IMPL("bc5-rg-snorm"),
        MAKE_STATIC_STRING_IMPL("bc6h-rgb-ufloat"),
        MAKE_STATIC_STRING_IMPL("bc6h-rgb-float"),
        MAKE_STATIC_STRING_IMPL("bc7-rgba-unorm"),
        MAKE_STATIC_STRING_IMPL("bc7-rgba-unorm-srgb"),
        MAKE_STATIC_STRING_IMPL("etc2-rgb8unorm"),
        MAKE_STATIC_STRING_IMPL("etc2-rgb8unorm-srgb"),
        MAKE_STATIC_STRING_IMPL("etc2-rgb8a1unorm"),
        MAKE_STATIC_STRING_IMPL("etc2-rgb8a1unorm-srgb"),
        MAKE_STATIC_STRING_IMPL("etc2-rgba8unorm"),
        MAKE_STATIC_STRING_IMPL("etc2-rgba8unorm-srgb"),
        MAKE_STATIC_STRING_IMPL("eac-r11unorm"),
        MAKE_STATIC_STRING_IMPL("eac-r11snorm"),
        MAKE_STATIC_STRING_IMPL("eac-rg11unorm"),
        MAKE_STATIC_STRING_IMPL("eac-rg11snorm"),
        MAKE_STATIC_STRING_IMPL("astc-4x4-unorm"),
        MAKE_STATIC_STRING_IMPL("astc-4x4-unorm-srgb"),
        MAKE_STATIC_STRING_IMPL("astc-5x4-unorm"),
        MAKE_STATIC_STRING_IMPL("astc-5x4-unorm-srgb"),
        MAKE_STATIC_STRING_IMPL("astc-5x5-unorm"),
        MAKE_STATIC_STRING_IMPL("astc-5x5-unorm-srgb"),
        MAKE_STATIC_STRING_IMPL("astc-6x5-unorm"),
        MAKE_STATIC_STRING_IMPL("astc-6x5-unorm-srgb"),
        MAKE_STATIC_STRING_IMPL("astc-6x6-unorm"),
        MAKE_STATIC_STRING_IMPL("astc-6x6-unorm-srgb"),
        MAKE_STATIC_STRING_IMPL("astc-8x5-unorm"),
        MAKE_STATIC_STRING_IMPL("astc-8x5-unorm-srgb"),
        MAKE_STATIC_STRING_IMPL("astc-8x6-unorm"),
        MAKE_STATIC_STRING_IMPL("astc-8x6-unorm-srgb"),
        MAKE_STATIC_STRING_IMPL("astc-8x8-unorm"),
        MAKE_STATIC_STRING_IMPL("astc-8x8-unorm-srgb"),
        MAKE_STATIC_STRING_IMPL("astc-10x5-unorm"),
        MAKE_STATIC_STRING_IMPL("astc-10x5-unorm-srgb"),
        MAKE_STATIC_STRING_IMPL("astc-10x6-unorm"),
        MAKE_STATIC_STRING_IMPL("astc-10x6-unorm-srgb"),
        MAKE_STATIC_STRING_IMPL("astc-10x8-unorm"),
        MAKE_STATIC_STRING_IMPL("astc-10x8-unorm-srgb"),
        MAKE_STATIC_STRING_IMPL("astc-10x10-unorm"),
        MAKE_STATIC_STRING_IMPL("astc-10x10-unorm-srgb"),
        MAKE_STATIC_STRING_IMPL("astc-12x10-unorm"),
        MAKE_STATIC_STRING_IMPL("astc-12x10-unorm-srgb"),
        MAKE_STATIC_STRING_IMPL("astc-12x12-unorm"),
        MAKE_STATIC_STRING_IMPL("astc-12x12-unorm-srgb"),
    };
    static_assert(static_cast<size_t>(GPUTextureFormat::R8unorm) == 0, "GPUTextureFormat::R8unorm is not 0 as expected");
    static_assert(static_cast<size_t>(GPUTextureFormat::R8snorm) == 1, "GPUTextureFormat::R8snorm is not 1 as expected");
    static_assert(static_cast<size_t>(GPUTextureFormat::R8uint) == 2, "GPUTextureFormat::R8uint is not 2 as expected");
    static_assert(static_cast<size_t>(GPUTextureFormat::R8sint) == 3, "GPUTextureFormat::R8sint is not 3 as expected");
    static_assert(static_cast<size_t>(GPUTextureFormat::R16uint) == 4, "GPUTextureFormat::R16uint is not 4 as expected");
    static_assert(static_cast<size_t>(GPUTextureFormat::R16sint) == 5, "GPUTextureFormat::R16sint is not 5 as expected");
    static_assert(static_cast<size_t>(GPUTextureFormat::R16float) == 6, "GPUTextureFormat::R16float is not 6 as expected");
    static_assert(static_cast<size_t>(GPUTextureFormat::Rg8unorm) == 7, "GPUTextureFormat::Rg8unorm is not 7 as expected");
    static_assert(static_cast<size_t>(GPUTextureFormat::Rg8snorm) == 8, "GPUTextureFormat::Rg8snorm is not 8 as expected");
    static_assert(static_cast<size_t>(GPUTextureFormat::Rg8uint) == 9, "GPUTextureFormat::Rg8uint is not 9 as expected");
    static_assert(static_cast<size_t>(GPUTextureFormat::Rg8sint) == 10, "GPUTextureFormat::Rg8sint is not 10 as expected");
    static_assert(static_cast<size_t>(GPUTextureFormat::R32uint) == 11, "GPUTextureFormat::R32uint is not 11 as expected");
    static_assert(static_cast<size_t>(GPUTextureFormat::R32sint) == 12, "GPUTextureFormat::R32sint is not 12 as expected");
    static_assert(static_cast<size_t>(GPUTextureFormat::R32float) == 13, "GPUTextureFormat::R32float is not 13 as expected");
    static_assert(static_cast<size_t>(GPUTextureFormat::Rg16uint) == 14, "GPUTextureFormat::Rg16uint is not 14 as expected");
    static_assert(static_cast<size_t>(GPUTextureFormat::Rg16sint) == 15, "GPUTextureFormat::Rg16sint is not 15 as expected");
    static_assert(static_cast<size_t>(GPUTextureFormat::Rg16float) == 16, "GPUTextureFormat::Rg16float is not 16 as expected");
    static_assert(static_cast<size_t>(GPUTextureFormat::Rgba8unorm) == 17, "GPUTextureFormat::Rgba8unorm is not 17 as expected");
    static_assert(static_cast<size_t>(GPUTextureFormat::Rgba8unormSRGB) == 18, "GPUTextureFormat::Rgba8unormSRGB is not 18 as expected");
    static_assert(static_cast<size_t>(GPUTextureFormat::Rgba8snorm) == 19, "GPUTextureFormat::Rgba8snorm is not 19 as expected");
    static_assert(static_cast<size_t>(GPUTextureFormat::Rgba8uint) == 20, "GPUTextureFormat::Rgba8uint is not 20 as expected");
    static_assert(static_cast<size_t>(GPUTextureFormat::Rgba8sint) == 21, "GPUTextureFormat::Rgba8sint is not 21 as expected");
    static_assert(static_cast<size_t>(GPUTextureFormat::Bgra8unorm) == 22, "GPUTextureFormat::Bgra8unorm is not 22 as expected");
    static_assert(static_cast<size_t>(GPUTextureFormat::Bgra8unormSRGB) == 23, "GPUTextureFormat::Bgra8unormSRGB is not 23 as expected");
    static_assert(static_cast<size_t>(GPUTextureFormat::Rgb9e5ufloat) == 24, "GPUTextureFormat::Rgb9e5ufloat is not 24 as expected");
    static_assert(static_cast<size_t>(GPUTextureFormat::Rgb10a2uint) == 25, "GPUTextureFormat::Rgb10a2uint is not 25 as expected");
    static_assert(static_cast<size_t>(GPUTextureFormat::Rgb10a2unorm) == 26, "GPUTextureFormat::Rgb10a2unorm is not 26 as expected");
    static_assert(static_cast<size_t>(GPUTextureFormat::Rg11b10ufloat) == 27, "GPUTextureFormat::Rg11b10ufloat is not 27 as expected");
    static_assert(static_cast<size_t>(GPUTextureFormat::Rg32uint) == 28, "GPUTextureFormat::Rg32uint is not 28 as expected");
    static_assert(static_cast<size_t>(GPUTextureFormat::Rg32sint) == 29, "GPUTextureFormat::Rg32sint is not 29 as expected");
    static_assert(static_cast<size_t>(GPUTextureFormat::Rg32float) == 30, "GPUTextureFormat::Rg32float is not 30 as expected");
    static_assert(static_cast<size_t>(GPUTextureFormat::Rgba16uint) == 31, "GPUTextureFormat::Rgba16uint is not 31 as expected");
    static_assert(static_cast<size_t>(GPUTextureFormat::Rgba16sint) == 32, "GPUTextureFormat::Rgba16sint is not 32 as expected");
    static_assert(static_cast<size_t>(GPUTextureFormat::Rgba16float) == 33, "GPUTextureFormat::Rgba16float is not 33 as expected");
    static_assert(static_cast<size_t>(GPUTextureFormat::Rgba32uint) == 34, "GPUTextureFormat::Rgba32uint is not 34 as expected");
    static_assert(static_cast<size_t>(GPUTextureFormat::Rgba32sint) == 35, "GPUTextureFormat::Rgba32sint is not 35 as expected");
    static_assert(static_cast<size_t>(GPUTextureFormat::Rgba32float) == 36, "GPUTextureFormat::Rgba32float is not 36 as expected");
    static_assert(static_cast<size_t>(GPUTextureFormat::Stencil8) == 37, "GPUTextureFormat::Stencil8 is not 37 as expected");
    static_assert(static_cast<size_t>(GPUTextureFormat::Depth16unorm) == 38, "GPUTextureFormat::Depth16unorm is not 38 as expected");
    static_assert(static_cast<size_t>(GPUTextureFormat::Depth24plus) == 39, "GPUTextureFormat::Depth24plus is not 39 as expected");
    static_assert(static_cast<size_t>(GPUTextureFormat::Depth24plusStencil8) == 40, "GPUTextureFormat::Depth24plusStencil8 is not 40 as expected");
    static_assert(static_cast<size_t>(GPUTextureFormat::Depth32float) == 41, "GPUTextureFormat::Depth32float is not 41 as expected");
    static_assert(static_cast<size_t>(GPUTextureFormat::Depth32floatStencil8) == 42, "GPUTextureFormat::Depth32floatStencil8 is not 42 as expected");
    static_assert(static_cast<size_t>(GPUTextureFormat::Bc1RgbaUnorm) == 43, "GPUTextureFormat::Bc1RgbaUnorm is not 43 as expected");
    static_assert(static_cast<size_t>(GPUTextureFormat::Bc1RgbaUnormSRGB) == 44, "GPUTextureFormat::Bc1RgbaUnormSRGB is not 44 as expected");
    static_assert(static_cast<size_t>(GPUTextureFormat::Bc2RgbaUnorm) == 45, "GPUTextureFormat::Bc2RgbaUnorm is not 45 as expected");
    static_assert(static_cast<size_t>(GPUTextureFormat::Bc2RgbaUnormSRGB) == 46, "GPUTextureFormat::Bc2RgbaUnormSRGB is not 46 as expected");
    static_assert(static_cast<size_t>(GPUTextureFormat::Bc3RgbaUnorm) == 47, "GPUTextureFormat::Bc3RgbaUnorm is not 47 as expected");
    static_assert(static_cast<size_t>(GPUTextureFormat::Bc3RgbaUnormSRGB) == 48, "GPUTextureFormat::Bc3RgbaUnormSRGB is not 48 as expected");
    static_assert(static_cast<size_t>(GPUTextureFormat::Bc4RUnorm) == 49, "GPUTextureFormat::Bc4RUnorm is not 49 as expected");
    static_assert(static_cast<size_t>(GPUTextureFormat::Bc4RSnorm) == 50, "GPUTextureFormat::Bc4RSnorm is not 50 as expected");
    static_assert(static_cast<size_t>(GPUTextureFormat::Bc5RgUnorm) == 51, "GPUTextureFormat::Bc5RgUnorm is not 51 as expected");
    static_assert(static_cast<size_t>(GPUTextureFormat::Bc5RgSnorm) == 52, "GPUTextureFormat::Bc5RgSnorm is not 52 as expected");
    static_assert(static_cast<size_t>(GPUTextureFormat::Bc6hRgbUfloat) == 53, "GPUTextureFormat::Bc6hRgbUfloat is not 53 as expected");
    static_assert(static_cast<size_t>(GPUTextureFormat::Bc6hRgbFloat) == 54, "GPUTextureFormat::Bc6hRgbFloat is not 54 as expected");
    static_assert(static_cast<size_t>(GPUTextureFormat::Bc7RgbaUnorm) == 55, "GPUTextureFormat::Bc7RgbaUnorm is not 55 as expected");
    static_assert(static_cast<size_t>(GPUTextureFormat::Bc7RgbaUnormSRGB) == 56, "GPUTextureFormat::Bc7RgbaUnormSRGB is not 56 as expected");
    static_assert(static_cast<size_t>(GPUTextureFormat::Etc2Rgb8unorm) == 57, "GPUTextureFormat::Etc2Rgb8unorm is not 57 as expected");
    static_assert(static_cast<size_t>(GPUTextureFormat::Etc2Rgb8unormSRGB) == 58, "GPUTextureFormat::Etc2Rgb8unormSRGB is not 58 as expected");
    static_assert(static_cast<size_t>(GPUTextureFormat::Etc2Rgb8a1unorm) == 59, "GPUTextureFormat::Etc2Rgb8a1unorm is not 59 as expected");
    static_assert(static_cast<size_t>(GPUTextureFormat::Etc2Rgb8a1unormSRGB) == 60, "GPUTextureFormat::Etc2Rgb8a1unormSRGB is not 60 as expected");
    static_assert(static_cast<size_t>(GPUTextureFormat::Etc2Rgba8unorm) == 61, "GPUTextureFormat::Etc2Rgba8unorm is not 61 as expected");
    static_assert(static_cast<size_t>(GPUTextureFormat::Etc2Rgba8unormSRGB) == 62, "GPUTextureFormat::Etc2Rgba8unormSRGB is not 62 as expected");
    static_assert(static_cast<size_t>(GPUTextureFormat::EacR11unorm) == 63, "GPUTextureFormat::EacR11unorm is not 63 as expected");
    static_assert(static_cast<size_t>(GPUTextureFormat::EacR11snorm) == 64, "GPUTextureFormat::EacR11snorm is not 64 as expected");
    static_assert(static_cast<size_t>(GPUTextureFormat::EacRg11unorm) == 65, "GPUTextureFormat::EacRg11unorm is not 65 as expected");
    static_assert(static_cast<size_t>(GPUTextureFormat::EacRg11snorm) == 66, "GPUTextureFormat::EacRg11snorm is not 66 as expected");
    static_assert(static_cast<size_t>(GPUTextureFormat::Astc4x4Unorm) == 67, "GPUTextureFormat::Astc4x4Unorm is not 67 as expected");
    static_assert(static_cast<size_t>(GPUTextureFormat::Astc4x4UnormSRGB) == 68, "GPUTextureFormat::Astc4x4UnormSRGB is not 68 as expected");
    static_assert(static_cast<size_t>(GPUTextureFormat::Astc5x4Unorm) == 69, "GPUTextureFormat::Astc5x4Unorm is not 69 as expected");
    static_assert(static_cast<size_t>(GPUTextureFormat::Astc5x4UnormSRGB) == 70, "GPUTextureFormat::Astc5x4UnormSRGB is not 70 as expected");
    static_assert(static_cast<size_t>(GPUTextureFormat::Astc5x5Unorm) == 71, "GPUTextureFormat::Astc5x5Unorm is not 71 as expected");
    static_assert(static_cast<size_t>(GPUTextureFormat::Astc5x5UnormSRGB) == 72, "GPUTextureFormat::Astc5x5UnormSRGB is not 72 as expected");
    static_assert(static_cast<size_t>(GPUTextureFormat::Astc6x5Unorm) == 73, "GPUTextureFormat::Astc6x5Unorm is not 73 as expected");
    static_assert(static_cast<size_t>(GPUTextureFormat::Astc6x5UnormSRGB) == 74, "GPUTextureFormat::Astc6x5UnormSRGB is not 74 as expected");
    static_assert(static_cast<size_t>(GPUTextureFormat::Astc6x6Unorm) == 75, "GPUTextureFormat::Astc6x6Unorm is not 75 as expected");
    static_assert(static_cast<size_t>(GPUTextureFormat::Astc6x6UnormSRGB) == 76, "GPUTextureFormat::Astc6x6UnormSRGB is not 76 as expected");
    static_assert(static_cast<size_t>(GPUTextureFormat::Astc8x5Unorm) == 77, "GPUTextureFormat::Astc8x5Unorm is not 77 as expected");
    static_assert(static_cast<size_t>(GPUTextureFormat::Astc8x5UnormSRGB) == 78, "GPUTextureFormat::Astc8x5UnormSRGB is not 78 as expected");
    static_assert(static_cast<size_t>(GPUTextureFormat::Astc8x6Unorm) == 79, "GPUTextureFormat::Astc8x6Unorm is not 79 as expected");
    static_assert(static_cast<size_t>(GPUTextureFormat::Astc8x6UnormSRGB) == 80, "GPUTextureFormat::Astc8x6UnormSRGB is not 80 as expected");
    static_assert(static_cast<size_t>(GPUTextureFormat::Astc8x8Unorm) == 81, "GPUTextureFormat::Astc8x8Unorm is not 81 as expected");
    static_assert(static_cast<size_t>(GPUTextureFormat::Astc8x8UnormSRGB) == 82, "GPUTextureFormat::Astc8x8UnormSRGB is not 82 as expected");
    static_assert(static_cast<size_t>(GPUTextureFormat::Astc10x5Unorm) == 83, "GPUTextureFormat::Astc10x5Unorm is not 83 as expected");
    static_assert(static_cast<size_t>(GPUTextureFormat::Astc10x5UnormSRGB) == 84, "GPUTextureFormat::Astc10x5UnormSRGB is not 84 as expected");
    static_assert(static_cast<size_t>(GPUTextureFormat::Astc10x6Unorm) == 85, "GPUTextureFormat::Astc10x6Unorm is not 85 as expected");
    static_assert(static_cast<size_t>(GPUTextureFormat::Astc10x6UnormSRGB) == 86, "GPUTextureFormat::Astc10x6UnormSRGB is not 86 as expected");
    static_assert(static_cast<size_t>(GPUTextureFormat::Astc10x8Unorm) == 87, "GPUTextureFormat::Astc10x8Unorm is not 87 as expected");
    static_assert(static_cast<size_t>(GPUTextureFormat::Astc10x8UnormSRGB) == 88, "GPUTextureFormat::Astc10x8UnormSRGB is not 88 as expected");
    static_assert(static_cast<size_t>(GPUTextureFormat::Astc10x10Unorm) == 89, "GPUTextureFormat::Astc10x10Unorm is not 89 as expected");
    static_assert(static_cast<size_t>(GPUTextureFormat::Astc10x10UnormSRGB) == 90, "GPUTextureFormat::Astc10x10UnormSRGB is not 90 as expected");
    static_assert(static_cast<size_t>(GPUTextureFormat::Astc12x10Unorm) == 91, "GPUTextureFormat::Astc12x10Unorm is not 91 as expected");
    static_assert(static_cast<size_t>(GPUTextureFormat::Astc12x10UnormSRGB) == 92, "GPUTextureFormat::Astc12x10UnormSRGB is not 92 as expected");
    static_assert(static_cast<size_t>(GPUTextureFormat::Astc12x12Unorm) == 93, "GPUTextureFormat::Astc12x12Unorm is not 93 as expected");
    static_assert(static_cast<size_t>(GPUTextureFormat::Astc12x12UnormSRGB) == 94, "GPUTextureFormat::Astc12x12UnormSRGB is not 94 as expected");
    ASSERT(static_cast<size_t>(enumerationValue) < std::size(values));
    return values[static_cast<size_t>(enumerationValue)];
}

template<> JSString* convertEnumerationToJS(VM& vm, GPUTextureFormat enumerationValue)
{
    return jsStringWithCache(vm, convertEnumerationToString(enumerationValue));
}

template<> std::optional<GPUTextureFormat> parseEnumerationFromString<GPUTextureFormat>(const String& stringValue)
{
    static constexpr std::pair<ComparableASCIILiteral, GPUTextureFormat> mappings[] = {
        { "astc-10x10-unorm", GPUTextureFormat::Astc10x10Unorm },
        { "astc-10x10-unorm-srgb", GPUTextureFormat::Astc10x10UnormSRGB },
        { "astc-10x5-unorm", GPUTextureFormat::Astc10x5Unorm },
        { "astc-10x5-unorm-srgb", GPUTextureFormat::Astc10x5UnormSRGB },
        { "astc-10x6-unorm", GPUTextureFormat::Astc10x6Unorm },
        { "astc-10x6-unorm-srgb", GPUTextureFormat::Astc10x6UnormSRGB },
        { "astc-10x8-unorm", GPUTextureFormat::Astc10x8Unorm },
        { "astc-10x8-unorm-srgb", GPUTextureFormat::Astc10x8UnormSRGB },
        { "astc-12x10-unorm", GPUTextureFormat::Astc12x10Unorm },
        { "astc-12x10-unorm-srgb", GPUTextureFormat::Astc12x10UnormSRGB },
        { "astc-12x12-unorm", GPUTextureFormat::Astc12x12Unorm },
        { "astc-12x12-unorm-srgb", GPUTextureFormat::Astc12x12UnormSRGB },
        { "astc-4x4-unorm", GPUTextureFormat::Astc4x4Unorm },
        { "astc-4x4-unorm-srgb", GPUTextureFormat::Astc4x4UnormSRGB },
        { "astc-5x4-unorm", GPUTextureFormat::Astc5x4Unorm },
        { "astc-5x4-unorm-srgb", GPUTextureFormat::Astc5x4UnormSRGB },
        { "astc-5x5-unorm", GPUTextureFormat::Astc5x5Unorm },
        { "astc-5x5-unorm-srgb", GPUTextureFormat::Astc5x5UnormSRGB },
        { "astc-6x5-unorm", GPUTextureFormat::Astc6x5Unorm },
        { "astc-6x5-unorm-srgb", GPUTextureFormat::Astc6x5UnormSRGB },
        { "astc-6x6-unorm", GPUTextureFormat::Astc6x6Unorm },
        { "astc-6x6-unorm-srgb", GPUTextureFormat::Astc6x6UnormSRGB },
        { "astc-8x5-unorm", GPUTextureFormat::Astc8x5Unorm },
        { "astc-8x5-unorm-srgb", GPUTextureFormat::Astc8x5UnormSRGB },
        { "astc-8x6-unorm", GPUTextureFormat::Astc8x6Unorm },
        { "astc-8x6-unorm-srgb", GPUTextureFormat::Astc8x6UnormSRGB },
        { "astc-8x8-unorm", GPUTextureFormat::Astc8x8Unorm },
        { "astc-8x8-unorm-srgb", GPUTextureFormat::Astc8x8UnormSRGB },
        { "bc1-rgba-unorm", GPUTextureFormat::Bc1RgbaUnorm },
        { "bc1-rgba-unorm-srgb", GPUTextureFormat::Bc1RgbaUnormSRGB },
        { "bc2-rgba-unorm", GPUTextureFormat::Bc2RgbaUnorm },
        { "bc2-rgba-unorm-srgb", GPUTextureFormat::Bc2RgbaUnormSRGB },
        { "bc3-rgba-unorm", GPUTextureFormat::Bc3RgbaUnorm },
        { "bc3-rgba-unorm-srgb", GPUTextureFormat::Bc3RgbaUnormSRGB },
        { "bc4-r-snorm", GPUTextureFormat::Bc4RSnorm },
        { "bc4-r-unorm", GPUTextureFormat::Bc4RUnorm },
        { "bc5-rg-snorm", GPUTextureFormat::Bc5RgSnorm },
        { "bc5-rg-unorm", GPUTextureFormat::Bc5RgUnorm },
        { "bc6h-rgb-float", GPUTextureFormat::Bc6hRgbFloat },
        { "bc6h-rgb-ufloat", GPUTextureFormat::Bc6hRgbUfloat },
        { "bc7-rgba-unorm", GPUTextureFormat::Bc7RgbaUnorm },
        { "bc7-rgba-unorm-srgb", GPUTextureFormat::Bc7RgbaUnormSRGB },
        { "bgra8unorm", GPUTextureFormat::Bgra8unorm },
        { "bgra8unorm-srgb", GPUTextureFormat::Bgra8unormSRGB },
        { "depth16unorm", GPUTextureFormat::Depth16unorm },
        { "depth24plus", GPUTextureFormat::Depth24plus },
        { "depth24plus-stencil8", GPUTextureFormat::Depth24plusStencil8 },
        { "depth32float", GPUTextureFormat::Depth32float },
        { "depth32float-stencil8", GPUTextureFormat::Depth32floatStencil8 },
        { "eac-r11snorm", GPUTextureFormat::EacR11snorm },
        { "eac-r11unorm", GPUTextureFormat::EacR11unorm },
        { "eac-rg11snorm", GPUTextureFormat::EacRg11snorm },
        { "eac-rg11unorm", GPUTextureFormat::EacRg11unorm },
        { "etc2-rgb8a1unorm", GPUTextureFormat::Etc2Rgb8a1unorm },
        { "etc2-rgb8a1unorm-srgb", GPUTextureFormat::Etc2Rgb8a1unormSRGB },
        { "etc2-rgb8unorm", GPUTextureFormat::Etc2Rgb8unorm },
        { "etc2-rgb8unorm-srgb", GPUTextureFormat::Etc2Rgb8unormSRGB },
        { "etc2-rgba8unorm", GPUTextureFormat::Etc2Rgba8unorm },
        { "etc2-rgba8unorm-srgb", GPUTextureFormat::Etc2Rgba8unormSRGB },
        { "r16float", GPUTextureFormat::R16float },
        { "r16sint", GPUTextureFormat::R16sint },
        { "r16uint", GPUTextureFormat::R16uint },
        { "r32float", GPUTextureFormat::R32float },
        { "r32sint", GPUTextureFormat::R32sint },
        { "r32uint", GPUTextureFormat::R32uint },
        { "r8sint", GPUTextureFormat::R8sint },
        { "r8snorm", GPUTextureFormat::R8snorm },
        { "r8uint", GPUTextureFormat::R8uint },
        { "r8unorm", GPUTextureFormat::R8unorm },
        { "rg11b10ufloat", GPUTextureFormat::Rg11b10ufloat },
        { "rg16float", GPUTextureFormat::Rg16float },
        { "rg16sint", GPUTextureFormat::Rg16sint },
        { "rg16uint", GPUTextureFormat::Rg16uint },
        { "rg32float", GPUTextureFormat::Rg32float },
        { "rg32sint", GPUTextureFormat::Rg32sint },
        { "rg32uint", GPUTextureFormat::Rg32uint },
        { "rg8sint", GPUTextureFormat::Rg8sint },
        { "rg8snorm", GPUTextureFormat::Rg8snorm },
        { "rg8uint", GPUTextureFormat::Rg8uint },
        { "rg8unorm", GPUTextureFormat::Rg8unorm },
        { "rgb10a2uint", GPUTextureFormat::Rgb10a2uint },
        { "rgb10a2unorm", GPUTextureFormat::Rgb10a2unorm },
        { "rgb9e5ufloat", GPUTextureFormat::Rgb9e5ufloat },
        { "rgba16float", GPUTextureFormat::Rgba16float },
        { "rgba16sint", GPUTextureFormat::Rgba16sint },
        { "rgba16uint", GPUTextureFormat::Rgba16uint },
        { "rgba32float", GPUTextureFormat::Rgba32float },
        { "rgba32sint", GPUTextureFormat::Rgba32sint },
        { "rgba32uint", GPUTextureFormat::Rgba32uint },
        { "rgba8sint", GPUTextureFormat::Rgba8sint },
        { "rgba8snorm", GPUTextureFormat::Rgba8snorm },
        { "rgba8uint", GPUTextureFormat::Rgba8uint },
        { "rgba8unorm", GPUTextureFormat::Rgba8unorm },
        { "rgba8unorm-srgb", GPUTextureFormat::Rgba8unormSRGB },
        { "stencil8", GPUTextureFormat::Stencil8 },
    };
    static constexpr SortedArrayMap enumerationMapping { mappings };
    if (auto* enumerationValue = enumerationMapping.tryGet(stringValue); LIKELY(enumerationValue))
        return *enumerationValue;
    return std::nullopt;
}

template<> std::optional<GPUTextureFormat> parseEnumeration<GPUTextureFormat>(JSGlobalObject& lexicalGlobalObject, JSValue value)
{
    return parseEnumerationFromString<GPUTextureFormat>(value.toWTFString(&lexicalGlobalObject));
}

template<> ASCIILiteral expectedEnumerationValues<GPUTextureFormat>()
{
    return "\"r8unorm\", \"r8snorm\", \"r8uint\", \"r8sint\", \"r16uint\", \"r16sint\", \"r16float\", \"rg8unorm\", \"rg8snorm\", \"rg8uint\", \"rg8sint\", \"r32uint\", \"r32sint\", \"r32float\", \"rg16uint\", \"rg16sint\", \"rg16float\", \"rgba8unorm\", \"rgba8unorm-srgb\", \"rgba8snorm\", \"rgba8uint\", \"rgba8sint\", \"bgra8unorm\", \"bgra8unorm-srgb\", \"rgb9e5ufloat\", \"rgb10a2uint\", \"rgb10a2unorm\", \"rg11b10ufloat\", \"rg32uint\", \"rg32sint\", \"rg32float\", \"rgba16uint\", \"rgba16sint\", \"rgba16float\", \"rgba32uint\", \"rgba32sint\", \"rgba32float\", \"stencil8\", \"depth16unorm\", \"depth24plus\", \"depth24plus-stencil8\", \"depth32float\", \"depth32float-stencil8\", \"bc1-rgba-unorm\", \"bc1-rgba-unorm-srgb\", \"bc2-rgba-unorm\", \"bc2-rgba-unorm-srgb\", \"bc3-rgba-unorm\", \"bc3-rgba-unorm-srgb\", \"bc4-r-unorm\", \"bc4-r-snorm\", \"bc5-rg-unorm\", \"bc5-rg-snorm\", \"bc6h-rgb-ufloat\", \"bc6h-rgb-float\", \"bc7-rgba-unorm\", \"bc7-rgba-unorm-srgb\", \"etc2-rgb8unorm\", \"etc2-rgb8unorm-srgb\", \"etc2-rgb8a1unorm\", \"etc2-rgb8a1unorm-srgb\", \"etc2-rgba8unorm\", \"etc2-rgba8unorm-srgb\", \"eac-r11unorm\", \"eac-r11snorm\", \"eac-rg11unorm\", \"eac-rg11snorm\", \"astc-4x4-unorm\", \"astc-4x4-unorm-srgb\", \"astc-5x4-unorm\", \"astc-5x4-unorm-srgb\", \"astc-5x5-unorm\", \"astc-5x5-unorm-srgb\", \"astc-6x5-unorm\", \"astc-6x5-unorm-srgb\", \"astc-6x6-unorm\", \"astc-6x6-unorm-srgb\", \"astc-8x5-unorm\", \"astc-8x5-unorm-srgb\", \"astc-8x6-unorm\", \"astc-8x6-unorm-srgb\", \"astc-8x8-unorm\", \"astc-8x8-unorm-srgb\", \"astc-10x5-unorm\", \"astc-10x5-unorm-srgb\", \"astc-10x6-unorm\", \"astc-10x6-unorm-srgb\", \"astc-10x8-unorm\", \"astc-10x8-unorm-srgb\", \"astc-10x10-unorm\", \"astc-10x10-unorm-srgb\", \"astc-12x10-unorm\", \"astc-12x10-unorm-srgb\", \"astc-12x12-unorm\", \"astc-12x12-unorm-srgb\""_s;
}

} // namespace WebCore
