/*
    This file is part of the WebKit open source project.
    This file has been generated by generate-bindings.pl. DO NOT MODIFY!

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public License
    along with this library; see the file COPYING.LIB.  If not, write to
    the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
    Boston, MA 02110-1301, USA.
*/

#include "config.h"
#include "JSGPUCanvasConfiguration.h"

#include "JSDOMConvertEnumeration.h"
#include "JSDOMConvertInterface.h"
#include "JSDOMConvertNumbers.h"
#include "JSDOMConvertOptional.h"
#include "JSDOMConvertSequences.h"
#include "JSGPUCanvasAlphaMode.h"
#include "JSGPUDevice.h"
#include "JSGPUPredefinedColorSpace.h"
#include "JSGPUTextureFormat.h"
#include <JavaScriptCore/JSArray.h>
#include <JavaScriptCore/JSCInlines.h>


namespace WebCore {
using namespace JSC;

template<> ConversionResult<IDLDictionary<GPUCanvasConfiguration>> convertDictionary<GPUCanvasConfiguration>(JSGlobalObject& lexicalGlobalObject, JSValue value)
{
    auto& vm = JSC::getVM(&lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    bool isNullOrUndefined = value.isUndefinedOrNull();
    auto* object = isNullOrUndefined ? nullptr : value.getObject();
    if (UNLIKELY(!isNullOrUndefined && !object)) {
        throwTypeError(&lexicalGlobalObject, throwScope);
        return ConversionResultException { };
    }
    GPUCanvasConfiguration result;
    JSValue alphaModeValue;
    if (isNullOrUndefined)
        alphaModeValue = jsUndefined();
    else {
        alphaModeValue = object->get(&lexicalGlobalObject, Identifier::fromString(vm, "alphaMode"_s));
        RETURN_IF_EXCEPTION(throwScope, ConversionResultException { });
    }
    auto alphaModeConversionResult = convertOptionalWithDefault<IDLEnumeration<GPUCanvasAlphaMode>>(lexicalGlobalObject, alphaModeValue, [&]() -> ConversionResult<IDLEnumeration<GPUCanvasAlphaMode>> { return Converter<IDLEnumeration<GPUCanvasAlphaMode>>::ReturnType { GPUCanvasAlphaMode::Opaque }; });
    if (UNLIKELY(alphaModeConversionResult.hasException(throwScope)))
        return ConversionResultException { };
    result.alphaMode = alphaModeConversionResult.releaseReturnValue();
    JSValue colorSpaceValue;
    if (isNullOrUndefined)
        colorSpaceValue = jsUndefined();
    else {
        colorSpaceValue = object->get(&lexicalGlobalObject, Identifier::fromString(vm, "colorSpace"_s));
        RETURN_IF_EXCEPTION(throwScope, ConversionResultException { });
    }
    auto colorSpaceConversionResult = convertOptionalWithDefault<IDLEnumeration<GPUPredefinedColorSpace>>(lexicalGlobalObject, colorSpaceValue, [&]() -> ConversionResult<IDLEnumeration<GPUPredefinedColorSpace>> { return Converter<IDLEnumeration<GPUPredefinedColorSpace>>::ReturnType { GPUPredefinedColorSpace::SRGB }; });
    if (UNLIKELY(colorSpaceConversionResult.hasException(throwScope)))
        return ConversionResultException { };
    result.colorSpace = colorSpaceConversionResult.releaseReturnValue();
    JSValue deviceValue;
    if (isNullOrUndefined)
        deviceValue = jsUndefined();
    else {
        deviceValue = object->get(&lexicalGlobalObject, Identifier::fromString(vm, "device"_s));
        RETURN_IF_EXCEPTION(throwScope, ConversionResultException { });
    }
    if (deviceValue.isUndefined()) {
        throwRequiredMemberTypeError(lexicalGlobalObject, throwScope, "device"_s, "GPUCanvasConfiguration"_s, "GPUDevice"_s);
        return ConversionResultException { };
    }
    auto deviceConversionResult = convert<IDLInterface<GPUDevice>>(lexicalGlobalObject, deviceValue);
    if (UNLIKELY(deviceConversionResult.hasException(throwScope)))
        return ConversionResultException { };
    result.device = deviceConversionResult.releaseReturnValue();
    JSValue formatValue;
    if (isNullOrUndefined)
        formatValue = jsUndefined();
    else {
        formatValue = object->get(&lexicalGlobalObject, Identifier::fromString(vm, "format"_s));
        RETURN_IF_EXCEPTION(throwScope, ConversionResultException { });
    }
    if (formatValue.isUndefined()) {
        throwRequiredMemberTypeError(lexicalGlobalObject, throwScope, "format"_s, "GPUCanvasConfiguration"_s, "GPUTextureFormat"_s);
        return ConversionResultException { };
    }
    auto formatConversionResult = convert<IDLEnumeration<GPUTextureFormat>>(lexicalGlobalObject, formatValue);
    if (UNLIKELY(formatConversionResult.hasException(throwScope)))
        return ConversionResultException { };
    result.format = formatConversionResult.releaseReturnValue();
    JSValue usageValue;
    if (isNullOrUndefined)
        usageValue = jsUndefined();
    else {
        usageValue = object->get(&lexicalGlobalObject, Identifier::fromString(vm, "usage"_s));
        RETURN_IF_EXCEPTION(throwScope, ConversionResultException { });
    }
    auto usageConversionResult = convertOptionalWithDefault<IDLEnforceRangeAdaptor<IDLUnsignedLong>>(lexicalGlobalObject, usageValue, [&]() -> ConversionResult<IDLEnforceRangeAdaptor<IDLUnsignedLong>> { return Converter<IDLEnforceRangeAdaptor<IDLUnsignedLong>>::ReturnType { 0x10 }; });
    if (UNLIKELY(usageConversionResult.hasException(throwScope)))
        return ConversionResultException { };
    result.usage = usageConversionResult.releaseReturnValue();
    JSValue viewFormatsValue;
    if (isNullOrUndefined)
        viewFormatsValue = jsUndefined();
    else {
        viewFormatsValue = object->get(&lexicalGlobalObject, Identifier::fromString(vm, "viewFormats"_s));
        RETURN_IF_EXCEPTION(throwScope, ConversionResultException { });
    }
    auto viewFormatsConversionResult = convertOptionalWithDefault<IDLSequence<IDLEnumeration<GPUTextureFormat>>>(lexicalGlobalObject, viewFormatsValue, [&]() -> ConversionResult<IDLSequence<IDLEnumeration<GPUTextureFormat>>> { return Converter<IDLSequence<IDLEnumeration<GPUTextureFormat>>>::ReturnType { }; });
    if (UNLIKELY(viewFormatsConversionResult.hasException(throwScope)))
        return ConversionResultException { };
    result.viewFormats = viewFormatsConversionResult.releaseReturnValue();
    return result;
}

} // namespace WebCore
