/*
    This file is part of the WebKit open source project.
    This file has been generated by generate-bindings.pl. DO NOT MODIFY!

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public License
    along with this library; see the file COPYING.LIB.  If not, write to
    the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
    Boston, MA 02110-1301, USA.
*/

#include "config.h"
#include "JSFocusEvent.h"

#include "ActiveDOMObject.h"
#include "ExtendedDOMClientIsoSubspaces.h"
#include "ExtendedDOMIsoSubspaces.h"
#include "JSDOMAttribute.h"
#include "JSDOMBinding.h"
#include "JSDOMConstructor.h"
#include "JSDOMConvertBoolean.h"
#include "JSDOMConvertInterface.h"
#include "JSDOMConvertNullable.h"
#include "JSDOMConvertNumbers.h"
#include "JSDOMConvertOptional.h"
#include "JSDOMConvertStrings.h"
#include "JSDOMExceptionHandling.h"
#include "JSDOMGlobalObject.h"
#include "JSDOMGlobalObjectInlines.h"
#include "JSDOMWrapperCache.h"
#include "JSEventTarget.h"
#include "JSWindowProxy.h"
#include "ScriptExecutionContext.h"
#include "WebCoreJSClientData.h"
#include <JavaScriptCore/HeapAnalyzer.h>
#include <JavaScriptCore/JSCInlines.h>
#include <JavaScriptCore/JSDestructibleObjectHeapCellType.h>
#include <JavaScriptCore/SlotVisitorMacros.h>
#include <JavaScriptCore/SubspaceInlines.h>
#include <wtf/GetPtr.h>
#include <wtf/PointerPreparations.h>
#include <wtf/URL.h>
#include <wtf/text/MakeString.h>


namespace WebCore {
using namespace JSC;

template<> ConversionResult<IDLDictionary<FocusEvent::Init>> convertDictionary<FocusEvent::Init>(JSGlobalObject& lexicalGlobalObject, JSValue value)
{
    auto& vm = JSC::getVM(&lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    bool isNullOrUndefined = value.isUndefinedOrNull();
    auto* object = isNullOrUndefined ? nullptr : value.getObject();
    if (UNLIKELY(!isNullOrUndefined && !object)) {
        throwTypeError(&lexicalGlobalObject, throwScope);
        return ConversionResultException { };
    }
    FocusEvent::Init result;
    JSValue bubblesValue;
    if (isNullOrUndefined)
        bubblesValue = jsUndefined();
    else {
        bubblesValue = object->get(&lexicalGlobalObject, Identifier::fromString(vm, "bubbles"_s));
        RETURN_IF_EXCEPTION(throwScope, ConversionResultException { });
    }
    auto bubblesConversionResult = convertOptionalWithDefault<IDLBoolean>(lexicalGlobalObject, bubblesValue, [&]() -> ConversionResult<IDLBoolean> { return Converter<IDLBoolean>::ReturnType { false }; });
    if (UNLIKELY(bubblesConversionResult.hasException(throwScope)))
        return ConversionResultException { };
    result.bubbles = bubblesConversionResult.releaseReturnValue();
    JSValue cancelableValue;
    if (isNullOrUndefined)
        cancelableValue = jsUndefined();
    else {
        cancelableValue = object->get(&lexicalGlobalObject, Identifier::fromString(vm, "cancelable"_s));
        RETURN_IF_EXCEPTION(throwScope, ConversionResultException { });
    }
    auto cancelableConversionResult = convertOptionalWithDefault<IDLBoolean>(lexicalGlobalObject, cancelableValue, [&]() -> ConversionResult<IDLBoolean> { return Converter<IDLBoolean>::ReturnType { false }; });
    if (UNLIKELY(cancelableConversionResult.hasException(throwScope)))
        return ConversionResultException { };
    result.cancelable = cancelableConversionResult.releaseReturnValue();
    JSValue composedValue;
    if (isNullOrUndefined)
        composedValue = jsUndefined();
    else {
        composedValue = object->get(&lexicalGlobalObject, Identifier::fromString(vm, "composed"_s));
        RETURN_IF_EXCEPTION(throwScope, ConversionResultException { });
    }
    auto composedConversionResult = convertOptionalWithDefault<IDLBoolean>(lexicalGlobalObject, composedValue, [&]() -> ConversionResult<IDLBoolean> { return Converter<IDLBoolean>::ReturnType { false }; });
    if (UNLIKELY(composedConversionResult.hasException(throwScope)))
        return ConversionResultException { };
    result.composed = composedConversionResult.releaseReturnValue();
    JSValue detailValue;
    if (isNullOrUndefined)
        detailValue = jsUndefined();
    else {
        detailValue = object->get(&lexicalGlobalObject, Identifier::fromString(vm, "detail"_s));
        RETURN_IF_EXCEPTION(throwScope, ConversionResultException { });
    }
    auto detailConversionResult = convertOptionalWithDefault<IDLLong>(lexicalGlobalObject, detailValue, [&]() -> ConversionResult<IDLLong> { return Converter<IDLLong>::ReturnType { 0 }; });
    if (UNLIKELY(detailConversionResult.hasException(throwScope)))
        return ConversionResultException { };
    result.detail = detailConversionResult.releaseReturnValue();
    JSValue viewValue;
    if (isNullOrUndefined)
        viewValue = jsUndefined();
    else {
        viewValue = object->get(&lexicalGlobalObject, Identifier::fromString(vm, "view"_s));
        RETURN_IF_EXCEPTION(throwScope, ConversionResultException { });
    }
    auto viewConversionResult = convertOptionalWithDefault<IDLNullable<IDLInterface<WindowProxy>>>(lexicalGlobalObject, viewValue, [&]() -> ConversionResult<IDLNullable<IDLInterface<WindowProxy>>> { return typename Converter<IDLNullable<IDLInterface<WindowProxy>>>::ReturnType { nullptr }; });
    if (UNLIKELY(viewConversionResult.hasException(throwScope)))
        return ConversionResultException { };
    result.view = viewConversionResult.releaseReturnValue();
    JSValue relatedTargetValue;
    if (isNullOrUndefined)
        relatedTargetValue = jsUndefined();
    else {
        relatedTargetValue = object->get(&lexicalGlobalObject, Identifier::fromString(vm, "relatedTarget"_s));
        RETURN_IF_EXCEPTION(throwScope, ConversionResultException { });
    }
    auto relatedTargetConversionResult = convertOptionalWithDefault<IDLNullable<IDLInterface<EventTarget>>>(lexicalGlobalObject, relatedTargetValue, [&]() -> ConversionResult<IDLNullable<IDLInterface<EventTarget>>> { return typename Converter<IDLNullable<IDLInterface<EventTarget>>>::ReturnType { nullptr }; });
    if (UNLIKELY(relatedTargetConversionResult.hasException(throwScope)))
        return ConversionResultException { };
    result.relatedTarget = relatedTargetConversionResult.releaseReturnValue();
    return result;
}

// Attributes

static JSC_DECLARE_CUSTOM_GETTER(jsFocusEventConstructor);
static JSC_DECLARE_CUSTOM_GETTER(jsFocusEvent_relatedTarget);

class JSFocusEventPrototype final : public JSC::JSNonFinalObject {
public:
    using Base = JSC::JSNonFinalObject;
    static JSFocusEventPrototype* create(JSC::VM& vm, JSDOMGlobalObject* globalObject, JSC::Structure* structure)
    {
        JSFocusEventPrototype* ptr = new (NotNull, JSC::allocateCell<JSFocusEventPrototype>(vm)) JSFocusEventPrototype(vm, globalObject, structure);
        ptr->finishCreation(vm);
        return ptr;
    }

    DECLARE_INFO;
    template<typename CellType, JSC::SubspaceAccess>
    static JSC::GCClient::IsoSubspace* subspaceFor(JSC::VM& vm)
    {
        STATIC_ASSERT_ISO_SUBSPACE_SHARABLE(JSFocusEventPrototype, Base);
        return &vm.plainObjectSpace();
    }
    static JSC::Structure* createStructure(JSC::VM& vm, JSC::JSGlobalObject* globalObject, JSC::JSValue prototype)
    {
        return JSC::Structure::create(vm, globalObject, prototype, JSC::TypeInfo(JSC::ObjectType, StructureFlags), info());
    }

private:
    JSFocusEventPrototype(JSC::VM& vm, JSC::JSGlobalObject*, JSC::Structure* structure)
        : JSC::JSNonFinalObject(vm, structure)
    {
    }

    void finishCreation(JSC::VM&);
};
STATIC_ASSERT_ISO_SUBSPACE_SHARABLE(JSFocusEventPrototype, JSFocusEventPrototype::Base);

using JSFocusEventDOMConstructor = JSDOMConstructor<JSFocusEvent>;

template<> EncodedJSValue JSC_HOST_CALL_ATTRIBUTES JSFocusEventDOMConstructor::construct(JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame)
{
    auto& vm = lexicalGlobalObject->vm();
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    auto* castedThis = jsCast<JSFocusEventDOMConstructor*>(callFrame->jsCallee());
    ASSERT(castedThis);
    if (UNLIKELY(callFrame->argumentCount() < 1))
        return throwVMError(lexicalGlobalObject, throwScope, createNotEnoughArgumentsError(lexicalGlobalObject));
    EnsureStillAliveScope argument0 = callFrame->uncheckedArgument(0);
    auto typeConversionResult = convert<IDLAtomStringAdaptor<IDLDOMString>>(*lexicalGlobalObject, argument0.value());
    if (UNLIKELY(typeConversionResult.hasException(throwScope)))
       return encodedJSValue();
    EnsureStillAliveScope argument1 = callFrame->argument(1);
    auto eventInitDictConversionResult = convert<IDLDictionary<FocusEvent::Init>>(*lexicalGlobalObject, argument1.value());
    if (UNLIKELY(eventInitDictConversionResult.hasException(throwScope)))
       return encodedJSValue();
    auto object = FocusEvent::create(typeConversionResult.releaseReturnValue(), eventInitDictConversionResult.releaseReturnValue());
    if constexpr (IsExceptionOr<decltype(object)>)
        RETURN_IF_EXCEPTION(throwScope, { });
    static_assert(TypeOrExceptionOrUnderlyingType<decltype(object)>::isRef);
    auto jsValue = toJSNewlyCreated<IDLInterface<FocusEvent>>(*lexicalGlobalObject, *castedThis->globalObject(), throwScope, WTFMove(object));
    if constexpr (IsExceptionOr<decltype(object)>)
        RETURN_IF_EXCEPTION(throwScope, { });
    setSubclassStructureIfNeeded<FocusEvent>(lexicalGlobalObject, callFrame, asObject(jsValue));
    RETURN_IF_EXCEPTION(throwScope, { });
    return JSValue::encode(jsValue);
}
JSC_ANNOTATE_HOST_FUNCTION(JSFocusEventDOMConstructorConstruct, JSFocusEventDOMConstructor::construct);

template<> const ClassInfo JSFocusEventDOMConstructor::s_info = { "FocusEvent"_s, &Base::s_info, nullptr, nullptr, CREATE_METHOD_TABLE(JSFocusEventDOMConstructor) };

template<> JSValue JSFocusEventDOMConstructor::prototypeForStructure(JSC::VM& vm, const JSDOMGlobalObject& globalObject)
{
    return JSUIEvent::getConstructor(vm, &globalObject);
}

template<> void JSFocusEventDOMConstructor::initializeProperties(VM& vm, JSDOMGlobalObject& globalObject)
{
    putDirect(vm, vm.propertyNames->length, jsNumber(1), JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::DontEnum);
    JSString* nameString = jsNontrivialString(vm, "FocusEvent"_s);
    m_originalName.set(vm, this, nameString);
    putDirect(vm, vm.propertyNames->name, nameString, JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::DontEnum);
    putDirect(vm, vm.propertyNames->prototype, JSFocusEvent::prototype(vm, globalObject), JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::DontEnum | JSC::PropertyAttribute::DontDelete);
}

/* Hash table for prototype */

static const HashTableValue JSFocusEventPrototypeTableValues[] =
{
    { "constructor"_s, static_cast<unsigned>(PropertyAttribute::DontEnum), NoIntrinsic, { HashTableValue::GetterSetterType, jsFocusEventConstructor, 0 } },
    { "relatedTarget"_s, JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsFocusEvent_relatedTarget, 0 } },
};

const ClassInfo JSFocusEventPrototype::s_info = { "FocusEvent"_s, &Base::s_info, nullptr, nullptr, CREATE_METHOD_TABLE(JSFocusEventPrototype) };

void JSFocusEventPrototype::finishCreation(VM& vm)
{
    Base::finishCreation(vm);
    reifyStaticProperties(vm, JSFocusEvent::info(), JSFocusEventPrototypeTableValues, *this);
    JSC_TO_STRING_TAG_WITHOUT_TRANSITION();
}

const ClassInfo JSFocusEvent::s_info = { "FocusEvent"_s, &Base::s_info, nullptr, nullptr, CREATE_METHOD_TABLE(JSFocusEvent) };

JSFocusEvent::JSFocusEvent(Structure* structure, JSDOMGlobalObject& globalObject, Ref<FocusEvent>&& impl)
    : JSUIEvent(structure, globalObject, WTFMove(impl))
{
}

Ref<FocusEvent> JSFocusEvent::protectedWrapped() const
{
    return wrapped();
}

static_assert(!std::is_base_of<ActiveDOMObject, FocusEvent>::value, "Interface is not marked as [ActiveDOMObject] even though implementation class subclasses ActiveDOMObject.");

JSObject* JSFocusEvent::createPrototype(VM& vm, JSDOMGlobalObject& globalObject)
{
    auto* structure = JSFocusEventPrototype::createStructure(vm, &globalObject, JSUIEvent::prototype(vm, globalObject));
    structure->setMayBePrototype(true);
    return JSFocusEventPrototype::create(vm, &globalObject, structure);
}

JSObject* JSFocusEvent::prototype(VM& vm, JSDOMGlobalObject& globalObject)
{
    return getDOMPrototype<JSFocusEvent>(vm, globalObject);
}

JSValue JSFocusEvent::getConstructor(VM& vm, const JSGlobalObject* globalObject)
{
    return getDOMConstructor<JSFocusEventDOMConstructor, DOMConstructorID::FocusEvent>(vm, *jsCast<const JSDOMGlobalObject*>(globalObject));
}

JSC_DEFINE_CUSTOM_GETTER(jsFocusEventConstructor, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName))
{
    auto& vm = JSC::getVM(lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    auto* prototype = jsDynamicCast<JSFocusEventPrototype*>(JSValue::decode(thisValue));
    if (UNLIKELY(!prototype))
        return throwVMTypeError(lexicalGlobalObject, throwScope);
    return JSValue::encode(JSFocusEvent::getConstructor(vm, prototype->globalObject()));
}

static inline JSValue jsFocusEvent_relatedTargetGetter(JSGlobalObject& lexicalGlobalObject, JSFocusEvent& thisObject)
{
    auto& vm = JSC::getVM(&lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    auto& impl = thisObject.wrapped();
    RELEASE_AND_RETURN(throwScope, (toJS<IDLNullable<IDLInterface<EventTarget>>>(lexicalGlobalObject, *thisObject.globalObject(), throwScope, impl.relatedTarget())));
}

JSC_DEFINE_CUSTOM_GETTER(jsFocusEvent_relatedTarget, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName attributeName))
{
    return IDLAttribute<JSFocusEvent>::get<jsFocusEvent_relatedTargetGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, attributeName);
}

JSC::GCClient::IsoSubspace* JSFocusEvent::subspaceForImpl(JSC::VM& vm)
{
    return WebCore::subspaceForImpl<JSFocusEvent, UseCustomHeapCellType::No>(vm,
        [] (auto& spaces) { return spaces.m_clientSubspaceForFocusEvent.get(); },
        [] (auto& spaces, auto&& space) { spaces.m_clientSubspaceForFocusEvent = std::forward<decltype(space)>(space); },
        [] (auto& spaces) { return spaces.m_subspaceForFocusEvent.get(); },
        [] (auto& spaces, auto&& space) { spaces.m_subspaceForFocusEvent = std::forward<decltype(space)>(space); }
    );
}

void JSFocusEvent::analyzeHeap(JSCell* cell, HeapAnalyzer& analyzer)
{
    auto* thisObject = jsCast<JSFocusEvent*>(cell);
    analyzer.setWrappedObjectForCell(cell, &thisObject->wrapped());
    if (thisObject->scriptExecutionContext())
        analyzer.setLabelForCell(cell, makeString("url "_s, thisObject->scriptExecutionContext()->url().string()));
    Base::analyzeHeap(cell, analyzer);
}

#if ENABLE(BINDING_INTEGRITY)
#if PLATFORM(WIN)
#pragma warning(disable: 4483)
extern "C" { extern void (*const __identifier("??_7FocusEvent@WebCore@@6B@")[])(); }
#else
extern "C" { extern void* _ZTVN7WebCore10FocusEventE[]; }
#endif
template<typename T, typename = std::enable_if_t<std::is_same_v<T, FocusEvent>, void>> static inline void verifyVTable(FocusEvent* ptr) {
    if constexpr (std::is_polymorphic_v<T>) {
        const void* actualVTablePointer = getVTablePointer<T>(ptr);
#if PLATFORM(WIN)
        void* expectedVTablePointer = __identifier("??_7FocusEvent@WebCore@@6B@");
#else
        void* expectedVTablePointer = &_ZTVN7WebCore10FocusEventE[2];
#endif

        // If you hit this assertion you either have a use after free bug, or
        // FocusEvent has subclasses. If FocusEvent has subclasses that get passed
        // to toJS() we currently require FocusEvent you to opt out of binding hardening
        // by adding the SkipVTableValidation attribute to the interface IDL definition
        RELEASE_ASSERT(actualVTablePointer == expectedVTablePointer);
    }
}
#endif
JSC::JSValue toJSNewlyCreated(JSC::JSGlobalObject*, JSDOMGlobalObject* globalObject, Ref<FocusEvent>&& impl)
{
#if ENABLE(BINDING_INTEGRITY)
    verifyVTable<FocusEvent>(impl.ptr());
#endif
    return createWrapper<FocusEvent>(globalObject, WTFMove(impl));
}

JSC::JSValue toJS(JSC::JSGlobalObject* lexicalGlobalObject, JSDOMGlobalObject* globalObject, FocusEvent& impl)
{
    return wrap(lexicalGlobalObject, globalObject, impl);
}


}
