/*
    This file is part of the WebKit open source project.
    This file has been generated by generate-bindings.pl. DO NOT MODIFY!

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public License
    along with this library; see the file COPYING.LIB.  If not, write to
    the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
    Boston, MA 02110-1301, USA.
*/

#include "config.h"

#if ENABLE(WEB_AUDIO)

#include "JSBiquadFilterOptions.h"

#include "JSBiquadFilterType.h"
#include "JSChannelCountMode.h"
#include "JSChannelInterpretation.h"
#include "JSDOMConvertEnumeration.h"
#include "JSDOMConvertNumbers.h"
#include "JSDOMConvertOptional.h"
#include <JavaScriptCore/JSCInlines.h>


namespace WebCore {
using namespace JSC;

#if ENABLE(WEB_AUDIO)

template<> ConversionResult<IDLDictionary<BiquadFilterOptions>> convertDictionary<BiquadFilterOptions>(JSGlobalObject& lexicalGlobalObject, JSValue value)
{
    auto& vm = JSC::getVM(&lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    bool isNullOrUndefined = value.isUndefinedOrNull();
    auto* object = isNullOrUndefined ? nullptr : value.getObject();
    if (UNLIKELY(!isNullOrUndefined && !object)) {
        throwTypeError(&lexicalGlobalObject, throwScope);
        return ConversionResultException { };
    }
    BiquadFilterOptions result;
    JSValue channelCountValue;
    if (isNullOrUndefined)
        channelCountValue = jsUndefined();
    else {
        channelCountValue = object->get(&lexicalGlobalObject, Identifier::fromString(vm, "channelCount"_s));
        RETURN_IF_EXCEPTION(throwScope, ConversionResultException { });
    }
    if (!channelCountValue.isUndefined()) {
        auto channelCountConversionResult = convert<IDLUnsignedLong>(lexicalGlobalObject, channelCountValue);
        if (UNLIKELY(channelCountConversionResult.hasException(throwScope)))
            return ConversionResultException { };
        result.channelCount = channelCountConversionResult.releaseReturnValue();
    }
    JSValue channelCountModeValue;
    if (isNullOrUndefined)
        channelCountModeValue = jsUndefined();
    else {
        channelCountModeValue = object->get(&lexicalGlobalObject, Identifier::fromString(vm, "channelCountMode"_s));
        RETURN_IF_EXCEPTION(throwScope, ConversionResultException { });
    }
    if (!channelCountModeValue.isUndefined()) {
        auto channelCountModeConversionResult = convert<IDLEnumeration<ChannelCountMode>>(lexicalGlobalObject, channelCountModeValue);
        if (UNLIKELY(channelCountModeConversionResult.hasException(throwScope)))
            return ConversionResultException { };
        result.channelCountMode = channelCountModeConversionResult.releaseReturnValue();
    }
    JSValue channelInterpretationValue;
    if (isNullOrUndefined)
        channelInterpretationValue = jsUndefined();
    else {
        channelInterpretationValue = object->get(&lexicalGlobalObject, Identifier::fromString(vm, "channelInterpretation"_s));
        RETURN_IF_EXCEPTION(throwScope, ConversionResultException { });
    }
    if (!channelInterpretationValue.isUndefined()) {
        auto channelInterpretationConversionResult = convert<IDLEnumeration<ChannelInterpretation>>(lexicalGlobalObject, channelInterpretationValue);
        if (UNLIKELY(channelInterpretationConversionResult.hasException(throwScope)))
            return ConversionResultException { };
        result.channelInterpretation = channelInterpretationConversionResult.releaseReturnValue();
    }
    JSValue QValue;
    if (isNullOrUndefined)
        QValue = jsUndefined();
    else {
        QValue = object->get(&lexicalGlobalObject, Identifier::fromString(vm, "Q"_s));
        RETURN_IF_EXCEPTION(throwScope, ConversionResultException { });
    }
    auto QConversionResult = convertOptionalWithDefault<IDLFloat>(lexicalGlobalObject, QValue, [&]() -> ConversionResult<IDLFloat> { return Converter<IDLFloat>::ReturnType { 1 }; });
    if (UNLIKELY(QConversionResult.hasException(throwScope)))
        return ConversionResultException { };
    result.Q = QConversionResult.releaseReturnValue();
    JSValue detuneValue;
    if (isNullOrUndefined)
        detuneValue = jsUndefined();
    else {
        detuneValue = object->get(&lexicalGlobalObject, Identifier::fromString(vm, "detune"_s));
        RETURN_IF_EXCEPTION(throwScope, ConversionResultException { });
    }
    auto detuneConversionResult = convertOptionalWithDefault<IDLFloat>(lexicalGlobalObject, detuneValue, [&]() -> ConversionResult<IDLFloat> { return Converter<IDLFloat>::ReturnType { 0 }; });
    if (UNLIKELY(detuneConversionResult.hasException(throwScope)))
        return ConversionResultException { };
    result.detune = detuneConversionResult.releaseReturnValue();
    JSValue frequencyValue;
    if (isNullOrUndefined)
        frequencyValue = jsUndefined();
    else {
        frequencyValue = object->get(&lexicalGlobalObject, Identifier::fromString(vm, "frequency"_s));
        RETURN_IF_EXCEPTION(throwScope, ConversionResultException { });
    }
    auto frequencyConversionResult = convertOptionalWithDefault<IDLFloat>(lexicalGlobalObject, frequencyValue, [&]() -> ConversionResult<IDLFloat> { return Converter<IDLFloat>::ReturnType { 350 }; });
    if (UNLIKELY(frequencyConversionResult.hasException(throwScope)))
        return ConversionResultException { };
    result.frequency = frequencyConversionResult.releaseReturnValue();
    JSValue gainValue;
    if (isNullOrUndefined)
        gainValue = jsUndefined();
    else {
        gainValue = object->get(&lexicalGlobalObject, Identifier::fromString(vm, "gain"_s));
        RETURN_IF_EXCEPTION(throwScope, ConversionResultException { });
    }
    auto gainConversionResult = convertOptionalWithDefault<IDLFloat>(lexicalGlobalObject, gainValue, [&]() -> ConversionResult<IDLFloat> { return Converter<IDLFloat>::ReturnType { 0 }; });
    if (UNLIKELY(gainConversionResult.hasException(throwScope)))
        return ConversionResultException { };
    result.gain = gainConversionResult.releaseReturnValue();
    JSValue typeValue;
    if (isNullOrUndefined)
        typeValue = jsUndefined();
    else {
        typeValue = object->get(&lexicalGlobalObject, Identifier::fromString(vm, "type"_s));
        RETURN_IF_EXCEPTION(throwScope, ConversionResultException { });
    }
    auto typeConversionResult = convertOptionalWithDefault<IDLEnumeration<BiquadFilterType>>(lexicalGlobalObject, typeValue, [&]() -> ConversionResult<IDLEnumeration<BiquadFilterType>> { return Converter<IDLEnumeration<BiquadFilterType>>::ReturnType { BiquadFilterType::Lowpass }; });
    if (UNLIKELY(typeConversionResult.hasException(throwScope)))
        return ConversionResultException { };
    result.type = typeConversionResult.releaseReturnValue();
    return result;
}

#endif

} // namespace WebCore

#endif // ENABLE(WEB_AUDIO)
