/*
 * Interface wrapper code.
 *
 * Generated by SIP 6.11.1
 *
 * Copyright (c) 2024 Riverbank Computing Limited <info@riverbankcomputing.com>
 * 
 * This file is part of PyQt5.
 * 
 * This file may be used under the terms of the GNU General Public License
 * version 3.0 as published by the Free Software Foundation and appearing in
 * the file LICENSE included in the packaging of this file.  Please review the
 * following information to ensure the GNU General Public License version 3.0
 * requirements will be met: http://www.gnu.org/copyleft/gpl.html.
 * 
 * If you do not wish to use this file under the terms of the GPL version 3.0
 * then you may purchase a commercial license.  For more information contact
 * info@riverbankcomputing.com.
 * 
 * This file is provided AS IS with NO WARRANTY OF ANY KIND, INCLUDING THE
 * WARRANTY OF DESIGN, MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE.
 */

#include "sipAPIQtNetwork.h"

#line 26 "/build/pyqt5/src/PyQt5-5.15.11/sip/QtNetwork/qudpsocket.sip"
#include <qudpsocket.h>
#line 29 "/build/pyqt5/src/PyQt5-5.15.11/build/QtNetwork/sipQtNetworkQUdpSocket.cpp"

#line 28 "/build/pyqt5/src/PyQt5-5.15.11/sip/QtCore/qobject.sip"
#include <qobject.h>
#line 33 "/build/pyqt5/src/PyQt5-5.15.11/build/QtNetwork/sipQtNetworkQUdpSocket.cpp"
#line 28 "/build/pyqt5/src/PyQt5-5.15.11/sip/QtNetwork/qnetworkdatagram.sip"
#include <qnetworkdatagram.h>
#line 36 "/build/pyqt5/src/PyQt5-5.15.11/build/QtNetwork/sipQtNetworkQUdpSocket.cpp"
#line 86 "/build/pyqt5/src/PyQt5-5.15.11/sip/QtNetwork/qnetworkinterface.sip"
#include <qnetworkinterface.h>
#line 39 "/build/pyqt5/src/PyQt5-5.15.11/build/QtNetwork/sipQtNetworkQUdpSocket.cpp"
#line 26 "/build/pyqt5/src/PyQt5-5.15.11/sip/QtNetwork/qhostaddress.sip"
#include <qhostaddress.h>
#line 42 "/build/pyqt5/src/PyQt5-5.15.11/build/QtNetwork/sipQtNetworkQUdpSocket.cpp"
#line 30 "/build/pyqt5/src/PyQt5-5.15.11/sip/QtCore/qbytearray.sip"
#include <qbytearray.h>
#line 45 "/build/pyqt5/src/PyQt5-5.15.11/build/QtNetwork/sipQtNetworkQUdpSocket.cpp"
#line 27 "/build/pyqt5/src/PyQt5-5.15.11/sip/QtCore/qstring.sip"
#include <qstring.h>
#line 48 "/build/pyqt5/src/PyQt5-5.15.11/build/QtNetwork/sipQtNetworkQUdpSocket.cpp"
#line 26 "/build/pyqt5/src/PyQt5-5.15.11/sip/QtNetwork/qabstractsocket.sip"
#include <qabstractsocket.h>
#line 51 "/build/pyqt5/src/PyQt5-5.15.11/build/QtNetwork/sipQtNetworkQUdpSocket.cpp"
#line 26 "/build/pyqt5/src/PyQt5-5.15.11/sip/QtNetwork/qabstractsocket.sip"
#include <qabstractsocket.h>
#line 54 "/build/pyqt5/src/PyQt5-5.15.11/build/QtNetwork/sipQtNetworkQUdpSocket.cpp"
#line 26 "/build/pyqt5/src/PyQt5-5.15.11/sip/QtCore/qvariant.sip"
#include <qvariant.h>
#line 57 "/build/pyqt5/src/PyQt5-5.15.11/build/QtNetwork/sipQtNetworkQUdpSocket.cpp"
#line 26 "/build/pyqt5/src/PyQt5-5.15.11/sip/QtNetwork/qabstractsocket.sip"
#include <qabstractsocket.h>
#line 60 "/build/pyqt5/src/PyQt5-5.15.11/build/QtNetwork/sipQtNetworkQUdpSocket.cpp"
#line 26 "/build/pyqt5/src/PyQt5-5.15.11/sip/QtNetwork/qnetworkproxy.sip"
#include <qnetworkproxy.h>
#line 63 "/build/pyqt5/src/PyQt5-5.15.11/build/QtNetwork/sipQtNetworkQUdpSocket.cpp"
#line 26 "/build/pyqt5/src/PyQt5-5.15.11/sip/QtNetwork/qauthenticator.sip"
#include <qauthenticator.h>
#line 66 "/build/pyqt5/src/PyQt5-5.15.11/build/QtNetwork/sipQtNetworkQUdpSocket.cpp"
#line 166 "/build/pyqt5/src/PyQt5-5.15.11/sip/QtCore/qglobal.sip"
#include <QtGlobal>
#line 69 "/build/pyqt5/src/PyQt5-5.15.11/build/QtNetwork/sipQtNetworkQUdpSocket.cpp"
#line 26 "/build/pyqt5/src/PyQt5-5.15.11/sip/QtCore/qiodevice.sip"
#include <qiodevice.h>
#line 72 "/build/pyqt5/src/PyQt5-5.15.11/build/QtNetwork/sipQtNetworkQUdpSocket.cpp"
#line 26 "/build/pyqt5/src/PyQt5-5.15.11/sip/QtCore/qobjectdefs.sip"
#include <qobjectdefs.h>
#line 146 "/build/pyqt5/src/PyQt5-5.15.11/sip/QtCore/qobjectdefs.sip"
#include <qobjectdefs.h>
#line 77 "/build/pyqt5/src/PyQt5-5.15.11/build/QtNetwork/sipQtNetworkQUdpSocket.cpp"
#line 26 "/build/pyqt5/src/PyQt5-5.15.11/sip/QtCore/qmetaobject.sip"
#include <qmetaobject.h>
#line 80 "/build/pyqt5/src/PyQt5-5.15.11/build/QtNetwork/sipQtNetworkQUdpSocket.cpp"
#line 26 "/build/pyqt5/src/PyQt5-5.15.11/sip/QtCore/qcoreevent.sip"
#include <qcoreevent.h>
#line 83 "/build/pyqt5/src/PyQt5-5.15.11/build/QtNetwork/sipQtNetworkQUdpSocket.cpp"
#line 252 "/build/pyqt5/src/PyQt5-5.15.11/sip/QtCore/qcoreevent.sip"
#include <qcoreevent.h>
#line 86 "/build/pyqt5/src/PyQt5-5.15.11/build/QtNetwork/sipQtNetworkQUdpSocket.cpp"
#line 240 "/build/pyqt5/src/PyQt5-5.15.11/sip/QtCore/qcoreevent.sip"
#include <qcoreevent.h>
#line 89 "/build/pyqt5/src/PyQt5-5.15.11/build/QtNetwork/sipQtNetworkQUdpSocket.cpp"
#line 38 "/build/pyqt5/src/PyQt5-5.15.11/sip/QtCore/qpycore_qlist.sip"
#include <qlist.h>
#line 92 "/build/pyqt5/src/PyQt5-5.15.11/build/QtNetwork/sipQtNetworkQUdpSocket.cpp"
#line 149 "/build/pyqt5/src/PyQt5-5.15.11/sip/QtCore/qpycore_qlist.sip"
#include <qlist.h>
#line 95 "/build/pyqt5/src/PyQt5-5.15.11/build/QtNetwork/sipQtNetworkQUdpSocket.cpp"
#line 26 "/build/pyqt5/src/PyQt5-5.15.11/sip/QtCore/qnamespace.sip"
#include <qnamespace.h>
#line 98 "/build/pyqt5/src/PyQt5-5.15.11/build/QtNetwork/sipQtNetworkQUdpSocket.cpp"
#line 26 "/build/pyqt5/src/PyQt5-5.15.11/sip/QtCore/qthread.sip"
#include <qthread.h>
#line 101 "/build/pyqt5/src/PyQt5-5.15.11/build/QtNetwork/sipQtNetworkQUdpSocket.cpp"
#line 26 "/build/pyqt5/src/PyQt5-5.15.11/sip/QtCore/qnamespace.sip"
#include <qnamespace.h>
#line 104 "/build/pyqt5/src/PyQt5-5.15.11/build/QtNetwork/sipQtNetworkQUdpSocket.cpp"
#line 26 "/build/pyqt5/src/PyQt5-5.15.11/sip/QtCore/qregexp.sip"
#include <qregexp.h>
#line 107 "/build/pyqt5/src/PyQt5-5.15.11/build/QtNetwork/sipQtNetworkQUdpSocket.cpp"
#line 26 "/build/pyqt5/src/PyQt5-5.15.11/sip/QtCore/qregularexpression.sip"
#include <qregularexpression.h>
#line 110 "/build/pyqt5/src/PyQt5-5.15.11/build/QtNetwork/sipQtNetworkQUdpSocket.cpp"
#line 26 "/build/pyqt5/src/PyQt5-5.15.11/sip/QtCore/qobjectdefs.sip"
#include <qobjectdefs.h>
#line 113 "/build/pyqt5/src/PyQt5-5.15.11/build/QtNetwork/sipQtNetworkQUdpSocket.cpp"


class sipQUdpSocket : public ::QUdpSocket
{
public:
    sipQUdpSocket(::QObject*);
    virtual ~sipQUdpSocket();

    int qt_metacall(QMetaObject::Call, int, void **) SIP_OVERRIDE;
    void *qt_metacast(const char *) SIP_OVERRIDE;
    const QMetaObject *metaObject() const SIP_OVERRIDE;

    /*
     * There is a protected method for every virtual method visible from
     * this class.
     */
protected:
    ::qint64 writeData(const char*, long long) SIP_OVERRIDE;
    ::qint64 readLineData(char*, ::qint64) SIP_OVERRIDE;
    ::qint64 readData(char*, ::qint64) SIP_OVERRIDE;
    bool waitForBytesWritten(int) SIP_OVERRIDE;
    bool waitForReadyRead(int) SIP_OVERRIDE;
    bool canReadLine() const SIP_OVERRIDE;
    ::qint64 bytesToWrite() const SIP_OVERRIDE;
    ::qint64 bytesAvailable() const SIP_OVERRIDE;
    bool reset() SIP_OVERRIDE;
    bool atEnd() const SIP_OVERRIDE;
    bool seek(::qint64) SIP_OVERRIDE;
    ::qint64 size() const SIP_OVERRIDE;
    ::qint64 pos() const SIP_OVERRIDE;
    void close() SIP_OVERRIDE;
    bool open(::QIODevice::OpenMode) SIP_OVERRIDE;
    bool isSequential() const SIP_OVERRIDE;
    bool event(::QEvent*) SIP_OVERRIDE;
    bool eventFilter(::QObject*, ::QEvent*) SIP_OVERRIDE;
    void timerEvent(::QTimerEvent*) SIP_OVERRIDE;
    void childEvent(::QChildEvent*) SIP_OVERRIDE;
    void customEvent(::QEvent*) SIP_OVERRIDE;
    void connectNotify(const ::QMetaMethod&) SIP_OVERRIDE;
    void disconnectNotify(const ::QMetaMethod&) SIP_OVERRIDE;
    void connectToHost(const ::QString&, ::quint16, ::QIODevice::OpenMode, ::QAbstractSocket::NetworkLayerProtocol) SIP_OVERRIDE;
    void connectToHost(const ::QHostAddress&, ::quint16, ::QIODevice::OpenMode) SIP_OVERRIDE;
    void disconnectFromHost() SIP_OVERRIDE;
    void setReadBufferSize(::qint64) SIP_OVERRIDE;
    bool setSocketDescriptor(::qintptr, ::QAbstractSocket::SocketState, ::QIODevice::OpenMode) SIP_OVERRIDE;
    ::qintptr socketDescriptor() const SIP_OVERRIDE;
    bool waitForConnected(int) SIP_OVERRIDE;
    bool waitForDisconnected(int) SIP_OVERRIDE;
    void setSocketOption(::QAbstractSocket::SocketOption, const ::QVariant&) SIP_OVERRIDE;
    ::QVariant socketOption(::QAbstractSocket::SocketOption) SIP_OVERRIDE;
    void resume() SIP_OVERRIDE;

public:
    sipSimpleWrapper *sipPySelf;

private:
    sipQUdpSocket(const sipQUdpSocket &);
    sipQUdpSocket &operator = (const sipQUdpSocket &);

    char sipPyMethods[34];
};

sipQUdpSocket::sipQUdpSocket(::QObject*a0): ::QUdpSocket(a0), sipPySelf(SIP_NULLPTR)
{
    memset(sipPyMethods, 0, sizeof (sipPyMethods));
}

sipQUdpSocket::~sipQUdpSocket()
{
    sipInstanceDestroyedEx(&sipPySelf);
}

const QMetaObject *sipQUdpSocket::metaObject() const
{
    if (sipGetInterpreter())
        return QObject::d_ptr->metaObject ? QObject::d_ptr->dynamicMetaObject() : sip_QtNetwork_qt_metaobject(sipPySelf, sipType_QUdpSocket);

    return ::QUdpSocket::metaObject();
}

int sipQUdpSocket::qt_metacall(QMetaObject::Call _c, int _id, void **_a)
{
    _id = ::QUdpSocket::qt_metacall(_c, _id, _a);

    if (_id >= 0)
    {
        SIP_BLOCK_THREADS
        _id = sip_QtNetwork_qt_metacall(sipPySelf, sipType_QUdpSocket, _c, _id, _a);
        SIP_UNBLOCK_THREADS
    }

    return _id;
}

void *sipQUdpSocket::qt_metacast(const char *_clname)
{
    void *sipCpp;

    return (sip_QtNetwork_qt_metacast(sipPySelf, sipType_QUdpSocket, _clname, &sipCpp) ? sipCpp : ::QUdpSocket::qt_metacast(_clname));
}

::qint64 sipQUdpSocket::writeData(const char*a0, long long a1)
{
    sip_gilstate_t sipGILState;
    PyObject *sipMeth;

    sipMeth = sipIsPyMethod(&sipGILState, &sipPyMethods[0], &sipPySelf, SIP_NULLPTR, sipName_writeData);

    if (!sipMeth)
        return ::QUdpSocket::writeData(a0, a1);

    extern ::qint64 sipVH_QtNetwork_14(sip_gilstate_t, sipVirtErrorHandlerFunc, sipSimpleWrapper *, PyObject *, const char*, long long);

    return sipVH_QtNetwork_14(sipGILState, sipImportedVirtErrorHandlers_QtNetwork_QtCore[0].iveh_handler, sipPySelf, sipMeth, a0, a1);
}

::qint64 sipQUdpSocket::readLineData(char*a0, ::qint64 a1)
{
    sip_gilstate_t sipGILState;
    PyObject *sipMeth;

    sipMeth = sipIsPyMethod(&sipGILState, &sipPyMethods[1], &sipPySelf, SIP_NULLPTR, sipName_readLineData);

    if (!sipMeth)
        return ::QUdpSocket::readLineData(a0, a1);

    extern ::qint64 sipVH_QtNetwork_15(sip_gilstate_t, sipVirtErrorHandlerFunc, sipSimpleWrapper *, PyObject *, char*, ::qint64);

    return sipVH_QtNetwork_15(sipGILState, sipImportedVirtErrorHandlers_QtNetwork_QtCore[0].iveh_handler, sipPySelf, sipMeth, a0, a1);
}

::qint64 sipQUdpSocket::readData(char*a0, ::qint64 a1)
{
    sip_gilstate_t sipGILState;
    PyObject *sipMeth;

    sipMeth = sipIsPyMethod(&sipGILState, &sipPyMethods[2], &sipPySelf, SIP_NULLPTR, sipName_readData);

    if (!sipMeth)
        return ::QUdpSocket::readData(a0, a1);

    extern ::qint64 sipVH_QtNetwork_16(sip_gilstate_t, sipVirtErrorHandlerFunc, sipSimpleWrapper *, PyObject *, char*, ::qint64);

    return sipVH_QtNetwork_16(sipGILState, sipImportedVirtErrorHandlers_QtNetwork_QtCore[0].iveh_handler, sipPySelf, sipMeth, a0, a1);
}

bool sipQUdpSocket::waitForBytesWritten(int a0)
{
    sip_gilstate_t sipGILState;
    PyObject *sipMeth;

    sipMeth = sipIsPyMethod(&sipGILState, &sipPyMethods[3], &sipPySelf, SIP_NULLPTR, sipName_waitForBytesWritten);

    if (!sipMeth)
        return ::QUdpSocket::waitForBytesWritten(a0);

    extern bool sipVH_QtNetwork_17(sip_gilstate_t, sipVirtErrorHandlerFunc, sipSimpleWrapper *, PyObject *, int);

    return sipVH_QtNetwork_17(sipGILState, sipImportedVirtErrorHandlers_QtNetwork_QtCore[0].iveh_handler, sipPySelf, sipMeth, a0);
}

bool sipQUdpSocket::waitForReadyRead(int a0)
{
    sip_gilstate_t sipGILState;
    PyObject *sipMeth;

    sipMeth = sipIsPyMethod(&sipGILState, &sipPyMethods[4], &sipPySelf, SIP_NULLPTR, sipName_waitForReadyRead);

    if (!sipMeth)
        return ::QUdpSocket::waitForReadyRead(a0);

    extern bool sipVH_QtNetwork_17(sip_gilstate_t, sipVirtErrorHandlerFunc, sipSimpleWrapper *, PyObject *, int);

    return sipVH_QtNetwork_17(sipGILState, sipImportedVirtErrorHandlers_QtNetwork_QtCore[0].iveh_handler, sipPySelf, sipMeth, a0);
}

bool sipQUdpSocket::canReadLine() const
{
    sip_gilstate_t sipGILState;
    PyObject *sipMeth;

    sipMeth = sipIsPyMethod(&sipGILState, const_cast<char *>(&sipPyMethods[5]), const_cast<sipSimpleWrapper **>(&sipPySelf), SIP_NULLPTR, sipName_canReadLine);

    if (!sipMeth)
        return ::QUdpSocket::canReadLine();

    extern bool sipVH_QtNetwork_18(sip_gilstate_t, sipVirtErrorHandlerFunc, sipSimpleWrapper *, PyObject *);

    return sipVH_QtNetwork_18(sipGILState, sipImportedVirtErrorHandlers_QtNetwork_QtCore[0].iveh_handler, sipPySelf, sipMeth);
}

::qint64 sipQUdpSocket::bytesToWrite() const
{
    sip_gilstate_t sipGILState;
    PyObject *sipMeth;

    sipMeth = sipIsPyMethod(&sipGILState, const_cast<char *>(&sipPyMethods[6]), const_cast<sipSimpleWrapper **>(&sipPySelf), SIP_NULLPTR, sipName_bytesToWrite);

    if (!sipMeth)
        return ::QUdpSocket::bytesToWrite();

    extern ::qint64 sipVH_QtNetwork_10(sip_gilstate_t, sipVirtErrorHandlerFunc, sipSimpleWrapper *, PyObject *);

    return sipVH_QtNetwork_10(sipGILState, sipImportedVirtErrorHandlers_QtNetwork_QtCore[0].iveh_handler, sipPySelf, sipMeth);
}

::qint64 sipQUdpSocket::bytesAvailable() const
{
    sip_gilstate_t sipGILState;
    PyObject *sipMeth;

    sipMeth = sipIsPyMethod(&sipGILState, const_cast<char *>(&sipPyMethods[7]), const_cast<sipSimpleWrapper **>(&sipPySelf), SIP_NULLPTR, sipName_bytesAvailable);

    if (!sipMeth)
        return ::QUdpSocket::bytesAvailable();

    extern ::qint64 sipVH_QtNetwork_10(sip_gilstate_t, sipVirtErrorHandlerFunc, sipSimpleWrapper *, PyObject *);

    return sipVH_QtNetwork_10(sipGILState, sipImportedVirtErrorHandlers_QtNetwork_QtCore[0].iveh_handler, sipPySelf, sipMeth);
}

bool sipQUdpSocket::reset()
{
    sip_gilstate_t sipGILState;
    PyObject *sipMeth;

    sipMeth = sipIsPyMethod(&sipGILState, &sipPyMethods[8], &sipPySelf, SIP_NULLPTR, sipName_reset);

    if (!sipMeth)
        return ::QUdpSocket::reset();

    extern bool sipVH_QtNetwork_18(sip_gilstate_t, sipVirtErrorHandlerFunc, sipSimpleWrapper *, PyObject *);

    return sipVH_QtNetwork_18(sipGILState, sipImportedVirtErrorHandlers_QtNetwork_QtCore[0].iveh_handler, sipPySelf, sipMeth);
}

bool sipQUdpSocket::atEnd() const
{
    sip_gilstate_t sipGILState;
    PyObject *sipMeth;

    sipMeth = sipIsPyMethod(&sipGILState, const_cast<char *>(&sipPyMethods[9]), const_cast<sipSimpleWrapper **>(&sipPySelf), SIP_NULLPTR, sipName_atEnd);

    if (!sipMeth)
        return ::QUdpSocket::atEnd();

    extern bool sipVH_QtNetwork_18(sip_gilstate_t, sipVirtErrorHandlerFunc, sipSimpleWrapper *, PyObject *);

    return sipVH_QtNetwork_18(sipGILState, sipImportedVirtErrorHandlers_QtNetwork_QtCore[0].iveh_handler, sipPySelf, sipMeth);
}

bool sipQUdpSocket::seek(::qint64 a0)
{
    sip_gilstate_t sipGILState;
    PyObject *sipMeth;

    sipMeth = sipIsPyMethod(&sipGILState, &sipPyMethods[10], &sipPySelf, SIP_NULLPTR, sipName_seek);

    if (!sipMeth)
        return ::QUdpSocket::seek(a0);

    extern bool sipVH_QtNetwork_19(sip_gilstate_t, sipVirtErrorHandlerFunc, sipSimpleWrapper *, PyObject *, ::qint64);

    return sipVH_QtNetwork_19(sipGILState, sipImportedVirtErrorHandlers_QtNetwork_QtCore[0].iveh_handler, sipPySelf, sipMeth, a0);
}

::qint64 sipQUdpSocket::size() const
{
    sip_gilstate_t sipGILState;
    PyObject *sipMeth;

    sipMeth = sipIsPyMethod(&sipGILState, const_cast<char *>(&sipPyMethods[11]), const_cast<sipSimpleWrapper **>(&sipPySelf), SIP_NULLPTR, sipName_size);

    if (!sipMeth)
        return ::QUdpSocket::size();

    extern ::qint64 sipVH_QtNetwork_10(sip_gilstate_t, sipVirtErrorHandlerFunc, sipSimpleWrapper *, PyObject *);

    return sipVH_QtNetwork_10(sipGILState, sipImportedVirtErrorHandlers_QtNetwork_QtCore[0].iveh_handler, sipPySelf, sipMeth);
}

::qint64 sipQUdpSocket::pos() const
{
    sip_gilstate_t sipGILState;
    PyObject *sipMeth;

    sipMeth = sipIsPyMethod(&sipGILState, const_cast<char *>(&sipPyMethods[12]), const_cast<sipSimpleWrapper **>(&sipPySelf), SIP_NULLPTR, sipName_pos);

    if (!sipMeth)
        return ::QUdpSocket::pos();

    extern ::qint64 sipVH_QtNetwork_10(sip_gilstate_t, sipVirtErrorHandlerFunc, sipSimpleWrapper *, PyObject *);

    return sipVH_QtNetwork_10(sipGILState, sipImportedVirtErrorHandlers_QtNetwork_QtCore[0].iveh_handler, sipPySelf, sipMeth);
}

void sipQUdpSocket::close()
{
    sip_gilstate_t sipGILState;
    PyObject *sipMeth;

    sipMeth = sipIsPyMethod(&sipGILState, &sipPyMethods[13], &sipPySelf, SIP_NULLPTR, sipName_close);

    if (!sipMeth)
    {
        ::QUdpSocket::close();
        return;
    }

    extern void sipVH_QtNetwork_13(sip_gilstate_t, sipVirtErrorHandlerFunc, sipSimpleWrapper *, PyObject *);

    sipVH_QtNetwork_13(sipGILState, sipImportedVirtErrorHandlers_QtNetwork_QtCore[0].iveh_handler, sipPySelf, sipMeth);
}

bool sipQUdpSocket::open(::QIODevice::OpenMode a0)
{
    sip_gilstate_t sipGILState;
    PyObject *sipMeth;

    sipMeth = sipIsPyMethod(&sipGILState, &sipPyMethods[14], &sipPySelf, SIP_NULLPTR, sipName_open);

    if (!sipMeth)
        return ::QUdpSocket::open(a0);

    extern bool sipVH_QtNetwork_20(sip_gilstate_t, sipVirtErrorHandlerFunc, sipSimpleWrapper *, PyObject *, ::QIODevice::OpenMode);

    return sipVH_QtNetwork_20(sipGILState, sipImportedVirtErrorHandlers_QtNetwork_QtCore[0].iveh_handler, sipPySelf, sipMeth, a0);
}

bool sipQUdpSocket::isSequential() const
{
    sip_gilstate_t sipGILState;
    PyObject *sipMeth;

    sipMeth = sipIsPyMethod(&sipGILState, const_cast<char *>(&sipPyMethods[15]), const_cast<sipSimpleWrapper **>(&sipPySelf), SIP_NULLPTR, sipName_isSequential);

    if (!sipMeth)
        return ::QUdpSocket::isSequential();

    extern bool sipVH_QtNetwork_18(sip_gilstate_t, sipVirtErrorHandlerFunc, sipSimpleWrapper *, PyObject *);

    return sipVH_QtNetwork_18(sipGILState, sipImportedVirtErrorHandlers_QtNetwork_QtCore[0].iveh_handler, sipPySelf, sipMeth);
}

bool sipQUdpSocket::event(::QEvent*a0)
{
    sip_gilstate_t sipGILState;
    PyObject *sipMeth;

    sipMeth = sipIsPyMethod(&sipGILState, &sipPyMethods[16], &sipPySelf, SIP_NULLPTR, sipName_event);

    if (!sipMeth)
        return ::QUdpSocket::event(a0);

    extern bool sipVH_QtNetwork_5(sip_gilstate_t, sipVirtErrorHandlerFunc, sipSimpleWrapper *, PyObject *, ::QEvent*);

    return sipVH_QtNetwork_5(sipGILState, sipImportedVirtErrorHandlers_QtNetwork_QtCore[0].iveh_handler, sipPySelf, sipMeth, a0);
}

bool sipQUdpSocket::eventFilter(::QObject*a0, ::QEvent*a1)
{
    sip_gilstate_t sipGILState;
    PyObject *sipMeth;

    sipMeth = sipIsPyMethod(&sipGILState, &sipPyMethods[17], &sipPySelf, SIP_NULLPTR, sipName_eventFilter);

    if (!sipMeth)
        return ::QUdpSocket::eventFilter(a0, a1);

    extern bool sipVH_QtNetwork_4(sip_gilstate_t, sipVirtErrorHandlerFunc, sipSimpleWrapper *, PyObject *, ::QObject*, ::QEvent*);

    return sipVH_QtNetwork_4(sipGILState, sipImportedVirtErrorHandlers_QtNetwork_QtCore[0].iveh_handler, sipPySelf, sipMeth, a0, a1);
}

void sipQUdpSocket::timerEvent(::QTimerEvent*a0)
{
    sip_gilstate_t sipGILState;
    PyObject *sipMeth;

    sipMeth = sipIsPyMethod(&sipGILState, &sipPyMethods[18], &sipPySelf, SIP_NULLPTR, sipName_timerEvent);

    if (!sipMeth)
    {
        ::QUdpSocket::timerEvent(a0);
        return;
    }

    extern void sipVH_QtNetwork_3(sip_gilstate_t, sipVirtErrorHandlerFunc, sipSimpleWrapper *, PyObject *, ::QTimerEvent*);

    sipVH_QtNetwork_3(sipGILState, sipImportedVirtErrorHandlers_QtNetwork_QtCore[0].iveh_handler, sipPySelf, sipMeth, a0);
}

void sipQUdpSocket::childEvent(::QChildEvent*a0)
{
    sip_gilstate_t sipGILState;
    PyObject *sipMeth;

    sipMeth = sipIsPyMethod(&sipGILState, &sipPyMethods[19], &sipPySelf, SIP_NULLPTR, sipName_childEvent);

    if (!sipMeth)
    {
        ::QUdpSocket::childEvent(a0);
        return;
    }

    extern void sipVH_QtNetwork_2(sip_gilstate_t, sipVirtErrorHandlerFunc, sipSimpleWrapper *, PyObject *, ::QChildEvent*);

    sipVH_QtNetwork_2(sipGILState, sipImportedVirtErrorHandlers_QtNetwork_QtCore[0].iveh_handler, sipPySelf, sipMeth, a0);
}

void sipQUdpSocket::customEvent(::QEvent*a0)
{
    sip_gilstate_t sipGILState;
    PyObject *sipMeth;

    sipMeth = sipIsPyMethod(&sipGILState, &sipPyMethods[20], &sipPySelf, SIP_NULLPTR, sipName_customEvent);

    if (!sipMeth)
    {
        ::QUdpSocket::customEvent(a0);
        return;
    }

    extern void sipVH_QtNetwork_1(sip_gilstate_t, sipVirtErrorHandlerFunc, sipSimpleWrapper *, PyObject *, ::QEvent*);

    sipVH_QtNetwork_1(sipGILState, sipImportedVirtErrorHandlers_QtNetwork_QtCore[0].iveh_handler, sipPySelf, sipMeth, a0);
}

void sipQUdpSocket::connectNotify(const ::QMetaMethod& a0)
{
    sip_gilstate_t sipGILState;
    PyObject *sipMeth;

    sipMeth = sipIsPyMethod(&sipGILState, &sipPyMethods[21], &sipPySelf, SIP_NULLPTR, sipName_connectNotify);

    if (!sipMeth)
    {
        ::QUdpSocket::connectNotify(a0);
        return;
    }

    extern void sipVH_QtNetwork_0(sip_gilstate_t, sipVirtErrorHandlerFunc, sipSimpleWrapper *, PyObject *, const ::QMetaMethod&);

    sipVH_QtNetwork_0(sipGILState, sipImportedVirtErrorHandlers_QtNetwork_QtCore[0].iveh_handler, sipPySelf, sipMeth, a0);
}

void sipQUdpSocket::disconnectNotify(const ::QMetaMethod& a0)
{
    sip_gilstate_t sipGILState;
    PyObject *sipMeth;

    sipMeth = sipIsPyMethod(&sipGILState, &sipPyMethods[22], &sipPySelf, SIP_NULLPTR, sipName_disconnectNotify);

    if (!sipMeth)
    {
        ::QUdpSocket::disconnectNotify(a0);
        return;
    }

    extern void sipVH_QtNetwork_0(sip_gilstate_t, sipVirtErrorHandlerFunc, sipSimpleWrapper *, PyObject *, const ::QMetaMethod&);

    sipVH_QtNetwork_0(sipGILState, sipImportedVirtErrorHandlers_QtNetwork_QtCore[0].iveh_handler, sipPySelf, sipMeth, a0);
}

void sipQUdpSocket::connectToHost(const ::QString& a0, ::quint16 a1, ::QIODevice::OpenMode a2, ::QAbstractSocket::NetworkLayerProtocol a3)
{
    sip_gilstate_t sipGILState;
    PyObject *sipMeth;

    sipMeth = sipIsPyMethod(&sipGILState, &sipPyMethods[23], &sipPySelf, SIP_NULLPTR, sipName_connectToHost);

    if (!sipMeth)
    {
        ::QUdpSocket::connectToHost(a0, a1, a2, a3);
        return;
    }

    extern void sipVH_QtNetwork_21(sip_gilstate_t, sipVirtErrorHandlerFunc, sipSimpleWrapper *, PyObject *, const ::QString&, ::quint16, ::QIODevice::OpenMode, ::QAbstractSocket::NetworkLayerProtocol);

    sipVH_QtNetwork_21(sipGILState, sipImportedVirtErrorHandlers_QtNetwork_QtCore[0].iveh_handler, sipPySelf, sipMeth, a0, a1, a2, a3);
}

void sipQUdpSocket::connectToHost(const ::QHostAddress& a0, ::quint16 a1, ::QIODevice::OpenMode a2)
{
    sip_gilstate_t sipGILState;
    PyObject *sipMeth;

    sipMeth = sipIsPyMethod(&sipGILState, &sipPyMethods[24], &sipPySelf, SIP_NULLPTR, sipName_connectToHost);

    if (!sipMeth)
    {
        ::QUdpSocket::connectToHost(a0, a1, a2);
        return;
    }

    extern void sipVH_QtNetwork_22(sip_gilstate_t, sipVirtErrorHandlerFunc, sipSimpleWrapper *, PyObject *, const ::QHostAddress&, ::quint16, ::QIODevice::OpenMode);

    sipVH_QtNetwork_22(sipGILState, sipImportedVirtErrorHandlers_QtNetwork_QtCore[0].iveh_handler, sipPySelf, sipMeth, a0, a1, a2);
}

void sipQUdpSocket::disconnectFromHost()
{
    sip_gilstate_t sipGILState;
    PyObject *sipMeth;

    sipMeth = sipIsPyMethod(&sipGILState, &sipPyMethods[25], &sipPySelf, SIP_NULLPTR, sipName_disconnectFromHost);

    if (!sipMeth)
    {
        ::QUdpSocket::disconnectFromHost();
        return;
    }

    extern void sipVH_QtNetwork_13(sip_gilstate_t, sipVirtErrorHandlerFunc, sipSimpleWrapper *, PyObject *);

    sipVH_QtNetwork_13(sipGILState, sipImportedVirtErrorHandlers_QtNetwork_QtCore[0].iveh_handler, sipPySelf, sipMeth);
}

void sipQUdpSocket::setReadBufferSize(::qint64 a0)
{
    sip_gilstate_t sipGILState;
    PyObject *sipMeth;

    sipMeth = sipIsPyMethod(&sipGILState, &sipPyMethods[26], &sipPySelf, SIP_NULLPTR, sipName_setReadBufferSize);

    if (!sipMeth)
    {
        ::QUdpSocket::setReadBufferSize(a0);
        return;
    }

    extern void sipVH_QtNetwork_23(sip_gilstate_t, sipVirtErrorHandlerFunc, sipSimpleWrapper *, PyObject *, ::qint64);

    sipVH_QtNetwork_23(sipGILState, sipImportedVirtErrorHandlers_QtNetwork_QtCore[0].iveh_handler, sipPySelf, sipMeth, a0);
}

bool sipQUdpSocket::setSocketDescriptor(::qintptr a0, ::QAbstractSocket::SocketState a1, ::QIODevice::OpenMode a2)
{
    sip_gilstate_t sipGILState;
    PyObject *sipMeth;

    sipMeth = sipIsPyMethod(&sipGILState, &sipPyMethods[27], &sipPySelf, SIP_NULLPTR, sipName_setSocketDescriptor);

    if (!sipMeth)
        return ::QUdpSocket::setSocketDescriptor(a0, a1, a2);

    extern bool sipVH_QtNetwork_24(sip_gilstate_t, sipVirtErrorHandlerFunc, sipSimpleWrapper *, PyObject *, ::qintptr, ::QAbstractSocket::SocketState, ::QIODevice::OpenMode);

    return sipVH_QtNetwork_24(sipGILState, sipImportedVirtErrorHandlers_QtNetwork_QtCore[0].iveh_handler, sipPySelf, sipMeth, a0, a1, a2);
}

::qintptr sipQUdpSocket::socketDescriptor() const
{
    sip_gilstate_t sipGILState;
    PyObject *sipMeth;

    sipMeth = sipIsPyMethod(&sipGILState, const_cast<char *>(&sipPyMethods[28]), const_cast<sipSimpleWrapper **>(&sipPySelf), SIP_NULLPTR, sipName_socketDescriptor);

    if (!sipMeth)
        return ::QUdpSocket::socketDescriptor();

    extern ::qintptr sipVH_QtNetwork_25(sip_gilstate_t, sipVirtErrorHandlerFunc, sipSimpleWrapper *, PyObject *);

    return sipVH_QtNetwork_25(sipGILState, sipImportedVirtErrorHandlers_QtNetwork_QtCore[0].iveh_handler, sipPySelf, sipMeth);
}

bool sipQUdpSocket::waitForConnected(int a0)
{
    sip_gilstate_t sipGILState;
    PyObject *sipMeth;

    sipMeth = sipIsPyMethod(&sipGILState, &sipPyMethods[29], &sipPySelf, SIP_NULLPTR, sipName_waitForConnected);

    if (!sipMeth)
        return ::QUdpSocket::waitForConnected(a0);

    extern bool sipVH_QtNetwork_17(sip_gilstate_t, sipVirtErrorHandlerFunc, sipSimpleWrapper *, PyObject *, int);

    return sipVH_QtNetwork_17(sipGILState, sipImportedVirtErrorHandlers_QtNetwork_QtCore[0].iveh_handler, sipPySelf, sipMeth, a0);
}

bool sipQUdpSocket::waitForDisconnected(int a0)
{
    sip_gilstate_t sipGILState;
    PyObject *sipMeth;

    sipMeth = sipIsPyMethod(&sipGILState, &sipPyMethods[30], &sipPySelf, SIP_NULLPTR, sipName_waitForDisconnected);

    if (!sipMeth)
        return ::QUdpSocket::waitForDisconnected(a0);

    extern bool sipVH_QtNetwork_17(sip_gilstate_t, sipVirtErrorHandlerFunc, sipSimpleWrapper *, PyObject *, int);

    return sipVH_QtNetwork_17(sipGILState, sipImportedVirtErrorHandlers_QtNetwork_QtCore[0].iveh_handler, sipPySelf, sipMeth, a0);
}

void sipQUdpSocket::setSocketOption(::QAbstractSocket::SocketOption a0, const ::QVariant& a1)
{
    sip_gilstate_t sipGILState;
    PyObject *sipMeth;

    sipMeth = sipIsPyMethod(&sipGILState, &sipPyMethods[31], &sipPySelf, SIP_NULLPTR, sipName_setSocketOption);

    if (!sipMeth)
    {
        ::QUdpSocket::setSocketOption(a0, a1);
        return;
    }

    extern void sipVH_QtNetwork_26(sip_gilstate_t, sipVirtErrorHandlerFunc, sipSimpleWrapper *, PyObject *, ::QAbstractSocket::SocketOption, const ::QVariant&);

    sipVH_QtNetwork_26(sipGILState, sipImportedVirtErrorHandlers_QtNetwork_QtCore[0].iveh_handler, sipPySelf, sipMeth, a0, a1);
}

::QVariant sipQUdpSocket::socketOption(::QAbstractSocket::SocketOption a0)
{
    sip_gilstate_t sipGILState;
    PyObject *sipMeth;

    sipMeth = sipIsPyMethod(&sipGILState, &sipPyMethods[32], &sipPySelf, SIP_NULLPTR, sipName_socketOption);

    if (!sipMeth)
        return ::QUdpSocket::socketOption(a0);

    extern ::QVariant sipVH_QtNetwork_27(sip_gilstate_t, sipVirtErrorHandlerFunc, sipSimpleWrapper *, PyObject *, ::QAbstractSocket::SocketOption);

    return sipVH_QtNetwork_27(sipGILState, sipImportedVirtErrorHandlers_QtNetwork_QtCore[0].iveh_handler, sipPySelf, sipMeth, a0);
}

void sipQUdpSocket::resume()
{
    sip_gilstate_t sipGILState;
    PyObject *sipMeth;

    sipMeth = sipIsPyMethod(&sipGILState, &sipPyMethods[33], &sipPySelf, SIP_NULLPTR, sipName_resume);

    if (!sipMeth)
    {
        ::QUdpSocket::resume();
        return;
    }

    extern void sipVH_QtNetwork_13(sip_gilstate_t, sipVirtErrorHandlerFunc, sipSimpleWrapper *, PyObject *);

    sipVH_QtNetwork_13(sipGILState, sipImportedVirtErrorHandlers_QtNetwork_QtCore[0].iveh_handler, sipPySelf, sipMeth);
}


PyDoc_STRVAR(doc_QUdpSocket_hasPendingDatagrams, "hasPendingDatagrams(self) -> bool");

extern "C" {static PyObject *meth_QUdpSocket_hasPendingDatagrams(PyObject *, PyObject *);}
static PyObject *meth_QUdpSocket_hasPendingDatagrams(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        const ::QUdpSocket *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "B", &sipSelf, sipType_QUdpSocket, &sipCpp))
        {
            bool sipRes;

            sipRes = sipCpp->hasPendingDatagrams();

            return PyBool_FromLong(sipRes);
        }
    }

    sipNoMethod(sipParseErr, sipName_QUdpSocket, sipName_hasPendingDatagrams, doc_QUdpSocket_hasPendingDatagrams);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_QUdpSocket_pendingDatagramSize, "pendingDatagramSize(self) -> int");

extern "C" {static PyObject *meth_QUdpSocket_pendingDatagramSize(PyObject *, PyObject *);}
static PyObject *meth_QUdpSocket_pendingDatagramSize(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        const ::QUdpSocket *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "B", &sipSelf, sipType_QUdpSocket, &sipCpp))
        {
            ::qint64 sipRes;

            sipRes = sipCpp->pendingDatagramSize();

            return PyLong_FromLongLong(sipRes);
        }
    }

    sipNoMethod(sipParseErr, sipName_QUdpSocket, sipName_pendingDatagramSize, doc_QUdpSocket_pendingDatagramSize);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_QUdpSocket_readDatagram, "readDatagram(self, maxlen: int) -> (str, Optional[QHostAddress], Optional[int])");

extern "C" {static PyObject *meth_QUdpSocket_readDatagram(PyObject *, PyObject *, PyObject *);}
static PyObject *meth_QUdpSocket_readDatagram(PyObject *sipSelf, PyObject *sipArgs, PyObject *sipKwds)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        ::qint64 a0;
        ::QHostAddress* a1;
        ::quint16 a2;
        ::QUdpSocket *sipCpp;

        static const char *sipKwdList[] = {
            SIP_NULLPTR,
        };

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, sipKwdList, SIP_NULLPTR, "Bn", &sipSelf, sipType_QUdpSocket, &sipCpp, &a0))
        {
            PyObject * sipRes = SIP_NULLPTR;
            a1 = new ::QHostAddress();
            int sipIsErr = 0;

#line 36 "/build/pyqt5/src/PyQt5-5.15.11/sip/QtNetwork/qudpsocket.sip"
        // Return the data read or None if there was an error.
        if (a0 < 0)
        {
            PyErr_SetString(PyExc_ValueError, "maximum length of data to be read cannot be negative");
            sipIsErr = 1;
        }
        else
        {
            char *s = new char[a0];
            qint64 len;
        
            Py_BEGIN_ALLOW_THREADS
            len = sipCpp->readDatagram(s, a0, a1, &a2);
            Py_END_ALLOW_THREADS
        
            if (len < 0)
            {
                Py_INCREF(Py_None);
                sipRes = Py_None;
            }
            else
            {
                sipRes = SIPBytes_FromStringAndSize(s, len);
        
                if (!sipRes)
                    sipIsErr = 1;
            }
        
            delete[] s;
        }
#line 868 "/build/pyqt5/src/PyQt5-5.15.11/build/QtNetwork/sipQtNetworkQUdpSocket.cpp"

            if (sipIsErr)
                return 0;

            return sipBuildResult(0, "(RNt)", sipRes, a1, sipType_QHostAddress, SIP_NULLPTR, a2);
        }
    }

    sipNoMethod(sipParseErr, sipName_QUdpSocket, sipName_readDatagram, doc_QUdpSocket_readDatagram);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_QUdpSocket_writeDatagram, "writeDatagram(self, data: Optional[PyQt5.sip.array[bytes]], host: Union[QHostAddress, QHostAddress.SpecialAddress], port: int) -> int\n"
"writeDatagram(self, datagram: Union[QByteArray, bytes, bytearray], host: Union[QHostAddress, QHostAddress.SpecialAddress], port: int) -> int\n"
"writeDatagram(self, datagram: QNetworkDatagram) -> int");

extern "C" {static PyObject *meth_QUdpSocket_writeDatagram(PyObject *, PyObject *);}
static PyObject *meth_QUdpSocket_writeDatagram(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        const char* a0;
        Py_ssize_t a1;
        const ::QHostAddress* a2;
        int a2State = 0;
        ::quint16 a3;
        ::QUdpSocket *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "BkJ1t", &sipSelf, sipType_QUdpSocket, &sipCpp, &a0, &a1, sipType_QHostAddress, &a2, &a2State, &a3))
        {
            ::qint64 sipRes;

            Py_BEGIN_ALLOW_THREADS
            sipRes = sipCpp->writeDatagram(a0, (long long)a1, *a2, a3);
            Py_END_ALLOW_THREADS
            sipReleaseType(const_cast< ::QHostAddress *>(a2), sipType_QHostAddress, a2State);

            return PyLong_FromLongLong(sipRes);
        }
    }

    {
        const ::QByteArray* a0;
        int a0State = 0;
        const ::QHostAddress* a1;
        int a1State = 0;
        ::quint16 a2;
        ::QUdpSocket *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "BJ1J1t", &sipSelf, sipType_QUdpSocket, &sipCpp, sipType_QByteArray, &a0, &a0State, sipType_QHostAddress, &a1, &a1State, &a2))
        {
            ::qint64 sipRes;

            Py_BEGIN_ALLOW_THREADS
            sipRes = sipCpp->writeDatagram(*a0, *a1, a2);
            Py_END_ALLOW_THREADS
            sipReleaseType(const_cast< ::QByteArray *>(a0), sipType_QByteArray, a0State);
            sipReleaseType(const_cast< ::QHostAddress *>(a1), sipType_QHostAddress, a1State);

            return PyLong_FromLongLong(sipRes);
        }
    }

    {
        const ::QNetworkDatagram* a0;
        ::QUdpSocket *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "BJ9", &sipSelf, sipType_QUdpSocket, &sipCpp, sipType_QNetworkDatagram, &a0))
        {
            ::qint64 sipRes;

            Py_BEGIN_ALLOW_THREADS
            sipRes = sipCpp->writeDatagram(*a0);
            Py_END_ALLOW_THREADS

            return PyLong_FromLongLong(sipRes);
        }
    }

    sipNoMethod(sipParseErr, sipName_QUdpSocket, sipName_writeDatagram, doc_QUdpSocket_writeDatagram);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_QUdpSocket_joinMulticastGroup, "joinMulticastGroup(self, groupAddress: Union[QHostAddress, QHostAddress.SpecialAddress]) -> bool\n"
"joinMulticastGroup(self, groupAddress: Union[QHostAddress, QHostAddress.SpecialAddress], iface: QNetworkInterface) -> bool");

extern "C" {static PyObject *meth_QUdpSocket_joinMulticastGroup(PyObject *, PyObject *);}
static PyObject *meth_QUdpSocket_joinMulticastGroup(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        const ::QHostAddress* a0;
        int a0State = 0;
        ::QUdpSocket *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "BJ1", &sipSelf, sipType_QUdpSocket, &sipCpp, sipType_QHostAddress, &a0, &a0State))
        {
            bool sipRes;

            sipRes = sipCpp->joinMulticastGroup(*a0);
            sipReleaseType(const_cast< ::QHostAddress *>(a0), sipType_QHostAddress, a0State);

            return PyBool_FromLong(sipRes);
        }
    }

    {
        const ::QHostAddress* a0;
        int a0State = 0;
        const ::QNetworkInterface* a1;
        ::QUdpSocket *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "BJ1J9", &sipSelf, sipType_QUdpSocket, &sipCpp, sipType_QHostAddress, &a0, &a0State, sipType_QNetworkInterface, &a1))
        {
            bool sipRes;

            sipRes = sipCpp->joinMulticastGroup(*a0, *a1);
            sipReleaseType(const_cast< ::QHostAddress *>(a0), sipType_QHostAddress, a0State);

            return PyBool_FromLong(sipRes);
        }
    }

    sipNoMethod(sipParseErr, sipName_QUdpSocket, sipName_joinMulticastGroup, doc_QUdpSocket_joinMulticastGroup);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_QUdpSocket_leaveMulticastGroup, "leaveMulticastGroup(self, groupAddress: Union[QHostAddress, QHostAddress.SpecialAddress]) -> bool\n"
"leaveMulticastGroup(self, groupAddress: Union[QHostAddress, QHostAddress.SpecialAddress], iface: QNetworkInterface) -> bool");

extern "C" {static PyObject *meth_QUdpSocket_leaveMulticastGroup(PyObject *, PyObject *);}
static PyObject *meth_QUdpSocket_leaveMulticastGroup(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        const ::QHostAddress* a0;
        int a0State = 0;
        ::QUdpSocket *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "BJ1", &sipSelf, sipType_QUdpSocket, &sipCpp, sipType_QHostAddress, &a0, &a0State))
        {
            bool sipRes;

            sipRes = sipCpp->leaveMulticastGroup(*a0);
            sipReleaseType(const_cast< ::QHostAddress *>(a0), sipType_QHostAddress, a0State);

            return PyBool_FromLong(sipRes);
        }
    }

    {
        const ::QHostAddress* a0;
        int a0State = 0;
        const ::QNetworkInterface* a1;
        ::QUdpSocket *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "BJ1J9", &sipSelf, sipType_QUdpSocket, &sipCpp, sipType_QHostAddress, &a0, &a0State, sipType_QNetworkInterface, &a1))
        {
            bool sipRes;

            sipRes = sipCpp->leaveMulticastGroup(*a0, *a1);
            sipReleaseType(const_cast< ::QHostAddress *>(a0), sipType_QHostAddress, a0State);

            return PyBool_FromLong(sipRes);
        }
    }

    sipNoMethod(sipParseErr, sipName_QUdpSocket, sipName_leaveMulticastGroup, doc_QUdpSocket_leaveMulticastGroup);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_QUdpSocket_multicastInterface, "multicastInterface(self) -> QNetworkInterface");

extern "C" {static PyObject *meth_QUdpSocket_multicastInterface(PyObject *, PyObject *);}
static PyObject *meth_QUdpSocket_multicastInterface(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        const ::QUdpSocket *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "B", &sipSelf, sipType_QUdpSocket, &sipCpp))
        {
            ::QNetworkInterface*sipRes;

            sipRes = new ::QNetworkInterface(sipCpp->multicastInterface());

            return sipConvertFromNewType(sipRes, sipType_QNetworkInterface, SIP_NULLPTR);
        }
    }

    sipNoMethod(sipParseErr, sipName_QUdpSocket, sipName_multicastInterface, doc_QUdpSocket_multicastInterface);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_QUdpSocket_setMulticastInterface, "setMulticastInterface(self, iface: QNetworkInterface)");

extern "C" {static PyObject *meth_QUdpSocket_setMulticastInterface(PyObject *, PyObject *);}
static PyObject *meth_QUdpSocket_setMulticastInterface(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        const ::QNetworkInterface* a0;
        ::QUdpSocket *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "BJ9", &sipSelf, sipType_QUdpSocket, &sipCpp, sipType_QNetworkInterface, &a0))
        {
            sipCpp->setMulticastInterface(*a0);

            Py_INCREF(Py_None);
            return Py_None;
        }
    }

    sipNoMethod(sipParseErr, sipName_QUdpSocket, sipName_setMulticastInterface, doc_QUdpSocket_setMulticastInterface);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_QUdpSocket_receiveDatagram, "receiveDatagram(self, maxSize: int = -1) -> QNetworkDatagram");

extern "C" {static PyObject *meth_QUdpSocket_receiveDatagram(PyObject *, PyObject *, PyObject *);}
static PyObject *meth_QUdpSocket_receiveDatagram(PyObject *sipSelf, PyObject *sipArgs, PyObject *sipKwds)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        ::qint64 a0 = -1;
        ::QUdpSocket *sipCpp;

        static const char *sipKwdList[] = {
            sipName_maxSize,
        };

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, sipKwdList, SIP_NULLPTR, "B|n", &sipSelf, sipType_QUdpSocket, &sipCpp, &a0))
        {
            ::QNetworkDatagram*sipRes;

            Py_BEGIN_ALLOW_THREADS
            sipRes = new ::QNetworkDatagram(sipCpp->receiveDatagram(a0));
            Py_END_ALLOW_THREADS

            return sipConvertFromNewType(sipRes, sipType_QNetworkDatagram, SIP_NULLPTR);
        }
    }

    sipNoMethod(sipParseErr, sipName_QUdpSocket, sipName_receiveDatagram, doc_QUdpSocket_receiveDatagram);

    return SIP_NULLPTR;
}


/* Cast a pointer to a type somewhere in its inheritance hierarchy. */
extern "C" {static void *cast_QUdpSocket(void *, const sipTypeDef *);}
static void *cast_QUdpSocket(void *sipCppV, const sipTypeDef *targetType)
{
    ::QUdpSocket *sipCpp = reinterpret_cast< ::QUdpSocket *>(sipCppV);

    if (targetType == sipType_QUdpSocket)
        return sipCppV;

    sipCppV = ((const sipClassTypeDef *)sipType_QAbstractSocket)->ctd_cast(static_cast< ::QAbstractSocket *>(sipCpp), targetType);
    if (sipCppV)
        return sipCppV;

    return SIP_NULLPTR;
}


/* Call the instance's destructor. */
extern "C" {static void release_QUdpSocket(void *, int);}
static void release_QUdpSocket(void *sipCppV, int)
{
    ::QUdpSocket *sipCpp = reinterpret_cast< ::QUdpSocket *>(sipCppV);

    if (QThread::currentThread() == sipCpp->thread())
        delete sipCpp;
    else
        sipCpp->deleteLater();
}


extern "C" {static void *array_QUdpSocket(Py_ssize_t);}
static void *array_QUdpSocket(Py_ssize_t sipNrElem)
{
    return new ::QUdpSocket[sipNrElem];
}


extern "C" {static void array_delete_QUdpSocket(void *);}
static void array_delete_QUdpSocket(void *sipCpp)
{
    delete[] reinterpret_cast< ::QUdpSocket *>(sipCpp);
}


extern "C" {static void dealloc_QUdpSocket(sipSimpleWrapper *);}
static void dealloc_QUdpSocket(sipSimpleWrapper *sipSelf)
{
    if (sipIsDerivedClass(sipSelf))
        reinterpret_cast<sipQUdpSocket *>(sipGetAddress(sipSelf))->sipPySelf = SIP_NULLPTR;

    if (sipIsOwnedByPython(sipSelf))
    {
        release_QUdpSocket(sipGetAddress(sipSelf), sipIsDerivedClass(sipSelf));
    }
}


extern "C" {static void *init_type_QUdpSocket(sipSimpleWrapper *, PyObject *, PyObject *, PyObject **, PyObject **, PyObject **);}
static void *init_type_QUdpSocket(sipSimpleWrapper *sipSelf, PyObject *sipArgs, PyObject *sipKwds, PyObject **sipUnused, PyObject **sipOwner, PyObject **sipParseErr)
{
    sipQUdpSocket *sipCpp = SIP_NULLPTR;

    {
        ::QObject* a0 = 0;

        static const char *sipKwdList[] = {
            sipName_parent,
        };

        if (sipParseKwdArgs(sipParseErr, sipArgs, sipKwds, sipKwdList, sipUnused, "|JH", sipType_QObject, &a0, sipOwner))
        {
            sipCpp = new sipQUdpSocket(a0);

            sipCpp->sipPySelf = sipSelf;

            return sipCpp;
        }
    }

    return SIP_NULLPTR;
}


/* Define this type's super-types. */
static sipEncodedTypeDef supers_QUdpSocket[] = {{1, 255, 1}};


static PyMethodDef methods_QUdpSocket[] = {
    {sipName_hasPendingDatagrams, meth_QUdpSocket_hasPendingDatagrams, METH_VARARGS, doc_QUdpSocket_hasPendingDatagrams},
    {sipName_joinMulticastGroup, meth_QUdpSocket_joinMulticastGroup, METH_VARARGS, doc_QUdpSocket_joinMulticastGroup},
    {sipName_leaveMulticastGroup, meth_QUdpSocket_leaveMulticastGroup, METH_VARARGS, doc_QUdpSocket_leaveMulticastGroup},
    {sipName_multicastInterface, meth_QUdpSocket_multicastInterface, METH_VARARGS, doc_QUdpSocket_multicastInterface},
    {sipName_pendingDatagramSize, meth_QUdpSocket_pendingDatagramSize, METH_VARARGS, doc_QUdpSocket_pendingDatagramSize},
    {sipName_readDatagram, SIP_MLMETH_CAST(meth_QUdpSocket_readDatagram), METH_VARARGS|METH_KEYWORDS, doc_QUdpSocket_readDatagram},
    {sipName_receiveDatagram, SIP_MLMETH_CAST(meth_QUdpSocket_receiveDatagram), METH_VARARGS|METH_KEYWORDS, doc_QUdpSocket_receiveDatagram},
    {sipName_setMulticastInterface, meth_QUdpSocket_setMulticastInterface, METH_VARARGS, doc_QUdpSocket_setMulticastInterface},
    {sipName_writeDatagram, meth_QUdpSocket_writeDatagram, METH_VARARGS, doc_QUdpSocket_writeDatagram}
};

PyDoc_STRVAR(doc_QUdpSocket, "\1QUdpSocket(parent: Optional[QObject] = None)");


static pyqt5ClassPluginDef plugin_QUdpSocket = {
    &::QUdpSocket::staticMetaObject,
    0,
    SIP_NULLPTR,
    SIP_NULLPTR
};


sipClassTypeDef sipTypeDef_QtNetwork_QUdpSocket = {
    {
        -1,
        SIP_NULLPTR,
        SIP_NULLPTR,
        SIP_TYPE_SCC|SIP_TYPE_SUPER_INIT|SIP_TYPE_LIMITED_API|SIP_TYPE_CLASS,
        sipNameNr_QUdpSocket,
        SIP_NULLPTR,
        &plugin_QUdpSocket,
    },
    {
        sipNameNr_QUdpSocket,
        {0, 0, 1},
        9, methods_QUdpSocket,
        0, SIP_NULLPTR,
        0, SIP_NULLPTR,
        {SIP_NULLPTR, SIP_NULLPTR, SIP_NULLPTR, SIP_NULLPTR, SIP_NULLPTR, SIP_NULLPTR, SIP_NULLPTR, SIP_NULLPTR, SIP_NULLPTR, SIP_NULLPTR},
    },
    doc_QUdpSocket,
    -1,
    -1,
    supers_QUdpSocket,
    SIP_NULLPTR,
    init_type_QUdpSocket,
    SIP_NULLPTR,
    SIP_NULLPTR,
    SIP_NULLPTR,
    SIP_NULLPTR,
    dealloc_QUdpSocket,
    SIP_NULLPTR,
    array_QUdpSocket,
    SIP_NULLPTR,
    release_QUdpSocket,
    cast_QUdpSocket,
    SIP_NULLPTR,
    SIP_NULLPTR,
    SIP_NULLPTR,
    SIP_NULLPTR,
    SIP_NULLPTR,
    SIP_NULLPTR,
    array_delete_QUdpSocket,
    sizeof (::QUdpSocket),
};
