/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.search.aggregations.matrix.stats;

import java.io.IOException;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import org.opensearch.OpenSearchException;
import org.opensearch.core.common.io.stream.StreamInput;
import org.opensearch.core.common.io.stream.StreamOutput;
import org.opensearch.core.common.io.stream.Writeable;
import org.opensearch.search.aggregations.matrix.stats.RunningStats;

class MatrixStatsResults
implements Writeable {
    protected final RunningStats results;
    protected final Map<String, Map<String, Double>> correlation;

    MatrixStatsResults(String[] fieldNames) {
        this.results = new RunningStats(fieldNames);
        this.correlation = new HashMap<String, Map<String, Double>>();
    }

    MatrixStatsResults(RunningStats stats) {
        this.results = stats.clone();
        this.correlation = new HashMap<String, Map<String, Double>>();
        this.compute();
    }

    protected MatrixStatsResults(StreamInput in) {
        try {
            this.results = new RunningStats(in);
            this.correlation = (Map)in.readGenericValue();
        }
        catch (IOException e) {
            throw new OpenSearchException("Error trying to create multifield_stats results from stream input", (Throwable)e, new Object[0]);
        }
    }

    public void writeTo(StreamOutput out) throws IOException {
        this.results.writeTo(out);
        out.writeGenericValue(this.correlation);
    }

    public final long getDocCount() {
        return this.results.docCount;
    }

    protected Map<String, Long> getFieldCounts() {
        if (this.results.usesMaps()) {
            return Collections.unmodifiableMap(this.results.counts);
        }
        return Collections.unmodifiableMap(this.results.convertLongArrayToMap(this.results.countsArr));
    }

    public long getFieldCount(String field) {
        Map<String, Long> counts = this.getFieldCounts();
        if (!counts.containsKey(field)) {
            return 0L;
        }
        return counts.get(field);
    }

    private Map<String, Double> getMapHelper(RunningStats results, Map<String, Double> map, double[] array) {
        if (results.usesMaps()) {
            return Collections.unmodifiableMap(map);
        }
        return Collections.unmodifiableMap(results.convertDoubleArrayToMap(array));
    }

    protected Map<String, Double> getMeans() {
        return this.getMapHelper(this.results, this.results.means, this.results.meansArr);
    }

    public double getMean(String field) {
        Map<String, Double> means = this.getMeans();
        this.checkField(field, means);
        return means.get(field);
    }

    protected Map<String, Double> getVariances() {
        return this.getMapHelper(this.results, this.results.variances, this.results.variancesArr);
    }

    public double getVariance(String field) {
        Map<String, Double> variances = this.getVariances();
        this.checkField(field, variances);
        return variances.get(field);
    }

    protected Map<String, Double> getSkewness() {
        return this.getMapHelper(this.results, this.results.skewness, this.results.skewnessArr);
    }

    public double getSkewness(String field) {
        Map<String, Double> skewness = this.getSkewness();
        this.checkField(field, skewness);
        return skewness.get(field);
    }

    protected Map<String, Double> getKurtosis() {
        return this.getMapHelper(this.results, this.results.kurtosis, this.results.kurtosisArr);
    }

    public double getKurtosis(String field) {
        Map<String, Double> kurtosis = this.getKurtosis();
        this.checkField(field, kurtosis);
        return kurtosis.get(field);
    }

    protected Map<String, Map<String, Double>> getCovariances() {
        return Collections.unmodifiableMap(this.results.covariances);
    }

    public double getCovariance(String fieldX, String fieldY) {
        Map<String, Double> variances = this.getVariances();
        if (fieldX.equals(fieldY)) {
            this.checkField(fieldX, variances);
            return variances.get(fieldX);
        }
        return MatrixStatsResults.getValFromUpperTriangularMatrix(this.getCovariances(), fieldX, fieldY);
    }

    protected Map<String, Map<String, Double>> getCorrelations() {
        return Collections.unmodifiableMap(this.correlation);
    }

    public Double getCorrelation(String fieldX, String fieldY) {
        if (fieldX.equals(fieldY)) {
            return 1.0;
        }
        return MatrixStatsResults.getValFromUpperTriangularMatrix(this.correlation, fieldX, fieldY);
    }

    static <M extends Map<String, Double>> double getValFromUpperTriangularMatrix(Map<String, M> map, String fieldX, String fieldY) {
        if (!map.containsKey(fieldX) && !map.containsKey(fieldY)) {
            throw new IllegalArgumentException("neither field " + fieldX + " nor " + fieldY + " exist");
        }
        if (map.containsKey(fieldX)) {
            if (((Map)map.get(fieldX)).containsKey(fieldY)) {
                return (Double)((Map)map.get(fieldX)).get(fieldY);
            }
            return (Double)((Map)map.get(fieldY)).get(fieldX);
        }
        if (map.containsKey(fieldY)) {
            return (Double)((Map)map.get(fieldY)).get(fieldX);
        }
        throw new IllegalArgumentException("Coefficient not computed between fields: " + fieldX + " and " + fieldY);
    }

    private void checkField(String field, Map<String, ?> map) {
        if (field == null) {
            throw new IllegalArgumentException("field name cannot be null");
        }
        if (!map.containsKey(field)) {
            throw new IllegalArgumentException("field " + field + " does not exist");
        }
    }

    private void compute() {
        if (!this.results.usesMaps()) {
            this.results.switchToMaps();
        }
        double nM1 = (double)this.results.docCount - 1.0;
        for (String fieldName : this.results.means.keySet()) {
            double var = this.results.variances.get(fieldName);
            this.results.skewness.put(fieldName, Math.sqrt(this.results.docCount) * this.results.skewness.get(fieldName) / Math.pow(var, 1.5));
            this.results.kurtosis.put(fieldName, (double)this.results.docCount * this.results.kurtosis.get(fieldName) / (var * var));
            this.results.variances.put(fieldName, this.results.variances.get(fieldName) / nM1);
        }
        for (Map.Entry<String, Map<String, Double>> row : this.results.covariances.entrySet()) {
            String rowName = row.getKey();
            Map<String, Double> covRow = row.getValue();
            HashMap<String, Double> corRow = new HashMap<String, Double>();
            for (Map.Entry<String, Double> col : covRow.entrySet()) {
                double cor;
                String colName = col.getKey();
                covRow.put(colName, covRow.get(colName) / nM1);
                if (this.results.variances.get(rowName) == 0.0 || this.results.variances.get(colName) == 0.0) {
                    cor = Double.NaN;
                } else {
                    double corDen = Math.sqrt(this.results.variances.get(rowName)) * Math.sqrt(this.results.variances.get(colName));
                    cor = covRow.get(colName) / corDen;
                }
                corRow.put(colName, cor);
            }
            this.results.covariances.put(rowName, covRow);
            this.correlation.put(rowName, corRow);
        }
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        MatrixStatsResults that = (MatrixStatsResults)o;
        return Objects.equals(this.results, that.results) && Objects.equals(this.correlation, that.correlation);
    }

    public int hashCode() {
        return Objects.hash(this.results, this.correlation);
    }
}

