/*
 * Decompiled with CFR 0.152.
 */
package com.github.kokorin.jaffree.ffprobe;

import com.github.kokorin.jaffree.Rational;
import com.github.kokorin.jaffree.StreamType;
import com.github.kokorin.jaffree.ffprobe.FrameSubtitle;
import com.github.kokorin.jaffree.ffprobe.Log;
import com.github.kokorin.jaffree.ffprobe.PacketFrameSubtitle;
import com.github.kokorin.jaffree.ffprobe.SideData;
import com.github.kokorin.jaffree.ffprobe.TagAware;
import com.github.kokorin.jaffree.ffprobe.data.ProbeData;
import java.util.List;

public class Frame
implements TagAware,
FrameSubtitle,
PacketFrameSubtitle {
    private final ProbeData probeData;

    public Frame(ProbeData probeData) {
        this.probeData = probeData;
    }

    @Override
    public ProbeData getProbeData() {
        return this.probeData;
    }

    public List<Log> getLogs() {
        return this.probeData.getSubDataList("logs", Log::new);
    }

    public List<SideData> getSideDataList() {
        return this.probeData.getSubDataList("side_data_list", SideData::new);
    }

    public Long getPts() {
        return this.probeData.getLong("pts");
    }

    public Float getPtsTime() {
        return this.probeData.getFloat("pts_time");
    }

    public StreamType getMediaType() {
        return this.probeData.getStreamType("media_type");
    }

    public Integer getStreamIndex() {
        return this.probeData.getInteger("stream_index");
    }

    public Boolean getKeyFrame() {
        return this.probeData.getBoolean("key_frame");
    }

    public Long getPktPts() {
        return this.probeData.getLong("pkt_pts");
    }

    public Float getPktPtsTime() {
        return this.probeData.getFloat("pkt_pts_time");
    }

    public Long getPktDts() {
        return this.probeData.getLong("pkt_dts");
    }

    public Float getPktDtsTime() {
        return this.probeData.getFloat("pkt_dts_time");
    }

    public Long getBestEffortTimestamp() {
        return this.probeData.getLong("best_effort_timestamp");
    }

    public Float getBestEffortTimestampTime() {
        return this.probeData.getFloat("best_effort_timestamp_time");
    }

    public Long getPktDuration() {
        return this.probeData.getLong("pkt_duration");
    }

    public Float getPktDurationTime() {
        return this.probeData.getFloat("pkt_duration_time");
    }

    public Long getPktPos() {
        return this.probeData.getLong("pkt_pos");
    }

    public Integer getPktSize() {
        return this.probeData.getInteger("pkt_size");
    }

    public String getSampleFmt() {
        return this.probeData.getString("sample_fmt");
    }

    public Long getNbSamples() {
        return this.probeData.getLong("nb_samples");
    }

    public Integer getChannels() {
        return this.probeData.getInteger("channels");
    }

    public String getChannelLayout() {
        return this.probeData.getString("channel_layout");
    }

    public Long getWidth() {
        return this.probeData.getLong("width");
    }

    public Long getHeight() {
        return this.probeData.getLong("height");
    }

    public String getPixFmt() {
        return this.probeData.getString("pix_fmt");
    }

    public Rational getSampleAspectRatio() {
        return this.probeData.getRatio("sample_aspect_ratio");
    }

    public String getPictType() {
        return this.probeData.getString("pict_type");
    }

    public Long getCodedPictureNumber() {
        return this.probeData.getLong("coded_picture_number");
    }

    public Long getDisplayPictureNumber() {
        return this.probeData.getLong("display_picture_number");
    }

    public Boolean getInterlacedFrame() {
        return this.probeData.getBoolean("interlaced_frame");
    }

    public Boolean getTopFieldFirst() {
        return this.probeData.getBoolean("top_field_first");
    }

    public Integer getRepeatPict() {
        return this.probeData.getInteger("repeat_pict");
    }
}

