/* ----------------------------------------------------------------------------
 * This file was automatically generated by SWIG (https://www.swig.org).
 * Version 4.4.0
 *
 * Do not make changes to this file unless you know what you are doing - modify
 * the SWIG interface file instead.
 * ----------------------------------------------------------------------------- */

package org.itk.simple;
/**

Segments structures in images based on intensity values.


IMPORTANT
The SegmentationLevelSetImageFilter class and the ThresholdSegmentationLevelSetFunction class contain additional information necessary to the full
understanding of how to use this filter.
OVERVIEW
This class is a level set method segmentation filter. It constructs a
speed function which is close to zero at the upper and lower bounds of
an intensity window, effectively locking the propagating front onto
those edges. Elsewhere, the front will propagate quickly.
INPUTS
This filter requires two inputs. The first input is a seed image. This
seed image must contain an isosurface that you want to use as the seed
for your segmentation. It can be a binary, graylevel, or floating
point image. The only requirement is that it contain a closed
isosurface that you will identify as the seed by setting the
IsosurfaceValue parameter of the filter. For a binary image you will
want to set your isosurface value halfway between your on and off
values (i.e. for 0's and 1's, use an isosurface value of 0.5).

The second input is the feature image. This is the image from which
the speed function will be calculated. For most applications, this is
the image that you want to segment. The desired isosurface in your
seed image should lie within the region of your feature image that you
are trying to segment. Note that this filter does no preprocessing of
the feature image before thresholding.

See SegmentationLevelSetImageFilter for more information on Inputs.
OUTPUTS
The filter outputs a single, scalar, real-valued image. Positive
values in the output image are inside the segmented region and
negative values in the image are outside of the inside region. The
zero crossings of the image correspond to the position of the level
set front.

See SparseFieldLevelSetImageFilter and SegmentationLevelSetImageFilter for more information.
PARAMETERS
In addition to parameters described in SegmentationLevelSetImageFilter , this filter adds the UpperThreshold and LowerThreshold. See ThresholdSegmentationLevelSetFunction for a description of how these values affect the segmentation.

See:
 SegmentationLevelSetImageFilter

 ThresholdSegmentationLevelSetFunction ,

 SparseFieldLevelSetImageFilter

 itk::simple::ThresholdSegmentationLevelSet for the procedural interface

 itk::ThresholdSegmentationLevelSetImageFilter for the Doxygen on the original ITK class.


C++ includes: sitkThresholdSegmentationLevelSetImageFilter.h
*/
public class ThresholdSegmentationLevelSetImageFilter extends ImageFilter {
  private transient long swigCPtr;

  protected ThresholdSegmentationLevelSetImageFilter(long cPtr, boolean cMemoryOwn) {
    super(SimpleITKJNI.ThresholdSegmentationLevelSetImageFilter_SWIGUpcast(cPtr), cMemoryOwn);
    swigCPtr = cPtr;
  }

  protected static long getCPtr(ThresholdSegmentationLevelSetImageFilter obj) {
    return (obj == null) ? 0 : obj.swigCPtr;
  }

  protected static long swigRelease(ThresholdSegmentationLevelSetImageFilter obj) {
    long ptr = 0;
    if (obj != null) {
      if (!obj.swigCMemOwn)
        throw new RuntimeException("Cannot release ownership as memory is not owned");
      ptr = obj.swigCPtr;
      obj.swigCMemOwn = false;
      obj.delete();
    }
    return ptr;
  }

  @SuppressWarnings({"deprecation", "removal"})
  protected void finalize() {
    delete();
  }

  /**
virtual itk::simple::ThresholdSegmentationLevelSetImageFilter::~ThresholdSegmentationLevelSetImageFilter()

Destructor

*/
public  void delete() {
    if (swigCPtr != 0) {
      if (swigCMemOwn) {
        swigCMemOwn = false;
        SimpleITKJNI.delete_ThresholdSegmentationLevelSetImageFilter(swigCPtr);
      }
      swigCPtr = 0;
    }
    super.delete();
  }

  /**
itk::simple::ThresholdSegmentationLevelSetImageFilter::ThresholdSegmentationLevelSetImageFilter()

Default Constructor that takes no arguments and initializes default
parameters

*/
public  ThresholdSegmentationLevelSetImageFilter() {
    this(SimpleITKJNI.new_ThresholdSegmentationLevelSetImageFilter(), true);
  }

  /**
Self&amp; itk::simple::ThresholdSegmentationLevelSetImageFilter::SetLowerThreshold(double LowerThreshold)
*/
public  void setLowerThreshold(double LowerThreshold) {
    SimpleITKJNI.ThresholdSegmentationLevelSetImageFilter_setLowerThreshold(swigCPtr, this, LowerThreshold);
  }

  /**
double itk::simple::ThresholdSegmentationLevelSetImageFilter::GetLowerThreshold() const
*/
public  double getLowerThreshold() {
    return SimpleITKJNI.ThresholdSegmentationLevelSetImageFilter_getLowerThreshold(swigCPtr, this);
  }

  /**
Self&amp; itk::simple::ThresholdSegmentationLevelSetImageFilter::SetUpperThreshold(double UpperThreshold)

Get/Set the threshold values that will be used to calculate the speed
function.

*/
public  void setUpperThreshold(double UpperThreshold) {
    SimpleITKJNI.ThresholdSegmentationLevelSetImageFilter_setUpperThreshold(swigCPtr, this, UpperThreshold);
  }

  /**
double itk::simple::ThresholdSegmentationLevelSetImageFilter::GetUpperThreshold() const
*/
public  double getUpperThreshold() {
    return SimpleITKJNI.ThresholdSegmentationLevelSetImageFilter_getUpperThreshold(swigCPtr, this);
  }

  /**
Self&amp; itk::simple::ThresholdSegmentationLevelSetImageFilter::SetMaximumRMSError(double MaximumRMSError)
*/
public  void setMaximumRMSError(double MaximumRMSError) {
    SimpleITKJNI.ThresholdSegmentationLevelSetImageFilter_setMaximumRMSError(swigCPtr, this, MaximumRMSError);
  }

  /**
double itk::simple::ThresholdSegmentationLevelSetImageFilter::GetMaximumRMSError() const
*/
public  double getMaximumRMSError() {
    return SimpleITKJNI.ThresholdSegmentationLevelSetImageFilter_getMaximumRMSError(swigCPtr, this);
  }

  /**
Self&amp; itk::simple::ThresholdSegmentationLevelSetImageFilter::SetPropagationScaling(double PropagationScaling)
*/
public  void setPropagationScaling(double PropagationScaling) {
    SimpleITKJNI.ThresholdSegmentationLevelSetImageFilter_setPropagationScaling(swigCPtr, this, PropagationScaling);
  }

  /**
double itk::simple::ThresholdSegmentationLevelSetImageFilter::GetPropagationScaling() const
*/
public  double getPropagationScaling() {
    return SimpleITKJNI.ThresholdSegmentationLevelSetImageFilter_getPropagationScaling(swigCPtr, this);
  }

  /**
Self&amp; itk::simple::ThresholdSegmentationLevelSetImageFilter::SetCurvatureScaling(double CurvatureScaling)
*/
public  void setCurvatureScaling(double CurvatureScaling) {
    SimpleITKJNI.ThresholdSegmentationLevelSetImageFilter_setCurvatureScaling(swigCPtr, this, CurvatureScaling);
  }

  /**
double itk::simple::ThresholdSegmentationLevelSetImageFilter::GetCurvatureScaling() const
*/
public  double getCurvatureScaling() {
    return SimpleITKJNI.ThresholdSegmentationLevelSetImageFilter_getCurvatureScaling(swigCPtr, this);
  }

  /**
Self&amp; itk::simple::ThresholdSegmentationLevelSetImageFilter::SetNumberOfIterations(uint32_t NumberOfIterations)
*/
public  void setNumberOfIterations(long NumberOfIterations) {
    SimpleITKJNI.ThresholdSegmentationLevelSetImageFilter_setNumberOfIterations(swigCPtr, this, NumberOfIterations);
  }

  /**
uint32_t itk::simple::ThresholdSegmentationLevelSetImageFilter::GetNumberOfIterations() const
*/
public  long getNumberOfIterations() {
    return SimpleITKJNI.ThresholdSegmentationLevelSetImageFilter_getNumberOfIterations(swigCPtr, this);
  }

  /**
Self&amp; itk::simple::ThresholdSegmentationLevelSetImageFilter::SetReverseExpansionDirection(bool ReverseExpansionDirection)
*/
public  void setReverseExpansionDirection(boolean ReverseExpansionDirection) {
    SimpleITKJNI.ThresholdSegmentationLevelSetImageFilter_setReverseExpansionDirection(swigCPtr, this, ReverseExpansionDirection);
  }

  /**
Self&amp; itk::simple::ThresholdSegmentationLevelSetImageFilter::ReverseExpansionDirectionOn()

Set the value of ReverseExpansionDirection to true or false
respectfully.

*/
public  void reverseExpansionDirectionOn() {
    SimpleITKJNI.ThresholdSegmentationLevelSetImageFilter_reverseExpansionDirectionOn(swigCPtr, this);
  }

  /**
Self&amp; itk::simple::ThresholdSegmentationLevelSetImageFilter::ReverseExpansionDirectionOff()
*/
public  void reverseExpansionDirectionOff() {
    SimpleITKJNI.ThresholdSegmentationLevelSetImageFilter_reverseExpansionDirectionOff(swigCPtr, this);
  }

  /**
bool itk::simple::ThresholdSegmentationLevelSetImageFilter::GetReverseExpansionDirection() const
*/
public  boolean getReverseExpansionDirection() {
    return SimpleITKJNI.ThresholdSegmentationLevelSetImageFilter_getReverseExpansionDirection(swigCPtr, this);
  }

  /**
uint32_t itk::simple::ThresholdSegmentationLevelSetImageFilter::GetElapsedIterations() const

Number of iterations run.


This is a measurement. Its value is updated in the Execute methods, so
the value will only be valid after an execution.

*/
public  long getElapsedIterations() {
    return SimpleITKJNI.ThresholdSegmentationLevelSetImageFilter_getElapsedIterations(swigCPtr, this);
  }

  /**
double itk::simple::ThresholdSegmentationLevelSetImageFilter::GetRMSChange() const

The Root Mean Square of the levelset upon termination.


This is a measurement. Its value is updated in the Execute methods, so
the value will only be valid after an execution.

*/
public  double getRMSChange() {
    return SimpleITKJNI.ThresholdSegmentationLevelSetImageFilter_getRMSChange(swigCPtr, this);
  }

  /**
std::string itk::simple::ThresholdSegmentationLevelSetImageFilter::GetName() const

Name of this class

*/
public  String getName() {
    return SimpleITKJNI.ThresholdSegmentationLevelSetImageFilter_getName(swigCPtr, this);
  }

  /**
std::string itk::simple::ThresholdSegmentationLevelSetImageFilter::ToString() const

Print ourselves out

*/
public  String toString() {
    return SimpleITKJNI.ThresholdSegmentationLevelSetImageFilter_toString(swigCPtr, this);
  }

  /**
Image itk::simple::ThresholdSegmentationLevelSetImageFilter::Execute(Image &amp;&amp;initialImage, const Image &amp;featureImage)

Execute the filter on the input image

*/
public  Image execute(Image initialImage, Image featureImage) {
    return new Image(SimpleITKJNI.ThresholdSegmentationLevelSetImageFilter_execute(swigCPtr, this, Image.getCPtr(initialImage), initialImage, Image.getCPtr(featureImage), featureImage), true);
  }

}
