﻿/**
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * SPDX-License-Identifier: Apache-2.0.
 */

#pragma once
#include <aws/core/utils/memory/stl/AWSString.h>
#include <aws/core/utils/memory/stl/AWSVector.h>
#include <aws/lightsail/Lightsail_EXPORTS.h>
#include <aws/lightsail/model/RelationalDatabaseBundle.h>

#include <utility>

namespace Aws {
template <typename RESULT_TYPE>
class AmazonWebServiceResult;

namespace Utils {
namespace Json {
class JsonValue;
}  // namespace Json
}  // namespace Utils
namespace Lightsail {
namespace Model {
class GetRelationalDatabaseBundlesResult {
 public:
  AWS_LIGHTSAIL_API GetRelationalDatabaseBundlesResult() = default;
  AWS_LIGHTSAIL_API GetRelationalDatabaseBundlesResult(const Aws::AmazonWebServiceResult<Aws::Utils::Json::JsonValue>& result);
  AWS_LIGHTSAIL_API GetRelationalDatabaseBundlesResult& operator=(const Aws::AmazonWebServiceResult<Aws::Utils::Json::JsonValue>& result);

  ///@{
  /**
   * <p>An object describing the result of your get relational database bundles
   * request.</p>
   */
  inline const Aws::Vector<RelationalDatabaseBundle>& GetBundles() const { return m_bundles; }
  template <typename BundlesT = Aws::Vector<RelationalDatabaseBundle>>
  void SetBundles(BundlesT&& value) {
    m_bundlesHasBeenSet = true;
    m_bundles = std::forward<BundlesT>(value);
  }
  template <typename BundlesT = Aws::Vector<RelationalDatabaseBundle>>
  GetRelationalDatabaseBundlesResult& WithBundles(BundlesT&& value) {
    SetBundles(std::forward<BundlesT>(value));
    return *this;
  }
  template <typename BundlesT = RelationalDatabaseBundle>
  GetRelationalDatabaseBundlesResult& AddBundles(BundlesT&& value) {
    m_bundlesHasBeenSet = true;
    m_bundles.emplace_back(std::forward<BundlesT>(value));
    return *this;
  }
  ///@}

  ///@{
  /**
   * <p>The token to advance to the next page of results from your request.</p> <p>A
   * next page token is not returned if there are no more results to display.</p>
   * <p>To get the next page of results, perform another
   * <code>GetRelationalDatabaseBundles</code> request and specify the next page
   * token using the <code>pageToken</code> parameter.</p>
   */
  inline const Aws::String& GetNextPageToken() const { return m_nextPageToken; }
  template <typename NextPageTokenT = Aws::String>
  void SetNextPageToken(NextPageTokenT&& value) {
    m_nextPageTokenHasBeenSet = true;
    m_nextPageToken = std::forward<NextPageTokenT>(value);
  }
  template <typename NextPageTokenT = Aws::String>
  GetRelationalDatabaseBundlesResult& WithNextPageToken(NextPageTokenT&& value) {
    SetNextPageToken(std::forward<NextPageTokenT>(value));
    return *this;
  }
  ///@}

  ///@{

  inline const Aws::String& GetRequestId() const { return m_requestId; }
  template <typename RequestIdT = Aws::String>
  void SetRequestId(RequestIdT&& value) {
    m_requestIdHasBeenSet = true;
    m_requestId = std::forward<RequestIdT>(value);
  }
  template <typename RequestIdT = Aws::String>
  GetRelationalDatabaseBundlesResult& WithRequestId(RequestIdT&& value) {
    SetRequestId(std::forward<RequestIdT>(value));
    return *this;
  }
  ///@}
 private:
  Aws::Vector<RelationalDatabaseBundle> m_bundles;

  Aws::String m_nextPageToken;

  Aws::String m_requestId;
  bool m_bundlesHasBeenSet = false;
  bool m_nextPageTokenHasBeenSet = false;
  bool m_requestIdHasBeenSet = false;
};

}  // namespace Model
}  // namespace Lightsail
}  // namespace Aws
