/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.visualvm.core.ui.components;

import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import javax.swing.BorderFactory;
import javax.swing.JLabel;
import javax.swing.JPanel;
import org.graalvm.visualvm.uisupport.SeparatorLine;

public final class SectionSeparator
extends JPanel {
    private JLabel label;

    public SectionSeparator(String text) {
        this(text, null);
    }

    public SectionSeparator(String text, Font font) {
        if (text == null) {
            throw new IllegalArgumentException("Text cannot be null");
        }
        this.initComponents(text, font);
    }

    @Override
    public void setForeground(Color foreground) {
        if (this.label == null) {
            super.setForeground(foreground);
        } else {
            this.label.setForeground(foreground);
        }
    }

    @Override
    public Color getForeground() {
        if (this.label == null) {
            return super.getForeground();
        }
        return this.label.getForeground();
    }

    @Override
    public void setFont(Font font) {
        if (this.label == null) {
            super.setFont(font);
        } else {
            this.label.setFont(font);
        }
    }

    @Override
    public Font getFont() {
        if (this.label == null) {
            return super.getFont();
        }
        return this.label.getFont();
    }

    private void initComponents(String text, Font font) {
        this.setBorder(BorderFactory.createEmptyBorder());
        this.setLayout(new GridBagLayout());
        this.setOpaque(false);
        this.label = new JLabel(text);
        this.label.setForeground(this.getForeground());
        if (font != null) {
            this.label.setFont(font);
        } else {
            this.label.setFont(this.label.getFont().deriveFont(1));
        }
        GridBagConstraints c1 = new GridBagConstraints();
        c1.weighty = 1.0;
        this.add((Component)this.label, c1);
        GridBagConstraints c2 = new GridBagConstraints();
        c2.weightx = 1.0;
        c2.fill = 2;
        c2.insets = new Insets(1, 4, 0, 0);
        this.add((Component)new SeparatorLine(), c2);
    }
}

