#!/bin/sh
export PATH='/usr/local/sbin:/usr/local/bin:/usr/bin:/usr/bin/site_perl:/usr/bin/vendor_perl:/usr/bin/core_perl'
echo 'name:                 lens
version:              5.0.1
visibility:           public
id:                   lens-5.0.1-7XUkI0pM5Tr3OUSblTWRuC
key:                  lens-5.0.1-7XUkI0pM5Tr3OUSblTWRuC
license:              BSD-2-Clause
copyright:            Copyright (C) 2012-2016 Edward A. Kmett
maintainer:           Edward A. Kmett <ekmett@gmail.com>
author:               Edward A. Kmett
stability:            provisional
homepage:             http://github.com/ekmett/lens/
synopsis:             Lenses, Folds and Traversals
description:
    This package comes \"Batteries Included\" with many useful lenses for the types
    commonly used from the Haskell Platform, and with tools for automatically
    generating lenses and isomorphisms for user-supplied data types.

    The combinators in @Control.Lens@ provide a highly generic toolbox for composing
    families of getters, folds, isomorphisms, traversals, setters and lenses and their
    indexed variants.

    An overview, with a large number of examples can be found in the <https://github.com/ekmett/lens#lens-lenses-folds-and-traversals README>.

    An introductory video on the style of code used in this library by Simon Peyton Jones is available from <http://skillsmatter.com/podcast/scala/lenses-compositional-data-access-and-manipulation Skills Matter>.

    A video on how to use lenses and how they are constructed is available on <http://youtu.be/cefnmjtAolY?hd=1 youtube>.

    Slides for that second talk can be obtained from <http://comonad.com/haskell/Lenses-Folds-and-Traversals-NYC.pdf comonad.com>.

    More information on the care and feeding of lenses, including a brief tutorial and motivation
    for their types can be found on the <https://github.com/ekmett/lens/wiki lens wiki>.

    A small game of @pong@ and other more complex examples that manage their state using lenses can be found in the <https://github.com/ekmett/lens/blob/master/examples/ example folder>.

    /Lenses, Folds and Traversals/

    With some signatures simplified, the core of the hierarchy of lens-like constructions looks like:


    <<http://i.imgur.com/ALlbPRa.png>>

    <images/Hierarchy.png (Local Copy)>

    You can compose any two elements of the hierarchy above using @(.)@ from the @Prelude@, and you can
    use any element of the hierarchy as any type it linked to above it.

    The result is their lowest upper bound in the hierarchy (or an error if that bound doesn'\''t exist).

    For instance:

    * You can use any '\''Traversal'\'' as a '\''Fold'\'' or as a '\''Setter'\''.

    * The composition of a '\''Traversal'\'' and a '\''Getter'\'' yields a '\''Fold'\''.

    /Minimizing Dependencies/

    If you want to provide lenses and traversals for your own types in your own libraries, then you
    can do so without incurring a dependency on this (or any other) lens package at all.

    /e.g./ for a data type:

    > data Foo a = Foo Int Int a

    You can define lenses such as

    > -- bar :: Lens'\'' (Foo a) Int
    > bar :: Functor f => (Int -> f Int) -> Foo a -> f (Foo a)
    > bar f (Foo a b c) = fmap (\a'\'' -> Foo a'\'' b c) (f a)

    > -- quux :: Lens (Foo a) (Foo b) a b
    > quux :: Functor f => (a -> f b) -> Foo a -> f (Foo b)
    > quux f (Foo a b c) = fmap (Foo a b) (f c)

    without the need to use any type that isn'\''t already defined in the @Prelude@.

    And you can define a traversal of multiple fields with '\''Control.Applicative.Applicative'\'':

    > -- traverseBarAndBaz :: Traversal'\'' (Foo a) Int
    > traverseBarAndBaz :: Applicative f => (Int -> f Int) -> Foo a -> f (Foo a)
    > traverseBarAndBaz f (Foo a b c) = Foo <$> f a <*> f b <*> pure c

    What is provided in this library is a number of stock lenses and traversals for
    common haskell types, a wide array of combinators for working them, and more
    exotic functionality, (/e.g./ getters, setters, indexed folds, isomorphisms).

category:             Data, Lenses, Generics
abi:                  f881fecad6d2e5b55ffc367ba8f4d085
exposed:              True
exposed-modules:
    Control.Exception.Lens Control.Lens Control.Lens.At
    Control.Lens.Combinators Control.Lens.Cons Control.Lens.Each
    Control.Lens.Empty Control.Lens.Equality Control.Lens.Extras
    Control.Lens.Fold Control.Lens.Getter Control.Lens.Indexed
    Control.Lens.Internal Control.Lens.Internal.Bazaar
    Control.Lens.Internal.ByteString Control.Lens.Internal.CTypes
    Control.Lens.Internal.Coerce Control.Lens.Internal.Context
    Control.Lens.Internal.Deque Control.Lens.Internal.Exception
    Control.Lens.Internal.FieldTH Control.Lens.Internal.Fold
    Control.Lens.Internal.Getter Control.Lens.Internal.Indexed
    Control.Lens.Internal.Instances Control.Lens.Internal.Iso
    Control.Lens.Internal.Level Control.Lens.Internal.List
    Control.Lens.Internal.Magma Control.Lens.Internal.Prism
    Control.Lens.Internal.PrismTH Control.Lens.Internal.Profunctor
    Control.Lens.Internal.Review Control.Lens.Internal.Setter
    Control.Lens.Internal.TH Control.Lens.Internal.Zoom
    Control.Lens.Iso Control.Lens.Lens Control.Lens.Level
    Control.Lens.Operators Control.Lens.Plated Control.Lens.Prism
    Control.Lens.Profunctor Control.Lens.Reified Control.Lens.Review
    Control.Lens.Setter Control.Lens.TH Control.Lens.Traversal
    Control.Lens.Tuple Control.Lens.Type Control.Lens.Unsound
    Control.Lens.Wrapped Control.Lens.Zoom Control.Monad.Error.Lens
    Control.Parallel.Strategies.Lens Control.Seq.Lens Data.Array.Lens
    Data.Bits.Lens Data.ByteString.Lazy.Lens Data.ByteString.Lens
    Data.ByteString.Strict.Lens Data.Complex.Lens Data.Data.Lens
    Data.Dynamic.Lens Data.HashSet.Lens Data.IntSet.Lens Data.List.Lens
    Data.Map.Lens Data.Sequence.Lens Data.Set.Lens Data.Text.Lazy.Lens
    Data.Text.Lens Data.Text.Strict.Lens Data.Tree.Lens
    Data.Typeable.Lens Data.Vector.Generic.Lens Data.Vector.Lens
    GHC.Generics.Lens Language.Haskell.TH.Lens Numeric.Lens
    Numeric.Natural.Lens System.Exit.Lens System.FilePath.Lens
    System.IO.Error.Lens

hidden-modules:       Control.Lens.Internal.Prelude Paths_lens
import-dirs:          /usr/lib/ghc-8.10.5/site-local/lens-5.0.1
library-dirs:         /usr/lib/ghc-8.10.5/site-local/lens-5.0.1
dynamic-library-dirs: /usr/lib
data-dir:             /usr/share/i386-linux-ghc-8.10.5/lens-5.0.1
hs-libraries:         HSlens-5.0.1-7XUkI0pM5Tr3OUSblTWRuC
depends:
    array-0.5.4.0 assoc-1.0.2-2NAY27Pxanp5SGhojPPgAH base-4.14.2.0
    base-orphans-0.8.4-B4zsXTdczgN9mmNUwgnmE3
    bifunctors-5.5.11-I8MVLGtsycGakOlqrC4OY bytestring-0.10.12.0
    call-stack-0.3.0-HaJG5jRa2XM74od97nDj56
    comonad-5.0.8-8a10YHmXJVq2BoDg3RtKOL containers-0.6.4.1
    contravariant-1.5.3-KWoYE9wiUjmElzHNq2wj10
    distributive-0.6.2.1-FKGYrCjdfe8EPx7TggrhZc exceptions-0.10.4
    filepath-1.4.2.1 free-5.1.7-G4cc1Y718fXDuPxii9x6Pg ghc-prim-0.6.1
    hashable-1.3.2.0-L2CDkY7lZtECinpkHRj0mo
    indexed-traversable-0.1.1-1Z2GfU1EWlL3ZzMnGNHsA4
    indexed-traversable-instances-0.1-2FY4aUQswFtJG74tcB3ijl
    kan-extensions-5.2.2-lFF6YUSQic8wUGduaZdNj mtl-2.2.2
    parallel-3.2.2.0-H513jAs1HA11zQonYV0DH5
    profunctors-5.6.2-HmnVxCk8JDbE3jxtqz7wd8
    reflection-2.1.6-6L6abu6K0SI4j16Tb0Qxrv
    semigroupoids-5.3.5-1MUCoMhFnfRKlT8x21E1a0
    strict-0.4.0.1-JMnBD6iPAun9tbAlBpqxyD
    tagged-0.8.6.1-F25vmSN4H5fEaMJYsLgYMV template-haskell-2.16.0.0
    text-1.2.4.1 th-abstraction-0.4.2.0-5X2XqBZ7rCLBwJXut5dQBZ
    these-1.1.1.1-6gES5kDvvXJGGRCQQG0Vwd transformers-0.5.6.2
    transformers-compat-0.6.6-8xD7tdhdla21VYsnm1hEvk
    unordered-containers-0.2.14.0-D9MLkVL2jXfKIhE8RrmI8O
    vector-0.12.3.0-K9OZS5OCy7cE2QKQqSO9mp

haddock-interfaces:   /usr/share/doc/haskell-lens/html/lens.haddock
haddock-html:         /usr/share/doc/haskell-lens/html
' | '/usr/bin/ghc-pkg' 'update' '--force' '-' '--global' '--no-user-package-db' "$@"

