#!/bin/sh
export PATH='/usr/local/sbin:/usr/local/bin:/usr/bin:/usr/bin/site_perl:/usr/bin/vendor_perl:/usr/bin/core_perl'
echo 'name:                 ghc-exactprint
version:              0.6.4
visibility:           public
id:                   ghc-exactprint-0.6.4-1Us7ZUMmejaDpTzk0GzlkA
key:                  ghc-exactprint-0.6.4-1Us7ZUMmejaDpTzk0GzlkA
license:              BSD-3-Clause
maintainer:           alan.zimm@gmail.com
author:               Alan Zimmerman, Matthew Pickering
synopsis:             ExactPrint for GHC
description:
    Using the API Annotations available from GHC 7.10.2, this
    library provides a means to round trip any code that can
    be compiled by GHC, currently excluding lhs files.

    It does this with a phased approach

    * Delta - converts GHC API Annotations into relative
    offsets, indexed by SrcSpan

    * Transform - functions to facilitate changes to
    the AST, adjusting the annotations generated in the
    Delta phase to suit the changes.

    * Print - converts an AST and its annotations to
    properly formatted source text.

    * Pretty - adds annotations to an AST (fragment) so that
    the output can be parsed back to the same AST.


    Note: requires GHC 7.10.2 or later

category:             Development
abi:                  3d15584197d3866a692d1de3afdb7788
exposed:              True
exposed-modules:
    Language.Haskell.GHC.ExactPrint
    Language.Haskell.GHC.ExactPrint.Annotate
    Language.Haskell.GHC.ExactPrint.AnnotateTypes
    Language.Haskell.GHC.ExactPrint.Annotater
    Language.Haskell.GHC.ExactPrint.Delta
    Language.Haskell.GHC.ExactPrint.Lookup
    Language.Haskell.GHC.ExactPrint.Parsers
    Language.Haskell.GHC.ExactPrint.Preprocess
    Language.Haskell.GHC.ExactPrint.Pretty
    Language.Haskell.GHC.ExactPrint.Print
    Language.Haskell.GHC.ExactPrint.Transform
    Language.Haskell.GHC.ExactPrint.Types
    Language.Haskell.GHC.ExactPrint.Utils

import-dirs:          /usr/lib/ghc-8.10.5/site-local/ghc-exactprint-0.6.4
library-dirs:         /usr/lib/ghc-8.10.5/site-local/ghc-exactprint-0.6.4
dynamic-library-dirs: /usr/lib
data-dir:             /usr/share/i386-linux-ghc-8.10.5/ghc-exactprint-0.6.4
hs-libraries:         HSghc-exactprint-0.6.4-1Us7ZUMmejaDpTzk0GzlkA
depends:
    base-4.14.2.0 bytestring-0.10.12.0 containers-0.6.4.1
    directory-1.3.6.0 filepath-1.4.2.1
    free-5.1.7-G4cc1Y718fXDuPxii9x6Pg ghc-8.10.5 ghc-boot-8.10.5
    ghc-paths-0.1.0.12-2xWgOnBVsu4JfFnY8cTnGw mtl-2.2.2
    syb-0.7.2.1-LCeM0k3cWww5FKQVRHAOJq

haddock-interfaces:
    /usr/share/doc/haskell-ghc-exactprint/html/ghc-exactprint.haddock

haddock-html:         /usr/share/doc/haskell-ghc-exactprint/html
' | '/usr/bin/ghc-pkg' 'update' '--force' '-' '--global' '--no-user-package-db' "$@"

