# SPDX-FileCopyrightText: Copyright (c) <2025> NVIDIA CORPORATION & AFFILIATES. All rights reserved.
#
# SPDX-License-Identifier: Apache-2.0

from cuda.tile._version import __version__  # noqa

from cuda.tile._cext import launch

from cuda.tile._by_target import ByTarget

from cuda.tile._memory_model import (
    MemoryOrder,
    MemoryScope,
)

from cuda.tile._numeric_semantics import (
    PaddingMode,
    RoundingMode,
)

from cuda.tile._datatype import (
    DType,

    bfloat16,
    bool_,
    float8_e4m3fn,
    float8_e5m2,
    float16,
    float32,
    float64,
    int8,
    int16,
    int32,
    int64,
    tfloat32,
    uint8,
    uint16,
    uint32,
    uint64,
)

from cuda.tile._exception import (
    TileCompilerExecutionError,
    TileCompilerTimeoutError,
    TileError,
    TileInternalError,
    TileRecursionError,
    TileSyntaxError,
    TileTypeError,
    TileValueError,
)

from cuda.tile._stub import (
    Array,
    Constant,
    ConstantAnnotation,
    Scalar,
    Tile,

    abs,
    add,
    arange,
    argmax,
    argmin,
    assert_,
    astype,
    atomic_add,
    atomic_and,
    atomic_cas,
    atomic_max,
    atomic_min,
    atomic_or,
    atomic_xchg,
    atomic_xor,
    bitwise_and,
    bitwise_lshift,
    bitwise_not,
    bitwise_or,
    bitwise_rshift,
    bitwise_xor,
    bid,
    bitcast,
    broadcast_to,
    cat,
    cdiv,
    ceil,
    cos,
    cosh,
    cumprod,
    cumsum,
    equal,
    exp,
    exp2,
    expand_dims,
    extract,
    floor,
    floordiv,
    full,
    gather,
    greater,
    greater_equal,
    less,
    less_equal,
    load,
    log,
    log2,
    matmul,
    max,
    maximum,
    min,
    minimum,
    mma,
    mod,
    mul,
    negative,
    not_equal,
    num_blocks,
    num_tiles,
    ones,
    permute,
    pow,
    printf,
    prod,
    reduce,
    reshape,
    rsqrt,
    scatter,
    sin,
    sinh,
    sqrt,
    store,
    sub,
    sum,
    tan,
    tanh,
    transpose,
    truediv,
    where,
    zeros,
)

from cuda.tile._execution import (
    function,
    kernel
)

__all__ = [
    "launch",

    "ByTarget",

    "MemoryOrder",
    "MemoryScope",

    "PaddingMode",
    "RoundingMode",

    "DType",

    "bfloat16",
    "bool_",
    "float8_e4m3fn",
    "float8_e5m2",
    "float16",
    "float32",
    "float64",
    "int8",
    "int16",
    "int32",
    "int64",
    "tfloat32",
    "uint8",
    "uint16",
    "uint32",
    "uint64",

    "TileCompilerExecutionError",
    "TileCompilerTimeoutError",
    "TileError",
    "TileInternalError",
    "TileRecursionError",
    "TileSyntaxError",
    "TileTypeError",
    "TileValueError",

    "Array",
    "Constant",
    "ConstantAnnotation",
    "Scalar",
    "Tile",

    "abs",
    "add",
    "arange",
    "argmax",
    "argmin",
    "assert_",
    "astype",
    "atomic_add",
    "atomic_and",
    "atomic_cas",
    "atomic_max",
    "atomic_min",
    "atomic_or",
    "atomic_xchg",
    "atomic_xor",
    "bitwise_and",
    "bitwise_lshift",
    "bitwise_not",
    "bitwise_or",
    "bitwise_rshift",
    "bitwise_xor",
    "bid",
    "bitcast",
    "broadcast_to",
    "cat",
    "cdiv",
    "ceil",
    "cos",
    "cosh",
    "cumprod",
    "cumsum",
    "equal",
    "exp",
    "exp2",
    "expand_dims",
    "extract",
    "floor",
    "floordiv",
    "full",
    "gather",
    "greater",
    "greater_equal",
    "less",
    "less_equal",
    "load",
    "log",
    "log2",
    "matmul",
    "max",
    "maximum",
    "min",
    "minimum",
    "mma",
    "mod",
    "mul",
    "negative",
    "not_equal",
    "num_blocks",
    "num_tiles",
    "ones",
    "permute",
    "pow",
    "printf",
    "prod",
    "reduce",
    "reshape",
    "rsqrt",
    "scatter",
    "sin",
    "sinh",
    "sqrt",
    "store",
    "sub",
    "sum",
    "tan",
    "tanh",
    "transpose",
    "truediv",
    "where",
    "zeros",

    "function",
    "kernel",
]
