/*
 * Decompiled with CFR 0.152.
 */
package org.jdesktop.swingx.plaf.misc;

import java.awt.GradientPaint;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Paint;
import java.awt.RenderingHints;
import javax.swing.JComponent;
import javax.swing.border.Border;
import javax.swing.plaf.ComponentUI;
import org.jdesktop.swingx.JXTaskPane;
import org.jdesktop.swingx.plaf.basic.BasicTaskPaneUI;

public class GlossyTaskPaneUI
extends BasicTaskPaneUI {
    public static ComponentUI createUI(JComponent c) {
        return new GlossyTaskPaneUI();
    }

    @Override
    protected Border createPaneBorder() {
        return new GlossyPaneBorder();
    }

    @Override
    public void update(Graphics g2, JComponent c) {
        if (c.isOpaque()) {
            g2.setColor(c.getParent().getBackground());
            g2.fillRect(0, 0, c.getWidth(), c.getHeight());
            g2.setColor(c.getBackground());
            g2.fillRect(0, this.getRoundHeight(), c.getWidth(), c.getHeight() - this.getRoundHeight());
        }
        this.paint(g2, c);
    }

    class GlossyPaneBorder
    extends BasicTaskPaneUI.PaneBorder {
        GlossyPaneBorder() {
        }

        @Override
        protected void paintTitleBackground(JXTaskPane group, Graphics g2) {
            if (group.isSpecial()) {
                g2.setColor(this.specialTitleBackground);
                g2.fillRoundRect(0, 0, group.getWidth(), GlossyTaskPaneUI.this.getRoundHeight() * 2, GlossyTaskPaneUI.this.getRoundHeight(), GlossyTaskPaneUI.this.getRoundHeight());
                g2.fillRect(0, GlossyTaskPaneUI.this.getRoundHeight(), group.getWidth(), GlossyTaskPaneUI.this.getTitleHeight(group) - GlossyTaskPaneUI.this.getRoundHeight());
            } else {
                Paint oldPaint = ((Graphics2D)g2).getPaint();
                GradientPaint gradient = new GradientPaint(0.0f, 0.0f, this.titleBackgroundGradientStart, 0.0f, GlossyTaskPaneUI.this.getTitleHeight(group), this.titleBackgroundGradientEnd);
                ((Graphics2D)g2).setRenderingHint(RenderingHints.KEY_COLOR_RENDERING, RenderingHints.VALUE_COLOR_RENDER_QUALITY);
                ((Graphics2D)g2).setRenderingHint(RenderingHints.KEY_INTERPOLATION, RenderingHints.VALUE_INTERPOLATION_BILINEAR);
                ((Graphics2D)g2).setRenderingHint(RenderingHints.KEY_RENDERING, RenderingHints.VALUE_RENDER_QUALITY);
                ((Graphics2D)g2).setPaint(gradient);
                g2.fillRoundRect(0, 0, group.getWidth(), GlossyTaskPaneUI.this.getRoundHeight() * 2, GlossyTaskPaneUI.this.getRoundHeight(), GlossyTaskPaneUI.this.getRoundHeight());
                g2.fillRect(0, GlossyTaskPaneUI.this.getRoundHeight(), group.getWidth(), GlossyTaskPaneUI.this.getTitleHeight(group) - GlossyTaskPaneUI.this.getRoundHeight());
                ((Graphics2D)g2).setPaint(oldPaint);
            }
            g2.setColor(this.borderColor);
            g2.drawRoundRect(0, 0, group.getWidth() - 1, GlossyTaskPaneUI.this.getTitleHeight(group) + GlossyTaskPaneUI.this.getRoundHeight(), GlossyTaskPaneUI.this.getRoundHeight(), GlossyTaskPaneUI.this.getRoundHeight());
            g2.drawLine(0, GlossyTaskPaneUI.this.getTitleHeight(group) - 1, group.getWidth(), GlossyTaskPaneUI.this.getTitleHeight(group) - 1);
        }

        @Override
        protected void paintExpandedControls(JXTaskPane group, Graphics g2, int x, int y, int width, int height) {
            ((Graphics2D)g2).setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
            this.paintOvalAroundControls(group, g2, x, y, width, height);
            g2.setColor(this.getPaintColor(group));
            this.paintChevronControls(group, g2, x, y, width, height);
            ((Graphics2D)g2).setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_OFF);
        }

        @Override
        protected boolean isMouseOverBorder() {
            return true;
        }
    }
}

