/*
 * Decompiled with CFR 0.152.
 */
package org.jdesktop.swingx.painter;

import java.awt.Insets;
import java.awt.Rectangle;
import org.jdesktop.swingx.painter.AbstractPainter;

public abstract class AbstractLayoutPainter<T>
extends AbstractPainter<T> {
    private VerticalAlignment verticalAlignment = VerticalAlignment.CENTER;
    private HorizontalAlignment horizontalAlignment = HorizontalAlignment.CENTER;
    private Insets insets = new Insets(0, 0, 0, 0);
    private boolean fillVertical = false;
    private boolean fillHorizontal = false;

    public HorizontalAlignment getHorizontalAlignment() {
        return this.horizontalAlignment;
    }

    public Insets getInsets() {
        return this.insets;
    }

    public VerticalAlignment getVerticalAlignment() {
        return this.verticalAlignment;
    }

    public boolean isFillHorizontal() {
        return this.fillHorizontal;
    }

    public boolean isFillVertical() {
        return this.fillVertical;
    }

    public void setHorizontalAlignment(HorizontalAlignment horizontal) {
        HorizontalAlignment old = this.getHorizontalAlignment();
        this.horizontalAlignment = horizontal;
        this.setDirty(true);
        this.firePropertyChange("horizontalAlignment", (Object)old, (Object)this.getHorizontalAlignment());
    }

    public void setFillHorizontal(boolean fillHorizontal) {
        boolean old = this.isFillHorizontal();
        this.fillHorizontal = fillHorizontal;
        this.setDirty(true);
        this.firePropertyChange("fillHorizontal", old, this.isFillHorizontal());
    }

    public void setInsets(Insets insets) {
        Insets old = this.getInsets();
        this.insets = insets;
        this.setDirty(true);
        this.firePropertyChange("insets", old, this.getInsets());
    }

    public void setVerticalAlignment(VerticalAlignment vertical) {
        VerticalAlignment old = this.getVerticalAlignment();
        this.verticalAlignment = vertical;
        this.setDirty(true);
        this.firePropertyChange("verticalAlignment", (Object)old, (Object)this.getVerticalAlignment());
    }

    public void setFillVertical(boolean verticalStretch) {
        boolean old = this.isFillVertical();
        this.fillVertical = verticalStretch;
        this.setDirty(true);
        this.firePropertyChange("fillVertical", old, this.isFillVertical());
    }

    protected final Rectangle calculateLayout(int contentWidth, int contentHeight, int width, int height) {
        Rectangle rect = new Rectangle();
        rect.width = contentWidth;
        rect.height = contentHeight;
        if (this.isFillHorizontal()) {
            rect.width = width - this.insets.left - this.insets.right;
        }
        if (this.isFillVertical()) {
            rect.height = height - this.insets.top - this.insets.bottom;
        }
        rect.x = this.calculateX(rect.width, width);
        rect.y = this.calculateY(rect.height, height);
        return rect;
    }

    private int calculateY(int imgHeight, int height) {
        int y = 0;
        if (this.getVerticalAlignment() == VerticalAlignment.TOP) {
            y = 0;
            y += this.insets.top;
        }
        if (this.getVerticalAlignment() == VerticalAlignment.CENTER) {
            y = (height - imgHeight) / 2;
            y += this.insets.top;
        }
        if (this.getVerticalAlignment() == VerticalAlignment.BOTTOM) {
            y = height - imgHeight;
            y -= this.insets.bottom;
        }
        return y;
    }

    private int calculateX(int imgWidth, int width) {
        int x = 0;
        if (this.getHorizontalAlignment() == HorizontalAlignment.LEFT) {
            x = 0;
            x += this.insets.left;
        }
        if (this.getHorizontalAlignment() == HorizontalAlignment.CENTER) {
            x = (width - imgWidth) / 2;
            x += this.insets.left;
        }
        if (this.getHorizontalAlignment() == HorizontalAlignment.RIGHT) {
            x = width - imgWidth;
            x -= this.insets.right;
        }
        return x;
    }

    public static enum VerticalAlignment {
        TOP,
        CENTER,
        BOTTOM;

    }

    public static enum HorizontalAlignment {
        LEFT,
        CENTER,
        RIGHT;

    }
}

