/*
 * Decompiled with CFR 0.152.
 */
package mediathek.gui.dialogEinstellungen;

import com.formdev.flatlaf.extras.FlatSVGIcon;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.io.File;
import java.nio.file.Files;
import java.nio.file.Paths;
import java.util.ArrayList;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.GroupLayout;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JColorChooser;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.JSpinner;
import javax.swing.JSplitPane;
import javax.swing.JTabbedPane;
import javax.swing.JTable;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.LayoutStyle;
import javax.swing.SpinnerNumberModel;
import javax.swing.SwingUtilities;
import javax.swing.border.EtchedBorder;
import javax.swing.border.SoftBevelBorder;
import javax.swing.border.TitledBorder;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.table.DefaultTableModel;
import javax.swing.text.JTextComponent;
import mediathek.config.Daten;
import mediathek.config.MVConfig;
import mediathek.controller.IoXmlSchreiben;
import mediathek.controller.starter.RuntimeExec;
import mediathek.daten.DatenProg;
import mediathek.daten.DatenPset;
import mediathek.daten.FilmResolution;
import mediathek.daten.ListePset;
import mediathek.file.GetFile;
import mediathek.gui.PanelVorlage;
import mediathek.gui.dialog.DialogHilfe;
import mediathek.gui.messages.ProgramSetChangedEvent;
import mediathek.mainwindow.MediathekGui;
import mediathek.tool.FileDialogs;
import mediathek.tool.FilenameUtils;
import mediathek.tool.GuiFunktionen;
import mediathek.tool.GuiFunktionenProgramme;
import mediathek.tool.MessageBus;
import mediathek.tool.NoSelectionErrorDialog;
import mediathek.tool.SVGIconUtilities;
import mediathek.tool.TextCopyPasteHandler;
import mediathek.tool.cellrenderer.CellRendererProgramme;
import mediathek.tool.cellrenderer.CellRendererPset;
import mediathek.tool.models.TModel;
import mediathek.tool.table.MVProgTable;
import mediathek.tool.table.MVPsetTable;
import mediathek.tool.table.MVTable;
import net.engio.mbassy.listener.Handler;
import net.miginfocom.layout.AC;
import net.miginfocom.layout.CC;
import net.miginfocom.layout.LC;
import net.miginfocom.swing.MigLayout;
import org.apache.commons.lang3.SystemUtils;

public class PanelPsetLang
extends PanelVorlage {
    private int neuZaehler;
    private final ListePset listePset;
    private final MVTable tabellePset;
    private final MVTable tabelleProgramme;
    private final boolean modalHilfe;
    private JButton jButtonHilfe;
    private JButton jButtonPruefen;
    private JTabbedPane jTabbedPane;
    private JTextField jTextFieldSetName;
    private JTextArea jTextAreaSetBeschreibung;
    private JCheckBox jCheckBoxSpeichern;
    private JCheckBox jCheckBoxButton;
    private JCheckBox jCheckBoxAbo;
    private JButton jButtonAbspielen;
    private JLabel jLabelMeldungAbspielen;
    private JLabel jLabelMeldungSeichern;
    private JButton jButtonGruppeFarbe;
    private JButton jButtonGruppeStandardfarbe;
    private JTextField tfGruppeZielPfad;
    private JButton jButtonGruppePfad;
    private JCheckBox jCheckBoxThema;
    private JTextField tfGruppeZielName;
    private JCheckBox jCheckBoxLaenge;
    private JSpinner jSpinnerLaenge;
    private JCheckBox jCheckBoxField;
    private JSpinner jSpinnerField;
    private JTextField tfGruppeDirektPraefix;
    private JTextField tfGruppeDirektSuffix;
    private JRadioButton jRadioButtonAufloesungNormal;
    private JRadioButton jRadioButtonAufloesungKlein;
    private JRadioButton jRadioButtonAufloesungHD;
    private JCheckBox jCheckBoxInfodatei;
    private JCheckBox jCheckBoxSpotlight;
    private JCheckBox jCheckBoxSubtitle;
    private JScrollPane jScrollPane1;
    private JButton jButtonProgPlus;
    private JButton jButtonProgMinus;
    private JButton jButtonProgDuplizieren;
    private JButton jButtonProgAuf;
    private JButton jButtonProgAb;
    private JTextField jTextFieldProgPfad;
    private JButton jButtonProgPfad;
    private JTextField jTextFieldProgSchalter;
    private JTextField jTextFieldProgName;
    private JTextField jTextFieldProgPraefix;
    private JTextField jTextFieldProgSuffix;
    private JCheckBox jCheckBoxRestart;
    private JTextField jTextFieldProgZielDateiName;
    private JCheckBox jCheckBoxRemoteDownload;
    private JScrollPane jScrollPane3;
    private JButton jButtonGruppeDuplizieren;
    private JButton jButtonExport;
    private JButton jButtonGruppeNeu;
    private JButton jButtonGruppeLoeschen;
    private JButton jButtonGruppeAuf;
    private JButton jButtonGruppeAb;

    public PanelPsetLang(Daten d, JFrame parentComponent, ListePset llistePset) {
        super(d, parentComponent);
        this.initComponents();
        this.modalHilfe = true;
        this.tabellePset = new MVPsetTable();
        this.jScrollPane3.setViewportView(this.tabellePset);
        this.tabelleProgramme = new MVProgTable();
        this.jScrollPane1.setViewportView(this.tabelleProgramme);
        this.listePset = llistePset;
        this.init();
    }

    @Handler
    private void handleProgramSetChanged(ProgramSetChangedEvent e) {
        SwingUtilities.invokeLater(() -> {
            if (!this.stopBeob) {
                this.tabellePset();
            }
        });
    }

    private void init() {
        this.jButtonHilfe.setIcon(SVGIconUtilities.createSVGIcon("icons/fontawesome/circle-question.svg"));
        this.jButtonGruppePfad.setIcon(SVGIconUtilities.createSVGIcon("icons/fontawesome/folder-open.svg"));
        this.jButtonProgPlus.setIcon(SVGIconUtilities.createSVGIcon("icons/fontawesome/plus.svg"));
        this.jButtonProgMinus.setIcon(SVGIconUtilities.createSVGIcon("icons/fontawesome/minus.svg"));
        this.jButtonProgAuf.setIcon(SVGIconUtilities.createSVGIcon("icons/fontawesome/arrow-up.svg"));
        this.jButtonProgAb.setIcon(SVGIconUtilities.createSVGIcon("icons/fontawesome/arrow-down.svg"));
        this.jButtonProgPfad.setIcon(SVGIconUtilities.createSVGIcon("icons/fontawesome/folder-open.svg"));
        this.jButtonGruppeNeu.setIcon(SVGIconUtilities.createSVGIcon("icons/fontawesome/plus.svg"));
        this.jButtonGruppeLoeschen.setIcon(SVGIconUtilities.createSVGIcon("icons/fontawesome/minus.svg"));
        this.jButtonGruppeAuf.setIcon(SVGIconUtilities.createSVGIcon("icons/fontawesome/arrow-up.svg"));
        this.jButtonGruppeAb.setIcon(SVGIconUtilities.createSVGIcon("icons/fontawesome/arrow-down.svg"));
        FlatSVGIcon exclamationIcon = SVGIconUtilities.createSVGIcon("icons/fontawesome/triangle-exclamation.svg");
        this.jLabelMeldungAbspielen.setIcon(exclamationIcon);
        this.jLabelMeldungSeichern.setIcon(exclamationIcon);
        MessageBus.getMessageBus().subscribe(this);
        this.tabellePset.setAutoResizeMode(0);
        BeobProgDoc beobDoc = new BeobProgDoc();
        this.jTextFieldProgPfad.getDocument().addDocumentListener(beobDoc);
        this.jTextFieldProgSchalter.getDocument().addDocumentListener(beobDoc);
        this.jTextFieldProgName.getDocument().addDocumentListener(beobDoc);
        this.jTextFieldProgZielDateiName.getDocument().addDocumentListener(beobDoc);
        this.jTextFieldProgPraefix.getDocument().addDocumentListener(beobDoc);
        this.jTextFieldProgSuffix.getDocument().addDocumentListener(beobDoc);
        TextCopyPasteHandler<JTextField> handler = new TextCopyPasteHandler<JTextField>(this.jTextFieldProgPfad);
        this.jTextFieldProgPfad.setComponentPopupMenu(handler.getPopupMenu());
        handler = new TextCopyPasteHandler<JTextField>(this.jTextFieldProgSchalter);
        this.jTextFieldProgSchalter.setComponentPopupMenu(handler.getPopupMenu());
        handler = new TextCopyPasteHandler<JTextField>(this.jTextFieldProgName);
        this.jTextFieldProgName.setComponentPopupMenu(handler.getPopupMenu());
        handler = new TextCopyPasteHandler<JTextField>(this.jTextFieldProgZielDateiName);
        this.jTextFieldProgZielDateiName.setComponentPopupMenu(handler.getPopupMenu());
        handler = new TextCopyPasteHandler<JTextField>(this.jTextFieldProgPraefix);
        this.jTextFieldProgPraefix.setComponentPopupMenu(handler.getPopupMenu());
        handler = new TextCopyPasteHandler<JTextField>(this.jTextFieldProgSuffix);
        this.jTextFieldProgSuffix.setComponentPopupMenu(handler.getPopupMenu());
        this.jTextFieldProgPfad.setEnabled(false);
        this.jTextFieldProgSchalter.setEnabled(false);
        this.jTextFieldProgName.setEnabled(false);
        this.jTextFieldProgZielDateiName.setEnabled(false);
        this.jTextFieldProgPraefix.setEnabled(false);
        this.jTextFieldProgSuffix.setEnabled(false);
        this.jButtonProgPfad.addActionListener(l -> {
            File destFile;
            String initialFile = "";
            if (!this.jTextFieldProgPfad.getText().isEmpty()) {
                initialFile = this.jTextFieldProgPfad.getText();
            }
            if ((destFile = FileDialogs.chooseLoadFileLocation(MediathekGui.ui(), "Programm ausw\u00e4hlen", initialFile)) != null) {
                this.jTextFieldProgPfad.setText(destFile.getAbsolutePath());
            }
        });
        this.jButtonProgPlus.addActionListener(l -> {
            DatenProg prog = new DatenProg();
            this.progNeueZeile(prog);
        });
        this.jButtonProgMinus.addActionListener(e -> {
            int[] rows = this.tabelleProgramme.getSelectedRows();
            if (rows.length > 0) {
                Object text;
                DatenPset pSet = this.getPset();
                if (rows.length == 1) {
                    int delRow = this.tabelleProgramme.convertRowIndexToModel(rows[0]);
                    text = pSet.getProg((int)delRow).arr[0];
                } else {
                    text = rows.length + " Programme l\u00f6schen?";
                }
                int ret = JOptionPane.showConfirmDialog(this.parentComponent, text, "L\u00f6schen?", 0);
                if (ret == 0) {
                    for (int i = rows.length - 1; i >= 0; --i) {
                        int delRow = this.tabelleProgramme.convertRowIndexToModel(rows[i]);
                        pSet.getListeProg().remove(delRow);
                    }
                    this.tabelleProgramme();
                }
            } else {
                NoSelectionErrorDialog.show(this);
            }
        });
        this.jButtonProgDuplizieren.addActionListener(e -> {
            int rows = this.tabelleProgramme.getSelectedRow();
            if (rows != -1) {
                int row = this.tabelleProgramme.convertRowIndexToModel(rows);
                DatenProg prog = (DatenProg)this.getPset().getListeProg().get(row);
                this.progNeueZeile(prog.copy());
            } else {
                NoSelectionErrorDialog.show(this);
            }
        });
        this.jButtonProgAuf.addActionListener(e -> this.progAufAb(true));
        this.jButtonProgAb.addActionListener(e -> this.progAufAb(false));
        this.jButtonProgPfad.setEnabled(false);
        this.jCheckBoxRestart.addActionListener(e -> {
            int rows;
            if (!this.stopBeob && (rows = this.tabelleProgramme.getSelectedRow()) != -1) {
                int row = this.tabelleProgramme.convertRowIndexToModel(rows);
                DatenProg prog = (DatenProg)this.getPset().getListeProg().get(row);
                prog.arr[6] = Boolean.toString(this.jCheckBoxRestart.isSelected());
                this.tabelleProgramme.getModel().setValueAt(Boolean.toString(this.jCheckBoxRestart.isSelected()), row, 6);
            }
        });
        this.jCheckBoxRemoteDownload.addActionListener(e -> {
            int rows;
            if (!this.stopBeob && (rows = this.tabelleProgramme.getSelectedRow()) != -1) {
                int modelIndex = this.tabelleProgramme.convertRowIndexToModel(rows);
                DatenProg prog = (DatenProg)this.getPset().getListeProg().get(modelIndex);
                prog.arr[7] = Boolean.toString(this.jCheckBoxRemoteDownload.isSelected());
                this.tabelleProgramme.getModel().setValueAt(Boolean.toString(this.jCheckBoxRemoteDownload.isSelected()), modelIndex, 7);
            }
        });
        this.jButtonAbspielen.addActionListener(e -> {
            DatenPset pset = this.getPset();
            if (pset != null) {
                pset.setAbspielen();
                this.nurtabellePset();
                this.notifyProgramSetChanged();
            }
        });
        this.jCheckBoxSpeichern.addActionListener(e -> {
            DatenPset pset = this.getPset();
            if (pset != null) {
                pset.setSpeichern(this.jCheckBoxSpeichern.isSelected());
                this.nurtabellePset();
                this.notifyProgramSetChanged();
            }
        });
        this.jCheckBoxButton.addActionListener(e -> {
            DatenPset pset = this.getPset();
            if (pset != null) {
                pset.setButton(this.jCheckBoxButton.isSelected());
                this.nurtabellePset();
                this.notifyProgramSetChanged();
            }
        });
        this.jCheckBoxAbo.addActionListener(e -> {
            DatenPset pset = this.getPset();
            if (pset != null) {
                pset.setAbo(this.jCheckBoxAbo.isSelected());
                this.nurtabellePset();
                this.notifyProgramSetChanged();
            }
        });
        this.jCheckBoxLaenge.addActionListener(e -> {
            DatenPset pset = this.getPset();
            if (pset != null) {
                pset.arr[11] = Boolean.toString(this.jCheckBoxLaenge.isSelected());
                this.nurtabellePset();
            }
        });
        this.jCheckBoxField.addActionListener(e -> {
            DatenPset pset = this.getPset();
            if (pset != null) {
                pset.arr[12] = Boolean.toString(this.jCheckBoxField.isSelected());
                this.nurtabellePset();
            }
        });
        this.jCheckBoxThema.addActionListener(e -> {
            DatenPset pset = this.getPset();
            if (pset != null) {
                pset.arr[6] = Boolean.toString(this.jCheckBoxThema.isSelected());
                this.nurtabellePset();
            }
        });
        this.jSpinnerLaenge.addChangeListener(e -> {
            DatenPset pset = this.getPset();
            if (pset != null) {
                pset.arr[13] = String.valueOf(((Number)this.jSpinnerLaenge.getModel().getValue()).intValue());
            }
        });
        this.jSpinnerField.addChangeListener(e -> {
            DatenPset pset = this.getPset();
            if (pset != null) {
                pset.arr[14] = String.valueOf(((Number)this.jSpinnerField.getModel().getValue()).intValue());
            }
        });
        this.jCheckBoxInfodatei.addActionListener(e -> {
            DatenPset pset = this.getPset();
            if (pset != null) {
                pset.arr[19] = Boolean.toString(this.jCheckBoxInfodatei.isSelected());
                this.nurtabellePset();
            }
        });
        this.jCheckBoxSubtitle.addActionListener(e -> {
            DatenPset pset = this.getPset();
            if (pset != null) {
                pset.arr[21] = Boolean.toString(this.jCheckBoxSubtitle.isSelected());
                this.nurtabellePset();
            }
        });
        this.jCheckBoxSpotlight.setEnabled(SystemUtils.IS_OS_MAC_OSX);
        this.jCheckBoxSpotlight.addActionListener(e -> {
            DatenPset pset = this.getPset();
            if (pset != null) {
                pset.arr[20] = Boolean.toString(this.jCheckBoxSpotlight.isSelected());
                this.nurtabellePset();
            }
        });
        this.jButtonGruppeNeu.addActionListener(e -> this.setNeu());
        this.jButtonGruppeLoeschen.addActionListener(e -> this.setLoeschen());
        this.jButtonGruppeFarbe.addActionListener(e -> {
            Color selectedColor;
            DatenPset pSet = this.getPset();
            if (pSet != null && (selectedColor = JColorChooser.showDialog(this, "Farbe ausw\u00e4hlen", pSet.getFarbe())) != null) {
                pSet.setFarbe(selectedColor);
                this.tabellePset();
                this.notifyProgramSetChanged();
            }
        });
        this.jButtonGruppeStandardfarbe.addActionListener(l -> {
            DatenPset pSet = this.getPset();
            if (pSet != null) {
                pSet.arr[3] = "";
                this.tabellePset();
                this.notifyProgramSetChanged();
            }
        });
        this.jButtonGruppeAuf.addActionListener(e -> this.setAufAb(true));
        this.jButtonGruppeAb.addActionListener(e -> this.setAufAb(false));
        this.jButtonGruppeDuplizieren.addActionListener(e -> {
            int row = this.tabellePset.getSelectedRow();
            if (row != -1) {
                DatenPset gruppe = (DatenPset)this.listePset.get(this.tabellePset.convertRowIndexToModel(row));
                this.listePset.addPset(gruppe.copy());
                this.tabellePset();
                this.notifyProgramSetChanged();
            } else {
                NoSelectionErrorDialog.show(this);
            }
        });
        this.jButtonExport.addActionListener(e -> this.setExport());
        this.jButtonGruppePfad.addActionListener(l -> {
            File destDirectory;
            String initialFile = "";
            if (!this.tfGruppeZielPfad.getText().isEmpty()) {
                initialFile = this.tfGruppeZielPfad.getText();
            }
            if ((destDirectory = FileDialogs.chooseDirectoryLocation(MediathekGui.ui(), "Filme speichern unter", initialFile)) != null) {
                this.tfGruppeZielPfad.setText(destDirectory.getAbsolutePath());
            }
        });
        this.jTextAreaSetBeschreibung.getDocument().addDocumentListener(new BeobDoc(this.jTextAreaSetBeschreibung, 17));
        TextCopyPasteHandler<JTextArea> handler2 = new TextCopyPasteHandler<JTextArea>(this.jTextAreaSetBeschreibung);
        this.jTextAreaSetBeschreibung.setComponentPopupMenu(handler2.getPopupMenu());
        this.tfGruppeDirektSuffix.getDocument().addDocumentListener(new BeobDoc(this.tfGruppeDirektSuffix, 2, false));
        this.tfGruppeDirektPraefix.getDocument().addDocumentListener(new BeobDoc(this.tfGruppeDirektPraefix, 1, false));
        this.tfGruppeZielName.getDocument().addDocumentListener(new BeobDoc(this.tfGruppeZielName, 5, false));
        this.tfGruppeZielPfad.getDocument().addDocumentListener(new BeobDoc(this.tfGruppeZielPfad, 4, false));
        this.jTextFieldSetName.getDocument().addDocumentListener(new BeobDoc(this.jTextFieldSetName, 0));
        handler = new TextCopyPasteHandler<JTextField>(this.jTextFieldSetName);
        this.jTextFieldSetName.setComponentPopupMenu(handler.getPopupMenu());
        handler = new TextCopyPasteHandler<JTextField>(this.tfGruppeDirektSuffix);
        this.tfGruppeDirektSuffix.setComponentPopupMenu(handler.getPopupMenu());
        handler = new TextCopyPasteHandler<JTextField>(this.tfGruppeDirektPraefix);
        this.tfGruppeDirektPraefix.setComponentPopupMenu(handler.getPopupMenu());
        handler = new TextCopyPasteHandler<JTextField>(this.tfGruppeZielName);
        this.tfGruppeZielName.setComponentPopupMenu(handler.getPopupMenu());
        handler = new TextCopyPasteHandler<JTextField>(this.tfGruppeZielPfad);
        this.tfGruppeZielPfad.setComponentPopupMenu(handler.getPopupMenu());
        this.jButtonHilfe.addActionListener(e -> new DialogHilfe(this.parentComponent, this.modalHilfe, new GetFile().getHilfeSuchen("/mediathek/file/hilfetext_pset.txt")).setVisible(true));
        this.jRadioButtonAufloesungKlein.addActionListener(e -> this.setAufloesung());
        this.jRadioButtonAufloesungNormal.addActionListener(e -> this.setAufloesung());
        this.jRadioButtonAufloesungHD.addActionListener(e -> this.setAufloesung());
        this.jButtonPruefen.addActionListener(l -> this.programmePruefen());
        this.tabelleProgramme.getSelectionModel().addListSelectionListener(e -> {
            if (!e.getValueIsAdjusting() && !this.stopBeob) {
                this.fillTextProgramme();
            }
        });
        this.tabelleProgramme.setDefaultRenderer(Object.class, new CellRendererProgramme());
        this.tabellePset.setDefaultRenderer(Object.class, new CellRendererPset());
        this.tabellePset.getSelectionModel().addListSelectionListener(event -> {
            if (!this.stopBeob && !event.getValueIsAdjusting()) {
                this.tabelleProgramme();
                int row = this.tabellePset.getSelectedRow();
                if (row != -1) {
                    DatenPset datenPset = (DatenPset)this.listePset.get(this.tabellePset.convertRowIndexToModel(row));
                    this.tabellePset.getModel().setValueAt(this.jTextFieldSetName.getText(), this.tabellePset.convertRowIndexToModel(row), 0);
                    this.jTabbedPane.setTitleAt(0, "Set Name: " + datenPset.arr[0]);
                }
            }
        });
        this.tabellePset();
        if (this.tabellePset.getRowCount() > 0) {
            this.tabellePset.setRowSelectionInterval(0, 0);
            this.tabellePset.scrollRectToVisible(this.tabellePset.getCellRect(0, 0, false));
        }
    }

    public void programmePruefen() {
        String PIPE = "| ";
        String LEER = "      ";
        String PFEIL = " -> ";
        StringBuilder text = new StringBuilder();
        for (DatenPset datenPset : Daten.listePset) {
            boolean ret = true;
            if (datenPset.isFreeLine() || datenPset.isLabel()) continue;
            text.append("++++++++++++++++++++++++++++++++++++++++++++\n");
            text.append("| Programmgruppe: ").append(datenPset.arr[0]).append('\n');
            String zielPfad = datenPset.arr[4];
            if (datenPset.progsContainPath()) {
                if (zielPfad.isEmpty()) {
                    ret = false;
                    text.append("|       Zielpfad fehlt!\n");
                } else if (!GuiFunktionenProgramme.checkPathWriteable(zielPfad)) {
                    ret = false;
                    text.append("|       Falscher Zielpfad!\n");
                    text.append("|        -> Zielpfad \"").append(zielPfad).append("\" nicht beschreibbar!").append('\n');
                }
            }
            for (DatenProg datenProg : datenPset.getListeProg()) {
                String progPfad = datenProg.arr[2];
                String progName = datenProg.arr[0];
                if (progPfad.isEmpty()) {
                    ret = false;
                    text.append("|       Kein Programm angegeben!\n");
                    text.append("|        -> Programmname: ").append(progName).append('\n');
                    text.append("|             Pfad: ").append(progPfad).append('\n');
                    continue;
                }
                if (Files.isExecutable(Paths.get(progPfad, new String[0]))) continue;
                RuntimeExec r = new RuntimeExec(progPfad);
                Process pr = r.exec(false);
                if (pr == null) {
                    ret = false;
                    text.append("|       Falscher Programmpfad!\n");
                    text.append("|        -> Programmname: ").append(progName).append('\n');
                    text.append("|             Pfad: ").append(progPfad).append('\n');
                    if (progPfad.contains(File.separator)) continue;
                    text.append("|        -> Wenn das Programm nicht im Systempfad liegt, \n");
                    text.append("|             wird der Start nicht klappen!\n");
                    continue;
                }
                pr.destroy();
            }
            if (ret) {
                text.append("|  -> Ok!\n");
            }
            text.append("++++++++++++++++++++++++++++++++++++++++++++\n\n\n");
        }
        DialogHilfe dlg = new DialogHilfe(this.parentComponent, true, text.toString());
        dlg.setVisible(true);
    }

    private void setAufloesung() {
        DatenPset pset;
        if (this.jRadioButtonAufloesungNormal.isSelected() && (pset = this.getPset()) != null) {
            pset.arr[15] = FilmResolution.Enum.NORMAL.toString();
        }
        if (this.jRadioButtonAufloesungHD.isSelected() && (pset = this.getPset()) != null) {
            pset.arr[15] = FilmResolution.Enum.HIGH_QUALITY.toString();
        }
        if (this.jRadioButtonAufloesungKlein.isSelected() && (pset = this.getPset()) != null) {
            pset.arr[15] = FilmResolution.Enum.LOW.toString();
        }
    }

    private void tabellePset() {
        this.nurtabellePset();
        this.tabelleProgramme();
    }

    private void nurtabellePset() {
        this.stopBeob = true;
        this.tabellePset.getSpalten();
        this.tabellePset.setModel(this.listePset.getModel());
        this.tabellePset.setSpalten();
        this.spaltenSetzen();
        this.jLabelMeldungAbspielen.setVisible(this.listePset.getPsetAbspielen() == null);
        this.jLabelMeldungSeichern.setVisible(this.listePset.getListeSpeichern().isEmpty());
        this.stopBeob = false;
    }

    private void spaltenSetzen() {
        for (int i = 0; i < this.tabellePset.getColumnCount(); ++i) {
            if (i == 0) {
                this.tabellePset.getColumnModel().getColumn(this.tabellePset.convertColumnIndexToView(i)).setMinWidth(10);
                this.tabellePset.getColumnModel().getColumn(this.tabellePset.convertColumnIndexToView(i)).setPreferredWidth(120);
                this.tabellePset.getColumnModel().getColumn(this.tabellePset.convertColumnIndexToView(i)).setMaxWidth(1000);
                continue;
            }
            if (i == 7 || i == 8) {
                this.tabellePset.getColumnModel().getColumn(this.tabellePset.convertColumnIndexToView(i)).setMinWidth(10);
                this.tabellePset.getColumnModel().getColumn(this.tabellePset.convertColumnIndexToView(i)).setPreferredWidth(80);
                this.tabellePset.getColumnModel().getColumn(this.tabellePset.convertColumnIndexToView(i)).setMaxWidth(1000);
                continue;
            }
            this.tabellePset.getColumnModel().getColumn(this.tabellePset.convertColumnIndexToView(i)).setMinWidth(0);
            this.tabellePset.getColumnModel().getColumn(this.tabellePset.convertColumnIndexToView(i)).setPreferredWidth(0);
            this.tabellePset.getColumnModel().getColumn(this.tabellePset.convertColumnIndexToView(i)).setMaxWidth(0);
        }
    }

    private void tabelleProgramme() {
        DatenPset pSet = this.getPset();
        this.stopBeob = true;
        GuiFunktionen.enableComponents(this.jTabbedPane, pSet != null);
        this.jButtonAbspielen.setBackground(null);
        if (pSet != null) {
            this.jTabbedPane.setTitleAt(0, "Set Name: " + pSet.arr[0]);
            if (pSet.arr[13].equals("")) {
                this.jSpinnerLaenge.setValue(25);
                pSet.arr[13] = String.valueOf(25);
            } else {
                this.jSpinnerLaenge.setValue(Integer.parseInt(pSet.arr[13]));
            }
            if (pSet.arr[14].equals("")) {
                this.jSpinnerField.setValue(10);
                pSet.arr[14] = String.valueOf(10);
            } else {
                this.jSpinnerField.setValue(Integer.parseInt(pSet.arr[14]));
            }
            this.jCheckBoxLaenge.setSelected(Boolean.parseBoolean(pSet.arr[11]));
            this.jCheckBoxField.setSelected(Boolean.parseBoolean(pSet.arr[12]));
            this.jCheckBoxThema.setSelected(Boolean.parseBoolean(pSet.arr[6]));
            this.jCheckBoxInfodatei.setSelected(Boolean.parseBoolean(pSet.arr[19]));
            this.jCheckBoxSubtitle.setSelected(Boolean.parseBoolean(pSet.arr[21]));
            this.jCheckBoxSpotlight.setEnabled(SystemUtils.IS_OS_MAC_OSX);
            this.jCheckBoxSpotlight.setSelected(Boolean.parseBoolean(pSet.arr[20]));
            this.jScrollPane1.setBorder(BorderFactory.createTitledBorder(null, "Set Name: " + pSet.arr[0], 1, 2));
            this.jTextFieldSetName.setText(pSet.arr[0]);
            this.tfGruppeDirektSuffix.setText(pSet.arr[2]);
            this.tfGruppeDirektPraefix.setText(pSet.arr[1]);
            this.tfGruppeZielName.setText(pSet.arr[5]);
            this.tfGruppeZielPfad.setText(pSet.arr[4]);
            this.jTextAreaSetBeschreibung.setText(pSet.arr[17]);
            this.jCheckBoxSpeichern.setSelected(pSet.istSpeichern());
            this.jCheckBoxButton.setSelected(pSet.istButton());
            this.jCheckBoxAbo.setSelected(pSet.istAbo());
            switch (pSet.arr[15]) {
                case "hd": {
                    this.jRadioButtonAufloesungHD.setSelected(true);
                    break;
                }
                case "klein": {
                    this.jRadioButtonAufloesungKlein.setSelected(true);
                    break;
                }
                default: {
                    this.jRadioButtonAufloesungNormal.setSelected(true);
                }
            }
            this.tabelleProgramme.setModel(pSet.getListeProg().getModel());
            if (this.tabelleProgramme.getRowCount() > 0) {
                this.spaltenSetzenProgramme();
                this.tabelleProgramme.setRowSelectionInterval(0, 0);
                this.tabelleProgramme.scrollRectToVisible(this.tabelleProgramme.getCellRect(0, 0, true));
            }
        } else {
            this.jScrollPane1.setBorder(BorderFactory.createTitledBorder(null, "", 1, 2));
            this.jTabbedPane.setTitleAt(0, "Sets");
            this.jCheckBoxLaenge.setSelected(false);
            this.jCheckBoxThema.setSelected(false);
            this.jCheckBoxInfodatei.setSelected(false);
            this.jCheckBoxSubtitle.setSelected(false);
            this.jCheckBoxSpotlight.setSelected(false);
            this.jTextFieldSetName.setText("");
            this.tfGruppeDirektSuffix.setText("");
            this.tfGruppeDirektPraefix.setText("");
            this.tfGruppeZielName.setText("");
            this.tfGruppeZielPfad.setText("");
            this.jTextAreaSetBeschreibung.setText("");
            this.tabelleProgramme.setModel(new TModel(new Object[0][8], DatenProg.COLUMN_NAMES));
        }
        this.stopBeob = false;
        this.fillTextProgramme();
    }

    public void spaltenSetzenProgramme() {
        for (int i = 0; i < this.tabelleProgramme.getColumnCount(); ++i) {
            if (i == 4 || i == 6 || i == 7 || i == 5) {
                this.tabelleProgramme.getColumnModel().getColumn(this.tabelleProgramme.convertColumnIndexToView(i)).setMinWidth(10);
                this.tabelleProgramme.getColumnModel().getColumn(this.tabelleProgramme.convertColumnIndexToView(i)).setMaxWidth(3000);
                this.tabelleProgramme.getColumnModel().getColumn(this.tabelleProgramme.convertColumnIndexToView(i)).setPreferredWidth(75);
                continue;
            }
            this.tabelleProgramme.getColumnModel().getColumn(this.tabelleProgramme.convertColumnIndexToView(i)).setMinWidth(10);
            this.tabelleProgramme.getColumnModel().getColumn(this.tabelleProgramme.convertColumnIndexToView(i)).setMaxWidth(3000);
            this.tabelleProgramme.getColumnModel().getColumn(this.tabelleProgramme.convertColumnIndexToView(i)).setPreferredWidth(150);
        }
    }

    private void notifyProgramSetChanged() {
        MessageBus.getMessageBus().publishAsync(new ProgramSetChangedEvent());
    }

    private void fillTextProgramme() {
        this.stopBeob = true;
        int row = this.tabelleProgramme.getSelectedRow();
        boolean letzteZeile = this.tabelleProgramme.getRowCount() <= 1 || row == this.tabelleProgramme.getRowCount() - 1;
        this.jTextFieldProgPfad.setEnabled(row != -1);
        this.jTextFieldProgSchalter.setEnabled(row != -1);
        this.jTextFieldProgZielDateiName.setEnabled(row != -1);
        this.jTextFieldProgName.setEnabled(row != -1);
        this.jTextFieldProgZielDateiName.setEnabled(row != -1);
        this.jTextFieldProgPraefix.setEnabled(row != -1);
        this.jTextFieldProgSuffix.setEnabled(row != -1);
        this.jButtonProgPfad.setEnabled(row != -1);
        this.jCheckBoxRestart.setEnabled(row != -1);
        this.jCheckBoxRemoteDownload.setEnabled(row != -1);
        if (row != -1) {
            DatenProg prog = this.getPset().getProg(this.tabelleProgramme.convertRowIndexToModel(row));
            this.jTextFieldProgPfad.setText(prog.arr[2]);
            this.jTextFieldProgSchalter.setText(prog.arr[3]);
            this.jTextFieldProgZielDateiName.setText(prog.arr[1]);
            this.jTextFieldProgName.setText(prog.arr[0]);
            this.jTextFieldProgZielDateiName.setText(prog.arr[1]);
            this.jTextFieldProgPraefix.setText(prog.arr[4]);
            this.jTextFieldProgSuffix.setText(prog.arr[5]);
            this.jCheckBoxRestart.setSelected(prog.isRestart());
            this.jCheckBoxRemoteDownload.setSelected(prog.isDownloadManager());
        } else {
            this.jTextFieldProgPfad.setText("");
            this.jTextFieldProgSchalter.setText("");
            this.jTextFieldProgZielDateiName.setText("");
            this.jTextFieldProgName.setText("");
            this.jTextFieldProgZielDateiName.setText("");
            this.jTextFieldProgPraefix.setText("");
            this.jTextFieldProgSuffix.setText("");
        }
        if (letzteZeile) {
            this.jTextFieldProgPraefix.setEnabled(false);
            this.jTextFieldProgSuffix.setEnabled(false);
        }
        this.stopBeob = false;
    }

    private DatenPset getPset() {
        DatenPset ret = null;
        int row = this.tabellePset.getSelectedRow();
        if (row != -1) {
            ret = (DatenPset)this.listePset.get(this.tabellePset.convertRowIndexToModel(row));
        }
        return ret;
    }

    private void setAufAb(boolean auf) {
        int row = this.tabellePset.getSelectedRow();
        if (row != -1) {
            int neu = this.listePset.auf(this.tabellePset.convertRowIndexToModel(row), auf);
            neu = this.tabellePset.convertRowIndexToView(neu);
            this.tabellePset.setRowSelectionInterval(neu, neu);
            this.tabellePset.scrollRectToVisible(this.tabellePset.getCellRect(neu, 0, false));
            this.notifyProgramSetChanged();
        } else {
            NoSelectionErrorDialog.show(this);
        }
    }

    private void setNeu() {
        this.listePset.addPset(new DatenPset("Neu-" + ++this.neuZaehler));
        this.tabellePset();
        this.notifyProgramSetChanged();
    }

    private void setLoeschen() {
        int[] rows = this.tabellePset.getSelectedRows();
        if (rows.length > 0) {
            Object text;
            if (rows.length == 1) {
                DatenPset pSet = (DatenPset)this.listePset.get(this.tabellePset.convertRowIndexToModel(rows[0]));
                text = pSet.arr[0];
            } else {
                text = rows.length + " Set l\u00f6schen?";
            }
            int ret = JOptionPane.showConfirmDialog(this.parentComponent, text, "L\u00f6schen?", 0);
            if (ret == 0) {
                for (int i = rows.length - 1; i >= 0; --i) {
                    int delRow = this.tabellePset.convertRowIndexToModel(rows[i]);
                    ((TModel)this.tabellePset.getModel()).removeRow(delRow);
                    this.listePset.remove(delRow);
                }
                this.tabellePset();
                this.notifyProgramSetChanged();
            }
        } else {
            NoSelectionErrorDialog.show(this);
        }
    }

    private void setExport() {
        ArrayList<DatenPset> liste = new ArrayList<DatenPset>();
        int[] rows = this.tabellePset.getSelectedRows();
        if (rows.length > 0) {
            for (int row : rows) {
                int delRow = this.tabellePset.convertRowIndexToModel(row);
                DatenPset pSet = (DatenPset)this.listePset.get(delRow);
                if (pSet == null) continue;
                liste.add(pSet);
            }
            String entryName = ((DatenPset)liste.get((int)0)).arr[0];
            Object name = entryName.isEmpty() ? "Name.xml" : entryName + ".xml";
            String fileName = FilenameUtils.replaceLeerDateiname((String)name, false, Boolean.parseBoolean(MVConfig.get(MVConfig.Configs.SYSTEM_USE_REPLACETABLE)), Boolean.parseBoolean(MVConfig.get(MVConfig.Configs.SYSTEM_ONLY_ASCII)));
            File resultFile = FileDialogs.chooseSaveFileLocation(this.parentComponent, "PSet exportieren", fileName);
            if (resultFile != null) {
                String ziel = resultFile.getAbsolutePath();
                IoXmlSchreiben configWriter = new IoXmlSchreiben();
                configWriter.exportPset(liste.toArray(new DatenPset[0]), ziel);
                JOptionPane.showMessageDialog(this, "Das Programmset wurde erfolgreich exportiert.", "MediathekView", 1);
            }
        } else {
            NoSelectionErrorDialog.show(this);
        }
    }

    private void progNeueZeile(DatenProg prog) {
        DatenPset gruppe = this.getPset();
        if (gruppe != null) {
            gruppe.addProg(prog);
            this.tabelleProgramme();
        }
    }

    private void progAufAb(boolean auf) {
        int rows = this.tabelleProgramme.getSelectedRow();
        if (rows != -1) {
            int row = this.tabelleProgramme.convertRowIndexToModel(rows);
            int neu = this.getPset().getListeProg().auf(row, auf);
            this.tabelleProgramme();
            this.tabelleProgramme.setRowSelectionInterval(neu, neu);
            this.tabelleProgramme.scrollRectToVisible(this.tabelleProgramme.getCellRect(neu, 0, true));
        } else {
            NoSelectionErrorDialog.show(this);
        }
    }

    private void initComponents() {
        this.jButtonHilfe = new JButton();
        this.jButtonPruefen = new JButton();
        JSplitPane jSplitPane1 = new JSplitPane();
        this.jTabbedPane = new JTabbedPane();
        JPanel jPanelDetails = new JPanel();
        JPanel jPanel7 = new JPanel();
        JLabel jLabel6 = new JLabel();
        this.jTextFieldSetName = new JTextField();
        JPanel jPanel4 = new JPanel();
        JScrollPane jScrollPane2 = new JScrollPane();
        this.jTextAreaSetBeschreibung = new JTextArea();
        JPanel jPanel6 = new JPanel();
        this.jCheckBoxSpeichern = new JCheckBox();
        this.jCheckBoxButton = new JCheckBox();
        this.jCheckBoxAbo = new JCheckBox();
        this.jButtonAbspielen = new JButton();
        this.jLabelMeldungAbspielen = new JLabel();
        this.jLabelMeldungSeichern = new JLabel();
        JPanel jPanel10 = new JPanel();
        JPanel jPanel5 = new JPanel();
        this.jButtonGruppeFarbe = new JButton();
        this.jButtonGruppeStandardfarbe = new JButton();
        JLabel jLabel11 = new JLabel();
        JLabel jLabel13 = new JLabel();
        JPanel jPanel9 = new JPanel();
        JPanel jPanel1 = new JPanel();
        JLabel jLabel7 = new JLabel();
        this.tfGruppeZielPfad = new JTextField();
        this.jButtonGruppePfad = new JButton();
        this.jCheckBoxThema = new JCheckBox();
        JLabel jLabel8 = new JLabel();
        this.tfGruppeZielName = new JTextField();
        this.jCheckBoxLaenge = new JCheckBox();
        this.jSpinnerLaenge = new JSpinner();
        JLabel jLabel12 = new JLabel();
        JLabel jLabel15 = new JLabel();
        this.jCheckBoxField = new JCheckBox();
        this.jSpinnerField = new JSpinner();
        JLabel jLabel16 = new JLabel();
        JPanel jPanel11 = new JPanel();
        JPanel jPanel8 = new JPanel();
        JLabel jLabel10 = new JLabel();
        this.tfGruppeDirektPraefix = new JTextField();
        JLabel jLabel5 = new JLabel();
        this.tfGruppeDirektSuffix = new JTextField();
        JTextArea jTextArea1 = new JTextArea();
        JPanel jPanel12 = new JPanel();
        this.jRadioButtonAufloesungNormal = new JRadioButton();
        this.jRadioButtonAufloesungKlein = new JRadioButton();
        this.jRadioButtonAufloesungHD = new JRadioButton();
        JLabel jLabel14 = new JLabel();
        JPanel jPanel13 = new JPanel();
        this.jCheckBoxInfodatei = new JCheckBox();
        this.jCheckBoxSpotlight = new JCheckBox();
        this.jCheckBoxSubtitle = new JCheckBox();
        JPanel jPanelProgramme = new JPanel();
        this.jScrollPane1 = new JScrollPane();
        JTable jTableProgramme = new JTable();
        JPanel jPanel2 = new JPanel();
        this.jButtonProgPlus = new JButton();
        this.jButtonProgMinus = new JButton();
        this.jButtonProgDuplizieren = new JButton();
        this.jButtonProgAuf = new JButton();
        this.jButtonProgAb = new JButton();
        JPanel jPanelProgrammDetails = new JPanel();
        JLabel jLabel = new JLabel();
        this.jTextFieldProgPfad = new JTextField();
        this.jButtonProgPfad = new JButton();
        this.jTextFieldProgSchalter = new JTextField();
        JLabel jLabel1 = new JLabel();
        JLabel jLabel2 = new JLabel();
        this.jTextFieldProgName = new JTextField();
        JLabel jLabel3 = new JLabel();
        this.jTextFieldProgPraefix = new JTextField();
        JLabel jLabel4 = new JLabel();
        this.jTextFieldProgSuffix = new JTextField();
        this.jCheckBoxRestart = new JCheckBox();
        JLabel jLabel9 = new JLabel();
        this.jTextFieldProgZielDateiName = new JTextField();
        this.jCheckBoxRemoteDownload = new JCheckBox();
        JPanel jPanel3 = new JPanel();
        this.jScrollPane3 = new JScrollPane();
        JTable jTablePset = new JTable();
        this.jButtonGruppeDuplizieren = new JButton();
        this.jButtonExport = new JButton();
        this.jButtonGruppeNeu = new JButton();
        this.jButtonGruppeLoeschen = new JButton();
        this.jButtonGruppeAuf = new JButton();
        JPanel hSpacer1 = new JPanel(null);
        this.jButtonGruppeAb = new JButton();
        this.jButtonHilfe.setIcon(new ImageIcon(this.getClass().getResource("/mediathek/res/muster/button-help.png")));
        this.jButtonHilfe.setToolTipText("Hilfe anzeigen");
        this.jButtonPruefen.setText("Pr\u00fcfen");
        this.jButtonPruefen.setToolTipText("Programmpfade pr\u00fcfen");
        jSplitPane1.setDividerLocation(290);
        jPanelDetails.setBorder(new SoftBevelBorder(0));
        jPanel7.setBorder(new EtchedBorder());
        jLabel6.setText("Set Name:");
        jPanel4.setBorder(new TitledBorder("Beschreibung"));
        this.jTextAreaSetBeschreibung.setColumns(20);
        this.jTextAreaSetBeschreibung.setRows(8);
        this.jTextAreaSetBeschreibung.setPreferredSize(new Dimension(160, 130));
        this.jTextAreaSetBeschreibung.setMinimumSize(new Dimension(50, 50));
        jScrollPane2.setViewportView(this.jTextAreaSetBeschreibung);
        GroupLayout jPanel4Layout = new GroupLayout(jPanel4);
        jPanel4.setLayout(jPanel4Layout);
        jPanel4Layout.setHorizontalGroup(jPanel4Layout.createParallelGroup().addGroup(jPanel4Layout.createSequentialGroup().addContainerGap().addComponent(jScrollPane2, -1, 567, Short.MAX_VALUE).addContainerGap()));
        jPanel4Layout.setVerticalGroup(jPanel4Layout.createParallelGroup().addGroup(jPanel4Layout.createSequentialGroup().addComponent(jScrollPane2, -1, 211, Short.MAX_VALUE).addContainerGap()));
        jPanel6.setBorder(new TitledBorder("Funktion"));
        this.jCheckBoxSpeichern.setText("Speichern");
        this.jCheckBoxButton.setText("Button");
        this.jCheckBoxAbo.setText("Abo");
        this.jButtonAbspielen.setText("Abspielen via schwarzem Play-Button");
        GroupLayout jPanel6Layout = new GroupLayout(jPanel6);
        jPanel6.setLayout(jPanel6Layout);
        jPanel6Layout.setHorizontalGroup(jPanel6Layout.createParallelGroup().addGroup(jPanel6Layout.createSequentialGroup().addContainerGap().addComponent(this.jButtonAbspielen).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.jCheckBoxSpeichern).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.jCheckBoxButton).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.jCheckBoxAbo).addContainerGap(71, Short.MAX_VALUE)));
        jPanel6Layout.setVerticalGroup(jPanel6Layout.createParallelGroup().addGroup(jPanel6Layout.createSequentialGroup().addContainerGap().addGroup(jPanel6Layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jCheckBoxSpeichern).addComponent(this.jCheckBoxButton).addComponent(this.jCheckBoxAbo).addComponent(this.jButtonAbspielen)).addContainerGap(-1, Short.MAX_VALUE)));
        this.jLabelMeldungAbspielen.setText("kein Set zum Abspielen ausgew\u00e4hlt!");
        this.jLabelMeldungSeichern.setText("kein Set zum Speichern ausgew\u00e4hlt!");
        GroupLayout jPanel7Layout = new GroupLayout(jPanel7);
        jPanel7.setLayout(jPanel7Layout);
        jPanel7Layout.setHorizontalGroup(jPanel7Layout.createParallelGroup().addGroup(jPanel7Layout.createSequentialGroup().addContainerGap().addGroup(jPanel7Layout.createParallelGroup().addGroup(jPanel7Layout.createSequentialGroup().addComponent(jLabel6).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jTextFieldSetName)).addComponent(jPanel4, -1, -1, Short.MAX_VALUE).addComponent(jPanel6, -1, -1, Short.MAX_VALUE).addGroup(jPanel7Layout.createSequentialGroup().addGroup(jPanel7Layout.createParallelGroup().addComponent(this.jLabelMeldungAbspielen).addComponent(this.jLabelMeldungSeichern)).addGap(0, 0, Short.MAX_VALUE))).addContainerGap()));
        jPanel7Layout.setVerticalGroup(jPanel7Layout.createParallelGroup().addGroup(jPanel7Layout.createSequentialGroup().addContainerGap().addGroup(jPanel7Layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jTextFieldSetName, -2, -1, -2).addComponent(jLabel6)).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(jPanel4, -1, -1, Short.MAX_VALUE).addGap(18, 18, 18).addComponent(jPanel6, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.jLabelMeldungAbspielen).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.jLabelMeldungSeichern).addGap(38, 38, 38)));
        GroupLayout jPanelDetailsLayout = new GroupLayout(jPanelDetails);
        jPanelDetails.setLayout(jPanelDetailsLayout);
        jPanelDetailsLayout.setHorizontalGroup(jPanelDetailsLayout.createParallelGroup().addGroup(jPanelDetailsLayout.createSequentialGroup().addContainerGap().addComponent(jPanel7, -1, -1, Short.MAX_VALUE).addContainerGap()));
        jPanelDetailsLayout.setVerticalGroup(jPanelDetailsLayout.createParallelGroup().addGroup(jPanelDetailsLayout.createSequentialGroup().addContainerGap().addComponent(jPanel7, -1, -1, Short.MAX_VALUE).addGap(21, 21, 21)));
        this.jTabbedPane.addTab("Einstellungen", jPanelDetails);
        jPanel5.setBorder(new EtchedBorder());
        this.jButtonGruppeFarbe.setText("Farbe");
        this.jButtonGruppeFarbe.setToolTipText("Farbauswahldialog anzeigen");
        this.jButtonGruppeStandardfarbe.setText("Standardfarbe");
        this.jButtonGruppeStandardfarbe.setToolTipText("Farbe zur\u00fccksetzen");
        jLabel11.setText("Wird das Set als Button verwendet,");
        jLabel13.setText("kann damit die Schriftfarbe ver\u00e4ndert werden.");
        GroupLayout jPanel5Layout = new GroupLayout(jPanel5);
        jPanel5.setLayout(jPanel5Layout);
        jPanel5Layout.setHorizontalGroup(jPanel5Layout.createParallelGroup().addGroup(jPanel5Layout.createSequentialGroup().addContainerGap().addGroup(jPanel5Layout.createParallelGroup().addGroup(jPanel5Layout.createSequentialGroup().addComponent(this.jButtonGruppeFarbe).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jButtonGruppeStandardfarbe)).addComponent(jLabel11).addComponent(jLabel13)).addContainerGap(317, Short.MAX_VALUE)));
        jPanel5Layout.linkSize(0, this.jButtonGruppeFarbe, this.jButtonGruppeStandardfarbe);
        jPanel5Layout.setVerticalGroup(jPanel5Layout.createParallelGroup().addGroup(jPanel5Layout.createSequentialGroup().addContainerGap().addComponent(jLabel11).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(jLabel13).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addGroup(jPanel5Layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jButtonGruppeFarbe).addComponent(this.jButtonGruppeStandardfarbe)).addContainerGap(-1, Short.MAX_VALUE)));
        GroupLayout jPanel10Layout = new GroupLayout(jPanel10);
        jPanel10.setLayout(jPanel10Layout);
        jPanel10Layout.setHorizontalGroup(jPanel10Layout.createParallelGroup().addGroup(jPanel10Layout.createSequentialGroup().addContainerGap().addComponent(jPanel5, -1, -1, Short.MAX_VALUE).addContainerGap()));
        jPanel10Layout.setVerticalGroup(jPanel10Layout.createParallelGroup().addGroup(jPanel10Layout.createSequentialGroup().addContainerGap().addComponent(jPanel5, -2, -1, -2).addContainerGap(402, Short.MAX_VALUE)));
        this.jTabbedPane.addTab("Aussehen", jPanel10);
        jPanel1.setBorder(new EtchedBorder());
        jLabel7.setText("Zielpfad:");
        this.jButtonGruppePfad.setIcon(new ImageIcon(this.getClass().getResource("/mediathek/res/muster/button-file-open.png")));
        this.jButtonGruppePfad.setToolTipText("Pfad ausw\u00e4hlen");
        this.jCheckBoxThema.setText("einen Unterordner mit dem Thema / Abo-Zielpfad anlegen");
        this.jCheckBoxThema.setToolTipText("im Zielverzeichnis wird ein Unterordner mit dem Namen des Themas zum Speichern der Filme angelegt");
        jLabel8.setText("Zieldateiname:");
        this.jCheckBoxLaenge.setText("ganzen Dateiname beschr\u00e4nken auf:");
        this.jCheckBoxLaenge.setToolTipText("die L\u00e4nge des Dateinamens wird auf die Anzahl Zeichen beschr\u00e4nkt");
        this.jSpinnerLaenge.setModel(new SpinnerNumberModel(25, 10, 200, 1));
        jLabel12.setText("Zeichen");
        jLabel15.setText("(ist der Abo-Zielpfad leer, wird das Thema verwendet)");
        this.jCheckBoxField.setText("einzelne Felder beschr\u00e4nken auf:");
        this.jSpinnerField.setModel(new SpinnerNumberModel(10, 3, 100, 1));
        jLabel16.setText("Zeichen");
        GroupLayout jPanel1Layout = new GroupLayout(jPanel1);
        jPanel1.setLayout(jPanel1Layout);
        jPanel1Layout.setHorizontalGroup(jPanel1Layout.createParallelGroup().addGroup(jPanel1Layout.createSequentialGroup().addContainerGap().addGroup(jPanel1Layout.createParallelGroup().addGroup(jPanel1Layout.createSequentialGroup().addGap(21, 21, 21).addComponent(jLabel15).addGap(0, 0, Short.MAX_VALUE)).addGroup(jPanel1Layout.createSequentialGroup().addGroup(jPanel1Layout.createParallelGroup().addGroup(jPanel1Layout.createSequentialGroup().addComponent(jLabel7).addGap(56, 56, 56).addComponent(this.tfGruppeZielPfad).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jButtonGruppePfad)).addGroup(jPanel1Layout.createSequentialGroup().addComponent(this.jCheckBoxThema).addGap(0, 205, Short.MAX_VALUE))).addGap(16, 16, 16)).addGroup(jPanel1Layout.createSequentialGroup().addComponent(jLabel8).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(jPanel1Layout.createParallelGroup().addComponent(this.tfGruppeZielName).addGroup(jPanel1Layout.createSequentialGroup().addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING, false).addGroup(jPanel1Layout.createSequentialGroup().addComponent(this.jCheckBoxLaenge).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jSpinnerLaenge, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(jLabel12)).addGroup(jPanel1Layout.createSequentialGroup().addComponent(this.jCheckBoxField).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, -1, Short.MAX_VALUE).addComponent(this.jSpinnerField, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(jLabel16))).addGap(0, 0, Short.MAX_VALUE))).addContainerGap()))));
        jPanel1Layout.setVerticalGroup(jPanel1Layout.createParallelGroup().addGroup(jPanel1Layout.createSequentialGroup().addContainerGap().addComponent(this.jCheckBoxThema).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(jLabel15).addGap(18, 18, 18).addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.CENTER).addComponent(jLabel7).addComponent(this.tfGruppeZielPfad, -2, -1, -2).addComponent(this.jButtonGruppePfad)).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(jLabel8).addComponent(this.tfGruppeZielName, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jCheckBoxLaenge).addComponent(this.jSpinnerLaenge, -2, -1, -2).addComponent(jLabel12)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jCheckBoxField).addComponent(this.jSpinnerField, -2, -1, -2).addComponent(jLabel16)).addContainerGap(-1, Short.MAX_VALUE)));
        jPanel1Layout.linkSize(1, this.jButtonGruppePfad, this.tfGruppeZielName, this.tfGruppeZielPfad);
        GroupLayout jPanel9Layout = new GroupLayout(jPanel9);
        jPanel9.setLayout(jPanel9Layout);
        jPanel9Layout.setHorizontalGroup(jPanel9Layout.createParallelGroup().addGroup(jPanel9Layout.createSequentialGroup().addContainerGap().addComponent(jPanel1, -1, -1, Short.MAX_VALUE).addContainerGap()));
        jPanel9Layout.setVerticalGroup(jPanel9Layout.createParallelGroup().addGroup(jPanel9Layout.createSequentialGroup().addContainerGap().addComponent(jPanel1, -2, -1, -2).addContainerGap(271, Short.MAX_VALUE)));
        this.jTabbedPane.addTab("Speicherziel", jPanel9);
        jPanel8.setBorder(new TitledBorder("direkt speichern"));
        jLabel10.setText("direkter Download, Pr\u00e4fix ( z.B. http ):");
        jLabel5.setText("Suffix ( z.B. mp4,mp3):");
        GroupLayout jPanel8Layout = new GroupLayout(jPanel8);
        jPanel8.setLayout(jPanel8Layout);
        jPanel8Layout.setHorizontalGroup(jPanel8Layout.createParallelGroup().addGroup(jPanel8Layout.createSequentialGroup().addContainerGap().addComponent(jLabel10).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.tfGruppeDirektPraefix).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(jLabel5).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.tfGruppeDirektSuffix).addContainerGap()));
        jPanel8Layout.setVerticalGroup(jPanel8Layout.createParallelGroup().addGroup(jPanel8Layout.createSequentialGroup().addContainerGap().addGroup(jPanel8Layout.createParallelGroup(GroupLayout.Alignment.CENTER).addComponent(jLabel10).addComponent(this.tfGruppeDirektPraefix, -2, -1, -2).addComponent(jLabel5).addComponent(this.tfGruppeDirektSuffix, -2, -1, -2)).addContainerGap(34, Short.MAX_VALUE)));
        jTextArea1.setEditable(false);
        jTextArea1.setBackground(new Color(238, 238, 238));
        jTextArea1.setColumns(20);
        jTextArea1.setRows(4);
        jTextArea1.setText("Filme, deren URL mit \"Pr\u00e4fix\" beginnt und mit \"Suffix\" endet, werden nicht\nmit einem Hilfsprogramm gespeichert, sondern direkt geladen.\n\nEine geringere Aufl\u00f6sung ist nicht bei jedem Sender m\u00f6glich, es wird dann in der gleichen\nAufl\u00f6sung geladen.");
        jTextArea1.setBorder(null);
        jPanel12.setBorder(new TitledBorder("Film downloaden in"));
        this.jRadioButtonAufloesungNormal.setSelected(true);
        this.jRadioButtonAufloesungNormal.setText("Mittlere Qualit\u00e4t");
        this.jRadioButtonAufloesungKlein.setText("Niedrige Qualit\u00e4t");
        this.jRadioButtonAufloesungHD.setText("H\u00f6chste/Hohe Qualit\u00e4t");
        jLabel14.setText("Wenn es die Qualit\u00e4tstufe im Angebot nicht gibt, wird die n\u00e4chstkleinere genommen.");
        GroupLayout jPanel12Layout = new GroupLayout(jPanel12);
        jPanel12.setLayout(jPanel12Layout);
        jPanel12Layout.setHorizontalGroup(jPanel12Layout.createParallelGroup().addGroup(jPanel12Layout.createSequentialGroup().addContainerGap().addGroup(jPanel12Layout.createParallelGroup().addComponent(jLabel14).addComponent(this.jRadioButtonAufloesungNormal).addComponent(this.jRadioButtonAufloesungKlein).addComponent(this.jRadioButtonAufloesungHD)).addContainerGap(-1, Short.MAX_VALUE)));
        jPanel12Layout.setVerticalGroup(jPanel12Layout.createParallelGroup().addGroup(jPanel12Layout.createSequentialGroup().addContainerGap().addComponent(this.jRadioButtonAufloesungHD).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.jRadioButtonAufloesungNormal).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.jRadioButtonAufloesungKlein).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(jLabel14).addContainerGap(30, Short.MAX_VALUE)));
        jPanel13.setBorder(new TitledBorder("nach dem Speichern"));
        this.jCheckBoxInfodatei.setText("Infodatei anlegen: \"Filmname.txt\"");
        this.jCheckBoxSpotlight.setText("Filmbeschreibung als Finder-Kommentar f\u00fcr Spotlight speichern (nur OS X)");
        this.jCheckBoxSubtitle.setText("Untertitel speichern: \"Filmname.xxx\"");
        GroupLayout jPanel13Layout = new GroupLayout(jPanel13);
        jPanel13.setLayout(jPanel13Layout);
        jPanel13Layout.setHorizontalGroup(jPanel13Layout.createParallelGroup().addGroup(jPanel13Layout.createSequentialGroup().addContainerGap().addGroup(jPanel13Layout.createParallelGroup().addComponent(this.jCheckBoxSpotlight).addComponent(this.jCheckBoxInfodatei).addComponent(this.jCheckBoxSubtitle)).addContainerGap(-1, Short.MAX_VALUE)));
        jPanel13Layout.setVerticalGroup(jPanel13Layout.createParallelGroup().addGroup(jPanel13Layout.createSequentialGroup().addContainerGap().addComponent(this.jCheckBoxInfodatei).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.jCheckBoxSubtitle).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED, -1, Short.MAX_VALUE).addComponent(this.jCheckBoxSpotlight)));
        GroupLayout jPanel11Layout = new GroupLayout(jPanel11);
        jPanel11.setLayout(jPanel11Layout);
        jPanel11Layout.setHorizontalGroup(jPanel11Layout.createParallelGroup().addGroup(jPanel11Layout.createSequentialGroup().addContainerGap().addGroup(jPanel11Layout.createParallelGroup().addComponent(jTextArea1).addComponent(jPanel8, GroupLayout.Alignment.TRAILING, -1, -1, Short.MAX_VALUE).addComponent(jPanel12, -1, -1, Short.MAX_VALUE).addComponent(jPanel13, -1, -1, Short.MAX_VALUE)).addContainerGap()));
        jPanel11Layout.setVerticalGroup(jPanel11Layout.createParallelGroup().addGroup(jPanel11Layout.createSequentialGroup().addContainerGap().addComponent(jTextArea1, -2, 91, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(jPanel8, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(jPanel12, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(jPanel13, -2, -1, -2).addContainerGap(-1, Short.MAX_VALUE)));
        this.jTabbedPane.addTab("Download", jPanel11);
        this.jScrollPane1.setBorder(new TitledBorder(null, "Titel", 1, 2));
        jTableProgramme.setModel(new TModel());
        jTableProgramme.setAutoResizeMode(0);
        this.jScrollPane1.setViewportView(jTableProgramme);
        jPanel2.setBorder(new EtchedBorder());
        this.jButtonProgPlus.setIcon(new ImageIcon(this.getClass().getResource("/mediathek/res/muster/button-add.png")));
        this.jButtonProgPlus.setToolTipText("neues Programm anlegen");
        this.jButtonProgMinus.setIcon(new ImageIcon(this.getClass().getResource("/mediathek/res/muster/button-remove.png")));
        this.jButtonProgMinus.setToolTipText("markiertes Programm l\u00f6schen");
        this.jButtonProgDuplizieren.setText("Duplizieren");
        this.jButtonProgDuplizieren.setToolTipText("markierte Zeile duplizieren");
        this.jButtonProgAuf.setIcon(new ImageIcon(this.getClass().getResource("/mediathek/res/muster/button-move-up.png")));
        this.jButtonProgAuf.setToolTipText("markierte Zeile eins nach oben");
        this.jButtonProgAb.setIcon(new ImageIcon(this.getClass().getResource("/mediathek/res/muster/button-move-down.png")));
        this.jButtonProgAb.setToolTipText("markierte Zeile eins nach unten");
        GroupLayout jPanel2Layout = new GroupLayout(jPanel2);
        jPanel2.setLayout(jPanel2Layout);
        jPanel2Layout.setHorizontalGroup(jPanel2Layout.createParallelGroup().addGroup(jPanel2Layout.createSequentialGroup().addContainerGap().addComponent(this.jButtonProgPlus).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jButtonProgMinus).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jButtonProgAuf).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jButtonProgAb).addGap(18, 18, 18).addComponent(this.jButtonProgDuplizieren).addContainerGap(-1, Short.MAX_VALUE)));
        jPanel2Layout.setVerticalGroup(jPanel2Layout.createParallelGroup().addGroup(jPanel2Layout.createSequentialGroup().addContainerGap().addGroup(jPanel2Layout.createParallelGroup().addGroup(jPanel2Layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jButtonProgPlus).addComponent(this.jButtonProgMinus).addComponent(this.jButtonProgAuf).addComponent(this.jButtonProgAb)).addComponent(this.jButtonProgDuplizieren, GroupLayout.Alignment.TRAILING)).addContainerGap(-1, Short.MAX_VALUE)));
        jPanelProgrammDetails.setBorder(new EtchedBorder());
        jLabel.setText("Programm:");
        this.jButtonProgPfad.setIcon(new ImageIcon(this.getClass().getResource("/mediathek/res/muster/button-file-open.png")));
        this.jButtonProgPfad.setToolTipText("Programm ausw\u00e4hlen");
        jLabel1.setText("Schalter:");
        jLabel2.setText("Beschreibung:");
        jLabel3.setText("Pr\u00e4fix (z.B. http):");
        jLabel4.setText("Suffix ( z.B. mp4,mp3):");
        this.jCheckBoxRestart.setText("fehlgeschlagene Downloads wieder starten");
        jLabel9.setText("Zieldateiname:");
        this.jCheckBoxRemoteDownload.setText("externer Downloadmanager");
        GroupLayout jPanelProgrammDetailsLayout = new GroupLayout(jPanelProgrammDetails);
        jPanelProgrammDetails.setLayout(jPanelProgrammDetailsLayout);
        jPanelProgrammDetailsLayout.setHorizontalGroup(jPanelProgrammDetailsLayout.createParallelGroup().addGroup(jPanelProgrammDetailsLayout.createSequentialGroup().addContainerGap().addGroup(jPanelProgrammDetailsLayout.createParallelGroup().addGroup(jPanelProgrammDetailsLayout.createSequentialGroup().addGroup(jPanelProgrammDetailsLayout.createParallelGroup().addComponent(jLabel2).addComponent(jLabel9)).addGap(24, 24, 24).addGroup(jPanelProgrammDetailsLayout.createParallelGroup().addComponent(this.jTextFieldProgZielDateiName).addComponent(this.jTextFieldProgName))).addGroup(jPanelProgrammDetailsLayout.createSequentialGroup().addGroup(jPanelProgrammDetailsLayout.createParallelGroup().addComponent(jLabel3).addComponent(jLabel1).addComponent(jLabel)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(jPanelProgrammDetailsLayout.createParallelGroup().addComponent(this.jTextFieldProgSchalter).addGroup(GroupLayout.Alignment.TRAILING, jPanelProgrammDetailsLayout.createSequentialGroup().addComponent(this.jTextFieldProgPfad).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jButtonProgPfad)).addGroup(jPanelProgrammDetailsLayout.createSequentialGroup().addComponent(this.jTextFieldProgPraefix, -2, 146, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(jLabel4).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jTextFieldProgSuffix, -1, 183, Short.MAX_VALUE)).addGroup(jPanelProgrammDetailsLayout.createSequentialGroup().addGroup(jPanelProgrammDetailsLayout.createParallelGroup().addComponent(this.jCheckBoxRemoteDownload).addComponent(this.jCheckBoxRestart)).addGap(0, 194, Short.MAX_VALUE))))).addContainerGap()));
        jPanelProgrammDetailsLayout.setVerticalGroup(jPanelProgrammDetailsLayout.createParallelGroup().addGroup(jPanelProgrammDetailsLayout.createSequentialGroup().addContainerGap().addGroup(jPanelProgrammDetailsLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(jLabel2).addComponent(this.jTextFieldProgName, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(jPanelProgrammDetailsLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(jLabel9).addComponent(this.jTextFieldProgZielDateiName, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(jPanelProgrammDetailsLayout.createParallelGroup(GroupLayout.Alignment.CENTER).addComponent(jLabel).addComponent(this.jTextFieldProgPfad, -2, 12, -2).addComponent(this.jButtonProgPfad)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(jPanelProgrammDetailsLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(jLabel1).addComponent(this.jTextFieldProgSchalter, -2, 15, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(jPanelProgrammDetailsLayout.createParallelGroup(GroupLayout.Alignment.BASELINE, false).addComponent(this.jTextFieldProgPraefix, -2, -1, -2).addComponent(jLabel3).addComponent(this.jTextFieldProgSuffix, -2, -1, -2).addComponent(jLabel4)).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.jCheckBoxRestart).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.jCheckBoxRemoteDownload).addContainerGap(-1, Short.MAX_VALUE)));
        jPanelProgrammDetailsLayout.linkSize(1, this.jButtonProgPfad, this.jTextFieldProgName, this.jTextFieldProgPfad, this.jTextFieldProgPraefix, this.jTextFieldProgSchalter, this.jTextFieldProgSuffix, this.jTextFieldProgZielDateiName);
        GroupLayout jPanelProgrammeLayout = new GroupLayout(jPanelProgramme);
        jPanelProgramme.setLayout(jPanelProgrammeLayout);
        jPanelProgrammeLayout.setHorizontalGroup(jPanelProgrammeLayout.createParallelGroup().addGroup(jPanelProgrammeLayout.createSequentialGroup().addContainerGap().addGroup(jPanelProgrammeLayout.createParallelGroup().addComponent(jPanelProgrammDetails, -1, -1, Short.MAX_VALUE).addComponent(this.jScrollPane1).addComponent(jPanel2, -1, -1, Short.MAX_VALUE)).addContainerGap()));
        jPanelProgrammeLayout.setVerticalGroup(jPanelProgrammeLayout.createParallelGroup().addGroup(GroupLayout.Alignment.TRAILING, jPanelProgrammeLayout.createSequentialGroup().addContainerGap().addComponent(this.jScrollPane1, -1, 184, Short.MAX_VALUE).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(jPanel2, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(jPanelProgrammDetails, -2, -1, -2)));
        this.jTabbedPane.addTab("Hilfsprogramme", jPanelProgramme);
        jSplitPane1.setRightComponent(this.jTabbedPane);
        jPanel3.setLayout(new MigLayout(new LC().insets("0").hideMode(3).gridGap("5", "5"), new AC().fill().gap().grow().fill().gap().fill(), new AC().grow().fill().gap().fill().gap().fill().gap().fill().gap().fill()));
        this.jScrollPane3.setPreferredSize(new Dimension(150, 150));
        jTablePset.setModel(new DefaultTableModel(new Object[][]{{null, null, null}}, new String[]{"Title 1", "Title 2", "Title 3"}));
        jTablePset.setAutoResizeMode(0);
        jTablePset.setMinimumSize(new Dimension(50, 16));
        jTablePset.setPreferredSize(new Dimension(150, 50));
        this.jScrollPane3.setViewportView(jTablePset);
        jPanel3.add((Component)this.jScrollPane3, new CC().cell(0, 0, 3, 1));
        this.jButtonGruppeDuplizieren.setText("Duplizieren");
        this.jButtonGruppeDuplizieren.setToolTipText("Programmgruppe kopieren");
        jPanel3.add((Component)this.jButtonGruppeDuplizieren, new CC().cell(0, 3, 3, 1));
        this.jButtonExport.setText("Export");
        this.jButtonExport.setToolTipText("Programmgruppe in Datei exportieren");
        jPanel3.add((Component)this.jButtonExport, new CC().cell(0, 4, 3, 1));
        this.jButtonGruppeNeu.setIcon(new ImageIcon(this.getClass().getResource("/mediathek/res/muster/button-add.png")));
        this.jButtonGruppeNeu.setToolTipText("neue Programmgruppe anlegen");
        jPanel3.add((Component)this.jButtonGruppeNeu, new CC().cell(0, 2).alignX("center").growX(0.0f));
        this.jButtonGruppeLoeschen.setIcon(new ImageIcon(this.getClass().getResource("/mediathek/res/muster/button-remove.png")));
        this.jButtonGruppeLoeschen.setToolTipText("Programmgruppe l\u00f6schen");
        jPanel3.add((Component)this.jButtonGruppeLoeschen, new CC().cell(2, 2).alignX("center").growX(0.0f));
        this.jButtonGruppeAuf.setIcon(new ImageIcon(this.getClass().getResource("/mediathek/res/muster/button-move-up.png")));
        this.jButtonGruppeAuf.setToolTipText("Programmgruppe nach oben schieben");
        jPanel3.add((Component)this.jButtonGruppeAuf, new CC().cell(0, 1).alignX("center").growX(0.0f));
        jPanel3.add((Component)hSpacer1, new CC().cell(1, 1));
        this.jButtonGruppeAb.setIcon(new ImageIcon(this.getClass().getResource("/mediathek/res/muster/button-move-down.png")));
        this.jButtonGruppeAb.setToolTipText("Programmgruppe nach unten schieben");
        jPanel3.add((Component)this.jButtonGruppeAb, new CC().cell(2, 1).alignX("center").growX(0.0f));
        jSplitPane1.setLeftComponent(jPanel3);
        GroupLayout layout = new GroupLayout(this);
        this.setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup().addGroup(layout.createSequentialGroup().addGroup(layout.createParallelGroup().addComponent(jSplitPane1, -1, 926, Short.MAX_VALUE).addGroup(GroupLayout.Alignment.TRAILING, layout.createSequentialGroup().addContainerGap(742, Short.MAX_VALUE).addComponent(this.jButtonPruefen, -2, 100, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jButtonHilfe))).addContainerGap()));
        layout.setVerticalGroup(layout.createParallelGroup().addGroup(layout.createSequentialGroup().addContainerGap().addComponent(jSplitPane1).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.CENTER).addComponent(this.jButtonHilfe).addComponent(this.jButtonPruefen)).addContainerGap()));
        ButtonGroup buttonGroup1 = new ButtonGroup();
        buttonGroup1.add(this.jRadioButtonAufloesungNormal);
        buttonGroup1.add(this.jRadioButtonAufloesungKlein);
        buttonGroup1.add(this.jRadioButtonAufloesungHD);
    }

    private class BeobProgDoc
    implements DocumentListener {
        private BeobProgDoc() {
        }

        @Override
        public void insertUpdate(DocumentEvent arg0) {
            this.eingabe();
        }

        @Override
        public void removeUpdate(DocumentEvent arg0) {
            this.eingabe();
        }

        @Override
        public void changedUpdate(DocumentEvent arg0) {
            this.eingabe();
        }

        private void eingabe() {
            int rows;
            if (!PanelPsetLang.this.stopBeob && (rows = PanelPsetLang.this.tabelleProgramme.getSelectedRow()) != -1) {
                int row = PanelPsetLang.this.tabelleProgramme.convertRowIndexToModel(rows);
                DatenProg prog = (DatenProg)PanelPsetLang.this.getPset().getListeProg().get(row);
                prog.arr[2] = PanelPsetLang.this.jTextFieldProgPfad.getText();
                prog.arr[3] = PanelPsetLang.this.jTextFieldProgSchalter.getText();
                prog.arr[0] = PanelPsetLang.this.jTextFieldProgName.getText();
                prog.arr[1] = PanelPsetLang.this.jTextFieldProgZielDateiName.getText();
                prog.arr[5] = PanelPsetLang.this.jTextFieldProgSuffix.getText();
                prog.arr[4] = PanelPsetLang.this.jTextFieldProgPraefix.getText();
                PanelPsetLang.this.tabelleProgramme.getModel().setValueAt(PanelPsetLang.this.jTextFieldProgPfad.getText(), row, 2);
                PanelPsetLang.this.tabelleProgramme.getModel().setValueAt(PanelPsetLang.this.jTextFieldProgSchalter.getText(), row, 3);
                PanelPsetLang.this.tabelleProgramme.getModel().setValueAt(PanelPsetLang.this.jTextFieldProgName.getText(), row, 0);
                PanelPsetLang.this.tabelleProgramme.getModel().setValueAt(PanelPsetLang.this.jTextFieldProgZielDateiName.getText(), row, 1);
                PanelPsetLang.this.tabelleProgramme.getModel().setValueAt(PanelPsetLang.this.jTextFieldProgSuffix.getText(), row, 5);
                PanelPsetLang.this.tabelleProgramme.getModel().setValueAt(PanelPsetLang.this.jTextFieldProgPraefix.getText(), row, 4);
            }
        }
    }

    private class BeobDoc
    implements DocumentListener {
        private final JTextComponent textComponent;
        private final int psetIndex;
        private final boolean fireUpdate;

        public BeobDoc(JTextComponent comp, int psetIndex, boolean fireUpdate) {
            this.psetIndex = psetIndex;
            this.textComponent = comp;
            this.fireUpdate = fireUpdate;
        }

        public BeobDoc(JTextComponent comp, int psetIndex) {
            this(comp, psetIndex, true);
        }

        @Override
        public void insertUpdate(DocumentEvent arg0) {
            this.eingabe();
        }

        @Override
        public void removeUpdate(DocumentEvent arg0) {
            this.eingabe();
        }

        @Override
        public void changedUpdate(DocumentEvent arg0) {
        }

        private void setNamePruefen() {
            int row = PanelPsetLang.this.tabellePset.getSelectedRow();
            if (row != -1) {
                int foundgruppe = 0;
                for (DatenPset gruppe : PanelPsetLang.this.listePset) {
                    if (!PanelPsetLang.this.jTextFieldSetName.getText().equals(gruppe.arr[0])) continue;
                    ++foundgruppe;
                }
                if (foundgruppe > 1) {
                    PanelPsetLang.this.jTextFieldSetName.setBackground(Color.ORANGE);
                } else {
                    PanelPsetLang.this.jTextFieldSetName.setBackground(Color.WHITE);
                }
            }
        }

        private void eingabe() {
            if (!PanelPsetLang.this.stopBeob) {
                int row = PanelPsetLang.this.tabellePset.getSelectedRow();
                if (row != -1) {
                    PanelPsetLang.this.stopBeob = true;
                    int modelIndex = PanelPsetLang.this.tabellePset.convertRowIndexToModel(row);
                    DatenPset datenPset = (DatenPset)PanelPsetLang.this.listePset.get(modelIndex);
                    datenPset.arr[this.psetIndex] = this.textComponent.getText();
                    if (this.psetIndex == 0) {
                        PanelPsetLang.this.tabellePset.getModel().setValueAt(PanelPsetLang.this.jTextFieldSetName.getText(), modelIndex, 0);
                        PanelPsetLang.this.jTabbedPane.setTitleAt(0, "Set Name: " + datenPset.arr[0]);
                    }
                    if (this.fireUpdate) {
                        PanelPsetLang.this.notifyProgramSetChanged();
                    }
                    PanelPsetLang.this.stopBeob = false;
                } else {
                    NoSelectionErrorDialog.show(null);
                }
            }
            this.setNamePruefen();
        }
    }
}

