/*
 * Decompiled with CFR 0.152.
 */
package mediathek.daten;

import java.util.ArrayList;
import java.util.Collections;
import mediathek.config.Daten;
import mediathek.config.MVConfig;
import mediathek.daten.DatenFilm;
import mediathek.daten.ListeFilme;
import mediathek.daten.abo.DatenAbo;
import mediathek.daten.abo.FilmLengthState;
import mediathek.gui.dialog.DialogEditAbo;
import mediathek.gui.messages.AboListChangedEvent;
import mediathek.mainwindow.MediathekGui;
import mediathek.tool.FilenameUtils;
import mediathek.tool.Filter;
import mediathek.tool.GermanStringSorter;
import mediathek.tool.MVMessageDialog;
import mediathek.tool.MessageBus;
import org.jetbrains.annotations.NotNull;

public class ListeAbo
extends ArrayList<DatenAbo> {
    private static final String[] LEER = new String[]{""};
    private int nr;

    private int parseMinSize() {
        int min2;
        try {
            min2 = Integer.parseInt(MVConfig.get(MVConfig.Configs.SYSTEM_ABO_MIN_SIZE));
        }
        catch (Exception ex) {
            min2 = 0;
            MVConfig.add(MVConfig.Configs.SYSTEM_ABO_MIN_SIZE, "0");
        }
        return min2;
    }

    public void addAbo(String aboname, String filmSender, String filmThema, String filmTitel) {
        aboname = FilenameUtils.replaceLeerDateiname(aboname, false, Boolean.parseBoolean(MVConfig.get(MVConfig.Configs.SYSTEM_USE_REPLACETABLE)), Boolean.parseBoolean(MVConfig.get(MVConfig.Configs.SYSTEM_ONLY_ASCII)));
        DatenAbo datenAbo = new DatenAbo();
        datenAbo.setName(aboname);
        datenAbo.setSender(filmSender);
        datenAbo.setThema(filmThema);
        datenAbo.setTitle(filmTitel);
        datenAbo.setThemaTitel("");
        datenAbo.setIrgendwo("");
        datenAbo.setMindestDauerMinuten(this.parseMinSize());
        datenAbo.setFilmLengthState(FilmLengthState.MINIMUM);
        datenAbo.setZielpfad(aboname);
        datenAbo.setPsetName("");
        DialogEditAbo dialogEditAbo = new DialogEditAbo(MediathekGui.ui(), datenAbo, false);
        dialogEditAbo.setTitle("Neues Abo anlegen");
        dialogEditAbo.setVisible(true);
        if (dialogEditAbo.successful()) {
            if (!this.aboExistiertBereits(datenAbo)) {
                MVConfig.add(MVConfig.Configs.SYSTEM_ABO_MIN_SIZE, Integer.toString(datenAbo.getMindestDauerMinuten()));
                this.addAbo(datenAbo);
                this.aenderungMelden();
                Collections.sort(this);
            } else {
                MVMessageDialog.showMessageDialog(MediathekGui.ui(), "Abo existiert bereits", "Abo anlegen", 1);
            }
        }
    }

    public void addAbo(DatenAbo datenAbo) {
        ++this.nr;
        datenAbo.setNr(this.nr);
        if (datenAbo.getName().isEmpty()) {
            datenAbo.setName("Abo_" + this.nr);
        }
        this.add(datenAbo);
    }

    public void aboLoeschen(@NotNull DatenAbo abo) {
        this.remove(abo);
        this.aenderungMelden();
    }

    public void aenderungMelden() {
        this.setAboFuerFilm(Daten.getInstance().getListeFilme(), true);
        MessageBus.getMessageBus().publishAsync(new AboListChangedEvent());
    }

    public ArrayList<String> getPfade() {
        ArrayList<String> pfade = new ArrayList<String>();
        for (DatenAbo abo : this) {
            String zielpfad = abo.getZielpfad();
            if (pfade.contains(zielpfad)) continue;
            pfade.add(zielpfad);
        }
        pfade.sort(GermanStringSorter.getInstance());
        return pfade;
    }

    private boolean aboExistiertBereits(DatenAbo abo) {
        for (DatenAbo datenAbo : this) {
            if (!Filter.aboExistiertBereits(datenAbo, abo)) continue;
            return true;
        }
        return false;
    }

    public DatenAbo getAboFuerFilm_schnell(DatenFilm film, boolean laengePruefen) {
        DatenAbo abo = film.getAbo();
        if (abo == null) {
            return null;
        }
        if (laengePruefen && !Filter.laengePruefen(abo.getMindestDauerMinuten(), film.getFilmLength(), abo.getFilmLengthState() == FilmLengthState.MINIMUM)) {
            return null;
        }
        return abo;
    }

    private void deleteAboInFilm(DatenFilm film) {
        film.setAbo(null);
    }

    private void createAbo(DatenAbo abo) {
        if (abo.getTitle().isEmpty()) {
            abo.setTitelFilterPattern(LEER);
        } else {
            String[] stringArray;
            if (Filter.isPattern(abo.getTitle())) {
                String[] stringArray2 = new String[1];
                stringArray = stringArray2;
                stringArray2[0] = abo.getTitle();
            } else {
                stringArray = abo.getTitle().toLowerCase().split(",");
            }
            abo.setTitelFilterPattern(stringArray);
        }
        if (abo.getThemaTitel().isEmpty()) {
            abo.setThemaFilterPattern(LEER);
        } else {
            String[] stringArray;
            if (Filter.isPattern(abo.getThemaTitel())) {
                String[] stringArray3 = new String[1];
                stringArray = stringArray3;
                stringArray3[0] = abo.getThemaTitel();
            } else {
                stringArray = abo.getThemaTitel().toLowerCase().split(",");
            }
            abo.setThemaFilterPattern(stringArray);
        }
        if (abo.getIrgendwo().isEmpty()) {
            abo.setIrgendwoFilterPattern(LEER);
        } else {
            String[] stringArray;
            if (Filter.isPattern(abo.getIrgendwo())) {
                String[] stringArray4 = new String[1];
                stringArray = stringArray4;
                stringArray4[0] = abo.getIrgendwo();
            } else {
                stringArray = abo.getIrgendwo().toLowerCase().split(",");
            }
            abo.setIrgendwoFilterPattern(stringArray);
        }
    }

    private void assignAboToFilm(@NotNull DatenFilm film) {
        this.stream().filter(abo -> Filter.filterAufFilmPruefen(abo.getSender(), abo.getThema(), abo.getTitelFilterPattern(), abo.getThemaFilterPattern(), abo.getIrgendwoFilterPattern(), film)).findAny().ifPresentOrElse(film::setAbo, () -> this.deleteAboInFilm(film));
    }

    public void setAboFuerFilm(ListeFilme listeFilme, boolean aboLoeschen) {
        if (this.isEmpty() && aboLoeschen) {
            listeFilme.forEach(this::deleteAboInFilm);
            return;
        }
        this.stream().filter(DatenAbo::isInvalid).forEach(this::remove);
        this.forEach(this::createAbo);
        listeFilme.parallelStream().forEach(this::assignAboToFilm);
        this.forEach((? super E datenAbo) -> {
            datenAbo.setTitelFilterPattern(LEER);
            datenAbo.setThemaFilterPattern(LEER);
            datenAbo.setIrgendwoFilterPattern(LEER);
        });
    }
}

