/*
 * Decompiled with CFR 0.152.
 */
package mediathek.config;

import com.formdev.flatlaf.FlatLaf;
import java.awt.Color;
import java.util.ArrayList;
import javax.swing.UIManager;
import mediathek.config.MVConfig;
import mediathek.tool.MVC;
import org.jetbrains.annotations.NotNull;

public class MVColor {
    public static final MVC FILM_HISTORY = new MVC(MVConfig.Configs.FARBE__FILM_HISTORY, new Color(225, 225, 225), "Filme, gesehen");
    public static final MVC FILM_BOOKMARKED = new MVC(MVConfig.Configs.FARBE__FILM_BOOKMARKED, new Color(204, 238, 255), "Filme, gemerkt");
    public static final MVC DOWNLOAD_IST_ABO = new MVC(MVConfig.Configs.FARBE__DOWNLOAD_IST_ABO, new Color(138, 67, 0), "Download ist ein Abo");
    public static final MVC DOWNLOAD_IST_DIREKTER_DOWNLOAD = new MVC(MVConfig.Configs.FARBE__DOWNLOAD_IST_DIREKTER_DOWNLOAD, new Color(0, 72, 138), "Download ist ein direkter Download");
    public static final MVC DOWNLOAD_WAIT = new MVC(MVConfig.Configs.FARBE__DOWNLOAD_WAIT, new Color(239, 244, 255), "Download, noch nicht gestartet");
    public static final MVC DOWNLOAD_WAIT_SEL = new MVC(MVConfig.Configs.FARBE__DOWNLOAD_WAIT_SEL, new Color(199, 206, 222), "Download, noch nicht gestartet, selektiert");
    public static final MVC DOWNLOAD_RUN = new MVC(MVConfig.Configs.FARBE__DOWNLOAD_RUN, new Color(241, 228, 188), "Download, l\u00e4uft");
    public static final MVC DOWNLOAD_RUN_SEL = new MVC(MVConfig.Configs.FARBE__DOWNLOAD_RUN_SEL, new Color(206, 178, 92), "Download, l\u00e4uft, selektiert");
    public static final MVC DOWNLOAD_FERTIG = new MVC(MVConfig.Configs.FARBE__DOWNLOAD_FERTIG, new Color(188, 241, 195), "Download, fertig");
    public static final MVC DOWNLOAD_FERTIG_SEL = new MVC(MVConfig.Configs.FARBE__DOWNLOAD_FERTIG_SEL, new Color(115, 206, 92), "Download, fertig, selektiert");
    public static final MVC DOWNLOAD_FEHLER = new MVC(MVConfig.Configs.FARBE__DOWNLOAD_FEHLER, new Color(241, 188, 221), "Download, fehlerhaft");
    public static final MVC DOWNLOAD_FEHLER_SEL = new MVC(MVConfig.Configs.FARBE__DOWNLOAD_FEHLER_SEL, new Color(206, 92, 128), "Download, fehlerhaft, selektiert");
    public static final MVC DOWNLOAD_DATEINAME_NEU = new MVC(MVConfig.Configs.FARBE__DOWNLOAD_DATEINAME_NEU, new Color(0, 140, 0), "Download, Dateiname ist neu");
    public static final MVC DOWNLOAD_DATEINAME_ALT = new MVC(MVConfig.Configs.FARBE__DOWNLOAD_DATEINAME_ALT, new Color(0, 0, 200), "Download, Dateiname ist der alte");
    public static final int MVC_TEXT = 0;
    public static final int MVC_COLOR = 1;
    public static final int MVC_MAX = 2;
    private static final Color JTABLE_ALTERNATE_ROW_COLOR = new Color(247, 247, 247);
    public ArrayList<MVC> liste = new ArrayList();

    public MVColor() {
        this.liste.add(FILM_HISTORY);
        this.liste.add(FILM_BOOKMARKED);
        this.liste.add(DOWNLOAD_IST_ABO);
        this.liste.add(DOWNLOAD_IST_DIREKTER_DOWNLOAD);
        this.liste.add(DOWNLOAD_WAIT);
        this.liste.add(DOWNLOAD_WAIT_SEL);
        this.liste.add(DOWNLOAD_RUN);
        this.liste.add(DOWNLOAD_RUN_SEL);
        this.liste.add(DOWNLOAD_FERTIG);
        this.liste.add(DOWNLOAD_FERTIG_SEL);
        this.liste.add(DOWNLOAD_FEHLER);
        this.liste.add(DOWNLOAD_FEHLER_SEL);
        this.liste.add(DOWNLOAD_DATEINAME_NEU);
        this.liste.add(DOWNLOAD_DATEINAME_ALT);
    }

    public static Color getRegExPatternColor() {
        Color color = FlatLaf.isLafDark() ? UIManager.getColor("Hyperlink.linkColor") : Color.BLUE;
        return color;
    }

    public static Color getNewColor() {
        return MVColor.getRegExPatternColor();
    }

    public static Color getBlueColor() {
        return MVColor.getRegExPatternColor();
    }

    public static Color getSelectedColor() {
        return MVColor.getRegExPatternColor();
    }

    public static Color getAlternatingRowColor() {
        if (!FlatLaf.isLafDark()) {
            return JTABLE_ALTERNATE_ROW_COLOR;
        }
        Color tableBg = UIManager.getColor("Table.background");
        Color color = MVColor.brightenColor(tableBg, 0.25f);
        return color;
    }

    @NotNull
    private static Color brightenColor(@NotNull Color originalColor, float factor) {
        float[] hsb = Color.RGBtoHSB(originalColor.getRed(), originalColor.getGreen(), originalColor.getBlue(), null);
        return Color.getHSBColor(hsb[0], hsb[1], factor * (1.0f + hsb[2]));
    }

    public final void load() {
        this.liste.stream().filter(mvc -> !MVConfig.get(mvc.configs).isEmpty()).forEach(mvc -> {
            try {
                mvc.color = new Color(Integer.parseInt(MVConfig.get(mvc.configs)));
            }
            catch (Exception exception) {
                // empty catch block
            }
        });
    }

    public final void save() {
        for (MVC mvc : this.liste) {
            MVConfig.add(mvc.configs, String.valueOf(mvc.color.getRGB()));
        }
    }

    public void reset() {
        this.liste.forEach(MVC::reset);
    }
}

