/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javafx.binding;

import com.sun.javafx.binding.LazyObjectBinding;
import com.sun.javafx.binding.Subscription;
import java.util.Objects;
import javafx.beans.value.ObservableValue;

public class ConditionalBinding<T>
extends LazyObjectBinding<T> {
    private final ObservableValue<T> source;
    private final ObservableValue<Boolean> nonNullCondition;
    private Subscription subscription;

    public ConditionalBinding(ObservableValue<T> observableValue, ObservableValue<Boolean> observableValue2) {
        this.source = Objects.requireNonNull(observableValue, "source cannot be null");
        this.nonNullCondition = Objects.requireNonNull(observableValue2, "condition cannot be null").orElse(false);
        Subscription.subscribe(this.nonNullCondition, bl -> {
            this.invalidate();
            if (!bl.booleanValue()) {
                this.getValue();
            }
        });
    }

    @Override
    protected boolean allowValidation() {
        return super.allowValidation() || !this.isActive();
    }

    @Override
    protected T computeValue() {
        if (this.isObserved() && this.isActive()) {
            if (this.subscription == null) {
                this.subscription = Subscription.subscribeInvalidations(this.source, this::invalidate);
            }
        } else {
            this.unsubscribe();
        }
        return this.source.getValue();
    }

    @Override
    protected Subscription observeSources() {
        return this::unsubscribe;
    }

    private boolean isActive() {
        return this.nonNullCondition.getValue();
    }

    private void unsubscribe() {
        if (this.subscription != null) {
            this.subscription.unsubscribe();
            this.subscription = null;
        }
    }
}

