/*
 * Decompiled with CFR 0.152.
 */
package com.jidesoft.plaf.eclipse;

import com.jidesoft.plaf.UIDefaultsLookup;
import com.jidesoft.plaf.basic.BasicPainter;
import com.jidesoft.plaf.basic.ThemePainter;
import com.jidesoft.plaf.eclipse.EclipseUtils;
import com.jidesoft.swing.JideSwingUtilities;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.Rectangle;
import javax.swing.JComponent;

public class EclipsePainter
extends BasicPainter {
    private static EclipsePainter _instance;
    protected Color _shadowColor = UIDefaultsLookup.getColor("controlShadow");
    protected Color _darkShadowColor = UIDefaultsLookup.getColor("controlDkShadow");
    protected Color _highlight = UIDefaultsLookup.getColor("controlHighlight");
    protected Color _lightHighlightColor = UIDefaultsLookup.getColor("controlLtHighlight");

    public static ThemePainter getInstance() {
        if (_instance == null) {
            _instance = new EclipsePainter();
        }
        return _instance;
    }

    protected EclipsePainter() {
    }

    @Override
    public void paintButtonBackground(JComponent c, Graphics g2, Rectangle rect, int orientation, int state) {
        Color oldColor = g2.getColor();
        if (state != 0) {
            if (state == 2) {
                if (orientation == 0) {
                    g2.setColor(this._lightHighlightColor);
                    g2.drawLine(rect.x, rect.y, rect.x + rect.width - 1, rect.y);
                    g2.drawLine(rect.x, rect.y, rect.x, rect.y + rect.height - 1);
                    g2.setColor(this._shadowColor);
                    g2.drawLine(rect.x, rect.y + rect.height - 1, rect.x + rect.width - 1, rect.y + rect.height - 1);
                    g2.drawLine(rect.x + rect.width - 1, rect.y, rect.x + rect.width - 1, rect.x + rect.height - 1);
                } else {
                    g2.setColor(this._lightHighlightColor);
                    g2.drawLine(rect.x, rect.y, rect.x, rect.y + rect.height - 1);
                    g2.drawLine(rect.x, rect.y + rect.height - 1, rect.x + rect.width - 1, rect.y + rect.height - 1);
                    g2.setColor(this._shadowColor);
                    g2.drawLine(rect.x, rect.y, rect.x + rect.width - 1, rect.y);
                    g2.drawLine(rect.x + rect.width - 1, rect.y, rect.x + rect.width - 1, rect.x + rect.height - 1);
                }
            } else if (state == 3) {
                EclipseUtils.fillRectWithHatch((Graphics2D)g2, new Rectangle(2, 2, rect.width - 4, rect.height - 4), UIDefaultsLookup.getColor("JideButton.background"));
                if (orientation == 0) {
                    g2.setColor(this._shadowColor);
                    g2.drawLine(rect.x, rect.y, rect.x + rect.width - 1, rect.y);
                    g2.drawLine(rect.x, rect.y, rect.x, rect.y + rect.height - 1);
                    g2.setColor(this._lightHighlightColor);
                    g2.drawLine(rect.x, rect.y + rect.height - 1, rect.x + rect.width - 1, rect.y + rect.height - 1);
                    g2.drawLine(rect.x + rect.width - 1, rect.y, rect.x + rect.width - 1, rect.y + rect.height - 1);
                } else {
                    g2.setColor(this._shadowColor);
                    g2.drawLine(rect.x, rect.y, rect.x, rect.y + rect.height - 1);
                    g2.drawLine(rect.x, rect.y + rect.height - 1, rect.x + rect.width - 1, rect.y + rect.height - 1);
                    g2.setColor(this._lightHighlightColor);
                    g2.drawLine(rect.x, rect.y, rect.x + rect.width - 1, rect.y);
                    g2.drawLine(rect.x + rect.width - 1, rect.y, rect.x + rect.width - 1, rect.y + rect.height - 1);
                }
            } else if (state == 1) {
                g2.setColor(this._shadowColor);
                g2.drawLine(rect.x, rect.y, rect.x + rect.width - 1, rect.y);
                g2.drawLine(rect.x, rect.y, rect.x, rect.y + rect.height - 1);
                g2.setColor(this._lightHighlightColor);
                g2.drawLine(rect.x, rect.y + rect.height - 1, rect.x + rect.width - 1, rect.y + rect.height - 1);
                g2.drawLine(rect.x + rect.width - 1, rect.y, rect.x + rect.width - 1, rect.y + rect.height - 1);
            }
        }
        g2.setColor(oldColor);
    }

    @Override
    public void paintSelectedMenu(JComponent c, Graphics g2, Rectangle rect, int orientation, int state) {
    }

    @Override
    public void paintGripper(JComponent c, Graphics g2, Rectangle rect, int orientation, int state) {
        int h2 = orientation == 0 ? rect.height : rect.width;
        h2 -= 4;
        int y = rect.y + 2;
        int x = rect.x + 2;
        Color oldColor = g2.getColor();
        if (orientation == 0) {
            g2.setColor(this._lightHighlightColor);
            g2.drawLine(x, y, x, y + h2);
            g2.drawLine(x, y, x + 2, y);
            g2.setColor(this._shadowColor);
            g2.drawLine(x + 2, y, x + 2, y + h2);
            g2.drawLine(x, y + h2, x + 2, y + h2);
            g2.setColor(UIDefaultsLookup.getColor("JideButton.background"));
            g2.drawLine(x + 1, y + 1, x + 1, y + h2 - 1);
        } else {
            g2.setColor(this._lightHighlightColor);
            g2.drawLine(x, y, x + h2, y);
            g2.drawLine(x, y, x, y + 2);
            g2.setColor(this._shadowColor);
            g2.drawLine(x, y + 2, x + h2, y + 2);
            g2.drawLine(x + h2, y, x + h2, y + 2);
            g2.setColor(UIDefaultsLookup.getColor("JideButton.background"));
            g2.drawLine(x + 1, y + 1, x + h2 - 1, y + 1);
        }
        g2.setColor(oldColor);
    }

    @Override
    public void paintDockableFrameTitlePane(JComponent c, Graphics g2, Rectangle rect, int orientation, int state) {
        int x = rect.x;
        int y = rect.y;
        int w = c.getWidth();
        int h2 = rect.height;
        if (c.getBorder() != null) {
            Insets insets = c.getBorder().getBorderInsets(c);
            x += insets.left;
            y += insets.top;
            w -= insets.right + insets.left;
            h2 -= insets.top + insets.bottom;
        }
        g2.setColor(Color.white);
        g2.drawLine(x, y, x + w, y);
        g2.drawLine(x, y, x, y + h2 - 1);
        g2.setColor(Color.gray);
        g2.drawLine(x, y + h2 - 1, x + w, y + h2 - 1);
        if (state == 3) {
            int width = rect.width;
            Graphics2D g2d = (Graphics2D)g2;
            JideSwingUtilities.fillGradient(g2d, new Rectangle(x + 1, y + 1, width / 2, h2 - 2), UIDefaultsLookup.getColor("DockableFrame.activeTitleBackground"), UIDefaultsLookup.getColor("DockableFrame.activeTitleBackground2"), false);
            JideSwingUtilities.fillGradient(g2d, new Rectangle(x + 1 + width / 2, y + 1, width / 2, h2 - 2), UIDefaultsLookup.getColor("DockableFrame.activeTitleBackground2"), UIDefaultsLookup.getColor("DockableFrame.background"), false);
        }
    }

    @Override
    public void paintToolBarSeparator(JComponent c, Graphics g2, Rectangle rect, int orientation, int state) {
        int h2 = orientation == 0 ? c.getHeight() : c.getWidth();
        h2 -= 5;
        if (JideSwingUtilities.getOrientationOf(c) == 0) {
            int y = rect.y + 3;
            int x = rect.x + 1;
            g2.setColor(this._shadowColor);
            g2.drawLine(x, y, x, y + h2);
            g2.setColor(this._lightHighlightColor);
            g2.drawLine(x + 1, y + 1, x + 1, y + h2 + 1);
        } else {
            int y = rect.y + 1;
            int x = rect.x + 3;
            g2.setColor(this._shadowColor);
            g2.drawLine(x, y, x + h2, y);
            g2.setColor(this._lightHighlightColor);
            g2.drawLine(x + 1, y + 1, x + 1 + h2, y + 1);
        }
    }
}

