/*
 * Decompiled with CFR 0.152.
 */
package com.install4j.runtime.beans.formcomponents;

import com.install4j.api.context.Context;
import com.install4j.api.context.UserCanceledException;
import com.install4j.api.events.EventType;
import com.install4j.api.events.InstallerVariableEvent;
import com.install4j.api.screens.Console;
import com.install4j.runtime.beans.formcomponents.TextfieldComponent;
import com.install4j.runtime.util.Base64;
import com.install4j.runtime.util.IconHelper;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.io.UnsupportedEncodingException;
import java.util.Objects;
import javax.swing.Icon;
import javax.swing.JLabel;
import javax.swing.JPasswordField;
import javax.swing.text.JTextComponent;

public class PasswordComponent
extends TextfieldComponent {
    private static final String ENCODING = "UTF-8";
    private boolean writeToResponseFile = false;
    private CustomPasswordField passwordField;
    private boolean eyeVisible = false;

    public boolean isEyeVisible() {
        return this.replaceWithTextOverride("eyeVisible", this.eyeVisible);
    }

    public void setEyeVisible(boolean eyeVisible) {
        this.eyeVisible = eyeVisible;
    }

    @Override
    protected JTextComponent createTextComponent() {
        this.passwordField = new CustomPasswordField();
        this.applyTextFieldProperties(this.passwordField);
        this.passwordField.setEyeVisible(this.isEyeVisible());
        return this.passwordField;
    }

    public boolean isWriteToResponseFile() {
        return this.replaceWithTextOverride("writeToResponseFile", this.writeToResponseFile);
    }

    public void setWriteToResponseFile(boolean writeToResponseFile) {
        this.writeToResponseFile = writeToResponseFile;
    }

    @Override
    public Class getConfigurationObjectClass() {
        return JPasswordField.class;
    }

    @Override
    public void setContext(Context context) {
        super.setContext(context);
        if (context != null) {
            this.decodeVariable();
            context.addInstallerEventListener(event -> {
                if (event.getType() == EventType.VARIABLE_CHANGED && Objects.equals(((InstallerVariableEvent)event).getVariableName(), this.getEncodedVariableName())) {
                    this.decodeVariable();
                }
            });
        }
    }

    private void decodeVariable() {
        String initValue = (String)this.getInitValue(null, this.getEncodedVariableName(), String.class);
        if (initValue != null) {
            Context context = this.getContext();
            String value = this.decodeValue(initValue);
            if (value != null) {
                String variableName = this.getVariableName();
                context.registerHiddenVariable(variableName);
                context.setVariable(variableName, value);
            }
        }
    }

    @Override
    public boolean checkCompleted() {
        if (!super.checkCompleted()) {
            return false;
        }
        if (this.isWriteToResponseFile()) {
            String encodedVariableName = this.getEncodedVariableName();
            try {
                byte[] bytes = this.getValue().toString().getBytes(ENCODING);
                for (int i = 0; i < bytes.length; ++i) {
                    bytes[i] = (byte)(255 - bytes[i]);
                }
                this.getContext().setVariable(encodedVariableName, Base64.encode(bytes));
            }
            catch (UnsupportedEncodingException e) {
                e.printStackTrace();
            }
            this.getContext().registerResponseFileVariable(encodedVariableName);
        }
        return true;
    }

    private String getEncodedVariableName() {
        return this.getVariableName() + ".encoded";
    }

    @Override
    protected boolean isRegisterResponseFileVariable() {
        return false;
    }

    @Override
    protected void initText(JTextComponent textComponent) {
        String decodedValue;
        super.initText(textComponent);
        this.getContext().registerHiddenVariable(this.getVariableName());
        String initValue = (String)this.getInitValue(null, this.getEncodedVariableName(), String.class);
        if (initValue != null && (decodedValue = this.decodeValue(initValue)) != null) {
            textComponent.setText(decodedValue);
        }
    }

    private String decodeValue(String initValue) {
        try {
            byte[] bytes = Base64.decode(initValue);
            for (int i = 0; i < bytes.length; ++i) {
                bytes[i] = (byte)(255 - bytes[i]);
            }
            return new String(bytes, ENCODING);
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    @Override
    protected Object getValue() {
        return this.getTextComponent().getText();
    }

    @Override
    protected String askString(Console console, String oldValue, String labelText) throws UserCanceledException {
        return console.askPassword(labelText, oldValue);
    }

    public static class CustomPasswordField
    extends JPasswordField {
        public static final Icon ICON_EYE_16 = IconHelper.loadIcon("eye_16.png");
        private JLabel lblEye;

        public void setEyeVisible(boolean visible) {
            this.lblEye.setVisible(visible);
        }

        public CustomPasswordField() {
            this.setLayout(new BorderLayout());
            this.lblEye = new JLabel(ICON_EYE_16);
            this.lblEye.setVisible(false);
            this.add((Component)this.lblEye, "East");
            this.lblEye.addMouseListener(new MouseAdapter(){

                @Override
                public void mousePressed(MouseEvent me) {
                    this.setEchoChar('\u0000');
                }

                @Override
                public void mouseReleased(MouseEvent me) {
                    this.setEchoChar(new JPasswordField().getEchoChar());
                }

                @Override
                public void mouseEntered(MouseEvent me) {
                    this.setCursor(new Cursor(12));
                }

                @Override
                public void mouseExited(MouseEvent me) {
                    this.setCursor(new Cursor(0));
                }
            });
        }
    }
}

